/* 
 * twHamQTH - an online callsign look up progran
 * Copyright (C) 2011->2014 Ted Williams - WA0EIR
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
 */

#include "twhamqth.h"
#include "twhamqthHelp.h"

/*
 * popup_aboutDiag - creates the aboutDiag and pops it up
 */
void popup_aboutDiag ()
{
   extern Pixmap pixmap;

   static Widget abtDiag = NULL;
   XmString  msg_xs;
   char msg_str[] = PACKAGE_STRING " \251 2011,2012,2013,2014,2015\n"
                "was written by Ted Williams - WA\330EIR\n\n"
                "Thanks to Petr, OK2CQR, for his HamQTH.com database.\n"
                "Support Petr with a donation at hamqth.com/donations.php\n\n"
                "Please send bug reports to\n" PACKAGE_BUGREPORT;

   if (abtDiag == NULL)
      {
      abtDiag = XmCreateInformationDialog (shell, "abtDiag", NULL, 0);
      XtVaSetValues (XtParent(abtDiag),
         XmNtitle, "ABOUT TWPSK",
         #if (MAKE_ICON == 1) && (HAVE_X11_XPM_H == 1) && (HAVE_LIBXPM == 1)
         XmNiconPixmap, pixmap,
         #endif
         NULL);

      msg_xs = XmStringCreateLtoR (msg_str, XmFONTLIST_DEFAULT_TAG);
      XtVaSetValues (abtDiag,
         XmNmessageAlignment, XmALIGNMENT_CENTER,
         XmNmessageString, msg_xs,
         NULL);
      XmStringFree(msg_xs);

      XtUnmanageChild (XmMessageBoxGetChild (abtDiag, XmDIALOG_CANCEL_BUTTON));
      XtUnmanageChild (XmMessageBoxGetChild (abtDiag, XmDIALOG_HELP_BUTTON));
      }
   XtManageChild (abtDiag);
}


/*
 * popup_helpDiag - creates the helpDiag and pops it up
 */
void popup_helpDiag (void)
{
   int i;
   Arg args[15];
   static Widget helpDiag, helpTxt;
   XmString xs;

   if (helpDiag == NULL)
   {
      helpDiag = XmCreateInformationDialog (shell, "helpDiag", NULL, 0);

      XtUnmanageChild (XmMessageBoxGetChild (helpDiag, XmDIALOG_CANCEL_BUTTON));
      XtUnmanageChild (XmMessageBoxGetChild (helpDiag, XmDIALOG_HELP_BUTTON));

      xs = XmStringCreateLocalized ("twHamQTH HELP FILE");

      XtVaSetValues (helpDiag,
         XmNdialogStyle, XmDIALOG_MODELESS,
         XmNmessageString, xs,
         NULL);
      XmStringFree (xs);

      i=0;
      XtSetArg (args[i], XmNcolumns, 60); i++;
      XtSetArg (args[i], XmNmargin, 10); i++;
      XtSetArg (args[i], XmNrows, 10); i++;
      XtSetArg (args[i], XmNeditable, False); i++;
      XtSetArg (args[i], XmNscrollHorizontal, False); i++;
      XtSetArg (args[i], XmNwordWrap, True); i++;
      XtSetArg (args[i], XmNvalue, helpText); i++;
      XtSetArg (args[i], XmNeditMode, XmMULTI_LINE_EDIT); i++;
      XtSetArg (args[i], XmNscrollingPolicy, XmAUTOMATIC); i++;
      XtSetArg (args[i], XmNresizeWidth, True); i++;
      XtSetArg (args[i], XmNautoShowCursorPosition, False); i++;
      XtSetArg (args[i], XmNcursorPositionVisible, False); i++;

      helpTxt = XmCreateScrolledText (helpDiag, "helpTxt", args, i);
      XtManageChild (helpTxt);

   }
   XtManageChild (helpDiag);
}

