
#ifndef TWHAMQTH_H_INCLUDED
#define TWHAMQTH_H_INCLUDED

#define _XOPEN_SOURCE 500

#include "IPC.h"
#include <time.h>
#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <Xm/Xm.h>
#include <Xm/Form.h>
#include <Xm/Text.h>
#include <Xm/Label.h>
#include <Xm/TextF.h>
#include <Xm/PushB.h>
#include <Xm/MwmUtil.h>
#include <Xm/Notebook.h>
#include <Xm/MessageB.h>
#include <Xm/RowColumn.h>
#include <X11/cursorfont.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include "../config.h"
#include <curl/curl.h>
#include <libxml/xmlreader.h>
#include "IPC.h"

#define DEBUG     0

#define DIRNAME   "/.twHamQTHdir"
#define AGNAME    "/AGcalls"
#define MAKE_ICON 1
#define TEXT_ROWS 8

#define LOGIN  1
#define SEARCH 2

#define SUCCESS       0
#define GOT_SID       1
#define GOT_DATA      2
#define BAD_LOGIN     3
#define EXPIRED_LOGIN 4
#define UNKNOWN_CALL  5
#define BAD_DATA      6
#define EQSL_LEN      32
#define PATH_LEN      64
#define HEAD_LEN      50
#define SZ            1500

#define LOCAL_OK      1

#define BOTH_BAD      0
#define USE_LOCAL     1
#define USE_EQSL      2

/* FOR MAIN MENU PULLDOWN */
#define LOOKUP_BTN   "button_0"
#define SAVE_BTN     "button_1"
#define CLEAR_BTN    "button_2"
#define REMOVE_BTN   "button_3"

/*
 * APPLICATION DEFINED RESOURCES
 */
#define XmNusername  "username"
#define XmCUsername  "Username"

#define XmNpassword  "password"
#define XmCPassword  "Password"

#define XmNdoAG  "doAG"
#define XmCDoAG  "DoAG"

#define XmNdays  "days"
#define XmCDays  "Days"

/* 
 * DATA STRUCTS
 */

/* struct for application resources */
struct AppRes
{
   String username;
   String password;
   int doAG;
   int days;
} appRes;

/* struct CBdata for callback client data */
struct CBdata
{
   XtAppContext app;        /* app context */
   Widget wid1;             /* notebook */
   Widget wid2;             /* lookupTF */
   Widget wid3;             /* mainTX */
};

/* struct for linked list of notebook widgets and allXML data */
struct list
{
   Widget page;
   Widget tab;
   struct allXML *xmlData;
   struct list *next;
};

/* struct for linked list of all AG calls */
struct AGcalls 
{
   char call[EQSL_LEN];
   struct AGcalls *next;
} *headAG;

struct AGcalls *headAG;

/*
 * GLOBALS
 */
int useMotif;
int selectedPageNum;
Widget shell;
struct list *head;
struct allXML results;

/* 
 * FUNCTIONS DECLARATIONS
 */
int  do_request (int type, struct CBdata *wids);
int  getNewer (char *AGhead);
struct CBdata *buildWidgets (Widget shell, XtAppContext app);
void getLogin(Widget w);
void initDiagCB (Widget w, XtPointer client_data, XtPointer cbs);
void fileCB (Widget w, XtPointer client_data, XtPointer cbs);
void helpCB (Widget w, XtPointer client_data, XtPointer cbs);
void popup_aboutDiag (void);
void popup_helpDiag (void);
void lookupCB (Widget w, XtPointer client_data, XtPointer cbs);
void pageChangeCB (Widget w, XtPointer client_data, XtPointer cbs);
void mvCB (Widget w, XtPointer client_data, XtPointer cbs);
void mainCB (Widget w, XtPointer client_data, XtPointer cbs);
void saveCB (Widget w, XtPointer client_data, XtPointer cbs);
void clearCB (Widget w, XtPointer client_data, XtPointer cbs);
void removeCB (Widget w, XtPointer client_data, XtPointer cbs);
void errorDiag (Widget w, char *emess, struct CBdata *wids);
void okCB (Widget w, XtPointer client_data, XtPointer cbs);
void pwordCB (Widget w, XtPointer client_data, XtPointer cbs);
void exportCB (Widget w, XtPointer client_data, XtPointer cbs);
void qrtCB (Widget w, XtPointer client_data, XtPointer cbs);
void deepcpy (struct allXML *dest, struct allXML *src);
Boolean readAG (struct CBdata *wids);
void getAGstatus (Widget w, char *call);
void printList (void);
void renumber (void);

void initCB (Widget w, XtPointer client_data, XtPointer cbs);
#endif

