/* 
 * Get All Data From www.HamQTH.com
 *
 * twHamQTH - an online callsign look up progran
 * Copyright (C) 2011->2014 Ted Williams - WA0EIR
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
 */

#include "twhamqth.h"

#if (MAKE_ICON == 1 && (HAVE_X11_XPM_H == 1) && HAVE_LIBXPM == 1)
   #include <X11/xpm.h>
   #include "icons/twHamQTH.xpm"
   Pixmap pixmap, mask;
   XpmAttributes pix_attributes;
   XpmColorSymbol transparentColor[1] = {{NULL, "none", 0}};
#endif

/*
 * main function - no command line args are used
 */
int main (int argc, char **argv)
{
   int rtn;
   struct CBdata *wids;
   Dimension h, w;
   XtAppContext app;
   char note[] = "You have been logged onto HamQTH.com\n"
                 "via the resource file.\n";

   XtResource appRes_desc[] =   /* define the app resources */
   {
      {
         XmNusername,
         XmCUsername,
         XtRString,
         sizeof (String),
         XtOffsetOf (struct AppRes, username),
         XtRImmediate,
         (XtPointer) "dummy"
      },

      {
         XmNpassword,
         XmCPassword,
         XtRString,
         sizeof (String),
         XtOffsetOf (struct AppRes, password),
         XtRImmediate,
         (XtPointer) "dummy"
      },

      {
         XmNdoAG,
         XmCDoAG,
         XtRInt,
         sizeof (int),
         XtOffsetOf (struct AppRes, doAG),
         XtRImmediate,
         (XtPointer) 0
      },

      {
         XmNdays,
         XmCDays,
         XtRInt,
         sizeof (int),
         XtOffsetOf (struct AppRes, days),
         XtRImmediate,
         (XtPointer) 3
      }
   };

#ifdef XmVERSION_STRING
   extern const char _XmVersionString[];
   fprintf (stderr, "Compiled with %s\n", XmVERSION_STRING + 4);
   fprintf (stderr, "Running with %s\n", _XmVersionString + 4);
   if (strstr (XmVERSION_STRING, "Motif") != NULL)
   {
      useMotif = True;
   }
   else
   {
      useMotif = False;
   }
#endif

   /* create the top lever shell and set package name and
    * version in the wm frame
    */
   shell = XtVaOpenApplication (&app, "TwHamQTH", NULL, 0,
      &argc, argv, NULL, sessionShellWidgetClass,
      XmNtitle, PACKAGE_STRING,
      NULL);


   /* get the resources from resources file */
   XtGetApplicationResources (shell, &appRes, appRes_desc,
      XtNumber (appRes_desc), NULL, 0);

#if (MAKE_ICON == 1) && (HAVE_X11_XPM_H == 1) && (HAVE_LIBXPM == 1) 
   pix_attributes.closeness = 40000;
   pix_attributes.valuemask = XpmColorSymbols | XpmCloseness;
   pix_attributes.colorsymbols = transparentColor;
   pix_attributes.numsymbols = 1;

   XpmCreatePixmapFromData (XtDisplay (shell),
      DefaultRootWindow (XtDisplay (shell)),
      twHamQTH_xpm, &pixmap, &mask, &pix_attributes);

   XtVaSetValues (shell,
      XmNiconPixmap, pixmap,
      NULL);
#endif

   /* returns a pointer to the struct CBdata */
   wids = buildWidgets (shell, app);

   XtRealizeWidget (shell);

   /* force focus to the lookupTF */
   XmProcessTraversal (wids->wid2, XmTRAVERSE_CURRENT);

   /* do some setup of stuff */
   head = NULL;      /* make the list empty */
   
   /*
   * we don't want the window smaller or wider than it is
   * right now, so make it the min height and width
   */
   XtVaGetValues (shell,
      XmNheight, &h,
      XmNwidth, &w,
      NULL);

   XtVaSetValues (shell,
      XmNminHeight, h,
      XmNminWidth, w,
      NULL);

   /*
    * create shared memory for XML data
    * and attach it with the XMLdata pointer
    */
   if ((shmid2 = shmget (XML_KEY, sizeof (struct allXML),
                          IPC_CREAT | 0644)) == -1)
   {
      perror ("shmget create");
      return -1;
   }

   if ((XMLdata = shmat (shmid2, 0, 0)) == (struct allXML *) -1)
   {
      perror ("shmat failed");
      return -2;
   }

   /*
    * create the semaphores
    */
   if ((semid = semget (SEM_KEY, 2, IPC_CREAT | 0660)) == -1)
   {  /* failed, see if it already exists */  
      if (errno == EEXIST)
      {
         if ((semid = semget (SEM_KEY, 2, 0)) == -1)
         {
            perror ("semget failed");
            return -3;
         }
      }
      else
      {
         perror ("create server sem");
         return -4;
      }
   }

   rtn = semctl (semid, 0, SETALL, initial);
   if (rtn == -1)
   {
      perror ("initialize");
   }

   /* enter the main loop */
   XtAppMainLoop (app);
   return (0);                  /* we better never get here */
}

