/*
 * IPC.h
 * variables and headers needed to share callsign data between 
 * twHamQTH and any other program.  twHamQTH and twlog have links to 
 * this file in their src directories.
 */
#ifndef IPC_H_INCLUDED
#define IPC_H_INCLUDED

#include <string.h>
#include <sys/sem.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/shm.h>

#define CALL_KEY 6146
#define XML_KEY  6870
#define SEM_KEY  8511


/* GLOBALS */
int semid;                   /* semaphore id */
int shmid1;                  /* for server (twhamqth) */
int shmid2;                  /* for client */
static unsigned short initial[2] = {0, 0};

struct allXML *XMLdata;

struct allXML
{
   int  type;          /* session_id, error, or search */
   char sid[50];
   char error[50];

   char callsign[20]; /* lookup data fields */
   char nick[20];
   char qth[20];
   char country[50];
   char adif[20];
   char itu[4];
   char cq[4];
   char grid[10];
   char adr_name[50];
   char adr_street1[50];
   char adr_street2[50];
   char adr_street3[50];
   char adr_city[50];
   char adr_zip[20];
   char adr_country[50];
   char adr_adif[30];
   char district[50];
   char us_state[20];
   char us_county[30];
   char oblast[30];
   char dok[30];
   char iota[20];
   char qsl_via[50];
   char lotw[2];
   char eqsl[2];
   char qsl[2];
   char qsldirect[2];
   char email[50];
   char jabber[20];
   char icq[30];
   char msn[20];
   char skype[20];
   char birth_year[10];
   char lic_year[10];
   char picture[128];
   char web[50];
   char latitude[20];
   char longitude[20];
   char continent[20];
   char utc_offset[10];
   char facebook[128];
   char twitter[128];
   char gplus[128];
   char youtube[128];
   char linkedin[128];
   char flicker[128];
   char vimeo[128];
/*
 * add new lookup structure elements above here
 */
};

#endif

