/*  lpsk31.h
 *
 *  Header file for lpsk31
 */

/*
 *  lpsk31: An application to transmit and receive
 *  PSK31 signals using a computer's sound card
 *
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */


#ifndef PSKCODEC_H
#define PSKCODEC_H  1

#include "common.h"
#include "math.h"

/* Phase detector parameter definitions */
#define SAMPLES_PER_CYCLE        96 /* Samples per cycle of audio signal  */
#define PHASE_SHIFT_0             0 /* PSK phase reference     */
#define PHASE_SHIFT_90            1 /* PSK 90 phase advance    */
#define PHASE_SHIFT_180           2 /* PSK 180 phase reversal  */
#define PHASE_SHIFT_270           3 /* PSK 90 phase retard     */

/* Polynomials for the convolution encoder */
#define POLYNOM1               0x19
#define POLYNOM2               0x17

/* Trellis data structure for the Viterbi decoder */
typedef struct
{
  int      distance; /* Total excess distance to this state  */
  long int estimate; /* Estimate of transmitted bit sequence */

} trellis_state_t;

/*
   The VARICODE Alphabet

   The codes are transmitted left bit first, with '0' representing
   a phase reversal on BPSK and '1' representing a steady carrier.
   A minimum of two zeros is inserted between characters.
   Some implementations may not handle all the codes below 32.
 */

#define NUM_VARICODE_CHARS  128

#define VARICODE_ALPHABET \
{ \
  /* ASCII   VARICODE       HEX */ \
  /* NUL   10 1010 1011 */  0x2ab, \
  /* SOH   10 1101 1011 */  0x2db, \
  /* STX   10 1110 1101 */  0x2ed, \
  /* ETX   11 0111 0111 */  0x377, \
  /* EOT   10 1110 1011 */  0x2eb, \
  /* ENQ   11 0101 1111 */  0x35f, \
  /* ACK   10 1110 1111 */  0x2ef, \
  /* BEL   10 1111 1101 */  0x2fd, \
  /* BS    10 1111 1111 */  0x2ff, \
  /* TAB      1110 1111 */  0x0ef, \
  /* LF          1 1101 */  0x01d, \
  /* VT    11 0110 1111 */  0x36f, \
  /* FF    10 1101 1101 */  0x2dd, \
  /* CR          1 1111 */  0x01f, \
  /* SO    11 0111 0101 */  0x375, \
  /* SI    11 1010 1011 */  0x3ab, \
  /* DLE   10 1111 0111 */  0x2f7, \
  /* DC1   10 1111 0101 */  0x2f5, \
  /* DC2   11 1010 1101 */  0x3ad, \
  /* DC3   11 1010 1111 */  0x3af, \
  /* DC4   11 0101 1011 */  0x35b, \
  /* NAK   11 0110 1011 */  0x36b, \
  /* SYN   11 0110 1101 */  0x36d, \
  /* ETB   11 0101 0111 */  0x357, \
  /* CAN   11 0111 1011 */  0x37b, \
  /* EM    11 0111 1101 */  0x37d, \
  /* SUB   11 1011 0111 */  0x3b7, \
  /* ESC   11 0101 0101 */  0x355, \
  /* FS    11 0101 1101 */  0x35d, \
  /* GS    11 1011 1011 */  0x3bb, \
  /* RS    10 1111 1011 */  0x2fb, \
  /* US    11 0111 1111 */  0x37f, \
  /*                  1 */  0x001, \
  /* !      1 1111 1111 */  0x1ff, \
  /* "      1 0101 1111 */  0x15f, \
  /* #      1 1111 0101 */  0x1f5, \
  /* $      1 1101 1011 */  0x1db, \
  /* %     10 1101 0101 */  0x2d5, \
  /* &     10 1011 1011 */  0x2bb, \
  /* '      1 0111 1111 */  0x17f, \
  /* (        1111 1011 */  0x0fb, \
  /* )        1111 0111 */  0x0f7, \
  /* *      1 0110 1111 */  0x16f, \
  /* +      1 1101 1111 */  0x1df, \
  /* ,         111 0101 */  0x075, \
  /* -          11 0101 */  0x035, \
  /* .         101 0111 */  0x057, \
  /* /      1 1010 1111 */  0x1af, \
  /* 0        1011 0111 */  0x0b7, \
  /* 1        1011 1101 */  0x0bd, \
  /* 2        1110 1101 */  0x0ed, \
  /* 3        1111 1111 */  0x0ff, \
  /* 4      1 0111 0111 */  0x177, \
  /* 5      1 0101 1011 */  0x15b, \
  /* 6      1 0110 1011 */  0x16b, \
  /* 7      1 1010 1101 */  0x1ad, \
  /* 8      1 1010 1011 */  0x1ab, \
  /* 9      1 1011 0111 */  0x1b7, \
  /* :        1111 0101 */  0x0f5, \
  /* ;      1 1011 1101 */  0x1bd, \
  /* <      1 1110 1101 */  0x1ed, \
  /* =         101 0101 */  0x055, \
  /* >      1 1101 0111 */  0x1d7, \
  /* ?     10 1010 1111 */  0x2af, \
  /* @     10 1011 1101 */  0x2bd, \
  /* A         111 1101 */  0x07d, \
  /* B        1110 1011 */  0x0eb, \
  /* C        1010 1101 */  0x0ad, \
  /* D        1011 0101 */  0x0b5, \
  /* E         111 0111 */  0x077, \
  /* F        1101 1011 */  0x0db, \
  /* G        1111 1101 */  0x0fd, \
  /* H      1 0101 0101 */  0x155, \
  /* I         111 1111 */  0x07f, \
  /* J      1 1111 1101 */  0x1fd, \
  /* K      1 0111 1101 */  0x17d, \
  /* L        1101 0111 */  0x0d7, \
  /* M        1011 1011 */  0x0bb, \
  /* N        1101 1101 */  0x0dd, \
  /* O        1010 1011 */  0x0ab, \
  /* P        1101 0101 */  0x0d5, \
  /* Q      1 1101 1101 */  0x1dd, \
  /* R        1010 1111 */  0x0af, \
  /* S         110 1111 */  0x06f, \
  /* T         110 1101 */  0x06d, \
  /* U      1 0101 0111 */  0x157, \
  /* V      1 1011 0101 */  0x1b5, \
  /* W      1 0101 1101 */  0x15d, \
  /* X      1 0111 0101 */  0x175, \
  /* Y      1 0111 1011 */  0x17b, \
  /* Z     10 1010 1101 */  0x2ad, \
  /* [      1 1111 0111 */  0x1f7, \
  /* \      1 1110 1111 */  0x1ef, \
  /* ]      1 1111 1011 */  0x1fb, \
  /* ^     10 1011 1111 */  0x2bf, \
  /* _      1 0110 1101 */  0x16d, \
  /* `     10 1101 1111 */  0x2df, \
  /* a             1011 */  0x00b, \
  /* b         101 1111 */  0x05f, \
  /* c          10 1111 */  0x02f, \
  /* d          10 1101 */  0x02d, \
  /* e               11 */  0x003, \
  /* f          11 1101 */  0x03d, \
  /* g         101 1011 */  0x05b, \
  /* h          10 1011 */  0x02b, \
  /* i             1101 */  0x00d, \
  /* j      1 1110 1011 */  0x1eb, \
  /* k        1011 1111 */  0x0bf, \
  /* l           1 1011 */  0x01b, \
  /* m          11 1011 */  0x03b, \
  /* n             1111 */  0x00f, \
  /* o              111 */  0x007, \
  /* p          11 1111 */  0x03f, \
  /* q      1 1011 1111 */  0x1bf, \
  /* r           1 0101 */  0x015, \
  /* s           1 0111 */  0x017, \
  /* t              101 */  0x005, \
  /* u          11 0111 */  0x037, \
  /* v         111 1011 */  0x07b, \
  /* w         110 1011 */  0x06b, \
  /* x        1101 1111 */  0x0df, \
  /* y         101 1101 */  0x05d, \
  /* z      1 1101 0101 */  0x1d5, \
  /* {     10 1011 0111 */  0x2b7, \
  /* |      1 1011 1011 */  0x1bb, \
  /* }     10 1011 0101 */  0x2b5, \
  /* ~     10 1101 0111 */  0x2d7, \
  /* DEL   11 1011 0101 */  0x3b5  \
}

/*
   The CONVOLUTIONAL Code

   The left column contains the 32 combinations of a run of five
   Varicode bits, transmitted left bit first. The right column is
   the corresponding phase shift to be applied to the carrier, with
   0 meaning no shift, 1 meaning advance by 90, 2 meaning polarity
   reversal and 3 meaning retard by 90.  A continuous phase advance
   is the same as an HF frequency shift.
 */

#define CONVOLUTIONAL_CODE \
{ 			  \
  /* Bits      Phase */ \
  /* 00000 */  2,       \
  /* 00001 */  1,       \
  /* 00010 */  3,       \
  /* 00011 */  0,       \
  /* 00100 */  3,       \
  /* 00101 */  0,       \
  /* 00110 */  2,       \
  /* 00111 */  1,       \
  /* 01000 */  0,       \
  /* 01001 */  3,       \
  /* 01010 */  1,       \
  /* 01011 */  2,       \
  /* 01100 */  1,       \
  /* 01101 */  2,       \
  /* 01110 */  0,       \
  /* 01111 */  3,       \
  /* 10000 */  1,       \
  /* 10001 */  2,       \
  /* 10010 */  0,       \
  /* 10011 */  3,       \
  /* 10100 */  0,       \
  /* 10101 */  3,       \
  /* 10110 */  1,       \
  /* 10111 */  2,       \
  /* 11000 */  3,       \
  /* 11001 */  0,       \
  /* 11010 */  2,       \
  /* 11011 */  1,       \
  /* 11100 */  2,       \
  /* 11101 */  1,       \
  /* 11110 */  3,       \
  /* 11111 */  0        \
}

/*
   For example, the "space" symbol - a single 1 preceded and followed
   by zeros - would be represented by successive run-of-five groups
   00000, 00001, 00010, 00100, 01000, 10000, 00000.
   The transmitter will send the QPSK pattern .. 2,1,3,3,0,1,2, ..
   Note that a continuous sequence of zeros (the idle sequence)
   gives continuous reversals, the same as BPSK.
 */

/*-------------------------------------------------------------------*/

/* Definitions for ascii to Morse code conversion */
#define NUM_MORSE_CHARS           55 /* Number of chars in Morse table */

/* ASCII equivalents to Morse hex code. Last */
/* one (*) used for unrecognized characters. */
#define ASCII_CHAR \
{    \
  'A','B','C','D','E','F','G','H','I','J','K','L','M', \
  'N','O','P','Q','R','S','T','U','V','W','X','Y','Z', \
  '1','2','3','4','5','6','7','8','9','0','.',',',':', \
  '?','\'','-','/','(','"',';','$','#','<','!','@',']',\
  '=','~',' '		  								   \
}

/* Hex equivalents to Morse code chars above. Formed   */
/* by starting with a 1 and following with a 0 for     */
/* dash and 1 for dit e.g: A = ditdah = 101 = Hex 0x06 */
#define MORSE_CODE \
{ \
  0x06,0x17,0x15,0x0b,0x03,0x1d,0x09,0x1f,0x07,0x18,0x0a,0x1b,0x04,\
  0x05,0x08,0x19,0x12,0x0d,0x0f,0x02,0x0e,0x1e,0x0c,0x16,0x14,0x13,\
  0x30,0x38,0x3c,0x3e,0x3f,0x2f,0x27,0x23,0x21,0x20,0x6a,0x4c,0x47,\
  0x73,0x61,0x5e,0x2d,0x52,0x6d,0x55,0xf6,0x35,0x7a,0x2a,0x37,0x29,\
  0x2e,0xff,0x01												   \
}

/*** Tables for various trig functions ***/

/* Sine wave table (Full cycle) */
#define SINE_WAVE_TABLE_SIZE   64
#define SINE_WAVE_TABLE \
{ \
     0,   12,   25,   37,   49,   60,   71,   81, \
    90,   98,  106,  112,  117,  122,  125,  126, \
   127,  126,  125,  122,  117,  112,  106,   98, \
    90,   81,   71,   60,   49,   37,   25,   12, \
     0,  -12,  -25,  -37,  -49,  -60,  -71,  -81, \
   -90,  -98, -106, -112, -117, -122, -125, -126, \
  -127, -126, -125, -122, -117, -112, -106,  -98, \
   -90,  -81,  -71,  -60,  -49,  -37,  -25,  -12  \
}

/* Cosine wave table (1/4 cycle) */
#define COSINE_WAVE_TABLE_SIZE   512
#define COSINE_WAVE_TABLE \
{ \
  65536, 65536, 65535, 65533, 65531, 65528, 65525, 65521, \
  65516, 65511, 65505, 65499, 65492, 65484, 65476, 65467, \
  65457, 65447, 65436, 65425, 65413, 65400, 65387, 65373, \
  65358, 65343, 65328, 65311, 65294, 65277, 65259, 65240, \
  65220, 65200, 65180, 65159, 65137, 65114, 65091, 65067, \
  65043, 65018, 64993, 64967, 64940, 64912, 64884, 64856, \
  64827, 64797, 64766, 64735, 64704, 64672, 64639, 64605, \
  64571, 64536, 64501, 64465, 64429, 64392, 64354, 64316, \
  64277, 64237, 64197, 64156, 64115, 64073, 64031, 63987, \
  63944, 63899, 63854, 63809, 63763, 63716, 63668, 63621, \
  63572, 63523, 63473, 63423, 63372, 63320, 63268, 63215, \
  63162, 63108, 63054, 62998, 62943, 62886, 62830, 62772, \
  62714, 62655, 62596, 62536, 62476, 62415, 62353, 62291, \
  62228, 62165, 62101, 62036, 61971, 61906, 61839, 61772, \
  61705, 61637, 61568, 61499, 61429, 61359, 61288, 61217, \
  61145, 61072, 60999, 60925, 60851, 60776, 60700, 60624, \
  60547, 60470, 60392, 60314, 60235, 60156, 60075, 59995, \
  59914, 59832, 59750, 59667, 59583, 59499, 59415, 59330, \
  59244, 59158, 59071, 58983, 58896, 58807, 58718, 58628, \
  58538, 58448, 58356, 58265, 58172, 58079, 57986, 57892, \
  57798, 57703, 57607, 57511, 57414, 57317, 57219, 57121, \
  57022, 56923, 56823, 56722, 56621, 56520, 56418, 56315, \
  56212, 56108, 56004, 55900, 55794, 55689, 55582, 55476, \
  55368, 55260, 55152, 55043, 54934, 54824, 54714, 54603, \
  54491, 54379, 54267, 54154, 54040, 53926, 53812, 53697, \
  53581, 53465, 53349, 53232, 53114, 52996, 52878, 52759, \
  52639, 52519, 52398, 52277, 52156, 52034, 51911, 51789, \
  51665, 51541, 51417, 51292, 51166, 51041, 50914, 50787, \
  50660, 50532, 50404, 50275, 50146, 50016, 49886, 49756, \
  49624, 49493, 49361, 49228, 49095, 48962, 48828, 48694, \
  48559, 48424, 48288, 48152, 48015, 47878, 47741, 47603, \
  47464, 47325, 47186, 47046, 46906, 46765, 46624, 46483, \
  46341, 46199, 46056, 45912, 45769, 45625, 45480, 45335, \
  45190, 45044, 44898, 44751, 44604, 44456, 44308, 44160, \
  44011, 43862, 43713, 43562, 43412, 43261, 43110, 42958, \
  42806, 42654, 42501, 42348, 42194, 42040, 41886, 41731, \
  41576, 41420, 41264, 41108, 40951, 40794, 40636, 40478, \
  40320, 40161, 40002, 39843, 39683, 39523, 39362, 39201, \
  39040, 38878, 38716, 38554, 38391, 38228, 38064, 37900, \
  37736, 37572, 37407, 37241, 37076, 36910, 36744, 36577, \
  36410, 36243, 36075, 35907, 35738, 35570, 35401, 35231, \
  35062, 34892, 34721, 34551, 34380, 34208, 34037, 33865, \
  33692, 33520, 33347, 33173, 33000, 32826, 32652, 32477, \
  32303, 32127, 31952, 31776, 31600, 31424, 31248, 31071, \
  30893, 30716, 30538, 30360, 30182, 30003, 29824, 29645, \
  29466, 29286, 29106, 28926, 28745, 28564, 28383, 28202, \
  28020, 27838, 27656, 27474, 27291, 27108, 26925, 26742, \
  26558, 26374, 26190, 26005, 25821, 25636, 25451, 25265, \
  25080, 24894, 24708, 24521, 24335, 24148, 23961, 23774, \
  23586, 23398, 23210, 23022, 22834, 22645, 22457, 22268, \
  22078, 21889, 21699, 21510, 21320, 21129, 20939, 20748, \
  20557, 20366, 20175, 19984, 19792, 19600, 19409, 19216, \
  19024, 18832, 18639, 18446, 18253, 18060, 17867, 17673, \
  17479, 17285, 17091, 16897, 16703, 16508, 16314, 16119, \
  15924, 15729, 15534, 15338, 15143, 14947, 14751, 14555, \
  14359, 14163, 13966, 13770, 13573, 13376, 13180, 12983, \
  12785, 12588, 12391, 12193, 11996, 11798, 11600, 11402, \
  11204, 11006, 10808, 10609, 10411, 10212, 10014,  9815, \
   9616,  9417,  9218,  9019,  8820,  8621,  8421,  8222, \
   8022,  7823,  7623,  7423,  7224,  7024,  6824,  6624, \
   6424,  6224,  6023,  5823,  5623,  5422,  5222,  5022, \
   4821,  4621,  4420,  4219,  4019,  3818,  3617,  3417, \
   3216,  3015,  2814,  2613,  2412,  2211,  2010,  1809, \
   1608,  1407,  1206,  1005,   804,   603,   402,   201  \
}

#endif

