/*
 * Decompiled with CFR 0.152.
 */
package org.xml.sax.ext;

import org.xml.sax.Attributes;
import org.xml.sax.ext.Attributes2;
import org.xml.sax.helpers.AttributesImpl;

public class Attributes2Impl
extends AttributesImpl
implements Attributes2 {
    private boolean[] declared;
    private boolean[] specified;

    public Attributes2Impl() {
    }

    public Attributes2Impl(Attributes attributes) {
        super(attributes);
    }

    public boolean isDeclared(int n2) {
        if (n2 < 0 || n2 >= this.getLength()) {
            throw new ArrayIndexOutOfBoundsException("No attribute at index: " + n2);
        }
        return this.declared[n2];
    }

    public boolean isDeclared(String string, String string2) {
        int n2 = this.getIndex(string, string2);
        if (n2 < 0) {
            throw new IllegalArgumentException("No such attribute: local=" + string2 + ", namespace=" + string);
        }
        return this.declared[n2];
    }

    public boolean isDeclared(String string) {
        int n2 = this.getIndex(string);
        if (n2 < 0) {
            throw new IllegalArgumentException("No such attribute: " + string);
        }
        return this.declared[n2];
    }

    public boolean isSpecified(int n2) {
        if (n2 < 0 || n2 >= this.getLength()) {
            throw new ArrayIndexOutOfBoundsException("No attribute at index: " + n2);
        }
        return this.specified[n2];
    }

    public boolean isSpecified(String string, String string2) {
        int n2 = this.getIndex(string, string2);
        if (n2 < 0) {
            throw new IllegalArgumentException("No such attribute: local=" + string2 + ", namespace=" + string);
        }
        return this.specified[n2];
    }

    public boolean isSpecified(String string) {
        int n2 = this.getIndex(string);
        if (n2 < 0) {
            throw new IllegalArgumentException("No such attribute: " + string);
        }
        return this.specified[n2];
    }

    public void setAttributes(Attributes attributes) {
        int n2 = attributes.getLength();
        super.setAttributes(attributes);
        this.declared = new boolean[n2];
        this.specified = new boolean[n2];
        if (attributes instanceof Attributes2) {
            Attributes2 attributes2 = (Attributes2)attributes;
            int n3 = 0;
            while (n3 < n2) {
                this.declared[n3] = attributes2.isDeclared(n3);
                this.specified[n3] = attributes2.isSpecified(n3);
                ++n3;
            }
        } else {
            int n4 = 0;
            while (n4 < n2) {
                this.declared[n4] = !"CDATA".equals(attributes.getType(n4));
                this.specified[n4] = true;
                ++n4;
            }
        }
    }

    public void addAttribute(String string, String string2, String string3, String string4, String string5) {
        super.addAttribute(string, string2, string3, string4, string5);
        int n2 = this.getLength();
        if (n2 < this.specified.length) {
            boolean[] blArray = new boolean[n2];
            System.arraycopy(this.declared, 0, blArray, 0, this.declared.length);
            this.declared = blArray;
            blArray = new boolean[n2];
            System.arraycopy(this.specified, 0, blArray, 0, this.specified.length);
            this.specified = blArray;
        }
        this.specified[n2 - 1] = true;
        this.declared[n2 - 1] = !"CDATA".equals(string4);
    }

    public void removeAttribute(int n2) {
        int n3 = this.getLength() - 1;
        super.removeAttribute(n2);
        if (n2 != n3) {
            System.arraycopy(this.declared, n2 + 1, this.declared, n2, n3 - n2);
            System.arraycopy(this.specified, n2 + 1, this.specified, n2, n3 - n2);
        }
    }

    public void setDeclared(int n2, boolean bl) {
        if (n2 < 0 || n2 >= this.getLength()) {
            throw new ArrayIndexOutOfBoundsException("No attribute at index: " + n2);
        }
        this.declared[n2] = bl;
    }

    public void setSpecified(int n2, boolean bl) {
        if (n2 < 0 || n2 >= this.getLength()) {
            throw new ArrayIndexOutOfBoundsException("No attribute at index: " + n2);
        }
        this.specified[n2] = bl;
    }
}

