/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.values;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.SimpleValue;
import org.apache.xmlbeans.XmlAnySimpleType;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlSimpleList;
import org.apache.xmlbeans.impl.common.PrefixResolver;
import org.apache.xmlbeans.impl.common.QNameHelper;
import org.apache.xmlbeans.impl.common.ValidationContext;
import org.apache.xmlbeans.impl.common.XMLChar;
import org.apache.xmlbeans.impl.values.NamespaceContext;
import org.apache.xmlbeans.impl.values.NamespaceManager;
import org.apache.xmlbeans.impl.values.XmlObjectBase;
import org.apache.xmlbeans.impl.values.XmlValueOutOfRangeException;

public class XmlListImpl
extends XmlObjectBase
implements XmlAnySimpleType {
    private SchemaType _schemaType;
    private XmlSimpleList _value;
    private XmlSimpleList _jvalue;
    private static final String[] EMPTY_STRINGARRAY = new String[0];

    public XmlListImpl(SchemaType type, boolean complex) {
        this._schemaType = type;
        this.initComplexType(complex, false);
    }

    public SchemaType schemaType() {
        return this._schemaType;
    }

    private static String nullAsEmpty(String s2) {
        if (s2 == null) {
            return "";
        }
        return s2;
    }

    private static String compute_list_text(List xList) {
        if (xList.size() == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append(XmlListImpl.nullAsEmpty(((SimpleValue)xList.get(0)).getStringValue()));
        for (int i2 = 1; i2 < xList.size(); ++i2) {
            sb.append(' ');
            sb.append(XmlListImpl.nullAsEmpty(((SimpleValue)xList.get(i2)).getStringValue()));
        }
        return sb.toString();
    }

    protected String compute_text(NamespaceManager nsm) {
        return XmlListImpl.compute_list_text(this._value);
    }

    protected boolean is_defaultable_ws(String v2) {
        try {
            XmlSimpleList savedValue = this._value;
            this.set_text(v2);
            this._value = savedValue;
            return false;
        }
        catch (XmlValueOutOfRangeException e2) {
            return true;
        }
    }

    protected void set_text(String s2) {
        if (this._validateOnSet() && !this._schemaType.matchPatternFacet(s2)) {
            throw new XmlValueOutOfRangeException("cvc-datatype-valid.1.1", new Object[]{"list", s2, QNameHelper.readable(this._schemaType)});
        }
        SchemaType itemType = this._schemaType.getListItemType();
        XmlSimpleList newval = XmlListImpl.lex(s2, itemType, _voorVc, this.has_store() ? this.get_store() : null);
        if (this._validateOnSet()) {
            XmlListImpl.validateValue(newval, this._schemaType, _voorVc);
        }
        this._value = newval;
        this._jvalue = null;
    }

    public static String[] split_list(String s2) {
        if (s2.length() == 0) {
            return EMPTY_STRINGARRAY;
        }
        ArrayList<String> result = new ArrayList<String>();
        int i2 = 0;
        int start = 0;
        while (true) {
            if (i2 < s2.length() && XMLChar.isSpace(s2.charAt(i2))) {
                ++i2;
                continue;
            }
            if (i2 >= s2.length()) {
                return result.toArray(EMPTY_STRINGARRAY);
            }
            start = i2;
            while (i2 < s2.length() && !XMLChar.isSpace(s2.charAt(i2))) {
                ++i2;
            }
            result.add(s2.substring(start, i2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XmlSimpleList lex(String s2, SchemaType itemType, ValidationContext ctx, PrefixResolver resolver) {
        String[] parts = XmlListImpl.split_list(s2);
        XmlAnySimpleType[] newArray = new XmlAnySimpleType[parts.length];
        boolean pushed = false;
        if (resolver != null) {
            NamespaceContext.push(new NamespaceContext(resolver));
            pushed = true;
        }
        int i2 = 0;
        try {
            for (i2 = 0; i2 < parts.length; ++i2) {
                try {
                    newArray[i2] = itemType.newValue(parts[i2]);
                    continue;
                }
                catch (XmlValueOutOfRangeException e2) {
                    ctx.invalid("list", new Object[]{"item '" + parts[i2] + "' is not a valid value of " + QNameHelper.readable(itemType)});
                }
            }
        }
        finally {
            if (pushed) {
                NamespaceContext.pop();
            }
        }
        return new XmlSimpleList(Arrays.asList(newArray));
    }

    protected void set_nil() {
        this._value = null;
    }

    public List xgetListValue() {
        this.check_dated();
        return this._value;
    }

    public List getListValue() {
        this.check_dated();
        if (this._value == null) {
            return null;
        }
        if (this._jvalue != null) {
            return this._jvalue;
        }
        ArrayList<Object> javaResult = new ArrayList<Object>();
        for (int i2 = 0; i2 < this._value.size(); ++i2) {
            javaResult.add(XmlListImpl.java_value((XmlObject)this._value.get(i2)));
        }
        this._jvalue = new XmlSimpleList(javaResult);
        return this._jvalue;
    }

    private static boolean permits_inner_space(XmlObject obj) {
        switch (((SimpleValue)obj).instanceType().getPrimitiveType().getBuiltinTypeCode()) {
            case 1: 
            case 2: 
            case 6: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    private static boolean contains_white_space(String s2) {
        return s2.indexOf(32) >= 0 || s2.indexOf(9) >= 0 || s2.indexOf(10) >= 0 || s2.indexOf(13) >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set_list(List list) {
        XmlSimpleList xList;
        SchemaType itemType = this._schemaType.getListItemType();
        boolean pushed = false;
        if (this.has_store()) {
            NamespaceContext.push(new NamespaceContext(this.get_store()));
            pushed = true;
        }
        try {
            XmlAnySimpleType[] newval = new XmlAnySimpleType[list.size()];
            for (int i2 = 0; i2 < list.size(); ++i2) {
                String stringrep;
                Object entry = list.get(i2);
                if (entry instanceof XmlObject && XmlListImpl.permits_inner_space((XmlObject)list.get(i2)) && XmlListImpl.contains_white_space(stringrep = list.get(i2).toString())) {
                    throw new XmlValueOutOfRangeException();
                }
                newval[i2] = itemType.newValue(entry);
            }
            xList = new XmlSimpleList(Arrays.asList(newval));
        }
        finally {
            if (pushed) {
                NamespaceContext.pop();
            }
        }
        if (this._validateOnSet()) {
            XmlListImpl.validateValue(xList, this._schemaType, _voorVc);
        }
        this._value = xList;
        this._jvalue = null;
    }

    public static void validateValue(XmlSimpleList items, SchemaType sType, ValidationContext context) {
        int i2;
        XmlAnySimpleType o2;
        block6: {
            XmlAnySimpleType[] enumvals = sType.getEnumerationValues();
            if (enumvals != null) {
                for (int i3 = 0; i3 < enumvals.length; ++i3) {
                    if (!XmlListImpl.equal_xmlLists(items, ((XmlObjectBase)((Object)enumvals[i3])).xlistValue())) {
                        continue;
                    }
                    break block6;
                }
                context.invalid("cvc-enumeration-valid", new Object[]{"list", items, QNameHelper.readable(sType)});
            }
        }
        if ((o2 = sType.getFacet(0)) != null && (i2 = ((SimpleValue)((Object)o2)).getIntValue()) != items.size()) {
            context.invalid("cvc-length-valid.2", new Object[]{items, new Integer(items.size()), new Integer(i2), QNameHelper.readable(sType)});
        }
        if ((o2 = sType.getFacet(1)) != null && (i2 = ((SimpleValue)((Object)o2)).getIntValue()) > items.size()) {
            context.invalid("cvc-minLength-valid.2", new Object[]{items, new Integer(items.size()), new Integer(i2), QNameHelper.readable(sType)});
        }
        if ((o2 = sType.getFacet(2)) != null && (i2 = ((SimpleValue)((Object)o2)).getIntValue()) < items.size()) {
            context.invalid("cvc-maxLength-valid.2", new Object[]{items, new Integer(items.size()), new Integer(i2), QNameHelper.readable(sType)});
        }
    }

    protected boolean equal_to(XmlObject obj) {
        return XmlListImpl.equal_xmlLists(this._value, ((XmlObjectBase)obj).xlistValue());
    }

    private static boolean equal_xmlLists(List a2, List b2) {
        if (a2.size() != b2.size()) {
            return false;
        }
        for (int i2 = 0; i2 < a2.size(); ++i2) {
            if (a2.get(i2).equals(b2.get(i2))) continue;
            return false;
        }
        return true;
    }

    protected int value_hash_code() {
        int i2;
        if (this._value == null) {
            return 0;
        }
        int hash = this._value.size();
        int incr = this._value.size() / 9;
        if (incr < 1) {
            incr = 1;
        }
        for (i2 = 0; i2 < this._value.size(); i2 += incr) {
            hash *= 19;
            hash += this._value.get(i2).hashCode();
        }
        if (i2 < this._value.size()) {
            hash *= 19;
            hash += this._value.get(i2).hashCode();
        }
        return hash;
    }

    protected void validate_simpleval(String lexical, ValidationContext ctx) {
        XmlListImpl.validateValue((XmlSimpleList)this.xlistValue(), this.schemaType(), ctx);
    }
}

