/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.crypt.xor;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.util.BitSet;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.poi.poifs.crypt.ChunkedCipherOutputStream;
import org.apache.poi.poifs.crypt.CryptoFunctions;
import org.apache.poi.poifs.crypt.Encryptor;
import org.apache.poi.poifs.crypt.xor.XORDecryptor;
import org.apache.poi.poifs.crypt.xor.XOREncryptionVerifier;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.util.LittleEndian;

public class XOREncryptor
extends Encryptor
implements Cloneable {
    protected XOREncryptor() {
    }

    @Override
    public void confirmPassword(String password) {
        int keyComp = CryptoFunctions.createXorKey1(password);
        int verifierComp = CryptoFunctions.createXorVerifier1(password);
        byte[] xorArray = CryptoFunctions.createXorArray1(password);
        byte[] shortBuf = new byte[2];
        XOREncryptionVerifier ver = (XOREncryptionVerifier)this.getEncryptionInfo().getVerifier();
        LittleEndian.putUShort(shortBuf, 0, keyComp);
        ver.setEncryptedKey(shortBuf);
        LittleEndian.putUShort(shortBuf, 0, verifierComp);
        ver.setEncryptedVerifier(shortBuf);
        this.setSecretKey(new SecretKeySpec(xorArray, "XOR"));
    }

    @Override
    public void confirmPassword(String password, byte[] keySpec, byte[] keySalt, byte[] verifier, byte[] verifierSalt, byte[] integritySalt) {
        this.confirmPassword(password);
    }

    @Override
    public OutputStream getDataStream(DirectoryNode dir) throws IOException, GeneralSecurityException {
        return new XORCipherOutputStream(dir);
    }

    @Override
    public XORCipherOutputStream getDataStream(OutputStream stream, int initialOffset) throws IOException, GeneralSecurityException {
        return new XORCipherOutputStream(stream, initialOffset);
    }

    protected int getKeySizeInBytes() {
        return -1;
    }

    @Override
    public void setChunkSize(int chunkSize) {
    }

    protected void createEncryptionInfoEntry(DirectoryNode dir) throws IOException {
    }

    @Override
    public XOREncryptor clone() throws CloneNotSupportedException {
        return (XOREncryptor)super.clone();
    }

    private class XORCipherOutputStream
    extends ChunkedCipherOutputStream {
        private int recordStart;
        private int recordEnd;

        public XORCipherOutputStream(OutputStream stream, int initialPos) throws IOException, GeneralSecurityException {
            super(stream, -1);
            this.recordStart = 0;
            this.recordEnd = 0;
        }

        public XORCipherOutputStream(DirectoryNode dir) throws IOException, GeneralSecurityException {
            super(dir, -1);
            this.recordStart = 0;
            this.recordEnd = 0;
        }

        @Override
        protected Cipher initCipherForBlock(Cipher cipher, int block, boolean lastChunk) throws GeneralSecurityException {
            return XORDecryptor.initCipherForBlock(cipher, block, XOREncryptor.this.getEncryptionInfo(), XOREncryptor.this.getSecretKey(), 1);
        }

        @Override
        protected void calculateChecksum(File file, int i2) {
        }

        @Override
        protected void createEncryptionInfoEntry(DirectoryNode dir, File tmpFile) throws IOException, GeneralSecurityException {
            XOREncryptor.this.createEncryptionInfoEntry(dir);
        }

        @Override
        public void setNextRecordSize(int recordSize, boolean isPlain) {
            if (this.recordEnd > 0 && !isPlain) {
                this.invokeCipher((int)this.getPos(), true);
            }
            this.recordStart = (int)this.getTotalPos() + 4;
            this.recordEnd = this.recordStart + recordSize;
        }

        @Override
        public void flush() throws IOException {
            this.setNextRecordSize(0, true);
            super.flush();
        }

        @Override
        protected int invokeCipher(int posInChunk, boolean doFinal) {
            int i2;
            if (posInChunk == 0) {
                return 0;
            }
            int start = Math.max(posInChunk - (this.recordEnd - this.recordStart), 0);
            BitSet plainBytes = this.getPlainByteFlags();
            byte[] xorArray = XOREncryptor.this.getEncryptionInfo().getEncryptor().getSecretKey().getEncoded();
            byte[] chunk = this.getChunk();
            byte[] plain = plainBytes.isEmpty() ? null : (byte[])chunk.clone();
            int xorArrayIndex = this.recordEnd + (start - this.recordStart);
            for (i2 = start; i2 < posInChunk; ++i2) {
                byte value = chunk[i2];
                value = (byte)(value ^ xorArray[xorArrayIndex++ & 0xF]);
                chunk[i2] = value = this.rotateLeft(value, 5);
            }
            i2 = plainBytes.nextSetBit(start);
            while (i2 >= 0 && i2 < posInChunk) {
                chunk[i2] = plain[i2];
                i2 = plainBytes.nextSetBit(i2 + 1);
            }
            return posInChunk;
        }

        private byte rotateLeft(byte bits, int shift) {
            return (byte)((bits & 0xFF) << shift | (bits & 0xFF) >>> 8 - shift);
        }
    }
}

