/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.extractor;

import java.io.File;
import org.apache.poi.POITextExtractor;
import org.apache.poi.extractor.ExtractorFactory;

public class CommandLineTextExtractor {
    public static final String DIVIDER = "=======================";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.err.println("Use:");
            System.err.println("   CommandLineTextExtractor <filename> [filename] [filename]");
            System.exit(1);
        }
        for (String arg : args) {
            System.out.println(DIVIDER);
            File f2 = new File(arg);
            System.out.println(f2);
            POITextExtractor extractor = ExtractorFactory.createExtractor(f2);
            try {
                POITextExtractor metadataExtractor = extractor.getMetadataTextExtractor();
                System.out.println("   =======================");
                String metaData = metadataExtractor.getText();
                System.out.println(metaData);
                System.out.println("   =======================");
                String text = extractor.getText();
                System.out.println(text);
                System.out.println(DIVIDER);
                System.out.println("Had " + metaData.length() + " characters of metadata and " + text.length() + " characters of text");
            }
            finally {
                extractor.close();
            }
        }
    }
}

