/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.util.gui;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.batik.util.gui.ExtendedGridBagConstraints;
import org.apache.batik.util.gui.resource.ActionMap;
import org.apache.batik.util.gui.resource.ButtonFactory;
import org.apache.batik.util.gui.resource.MissingListenerException;
import org.apache.batik.util.resources.ResourceManager;

public class LanguageDialog
extends JDialog
implements ActionMap {
    public static final int OK_OPTION = 0;
    public static final int CANCEL_OPTION = 1;
    protected static final String RESOURCES = "org.apache.batik.util.gui.resources.LanguageDialogMessages";
    protected static ResourceBundle bundle = ResourceBundle.getBundle("org.apache.batik.util.gui.resources.LanguageDialogMessages", Locale.getDefault());
    protected static ResourceManager resources = new ResourceManager(bundle);
    protected Map listeners = new HashMap();
    protected Panel panel = new Panel();
    protected int returnCode;

    public LanguageDialog(JFrame f2) {
        super(f2);
        this.setModal(true);
        this.setTitle(resources.getString("Dialog.title"));
        this.listeners.put("OKButtonAction", new OKButtonAction());
        this.listeners.put("CancelButtonAction", new CancelButtonAction());
        this.getContentPane().add(this.panel);
        this.getContentPane().add((Component)this.createButtonsPanel(), "South");
        this.pack();
    }

    public int showDialog() {
        this.setVisible(true);
        return this.returnCode;
    }

    public void setLanguages(String s2) {
        this.panel.setLanguages(s2);
    }

    public String getLanguages() {
        return this.panel.getLanguages();
    }

    @Override
    public Action getAction(String key) throws MissingListenerException {
        return (Action)this.listeners.get(key);
    }

    protected JPanel createButtonsPanel() {
        JPanel p2 = new JPanel(new FlowLayout(2));
        ButtonFactory bf = new ButtonFactory(bundle, this);
        p2.add(bf.createJButton("OKButton"));
        p2.add(bf.createJButton("CancelButton"));
        return p2;
    }

    protected class CancelButtonAction
    extends AbstractAction {
        protected CancelButtonAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            LanguageDialog.this.returnCode = 1;
            LanguageDialog.this.dispose();
        }
    }

    protected class OKButtonAction
    extends AbstractAction {
        protected OKButtonAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            LanguageDialog.this.returnCode = 0;
            LanguageDialog.this.dispose();
        }
    }

    public static class Panel
    extends JPanel
    implements ActionMap {
        protected JList userList;
        protected JList languageList;
        protected DefaultListModel userListModel = new DefaultListModel();
        protected DefaultListModel languageListModel = new DefaultListModel();
        protected JButton addLanguageButton;
        protected JButton removeLanguageButton;
        protected JButton upLanguageButton;
        protected JButton downLanguageButton;
        protected JButton clearLanguageButton;
        protected Map listeners = new HashMap();
        private static Map iconMap = null;

        public Panel() {
            super(new GridBagLayout());
            Panel.initCountryIcons();
            this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), resources.getString("Panel.title")));
            this.listeners.put("AddLanguageButtonAction", new AddLanguageButtonAction());
            this.listeners.put("RemoveLanguageButtonAction", new RemoveLanguageButtonAction());
            this.listeners.put("UpLanguageButtonAction", new UpLanguageButtonAction());
            this.listeners.put("DownLanguageButtonAction", new DownLanguageButtonAction());
            this.listeners.put("ClearLanguageButtonAction", new ClearLanguageButtonAction());
            this.userList = new JList(this.userListModel);
            this.userList.setCellRenderer(new IconAndTextCellRenderer());
            this.languageList = new JList(this.languageListModel);
            this.languageList.setCellRenderer(new IconAndTextCellRenderer());
            StringTokenizer st = new StringTokenizer(resources.getString("Country.list"), " ");
            while (st.hasMoreTokens()) {
                this.languageListModel.addElement(st.nextToken());
            }
            ExtendedGridBagConstraints constraints = new ExtendedGridBagConstraints();
            constraints.insets = new Insets(5, 5, 5, 5);
            constraints.weightx = 1.0;
            constraints.weighty = 1.0;
            constraints.fill = 1;
            constraints.setGridBounds(0, 0, 1, 1);
            JScrollPane sp = new JScrollPane();
            sp.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), resources.getString("Languages.title")), BorderFactory.createLoweredBevelBorder()));
            sp.getViewport().add(this.languageList);
            this.add((Component)sp, constraints);
            this.languageList.setSelectionMode(0);
            this.languageList.addListSelectionListener(new LanguageListSelectionListener());
            constraints.setGridBounds(2, 0, 1, 1);
            JScrollPane sp2 = new JScrollPane();
            sp2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), resources.getString("User.title")), BorderFactory.createLoweredBevelBorder()));
            sp2.getViewport().add(this.userList);
            this.add((Component)sp2, constraints);
            this.userList.setSelectionMode(0);
            this.userList.addListSelectionListener(new UserListSelectionListener());
            constraints.setGridBounds(0, 1, 3, 1);
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            this.add((Component)new JLabel(resources.getString("InfoLabel.text")), constraints);
            ButtonFactory bf = new ButtonFactory(bundle, this);
            JPanel p2 = new JPanel(new GridLayout(5, 1, 0, 3));
            this.addLanguageButton = bf.createJButton("AddLanguageButton");
            p2.add(this.addLanguageButton);
            this.addLanguageButton.setEnabled(false);
            this.removeLanguageButton = bf.createJButton("RemoveLanguageButton");
            p2.add(this.removeLanguageButton);
            this.removeLanguageButton.setEnabled(false);
            this.upLanguageButton = bf.createJButton("UpLanguageButton");
            p2.add(this.upLanguageButton);
            this.upLanguageButton.setEnabled(false);
            this.downLanguageButton = bf.createJButton("DownLanguageButton");
            p2.add(this.downLanguageButton);
            this.downLanguageButton.setEnabled(false);
            this.clearLanguageButton = bf.createJButton("ClearLanguageButton");
            p2.add(this.clearLanguageButton);
            this.clearLanguageButton.setEnabled(false);
            JPanel t2 = new JPanel(new GridBagLayout());
            constraints.setGridBounds(1, 0, 1, 1);
            this.add((Component)t2, constraints);
            constraints.fill = 2;
            constraints.setGridBounds(0, 0, 1, 1);
            constraints.insets = new Insets(0, 0, 0, 0);
            t2.add((Component)p2, constraints);
            sp2.setPreferredSize(sp.getPreferredSize());
        }

        public static synchronized void initCountryIcons() {
            if (iconMap == null) {
                iconMap = new HashMap();
                StringTokenizer st = new StringTokenizer(resources.getString("Country.list"), " ");
                while (st.hasMoreTokens()) {
                    Panel.computeCountryIcon(Panel.class, st.nextToken());
                }
            }
        }

        public String getLanguages() {
            StringBuffer result = new StringBuffer();
            if (this.userListModel.getSize() > 0) {
                result.append(this.userListModel.getElementAt(0));
                for (int i2 = 1; i2 < this.userListModel.getSize(); ++i2) {
                    result.append(',');
                    result.append(this.userListModel.getElementAt(i2));
                }
            }
            return result.toString();
        }

        public void setLanguages(String str) {
            int len = this.userListModel.getSize();
            for (int i2 = 0; i2 < len; ++i2) {
                String s2;
                int n2;
                Object o2 = this.userListModel.getElementAt(0);
                this.userListModel.removeElementAt(0);
                String userListModelStr = (String)o2;
                int size = this.languageListModel.getSize();
                for (n2 = 0; n2 < size && userListModelStr.compareTo(s2 = (String)this.languageListModel.getElementAt(n2)) <= 0; ++n2) {
                }
                this.languageListModel.insertElementAt(o2, n2);
            }
            StringTokenizer st = new StringTokenizer(str, ",");
            while (st.hasMoreTokens()) {
                String s3 = st.nextToken();
                this.userListModel.addElement(s3);
                this.languageListModel.removeElement(s3);
            }
            this.updateButtons();
        }

        protected void updateButtons() {
            int size = this.userListModel.size();
            int i2 = this.userList.getSelectedIndex();
            boolean empty = size == 0;
            boolean selected = i2 != -1;
            boolean zeroSelected = i2 == 0;
            boolean lastSelected = i2 == size - 1;
            this.removeLanguageButton.setEnabled(!empty && selected);
            this.upLanguageButton.setEnabled(!empty && selected && !zeroSelected);
            this.downLanguageButton.setEnabled(!empty && selected && !lastSelected);
            this.clearLanguageButton.setEnabled(!empty);
            size = this.languageListModel.size();
            i2 = this.languageList.getSelectedIndex();
            empty = size == 0;
            selected = i2 != -1;
            this.addLanguageButton.setEnabled(!empty && selected);
        }

        protected String getCountryText(String code) {
            return resources.getString(code + ".text");
        }

        protected Icon getCountryIcon(String code) {
            return Panel.computeCountryIcon(this.getClass(), code);
        }

        private static Icon computeCountryIcon(Class ref, String code) {
            ImageIcon icon = null;
            try {
                icon = (ImageIcon)iconMap.get(code);
                if (icon != null) {
                    return icon;
                }
                String s2 = resources.getString(code + ".icon");
                URL url = ref.getResource(s2);
                if (url != null) {
                    icon = new ImageIcon(url);
                    iconMap.put(code, icon);
                    return icon;
                }
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            return new ImageIcon(ref.getResource("resources/blank.gif"));
        }

        @Override
        public Action getAction(String key) throws MissingListenerException {
            return (Action)this.listeners.get(key);
        }

        protected class IconAndTextCellRenderer
        extends JLabel
        implements ListCellRenderer {
            public IconAndTextCellRenderer() {
                this.setOpaque(true);
                this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
            }

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                String s2 = (String)value;
                this.setText(Panel.this.getCountryText(s2));
                this.setIcon(Panel.this.getCountryIcon(s2));
                this.setEnabled(list.isEnabled());
                this.setFont(list.getFont());
                if (isSelected) {
                    this.setBackground(list.getSelectionBackground());
                    this.setForeground(list.getSelectionForeground());
                } else {
                    this.setBackground(list.getBackground());
                    this.setForeground(list.getForeground());
                }
                return this;
            }
        }

        protected class UserListSelectionListener
        implements ListSelectionListener {
            protected UserListSelectionListener() {
            }

            @Override
            public void valueChanged(ListSelectionEvent e2) {
                int i2 = Panel.this.userList.getSelectedIndex();
                Panel.this.languageList.getSelectionModel().clearSelection();
                Panel.this.userList.setSelectedIndex(i2);
                Panel.this.updateButtons();
            }
        }

        protected class LanguageListSelectionListener
        implements ListSelectionListener {
            protected LanguageListSelectionListener() {
            }

            @Override
            public void valueChanged(ListSelectionEvent e2) {
                int i2 = Panel.this.languageList.getSelectedIndex();
                Panel.this.userList.getSelectionModel().clearSelection();
                Panel.this.languageList.setSelectedIndex(i2);
                Panel.this.updateButtons();
            }
        }

        protected class ClearLanguageButtonAction
        extends AbstractAction {
            protected ClearLanguageButtonAction() {
            }

            @Override
            public void actionPerformed(ActionEvent e2) {
                int len = Panel.this.userListModel.getSize();
                for (int i2 = 0; i2 < len; ++i2) {
                    String s2;
                    int n2;
                    Object o2 = Panel.this.userListModel.getElementAt(0);
                    Panel.this.userListModel.removeElementAt(0);
                    String userListModelStr = (String)o2;
                    int size = Panel.this.languageListModel.getSize();
                    for (n2 = 0; n2 < size && userListModelStr.compareTo(s2 = (String)Panel.this.languageListModel.getElementAt(n2)) <= 0; ++n2) {
                    }
                    Panel.this.languageListModel.insertElementAt(o2, n2);
                }
                Panel.this.updateButtons();
            }
        }

        protected class DownLanguageButtonAction
        extends AbstractAction {
            protected DownLanguageButtonAction() {
            }

            @Override
            public void actionPerformed(ActionEvent e2) {
                int i2 = Panel.this.userList.getSelectedIndex();
                Object o2 = Panel.this.userListModel.getElementAt(i2);
                Panel.this.userListModel.removeElementAt(i2);
                Panel.this.userListModel.insertElementAt(o2, i2 + 1);
                Panel.this.userList.setSelectedIndex(i2 + 1);
            }
        }

        protected class UpLanguageButtonAction
        extends AbstractAction {
            protected UpLanguageButtonAction() {
            }

            @Override
            public void actionPerformed(ActionEvent e2) {
                int i2 = Panel.this.userList.getSelectedIndex();
                Object o2 = Panel.this.userListModel.getElementAt(i2);
                Panel.this.userListModel.removeElementAt(i2);
                Panel.this.userListModel.insertElementAt(o2, i2 - 1);
                Panel.this.userList.setSelectedIndex(i2 - 1);
            }
        }

        protected class RemoveLanguageButtonAction
        extends AbstractAction {
            protected RemoveLanguageButtonAction() {
            }

            @Override
            public void actionPerformed(ActionEvent e2) {
                String s2;
                int n2;
                int i2 = Panel.this.userList.getSelectedIndex();
                Object o2 = Panel.this.userListModel.getElementAt(i2);
                Panel.this.userListModel.removeElementAt(i2);
                String userListModelStr = (String)o2;
                int size = Panel.this.languageListModel.getSize();
                for (n2 = 0; n2 < size && userListModelStr.compareTo(s2 = (String)Panel.this.languageListModel.getElementAt(n2)) <= 0; ++n2) {
                }
                Panel.this.languageListModel.insertElementAt(o2, n2);
                Panel.this.languageList.setSelectedValue(o2, true);
                Panel.this.updateButtons();
            }
        }

        protected class AddLanguageButtonAction
        extends AbstractAction {
            protected AddLanguageButtonAction() {
            }

            @Override
            public void actionPerformed(ActionEvent e2) {
                int i2 = Panel.this.languageList.getSelectedIndex();
                Object o2 = Panel.this.languageListModel.getElementAt(i2);
                Panel.this.languageListModel.removeElementAt(i2);
                Panel.this.userListModel.addElement(o2);
                Panel.this.userList.setSelectedValue(o2, true);
            }
        }
    }
}

