/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen.font.table;

import java.io.ByteArrayInputStream;
import org.apache.batik.svggen.font.table.GlyfDescript;
import org.apache.batik.svggen.font.table.GlyfTable;

public class GlyfSimpleDescript
extends GlyfDescript {
    private int[] endPtsOfContours;
    private byte[] flags;
    private short[] xCoordinates;
    private short[] yCoordinates;
    private int count;

    public GlyfSimpleDescript(GlyfTable parentTable, short numberOfContours, ByteArrayInputStream bais) {
        super(parentTable, (short)numberOfContours, bais);
        this.endPtsOfContours = new int[numberOfContours];
        for (int i2 = 0; i2 < numberOfContours; ++i2) {
            this.endPtsOfContours[i2] = bais.read() << 8 | bais.read();
        }
        this.count = this.endPtsOfContours[numberOfContours - 1] + 1;
        this.flags = new byte[this.count];
        this.xCoordinates = new short[this.count];
        this.yCoordinates = new short[this.count];
        int instructionCount = bais.read() << 8 | bais.read();
        this.readInstructions(bais, instructionCount);
        this.readFlags(this.count, bais);
        this.readCoords(this.count, bais);
    }

    @Override
    public int getEndPtOfContours(int i2) {
        return this.endPtsOfContours[i2];
    }

    @Override
    public byte getFlags(int i2) {
        return this.flags[i2];
    }

    @Override
    public short getXCoordinate(int i2) {
        return this.xCoordinates[i2];
    }

    @Override
    public short getYCoordinate(int i2) {
        return this.yCoordinates[i2];
    }

    @Override
    public boolean isComposite() {
        return false;
    }

    @Override
    public int getPointCount() {
        return this.count;
    }

    @Override
    public int getContourCount() {
        return this.getNumberOfContours();
    }

    private void readCoords(int count, ByteArrayInputStream bais) {
        int i2;
        short x2 = 0;
        short y2 = 0;
        for (i2 = 0; i2 < count; ++i2) {
            if ((this.flags[i2] & 0x10) != 0) {
                if ((this.flags[i2] & 2) != 0) {
                    x2 = (short)(x2 + (short)bais.read());
                }
            } else {
                x2 = (this.flags[i2] & 2) != 0 ? (short)(x2 + (short)(-((short)bais.read()))) : (short)(x2 + (short)(bais.read() << 8 | bais.read()));
            }
            this.xCoordinates[i2] = x2;
        }
        for (i2 = 0; i2 < count; ++i2) {
            if ((this.flags[i2] & 0x20) != 0) {
                if ((this.flags[i2] & 4) != 0) {
                    y2 = (short)(y2 + (short)bais.read());
                }
            } else {
                y2 = (this.flags[i2] & 4) != 0 ? (short)(y2 + (short)(-((short)bais.read()))) : (short)(y2 + (short)(bais.read() << 8 | bais.read()));
            }
            this.yCoordinates[i2] = y2;
        }
    }

    private void readFlags(int flagCount, ByteArrayInputStream bais) {
        try {
            for (int index = 0; index < flagCount; ++index) {
                this.flags[index] = (byte)bais.read();
                if ((this.flags[index] & 8) == 0) continue;
                int repeats = bais.read();
                for (int i2 = 1; i2 <= repeats; ++i2) {
                    this.flags[index + i2] = this.flags[index];
                }
                index += repeats;
            }
        }
        catch (ArrayIndexOutOfBoundsException e2) {
            System.out.println("error: array index out of bounds");
        }
    }
}

