/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen.font.table;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.batik.svggen.font.table.GlyfCompositeComp;
import org.apache.batik.svggen.font.table.GlyfDescript;
import org.apache.batik.svggen.font.table.GlyfTable;

public class GlyfCompositeDescript
extends GlyfDescript {
    private List components = new ArrayList();
    protected boolean beingResolved = false;
    protected boolean resolved = false;

    public GlyfCompositeDescript(GlyfTable parentTable, ByteArrayInputStream bais) {
        super(parentTable, (short)-1, bais);
        GlyfCompositeComp comp;
        do {
            comp = new GlyfCompositeComp(bais);
            this.components.add(comp);
        } while ((comp.getFlags() & 0x20) != 0);
        if ((comp.getFlags() & 0x100) != 0) {
            this.readInstructions(bais, bais.read() << 8 | bais.read());
        }
    }

    @Override
    public void resolve() {
        if (this.resolved) {
            return;
        }
        if (this.beingResolved) {
            System.err.println("Circular reference in GlyfCompositeDesc");
            return;
        }
        this.beingResolved = true;
        int firstIndex = 0;
        int firstContour = 0;
        for (Object component : this.components) {
            GlyfCompositeComp comp = (GlyfCompositeComp)component;
            comp.setFirstIndex(firstIndex);
            comp.setFirstContour(firstContour);
            GlyfDescript desc = this.parentTable.getDescription(comp.getGlyphIndex());
            if (desc == null) continue;
            desc.resolve();
            firstIndex += desc.getPointCount();
            firstContour += desc.getContourCount();
        }
        this.resolved = true;
        this.beingResolved = false;
    }

    @Override
    public int getEndPtOfContours(int i2) {
        GlyfCompositeComp c2 = this.getCompositeCompEndPt(i2);
        if (c2 != null) {
            GlyfDescript gd = this.parentTable.getDescription(c2.getGlyphIndex());
            return gd.getEndPtOfContours(i2 - c2.getFirstContour()) + c2.getFirstIndex();
        }
        return 0;
    }

    @Override
    public byte getFlags(int i2) {
        GlyfCompositeComp c2 = this.getCompositeComp(i2);
        if (c2 != null) {
            GlyfDescript gd = this.parentTable.getDescription(c2.getGlyphIndex());
            return gd.getFlags(i2 - c2.getFirstIndex());
        }
        return 0;
    }

    @Override
    public short getXCoordinate(int i2) {
        GlyfCompositeComp c2 = this.getCompositeComp(i2);
        if (c2 != null) {
            GlyfDescript gd = this.parentTable.getDescription(c2.getGlyphIndex());
            int n2 = i2 - c2.getFirstIndex();
            short x2 = gd.getXCoordinate(n2);
            short y2 = gd.getYCoordinate(n2);
            short x1 = (short)c2.scaleX(x2, y2);
            x1 = (short)(x1 + c2.getXTranslate());
            return x1;
        }
        return 0;
    }

    @Override
    public short getYCoordinate(int i2) {
        GlyfCompositeComp c2 = this.getCompositeComp(i2);
        if (c2 != null) {
            GlyfDescript gd = this.parentTable.getDescription(c2.getGlyphIndex());
            int n2 = i2 - c2.getFirstIndex();
            short x2 = gd.getXCoordinate(n2);
            short y2 = gd.getYCoordinate(n2);
            short y1 = (short)c2.scaleY(x2, y2);
            y1 = (short)(y1 + c2.getYTranslate());
            return y1;
        }
        return 0;
    }

    @Override
    public boolean isComposite() {
        return true;
    }

    @Override
    public int getPointCount() {
        if (!this.resolved) {
            System.err.println("getPointCount called on unresolved GlyfCompositeDescript");
        }
        GlyfCompositeComp c2 = (GlyfCompositeComp)this.components.get(this.components.size() - 1);
        return c2.getFirstIndex() + this.parentTable.getDescription(c2.getGlyphIndex()).getPointCount();
    }

    @Override
    public int getContourCount() {
        if (!this.resolved) {
            System.err.println("getContourCount called on unresolved GlyfCompositeDescript");
        }
        GlyfCompositeComp c2 = (GlyfCompositeComp)this.components.get(this.components.size() - 1);
        return c2.getFirstContour() + this.parentTable.getDescription(c2.getGlyphIndex()).getContourCount();
    }

    public int getComponentIndex(int i2) {
        return ((GlyfCompositeComp)this.components.get(i2)).getFirstIndex();
    }

    public int getComponentCount() {
        return this.components.size();
    }

    protected GlyfCompositeComp getCompositeComp(int i2) {
        for (Object component : this.components) {
            GlyfCompositeComp c2 = (GlyfCompositeComp)component;
            GlyfDescript gd = this.parentTable.getDescription(c2.getGlyphIndex());
            if (c2.getFirstIndex() > i2 || i2 >= c2.getFirstIndex() + gd.getPointCount()) continue;
            return c2;
        }
        return null;
    }

    protected GlyfCompositeComp getCompositeCompEndPt(int i2) {
        for (Object component : this.components) {
            GlyfCompositeComp c2 = (GlyfCompositeComp)component;
            GlyfDescript gd = this.parentTable.getDescription(c2.getGlyphIndex());
            if (c2.getFirstContour() > i2 || i2 >= c2.getFirstContour() + gd.getContourCount()) continue;
            return c2;
        }
        return null;
    }
}

