/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen.font.table;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.batik.svggen.font.table.CmapFormat;
import org.apache.batik.svggen.font.table.CmapIndexEntry;
import org.apache.batik.svggen.font.table.DirectoryEntry;
import org.apache.batik.svggen.font.table.Table;

public class CmapTable
implements Table {
    private int version;
    private int numTables;
    private CmapIndexEntry[] entries;
    private CmapFormat[] formats;

    protected CmapTable(DirectoryEntry de, RandomAccessFile raf) throws IOException {
        int i2;
        raf.seek(de.getOffset());
        long fp = raf.getFilePointer();
        this.version = raf.readUnsignedShort();
        this.numTables = raf.readUnsignedShort();
        this.entries = new CmapIndexEntry[this.numTables];
        this.formats = new CmapFormat[this.numTables];
        for (i2 = 0; i2 < this.numTables; ++i2) {
            this.entries[i2] = new CmapIndexEntry(raf);
        }
        for (i2 = 0; i2 < this.numTables; ++i2) {
            raf.seek(fp + (long)this.entries[i2].getOffset());
            int format = raf.readUnsignedShort();
            this.formats[i2] = CmapFormat.create(format, raf);
        }
    }

    public CmapFormat getCmapFormat(short platformId, short encodingId) {
        for (int i2 = 0; i2 < this.numTables; ++i2) {
            if (this.entries[i2].getPlatformId() != platformId || this.entries[i2].getEncodingId() != encodingId) continue;
            return this.formats[i2];
        }
        return null;
    }

    @Override
    public int getType() {
        return 1668112752;
    }

    public String toString() {
        int i2;
        StringBuffer sb = new StringBuffer(this.numTables * 8).append("cmap\n");
        for (i2 = 0; i2 < this.numTables; ++i2) {
            sb.append('\t').append(this.entries[i2].toString()).append('\n');
        }
        for (i2 = 0; i2 < this.numTables; ++i2) {
            sb.append('\t').append(this.formats[i2].toString()).append('\n');
        }
        return sb.toString();
    }
}

