/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen.font.table;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.batik.svggen.font.table.CmapFormat;

public class CmapFormat4
extends CmapFormat {
    public int language;
    private int segCountX2;
    private int searchRange;
    private int entrySelector;
    private int rangeShift;
    private int[] endCode;
    private int[] startCode;
    private int[] idDelta;
    private int[] idRangeOffset;
    private int[] glyphIdArray;
    private int segCount;
    private int first;
    private int last;

    protected CmapFormat4(RandomAccessFile raf) throws IOException {
        super(raf);
        int i2;
        this.format = 4;
        this.segCountX2 = raf.readUnsignedShort();
        this.segCount = this.segCountX2 / 2;
        this.endCode = new int[this.segCount];
        this.startCode = new int[this.segCount];
        this.idDelta = new int[this.segCount];
        this.idRangeOffset = new int[this.segCount];
        this.searchRange = raf.readUnsignedShort();
        this.entrySelector = raf.readUnsignedShort();
        this.rangeShift = raf.readUnsignedShort();
        this.last = -1;
        for (i2 = 0; i2 < this.segCount; ++i2) {
            this.endCode[i2] = raf.readUnsignedShort();
            if (this.endCode[i2] <= this.last) continue;
            this.last = this.endCode[i2];
        }
        raf.readUnsignedShort();
        for (i2 = 0; i2 < this.segCount; ++i2) {
            this.startCode[i2] = raf.readUnsignedShort();
            if (i2 != 0 && this.startCode[i2] >= this.first) continue;
            this.first = this.startCode[i2];
        }
        for (i2 = 0; i2 < this.segCount; ++i2) {
            this.idDelta[i2] = raf.readUnsignedShort();
        }
        for (i2 = 0; i2 < this.segCount; ++i2) {
            this.idRangeOffset[i2] = raf.readUnsignedShort();
        }
        int count = (this.length - 16 - this.segCount * 8) / 2;
        this.glyphIdArray = new int[count];
        for (int i3 = 0; i3 < count; ++i3) {
            this.glyphIdArray[i3] = raf.readUnsignedShort();
        }
    }

    @Override
    public int getFirst() {
        return this.first;
    }

    @Override
    public int getLast() {
        return this.last;
    }

    @Override
    public int mapCharCode(int charCode) {
        try {
            if (charCode < 0 || charCode >= 65534) {
                return 0;
            }
            for (int i2 = 0; i2 < this.segCount; ++i2) {
                if (this.endCode[i2] < charCode) continue;
                if (this.startCode[i2] <= charCode) {
                    if (this.idRangeOffset[i2] > 0) {
                        return this.glyphIdArray[this.idRangeOffset[i2] / 2 + (charCode - this.startCode[i2]) - (this.segCount - i2)];
                    }
                    return (this.idDelta[i2] + charCode) % 65536;
                }
                break;
            }
        }
        catch (ArrayIndexOutOfBoundsException e2) {
            System.err.println("error: Array out of bounds - " + e2.getMessage());
        }
        return 0;
    }

    @Override
    public String toString() {
        return new StringBuffer(80).append(super.toString()).append(", segCountX2: ").append(this.segCountX2).append(", searchRange: ").append(this.searchRange).append(", entrySelector: ").append(this.entrySelector).append(", rangeShift: ").append(this.rangeShift).append(", endCode: ").append(CmapFormat4.intToStr(this.endCode)).append(", startCode: ").append(CmapFormat4.intToStr(this.startCode)).append(", idDelta: ").append(CmapFormat4.intToStr(this.idDelta)).append(", idRangeOffset: ").append(CmapFormat4.intToStr(this.idRangeOffset)).toString();
    }

    private static String intToStr(int[] array) {
        int nSlots = array.length;
        StringBuffer workBuff = new StringBuffer(nSlots * 8);
        workBuff.append('[');
        for (int i2 = 0; i2 < nSlots; ++i2) {
            workBuff.append(array[i2]);
            if (i2 >= nSlots - 1) continue;
            workBuff.append(',');
        }
        workBuff.append(']');
        return workBuff.toString();
    }
}

