/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.script.jacl;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Locale;
import org.apache.batik.script.Interpreter;
import org.apache.batik.script.InterpreterException;
import org.apache.batik.script.jacl.JaclInterpreterFactory;
import tcl.lang.Interp;
import tcl.lang.ReflectObject;
import tcl.lang.TclException;

public class JaclInterpreter
implements Interpreter {
    private Interp interpreter = new Interp();

    public JaclInterpreter() {
        try {
            this.interpreter.eval("package require java", 0);
        }
        catch (TclException tclException) {
            // empty catch block
        }
    }

    @Override
    public String[] getMimeTypes() {
        return JaclInterpreterFactory.JACL_MIMETYPES;
    }

    @Override
    public Object evaluate(Reader scriptreader) throws IOException {
        return this.evaluate(scriptreader, "");
    }

    @Override
    public Object evaluate(Reader scriptreader, String description) throws IOException {
        StringBuffer sbuffer = new StringBuffer();
        char[] buffer = new char[1024];
        int val = 0;
        while ((val = scriptreader.read(buffer)) != -1) {
            sbuffer.append(buffer, 0, val);
        }
        String str = sbuffer.toString();
        return this.evaluate(str);
    }

    @Override
    public Object evaluate(String script) {
        try {
            this.interpreter.eval(script, 0);
        }
        catch (TclException e2) {
            throw new InterpreterException((Exception)((Object)e2), e2.getMessage(), -1, -1);
        }
        catch (RuntimeException re) {
            throw new InterpreterException(re, re.getMessage(), -1, -1);
        }
        return this.interpreter.getResult();
    }

    @Override
    public void dispose() {
        this.interpreter.dispose();
    }

    @Override
    public void bindObject(String name, Object object) {
        try {
            this.interpreter.setVar(name, ReflectObject.newInstance((Interp)this.interpreter, object.getClass(), (Object)object), 0);
        }
        catch (TclException tclException) {
            // empty catch block
        }
    }

    @Override
    public void setOut(Writer out) {
    }

    @Override
    public Locale getLocale() {
        return Locale.getDefault();
    }

    @Override
    public void setLocale(Locale locale) {
    }

    @Override
    public String formatMessage(String key, Object[] args) {
        return null;
    }
}

