/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.i18n;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.batik.i18n.LocaleGroup;
import org.apache.batik.i18n.Localizable;

public class LocalizableSupport
implements Localizable {
    protected LocaleGroup localeGroup = LocaleGroup.DEFAULT;
    protected String bundleName;
    protected ClassLoader classLoader;
    protected Locale locale;
    protected Locale usedLocale;
    List resourceBundles = new ArrayList();
    Class lastResourceClass;
    Class cls;

    public LocalizableSupport(String s2, Class cls) {
        this(s2, cls, null);
    }

    public LocalizableSupport(String s2, Class cls, ClassLoader cl) {
        this.bundleName = s2;
        this.cls = cls;
        this.classLoader = cl;
    }

    public LocalizableSupport(String s2) {
        this(s2, (ClassLoader)null);
    }

    public LocalizableSupport(String s2, ClassLoader cl) {
        this.bundleName = s2;
        this.classLoader = cl;
    }

    @Override
    public void setLocale(Locale l2) {
        if (this.locale != l2) {
            this.locale = l2;
            this.resourceBundles.clear();
            this.lastResourceClass = null;
        }
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    public void setLocaleGroup(LocaleGroup lg) {
        this.localeGroup = lg;
    }

    public LocaleGroup getLocaleGroup() {
        return this.localeGroup;
    }

    public void setDefaultLocale(Locale l2) {
        this.localeGroup.setLocale(l2);
    }

    public Locale getDefaultLocale() {
        return this.localeGroup.getLocale();
    }

    @Override
    public String formatMessage(String key, Object[] args) {
        return MessageFormat.format(this.getString(key), args);
    }

    protected Locale getCurrentLocale() {
        if (this.locale != null) {
            return this.locale;
        }
        Locale l2 = this.localeGroup.getLocale();
        if (l2 != null) {
            return l2;
        }
        return Locale.getDefault();
    }

    protected boolean setUsedLocale() {
        Locale l2 = this.getCurrentLocale();
        if (this.usedLocale == l2) {
            return false;
        }
        this.usedLocale = l2;
        this.resourceBundles.clear();
        this.lastResourceClass = null;
        return true;
    }

    public ResourceBundle getResourceBundle() {
        return this.getResourceBundle(0);
    }

    protected boolean hasNextResourceBundle(int i2) {
        if (i2 == 0) {
            return true;
        }
        if (i2 < this.resourceBundles.size()) {
            return true;
        }
        if (this.lastResourceClass == null) {
            return false;
        }
        return this.lastResourceClass != Object.class;
    }

    protected ResourceBundle lookupResourceBundle(String bundle, Class theClass) {
        ClassLoader cl = this.classLoader;
        ResourceBundle rb = null;
        if (cl != null) {
            try {
                rb = ResourceBundle.getBundle(bundle, this.usedLocale, cl);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            if (rb != null) {
                return rb;
            }
        }
        if (theClass != null) {
            try {
                cl = theClass.getClassLoader();
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        if (cl == null) {
            cl = this.getClass().getClassLoader();
        }
        try {
            rb = ResourceBundle.getBundle(bundle, this.usedLocale, cl);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return rb;
    }

    protected ResourceBundle getResourceBundle(int i2) {
        this.setUsedLocale();
        ResourceBundle rb = null;
        if (this.cls == null) {
            if (this.resourceBundles.size() == 0) {
                rb = this.lookupResourceBundle(this.bundleName, null);
                this.resourceBundles.add(rb);
            }
            return (ResourceBundle)this.resourceBundles.get(0);
        }
        while (i2 >= this.resourceBundles.size()) {
            if (this.lastResourceClass == Object.class) {
                return null;
            }
            this.lastResourceClass = this.lastResourceClass == null ? this.cls : this.lastResourceClass.getSuperclass();
            Class cl = this.lastResourceClass;
            String bundle = cl.getPackage().getName() + "." + this.bundleName;
            this.resourceBundles.add(this.lookupResourceBundle(bundle, cl));
        }
        return (ResourceBundle)this.resourceBundles.get(i2);
    }

    public String getString(String key) throws MissingResourceException {
        this.setUsedLocale();
        int i2 = 0;
        while (this.hasNextResourceBundle(i2)) {
            ResourceBundle rb = this.getResourceBundle(i2);
            if (rb != null) {
                try {
                    String ret = rb.getString(key);
                    if (ret != null) {
                        return ret;
                    }
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
            }
            ++i2;
        }
        String classStr = this.cls != null ? this.cls.toString() : this.bundleName;
        throw new MissingResourceException("Unable to find resource: " + key, classStr, key);
    }

    public int getInteger(String key) throws MissingResourceException {
        String i2 = this.getString(key);
        try {
            return Integer.parseInt(i2);
        }
        catch (NumberFormatException e2) {
            throw new MissingResourceException("Malformed integer", this.bundleName, key);
        }
    }

    public int getCharacter(String key) throws MissingResourceException {
        String s2 = this.getString(key);
        if (s2 == null || s2.length() == 0) {
            throw new MissingResourceException("Malformed character", this.bundleName, key);
        }
        return s2.charAt(0);
    }
}

