/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.extension.svg;

import java.awt.Color;
import java.awt.font.TextAttribute;
import java.awt.geom.Point2D;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.batik.anim.dom.SVGOMElement;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.CursorManager;
import org.apache.batik.bridge.SVGAElementBridge;
import org.apache.batik.bridge.SVGTextElementBridge;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.bridge.TextNode;
import org.apache.batik.bridge.TextUtilities;
import org.apache.batik.bridge.UnitProcessor;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.dom.events.NodeEventTarget;
import org.apache.batik.dom.util.XLinkSupport;
import org.apache.batik.dom.util.XMLSupport;
import org.apache.batik.extension.svg.BatikExtConstants;
import org.apache.batik.extension.svg.FlowExtTextNode;
import org.apache.batik.extension.svg.MarginInfo;
import org.apache.batik.extension.svg.RegionInfo;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.text.GVTAttributedCharacterIterator;
import org.apache.batik.gvt.text.TextPaintInfo;
import org.apache.batik.gvt.text.TextPath;
import org.apache.batik.parser.UnitProcessor;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BatikFlowTextElementBridge
extends SVGTextElementBridge
implements BatikExtConstants {
    public static final AttributedCharacterIterator.Attribute FLOW_PARAGRAPH = GVTAttributedCharacterIterator.TextAttribute.FLOW_PARAGRAPH;
    public static final AttributedCharacterIterator.Attribute FLOW_EMPTY_PARAGRAPH = GVTAttributedCharacterIterator.TextAttribute.FLOW_EMPTY_PARAGRAPH;
    public static final AttributedCharacterIterator.Attribute FLOW_LINE_BREAK = GVTAttributedCharacterIterator.TextAttribute.FLOW_LINE_BREAK;
    public static final AttributedCharacterIterator.Attribute FLOW_REGIONS = GVTAttributedCharacterIterator.TextAttribute.FLOW_REGIONS;
    public static final AttributedCharacterIterator.Attribute PREFORMATTED = GVTAttributedCharacterIterator.TextAttribute.PREFORMATTED;
    protected static final GVTAttributedCharacterIterator.TextAttribute TEXTPATH = GVTAttributedCharacterIterator.TextAttribute.TEXTPATH;
    protected static final GVTAttributedCharacterIterator.TextAttribute ANCHOR_TYPE = GVTAttributedCharacterIterator.TextAttribute.ANCHOR_TYPE;
    protected static final GVTAttributedCharacterIterator.TextAttribute LETTER_SPACING = GVTAttributedCharacterIterator.TextAttribute.LETTER_SPACING;
    protected static final GVTAttributedCharacterIterator.TextAttribute WORD_SPACING = GVTAttributedCharacterIterator.TextAttribute.WORD_SPACING;
    protected static final GVTAttributedCharacterIterator.TextAttribute KERNING = GVTAttributedCharacterIterator.TextAttribute.KERNING;

    @Override
    public String getNamespaceURI() {
        return "http://xml.apache.org/batik/ext";
    }

    @Override
    public String getLocalName() {
        return "flowText";
    }

    @Override
    public Bridge getInstance() {
        return new BatikFlowTextElementBridge();
    }

    @Override
    public boolean isComposite() {
        return false;
    }

    @Override
    protected GraphicsNode instantiateGraphicsNode() {
        return new FlowExtTextNode();
    }

    @Override
    protected Point2D getLocation(BridgeContext ctx, Element e2) {
        return new Point2D.Float(0.0f, 0.0f);
    }

    @Override
    protected void addContextToChild(BridgeContext ctx, Element e2) {
        String ln;
        if (this.getNamespaceURI().equals(e2.getNamespaceURI()) && ((ln = e2.getLocalName()).equals("flowPara") || ln.equals("flowRegionBreak") || ln.equals("flowLine") || ln.equals("flowSpan") || ln.equals("a") || ln.equals("tref"))) {
            ((SVGOMElement)e2).setSVGContext(new BatikFlowContentBridge(ctx, (SVGTextElementBridge)this, e2));
        }
        Node child = this.getFirstChild(e2);
        while (child != null) {
            if (child.getNodeType() == 1) {
                this.addContextToChild(ctx, (Element)child);
            }
            child = this.getNextSibling(child);
        }
    }

    @Override
    protected AttributedString buildAttributedString(BridgeContext ctx, Element element) {
        List rgns = this.getRegions(ctx, element);
        AttributedString ret = this.getFlowDiv(ctx, element);
        if (ret == null) {
            return ret;
        }
        ret.addAttribute(FLOW_REGIONS, rgns, 0, 1);
        return ret;
    }

    @Override
    protected void addGlyphPositionAttributes(AttributedString as, Element element, BridgeContext ctx) {
        if (element.getNodeType() != 1) {
            return;
        }
        String eNS = element.getNamespaceURI();
        if (!eNS.equals(this.getNamespaceURI()) && !eNS.equals("http://www.w3.org/2000/svg")) {
            return;
        }
        if (element.getLocalName() != "flowText") {
            super.addGlyphPositionAttributes(as, element, ctx);
            return;
        }
        for (Node n2 = element.getFirstChild(); n2 != null; n2 = n2.getNextSibling()) {
            Element e2;
            String ln;
            if (n2.getNodeType() != 1) continue;
            String nNS = n2.getNamespaceURI();
            if (!this.getNamespaceURI().equals(nNS) && !"http://www.w3.org/2000/svg".equals(nNS) || !(ln = (e2 = (Element)n2).getLocalName()).equals("flowDiv")) continue;
            super.addGlyphPositionAttributes(as, e2, ctx);
            return;
        }
    }

    @Override
    protected void addChildGlyphPositionAttributes(AttributedString as, Element element, BridgeContext ctx) {
        for (Node child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            String ln;
            if (child.getNodeType() != 1) continue;
            String cNS = child.getNamespaceURI();
            if (!this.getNamespaceURI().equals(cNS) && !"http://www.w3.org/2000/svg".equals(cNS) || !(ln = child.getLocalName()).equals("flowPara") && !ln.equals("flowRegionBreak") && !ln.equals("flowLine") && !ln.equals("flowSpan") && !ln.equals("a") && !ln.equals("tref")) continue;
            this.addGlyphPositionAttributes(as, (Element)child, ctx);
        }
    }

    @Override
    protected void addPaintAttributes(AttributedString as, Element element, TextNode node, TextPaintInfo parentPI, BridgeContext ctx) {
        if (element.getNodeType() != 1) {
            return;
        }
        String eNS = element.getNamespaceURI();
        if (!eNS.equals(this.getNamespaceURI()) && !eNS.equals("http://www.w3.org/2000/svg")) {
            return;
        }
        if (element.getLocalName() != "flowText") {
            super.addPaintAttributes(as, element, node, parentPI, ctx);
            return;
        }
        for (Node n2 = element.getFirstChild(); n2 != null; n2 = n2.getNextSibling()) {
            Element e2;
            String ln;
            if (n2.getNodeType() != 1 || !this.getNamespaceURI().equals(n2.getNamespaceURI()) || !(ln = (e2 = (Element)n2).getLocalName()).equals("flowDiv")) continue;
            super.addPaintAttributes(as, e2, node, parentPI, ctx);
            return;
        }
    }

    @Override
    protected void addChildPaintAttributes(AttributedString as, Element element, TextNode node, TextPaintInfo parentPI, BridgeContext ctx) {
        for (Node child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            String ln;
            if (child.getNodeType() != 1) continue;
            String cNS = child.getNamespaceURI();
            if (!this.getNamespaceURI().equals(cNS) && !"http://www.w3.org/2000/svg".equals(cNS) || !(ln = child.getLocalName()).equals("flowPara") && !ln.equals("flowRegionBreak") && !ln.equals("flowLine") && !ln.equals("flowSpan") && !ln.equals("a") && !ln.equals("tref")) continue;
            Element childElement = (Element)child;
            TextPaintInfo pi = this.getTextPaintInfo(childElement, node, parentPI, ctx);
            this.addPaintAttributes(as, childElement, node, pi, ctx);
        }
    }

    protected AttributedString getFlowDiv(BridgeContext ctx, Element element) {
        for (Node n2 = element.getFirstChild(); n2 != null; n2 = n2.getNextSibling()) {
            if (n2.getNodeType() != 1 || !this.getNamespaceURI().equals(n2.getNamespaceURI())) continue;
            Element e2 = (Element)n2;
            String ln = n2.getLocalName();
            if (!ln.equals("flowDiv")) continue;
            return this.gatherFlowPara(ctx, e2);
        }
        return null;
    }

    protected AttributedString gatherFlowPara(BridgeContext ctx, Element div) {
        TextPaintInfo divTPI = new TextPaintInfo();
        divTPI.visible = true;
        divTPI.fillPaint = Color.black;
        this.elemTPI.put(div, divTPI);
        SVGTextElementBridge.AttributedStringBuffer asb = new SVGTextElementBridge.AttributedStringBuffer();
        ArrayList<Integer> paraEnds = new ArrayList<Integer>();
        ArrayList<Element> paraElems = new ArrayList<Element>();
        ArrayList lnLocs = new ArrayList();
        for (Node n2 = div.getFirstChild(); n2 != null; n2 = n2.getNextSibling()) {
            if (n2.getNodeType() != 1 || !this.getNamespaceURI().equals(n2.getNamespaceURI())) continue;
            Element e2 = (Element)n2;
            String ln = e2.getLocalName();
            if (ln.equals("flowPara")) {
                this.fillAttributedStringBuffer(ctx, e2, true, null, null, asb, lnLocs);
                paraElems.add(e2);
                paraEnds.add(asb.length());
                continue;
            }
            if (!ln.equals("flowRegionBreak")) continue;
            this.fillAttributedStringBuffer(ctx, e2, true, null, null, asb, lnLocs);
            paraElems.add(e2);
            paraEnds.add(asb.length());
        }
        divTPI.startChar = 0;
        divTPI.endChar = asb.length() - 1;
        AttributedString ret = asb.toAttributedString();
        int prevLN = 0;
        for (Object lnLoc : lnLocs) {
            int nextLN = (Integer)lnLoc;
            if (nextLN == prevLN) continue;
            ret.addAttribute(FLOW_LINE_BREAK, new Object(), prevLN, nextLN);
            prevLN = nextLN;
        }
        int start = 0;
        LinkedList<MarginInfo> emptyPara = null;
        for (int i2 = 0; i2 < paraElems.size(); ++i2) {
            Element elem = (Element)paraElems.get(i2);
            int end = (Integer)paraEnds.get(i2);
            if (start == end) {
                if (emptyPara == null) {
                    emptyPara = new LinkedList<MarginInfo>();
                }
                emptyPara.add(this.makeMarginInfo(elem));
            } else {
                ret.addAttribute(FLOW_PARAGRAPH, this.makeMarginInfo(elem), start, end);
                if (emptyPara != null) {
                    ret.addAttribute(FLOW_EMPTY_PARAGRAPH, emptyPara, start, end);
                    emptyPara = null;
                }
            }
            start = end;
        }
        return ret;
    }

    protected List getRegions(BridgeContext ctx, Element element) {
        LinkedList ret = new LinkedList();
        for (Node n2 = element.getFirstChild(); n2 != null; n2 = n2.getNextSibling()) {
            Element e2;
            String ln;
            if (n2.getNodeType() != 1 || !this.getNamespaceURI().equals(n2.getNamespaceURI()) || !"flowRegion".equals(ln = (e2 = (Element)n2).getLocalName())) continue;
            float verticalAlignment = 0.0f;
            String verticalAlignmentAttribute = e2.getAttribute("vertical-align");
            if (verticalAlignmentAttribute != null && verticalAlignmentAttribute.length() > 0) {
                if ("top".equals(verticalAlignmentAttribute)) {
                    verticalAlignment = 0.0f;
                } else if ("middle".equals(verticalAlignmentAttribute)) {
                    verticalAlignment = 0.5f;
                } else if ("bottom".equals(verticalAlignmentAttribute)) {
                    verticalAlignment = 1.0f;
                }
            }
            this.gatherRegionInfo(ctx, e2, verticalAlignment, ret);
        }
        return ret;
    }

    protected void gatherRegionInfo(BridgeContext ctx, Element rgn, float verticalAlign, List regions) {
        for (Node n2 = rgn.getFirstChild(); n2 != null; n2 = n2.getNextSibling()) {
            UnitProcessor.Context uctx;
            RegionInfo ri;
            if (n2.getNodeType() != 1 || !this.getNamespaceURI().equals(n2.getNamespaceURI())) continue;
            Element e2 = (Element)n2;
            String ln = n2.getLocalName();
            if (!ln.equals("rect") || (ri = this.buildRegion(uctx = UnitProcessor.createContext(ctx, e2), e2, verticalAlign)) == null) continue;
            regions.add(ri);
        }
    }

    protected RegionInfo buildRegion(UnitProcessor.Context uctx, Element e2, float verticalAlignment) {
        String s2 = e2.getAttribute("x");
        float x2 = 0.0f;
        if (s2.length() != 0) {
            x2 = UnitProcessor.svgHorizontalCoordinateToUserSpace(s2, "x", uctx);
        }
        s2 = e2.getAttribute("y");
        float y2 = 0.0f;
        if (s2.length() != 0) {
            y2 = UnitProcessor.svgVerticalCoordinateToUserSpace(s2, "y", uctx);
        }
        if ((s2 = e2.getAttribute("width")).length() == 0) {
            throw new BridgeException(this.ctx, e2, "attribute.missing", new Object[]{"width", s2});
        }
        float w2 = UnitProcessor.svgHorizontalLengthToUserSpace(s2, "width", uctx);
        if (w2 == 0.0f) {
            return null;
        }
        s2 = e2.getAttribute("height");
        if (s2.length() == 0) {
            throw new BridgeException(this.ctx, e2, "attribute.missing", new Object[]{"height", s2});
        }
        float h2 = UnitProcessor.svgVerticalLengthToUserSpace(s2, "height", uctx);
        if (h2 == 0.0f) {
            return null;
        }
        return new RegionInfo(x2, y2, w2, h2, verticalAlignment);
    }

    protected void fillAttributedStringBuffer(BridgeContext ctx, Element element, boolean top, Integer bidiLevel, Map initialAttributes, SVGTextElementBridge.AttributedStringBuffer asb, List lnLocs) {
        if (!SVGUtilities.matchUserAgent(element, ctx.getUserAgent()) || !CSSUtilities.convertDisplay(element)) {
            return;
        }
        String s2 = XMLSupport.getXMLSpace(element);
        boolean preserve = s2.equals("preserve");
        Element nodeElement = element;
        int elementStartChar = asb.length();
        if (top) {
            this.endLimit = 0;
        }
        if (preserve) {
            this.endLimit = asb.length();
        }
        HashMap map = initialAttributes == null ? new HashMap() : new HashMap(initialAttributes);
        initialAttributes = this.getAttributeMap(ctx, element, null, bidiLevel, map);
        Object o2 = map.get(TextAttribute.BIDI_EMBEDDING);
        Integer subBidiLevel = bidiLevel;
        if (o2 != null) {
            subBidiLevel = (Integer)o2;
        }
        block4: for (Node n2 = element.getFirstChild(); n2 != null; n2 = n2.getNextSibling()) {
            boolean prevEndsWithSpace = preserve ? false : (asb.length() == 0 ? true : asb.getLastChar() == 32);
            switch (n2.getNodeType()) {
                case 1: {
                    if (!this.getNamespaceURI().equals(n2.getNamespaceURI()) && !"http://www.w3.org/2000/svg".equals(n2.getNamespaceURI())) continue block4;
                    nodeElement = (Element)n2;
                    String ln = n2.getLocalName();
                    if (ln.equals("flowLine")) {
                        int before = asb.length();
                        this.fillAttributedStringBuffer(ctx, nodeElement, false, subBidiLevel, initialAttributes, asb, lnLocs);
                        lnLocs.add(asb.length());
                        if (asb.length() == before) continue block4;
                        initialAttributes = null;
                        continue block4;
                    }
                    if (ln.equals("flowSpan") || ln.equals("altGlyph")) {
                        int before = asb.length();
                        this.fillAttributedStringBuffer(ctx, nodeElement, false, subBidiLevel, initialAttributes, asb, lnLocs);
                        if (asb.length() == before) continue block4;
                        initialAttributes = null;
                        continue block4;
                    }
                    if (ln.equals("a")) {
                        if (ctx.isInteractive()) {
                            NodeEventTarget target = (NodeEventTarget)((Object)nodeElement);
                            UserAgent ua = ctx.getUserAgent();
                            SVGAElementBridge.CursorHolder ch = new SVGAElementBridge.CursorHolder(CursorManager.DEFAULT_CURSOR);
                            target.addEventListenerNS("http://www.w3.org/2001/xml-events", "click", new SVGAElementBridge.AnchorListener(ua, ch), false, null);
                            target.addEventListenerNS("http://www.w3.org/2001/xml-events", "mouseover", new SVGAElementBridge.CursorMouseOverListener(ua, ch), false, null);
                            target.addEventListenerNS("http://www.w3.org/2001/xml-events", "mouseout", new SVGAElementBridge.CursorMouseOutListener(ua, ch), false, null);
                        }
                        int before = asb.length();
                        this.fillAttributedStringBuffer(ctx, nodeElement, false, subBidiLevel, initialAttributes, asb, lnLocs);
                        if (asb.length() == before) continue block4;
                        initialAttributes = null;
                        continue block4;
                    }
                    if (!ln.equals("tref")) continue block4;
                    String uriStr = XLinkSupport.getXLinkHref((Element)n2);
                    Element ref = ctx.getReferencedElement((Element)n2, uriStr);
                    s2 = TextUtilities.getElementContent(ref);
                    if ((s2 = this.normalizeString(s2, preserve, prevEndsWithSpace)).length() == 0) continue block4;
                    int trefStart = asb.length();
                    HashMap m2 = initialAttributes == null ? new HashMap() : new HashMap(initialAttributes);
                    this.getAttributeMap(ctx, nodeElement, null, bidiLevel, m2);
                    asb.append(s2, m2);
                    int trefEnd = asb.length() - 1;
                    TextPaintInfo tpi = (TextPaintInfo)this.elemTPI.get(nodeElement);
                    tpi.startChar = trefStart;
                    tpi.endChar = trefEnd;
                    initialAttributes = null;
                    continue block4;
                }
                case 3: 
                case 4: {
                    s2 = n2.getNodeValue();
                    s2 = this.normalizeString(s2, preserve, prevEndsWithSpace);
                    if (s2.length() == 0) continue block4;
                    asb.append(s2, map);
                    if (preserve) {
                        this.endLimit = asb.length();
                    }
                    initialAttributes = null;
                }
            }
        }
        if (top) {
            boolean strippedSome = false;
            while (this.endLimit < asb.length() && asb.getLastChar() == 32) {
                asb.stripLast();
                strippedSome = true;
            }
            if (strippedSome) {
                for (Object o1 : this.elemTPI.values()) {
                    TextPaintInfo tpi = (TextPaintInfo)o1;
                    if (tpi.endChar < asb.length()) continue;
                    tpi.endChar = asb.length() - 1;
                    if (tpi.startChar <= tpi.endChar) continue;
                    tpi.startChar = tpi.endChar;
                }
            }
        }
        int elementEndChar = asb.length() - 1;
        TextPaintInfo tpi = (TextPaintInfo)this.elemTPI.get(element);
        tpi.startChar = elementStartChar;
        tpi.endChar = elementEndChar;
    }

    @Override
    protected Map getAttributeMap(BridgeContext ctx, Element element, TextPath textPath, Integer bidiLevel, Map result) {
        Map initialMap = super.getAttributeMap(ctx, element, textPath, bidiLevel, result);
        String s2 = element.getAttribute("preformatted");
        if (s2.length() != 0 && s2.equals("true")) {
            result.put(PREFORMATTED, Boolean.TRUE);
        }
        return initialMap;
    }

    protected void checkMap(Map attrs) {
        if (attrs.containsKey(TEXTPATH)) {
            return;
        }
        if (attrs.containsKey(ANCHOR_TYPE)) {
            return;
        }
        if (attrs.containsKey(LETTER_SPACING)) {
            return;
        }
        if (attrs.containsKey(WORD_SPACING)) {
            return;
        }
        if (attrs.containsKey(KERNING)) {
            return;
        }
    }

    public MarginInfo makeMarginInfo(Element e2) {
        float top = 0.0f;
        float right = 0.0f;
        float bottom = 0.0f;
        float left = 0.0f;
        String s2 = e2.getAttribute("margin");
        try {
            if (s2.length() != 0) {
                float f2;
                bottom = left = (f2 = Float.parseFloat(s2));
                right = left;
                top = left;
            }
        }
        catch (NumberFormatException f2) {
            // empty catch block
        }
        s2 = e2.getAttribute("top-margin");
        try {
            if (s2.length() != 0) {
                top = f2 = Float.parseFloat(s2);
            }
        }
        catch (NumberFormatException f3) {
            // empty catch block
        }
        s2 = e2.getAttribute("right-margin");
        try {
            if (s2.length() != 0) {
                right = f4 = Float.parseFloat(s2);
            }
        }
        catch (NumberFormatException f4) {
            // empty catch block
        }
        s2 = e2.getAttribute("bottom-margin");
        try {
            if (s2.length() != 0) {
                bottom = f5 = Float.parseFloat(s2);
            }
        }
        catch (NumberFormatException f5) {
            // empty catch block
        }
        s2 = e2.getAttribute("left-margin");
        try {
            if (s2.length() != 0) {
                left = f6 = Float.parseFloat(s2);
            }
        }
        catch (NumberFormatException f6) {
            // empty catch block
        }
        float indent = 0.0f;
        s2 = e2.getAttribute("indent");
        try {
            if (s2.length() != 0) {
                float f7;
                indent = f7 = Float.parseFloat(s2);
            }
        }
        catch (NumberFormatException f7) {
            // empty catch block
        }
        int justification = 0;
        s2 = e2.getAttribute("justification");
        try {
            if (s2.length() != 0) {
                if ("start".equals(s2)) {
                    justification = 0;
                } else if ("middle".equals(s2)) {
                    justification = 1;
                } else if ("end".equals(s2)) {
                    justification = 2;
                } else if ("full".equals(s2)) {
                    justification = 3;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        String ln = e2.getLocalName();
        boolean rgnBr = ln.equals("flowRegionBreak");
        return new MarginInfo(top, right, bottom, left, indent, justification, rgnBr);
    }

    protected class BatikFlowContentBridge
    extends SVGTextElementBridge.AbstractTextChildTextContent {
        public BatikFlowContentBridge(BridgeContext ctx, SVGTextElementBridge parent, Element e2) {
            super(ctx, parent, e2);
        }
    }

    public static class LineBreakInfo {
        int breakIdx;
        float lineAdvAdj;
        boolean relative;

        public LineBreakInfo(int breakIdx, float lineAdvAdj, boolean relative) {
            this.breakIdx = breakIdx;
            this.lineAdvAdj = lineAdvAdj;
            this.relative = relative;
        }

        public int getBreakIdx() {
            return this.breakIdx;
        }

        public boolean isRelative() {
            return this.relative;
        }

        public float getLineAdvAdj() {
            return this.lineAdvAdj;
        }
    }
}

