/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.rendered;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.batik.ext.awt.image.GraphicsUtil;

public class IndexImage {
    static byte[][] computeRGB(int nCubes, Cube[] cubes) {
        byte[] r2 = new byte[nCubes];
        byte[] g2 = new byte[nCubes];
        byte[] b2 = new byte[nCubes];
        byte[] rgb = new byte[3];
        for (int i2 = 0; i2 < nCubes; ++i2) {
            rgb = cubes[i2].averageColorRGB(rgb);
            r2[i2] = rgb[0];
            g2[i2] = rgb[1];
            b2[i2] = rgb[2];
        }
        byte[][] result = new byte[][]{r2, g2, b2};
        return result;
    }

    static void logRGB(byte[] r2, byte[] g2, byte[] b2) {
        StringBuffer buff = new StringBuffer(100);
        int nColors = r2.length;
        for (int i2 = 0; i2 < nColors; ++i2) {
            String rgbStr = "(" + (r2[i2] + 128) + ',' + (g2[i2] + 128) + ',' + (b2[i2] + 128) + "),";
            buff.append(rgbStr);
        }
        System.out.println("RGB:" + nColors + buff);
    }

    static List[] createColorList(BufferedImage bi) {
        int w2 = bi.getWidth();
        int h2 = bi.getHeight();
        List[] colors = new ArrayList[4096];
        for (int i_w = 0; i_w < w2; ++i_w) {
            block1: for (int i_h = 0; i_h < h2; ++i_h) {
                int rgb = bi.getRGB(i_w, i_h) & 0xFFFFFF;
                int idx = (rgb & 0xF00000) >>> 12 | (rgb & 0xF000) >>> 8 | (rgb & 0xF0) >>> 4;
                ArrayList<Counter> v2 = colors[idx];
                if (v2 == null) {
                    v2 = new ArrayList<Counter>();
                    v2.add(new Counter(rgb));
                    colors[idx] = v2;
                    continue;
                }
                Iterator i2 = v2.iterator();
                while (i2.hasNext()) {
                    if (!((Counter)i2.next()).add(rgb)) continue;
                    continue block1;
                }
                v2.add(new Counter(rgb));
            }
        }
        return colors;
    }

    static Counter[][] convertColorList(List[] colors) {
        Counter[] EMPTY_COUNTER = new Counter[]{};
        Counter[][] colorTbl = new Counter[4096][];
        for (int i2 = 0; i2 < colors.length; ++i2) {
            List cl = colors[i2];
            if (cl == null) {
                colorTbl[i2] = EMPTY_COUNTER;
                continue;
            }
            int nSlots = cl.size();
            colorTbl[i2] = cl.toArray(new Counter[nSlots]);
            colors[i2] = null;
        }
        return colorTbl;
    }

    public static BufferedImage getIndexedImage(BufferedImage bi, int nColors) {
        int bits;
        int w2 = bi.getWidth();
        int h2 = bi.getHeight();
        List[] colors = IndexImage.createColorList(bi);
        Counter[][] colorTbl = IndexImage.convertColorList(colors);
        colors = null;
        int nCubes = 1;
        int fCube = 0;
        Cube[] cubes = new Cube[nColors];
        cubes[0] = new Cube(colorTbl, w2 * h2);
        while (nCubes < nColors) {
            int i2;
            while (cubes[fCube].isDone() && ++fCube != nCubes) {
            }
            if (fCube == nCubes) break;
            Cube c2 = cubes[fCube];
            Cube nc = c2.split();
            if (nc == null) continue;
            if (nc.count > c2.count) {
                Cube tmp = c2;
                c2 = nc;
                nc = tmp;
            }
            int j2 = fCube;
            int cnt = c2.count;
            for (i2 = fCube + 1; i2 < nCubes && cubes[i2].count >= cnt; ++i2) {
                cubes[j2++] = cubes[i2];
            }
            cubes[j2++] = c2;
            cnt = nc.count;
            while (j2 < nCubes && cubes[j2].count >= cnt) {
                ++j2;
            }
            for (i2 = nCubes; i2 > j2; --i2) {
                cubes[i2] = cubes[i2 - 1];
            }
            cubes[j2++] = nc;
            ++nCubes;
        }
        byte[][] rgbTbl = IndexImage.computeRGB(nCubes, cubes);
        IndexColorModel icm = new IndexColorModel(8, nCubes, rgbTbl[0], rgbTbl[1], rgbTbl[2]);
        BufferedImage indexed = new BufferedImage(w2, h2, 13, icm);
        Graphics2D g2d = indexed.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        g2d.drawImage((Image)bi, 0, 0, null);
        g2d.dispose();
        for (bits = 1; bits <= 8 && 1 << bits < nCubes; ++bits) {
        }
        if (bits > 4) {
            return indexed;
        }
        if (bits == 3) {
            bits = 4;
        }
        IndexColorModel cm = new IndexColorModel(bits, nCubes, rgbTbl[0], rgbTbl[1], rgbTbl[2]);
        MultiPixelPackedSampleModel sm = new MultiPixelPackedSampleModel(0, w2, h2, bits);
        WritableRaster ras = Raster.createWritableRaster(sm, new Point(0, 0));
        bi = indexed;
        indexed = new BufferedImage(cm, ras, bi.isAlphaPremultiplied(), null);
        GraphicsUtil.copyData(bi, indexed);
        return indexed;
    }

    private static class Cube {
        static final byte[] RGB_BLACK = new byte[]{0, 0, 0};
        int[] min = new int[]{0, 0, 0};
        int[] max = new int[]{255, 255, 255};
        boolean done = false;
        final Counter[][] colors;
        int count = 0;
        static final int RED = 0;
        static final int GRN = 1;
        static final int BLU = 2;

        Cube(Counter[][] colors, int count) {
            this.colors = colors;
            this.count = count;
        }

        public boolean isDone() {
            return this.done;
        }

        private boolean contains(int[] val) {
            int vRed = val[0];
            int vGrn = val[1];
            int vBlu = val[2];
            return this.min[0] <= vRed && vRed <= this.max[0] && this.min[1] <= vGrn && vGrn <= this.max[1] && this.min[2] <= vBlu && vBlu <= this.max[2];
        }

        Cube split() {
            int c1;
            int c0;
            int splitChannel;
            int dr = this.max[0] - this.min[0] + 1;
            int dg = this.max[1] - this.min[1] + 1;
            int db = this.max[2] - this.min[2] + 1;
            if (dr >= dg) {
                if (dr >= db) {
                    splitChannel = 0;
                    c0 = 1;
                    c1 = 2;
                } else {
                    splitChannel = 2;
                    c0 = 0;
                    c1 = 1;
                }
            } else if (dg >= db) {
                splitChannel = 1;
                c0 = 0;
                c1 = 2;
            } else {
                splitChannel = 2;
                c0 = 1;
                c1 = 0;
            }
            Cube ret = this.splitChannel(splitChannel, c0, c1);
            if (ret != null) {
                return ret;
            }
            ret = this.splitChannel(c0, splitChannel, c1);
            if (ret != null) {
                return ret;
            }
            ret = this.splitChannel(c1, splitChannel, c0);
            if (ret != null) {
                return ret;
            }
            this.done = true;
            return null;
        }

        private void normalize(int splitChannel, int[] counts) {
            boolean flagChangedHi;
            int i2;
            if (this.count == 0) {
                return;
            }
            int iMin = this.min[splitChannel];
            int iMax = this.max[splitChannel];
            int loBound = -1;
            int hiBound = -1;
            for (i2 = iMin; i2 <= iMax; ++i2) {
                if (counts[i2] == 0) continue;
                loBound = i2;
                break;
            }
            for (i2 = iMax; i2 >= iMin; --i2) {
                if (counts[i2] == 0) continue;
                hiBound = i2;
                break;
            }
            boolean flagChangedLo = loBound != -1 && iMin != loBound;
            boolean bl = flagChangedHi = hiBound != -1 && iMax != hiBound;
            if (flagChangedLo) {
                this.min[splitChannel] = loBound;
            }
            if (flagChangedHi) {
                this.max[splitChannel] = hiBound;
            }
        }

        Cube splitChannel(int splitChannel, int c0, int c1) {
            if (this.min[splitChannel] == this.max[splitChannel]) {
                return null;
            }
            if (this.count == 0) {
                return null;
            }
            int half = this.count / 2;
            int[] counts = this.computeCounts(splitChannel, c0, c1);
            int tcount = 0;
            int lastAdd = -1;
            int splitLo = this.min[splitChannel];
            int splitHi = this.max[splitChannel];
            for (int i2 = this.min[splitChannel]; i2 <= this.max[splitChannel]; ++i2) {
                int c2 = counts[i2];
                if (c2 == 0) {
                    if (tcount != 0 || i2 >= this.max[splitChannel]) continue;
                    this.min[splitChannel] = i2 + 1;
                    continue;
                }
                if (tcount + c2 < half) {
                    lastAdd = i2;
                    tcount += c2;
                    continue;
                }
                if (half - tcount <= tcount + c2 - half) {
                    if (lastAdd == -1) {
                        if (c2 == this.count) {
                            this.max[splitChannel] = i2;
                            return null;
                        }
                        splitLo = i2;
                        splitHi = i2 + 1;
                        tcount += c2;
                        break;
                    }
                    splitLo = lastAdd;
                    splitHi = i2;
                    break;
                }
                if (i2 == this.max[splitChannel]) {
                    if (c2 == this.count) {
                        return null;
                    }
                    splitLo = lastAdd;
                    splitHi = i2;
                    break;
                }
                tcount += c2;
                splitLo = i2;
                splitHi = i2 + 1;
                break;
            }
            Cube ret = new Cube(this.colors, tcount);
            this.count -= tcount;
            ret.min[splitChannel] = this.min[splitChannel];
            ret.max[splitChannel] = splitLo;
            this.min[splitChannel] = splitHi;
            ret.min[c0] = this.min[c0];
            ret.max[c0] = this.max[c0];
            ret.min[c1] = this.min[c1];
            ret.max[c1] = this.max[c1];
            this.normalize(splitChannel, counts);
            ret.normalize(splitChannel, counts);
            return ret;
        }

        private int[] computeCounts(int splitChannel, int c0, int c1) {
            int splitSh4 = (2 - splitChannel) * 4;
            int c0Sh4 = (2 - c0) * 4;
            int c1Sh4 = (2 - c1) * 4;
            int half = this.count / 2;
            int[] counts = new int[256];
            int tcount = 0;
            int minR = this.min[0];
            int minG = this.min[1];
            int minB = this.min[2];
            int maxR = this.max[0];
            int maxG = this.max[1];
            int maxB = this.max[2];
            int[] minIdx = new int[]{minR >> 4, minG >> 4, minB >> 4};
            int[] maxIdx = new int[]{maxR >> 4, maxG >> 4, maxB >> 4};
            int[] vals = new int[]{0, 0, 0};
            for (int i2 = minIdx[splitChannel]; i2 <= maxIdx[splitChannel]; ++i2) {
                int idx1 = i2 << splitSh4;
                for (int j2 = minIdx[c0]; j2 <= maxIdx[c0]; ++j2) {
                    int idx2 = idx1 | j2 << c0Sh4;
                    for (int k2 = minIdx[c1]; k2 <= maxIdx[c1]; ++k2) {
                        Counter[] v2;
                        int idx = idx2 | k2 << c1Sh4;
                        for (Counter c2 : v2 = this.colors[idx]) {
                            if (!this.contains(vals = c2.getRgb(vals))) continue;
                            int n2 = vals[splitChannel];
                            counts[n2] = counts[n2] + c2.count;
                            tcount += c2.count;
                        }
                    }
                }
            }
            return counts;
        }

        public String toString() {
            return "Cube: [" + this.min[0] + '-' + this.max[0] + "] [" + this.min[1] + '-' + this.max[1] + "] [" + this.min[2] + '-' + this.max[2] + "] n:" + this.count;
        }

        public int averageColor() {
            if (this.count == 0) {
                return 0;
            }
            byte[] rgb = this.averageColorRGB(null);
            return rgb[0] << 16 & 0xFF0000 | rgb[1] << 8 & 0xFF00 | rgb[2] & 0xFF;
        }

        public byte[] averageColorRGB(byte[] rgb) {
            if (this.count == 0) {
                return RGB_BLACK;
            }
            float red = 0.0f;
            float grn = 0.0f;
            float blu = 0.0f;
            int minR = this.min[0];
            int minG = this.min[1];
            int minB = this.min[2];
            int maxR = this.max[0];
            int maxG = this.max[1];
            int maxB = this.max[2];
            int[] minIdx = new int[]{minR >> 4, minG >> 4, minB >> 4};
            int[] maxIdx = new int[]{maxR >> 4, maxG >> 4, maxB >> 4};
            int[] vals = new int[3];
            for (int i2 = minIdx[0]; i2 <= maxIdx[0]; ++i2) {
                int idx1 = i2 << 8;
                for (int j2 = minIdx[1]; j2 <= maxIdx[1]; ++j2) {
                    int idx2 = idx1 | j2 << 4;
                    for (int k2 = minIdx[2]; k2 <= maxIdx[2]; ++k2) {
                        Counter[] v2;
                        int idx = idx2 | k2;
                        for (Counter c2 : v2 = this.colors[idx]) {
                            if (!this.contains(vals = c2.getRgb(vals))) continue;
                            float weight = (float)c2.count / (float)this.count;
                            red += (float)vals[0] * weight;
                            grn += (float)vals[1] * weight;
                            blu += (float)vals[2] * weight;
                        }
                    }
                }
            }
            byte[] result = rgb == null ? new byte[3] : rgb;
            result[0] = (byte)(red + 0.5f);
            result[1] = (byte)(grn + 0.5f);
            result[2] = (byte)(blu + 0.5f);
            return result;
        }
    }

    private static class Counter {
        final int val;
        int count = 1;

        Counter(int val) {
            this.val = val;
        }

        boolean add(int val) {
            if (this.val != val) {
                return false;
            }
            ++this.count;
            return true;
        }

        int[] getRgb(int[] rgb) {
            rgb[0] = (this.val & 0xFF0000) >> 16;
            rgb[1] = (this.val & 0xFF00) >> 8;
            rgb[2] = this.val & 0xFF;
            return rgb;
        }
    }
}

