/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.geom;

import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class RectListManager
implements Collection {
    Rectangle[] rects = null;
    int size = 0;
    Rectangle bounds = null;
    public static Comparator comparator = new RectXComparator();

    public void dump() {
        System.err.println("RLM: " + this + " Sz: " + this.size);
        System.err.println("Bounds: " + this.getBounds());
        for (int i2 = 0; i2 < this.size; ++i2) {
            Rectangle r2 = this.rects[i2];
            System.err.println("  [" + r2.x + ", " + r2.y + ", " + r2.width + ", " + r2.height + ']');
        }
    }

    public RectListManager(Collection rects) {
        this.rects = new Rectangle[rects.size()];
        Iterator i2 = rects.iterator();
        int j2 = 0;
        while (i2.hasNext()) {
            this.rects[j2++] = (Rectangle)i2.next();
        }
        this.size = this.rects.length;
        Arrays.sort(this.rects, comparator);
    }

    public RectListManager(Rectangle[] rects) {
        this(rects, 0, rects.length);
    }

    public RectListManager(Rectangle[] rects, int off, int sz) {
        this.size = sz;
        this.rects = new Rectangle[sz];
        System.arraycopy(rects, off, this.rects, 0, sz);
        Arrays.sort(this.rects, comparator);
    }

    public RectListManager(RectListManager rlm) {
        this(rlm.rects);
    }

    public RectListManager(Rectangle rect) {
        this();
        this.add(rect);
    }

    public RectListManager() {
        this.rects = new Rectangle[10];
        this.size = 0;
    }

    public RectListManager(int capacity) {
        this.rects = new Rectangle[capacity];
    }

    public Rectangle getBounds() {
        if (this.bounds != null) {
            return this.bounds;
        }
        if (this.size == 0) {
            return null;
        }
        this.bounds = new Rectangle(this.rects[0]);
        for (int i2 = 1; i2 < this.size; ++i2) {
            Rectangle r2 = this.rects[i2];
            if (r2.x < this.bounds.x) {
                this.bounds.width = this.bounds.x + this.bounds.width - r2.x;
                this.bounds.x = r2.x;
            }
            if (r2.y < this.bounds.y) {
                this.bounds.height = this.bounds.y + this.bounds.height - r2.y;
                this.bounds.y = r2.y;
            }
            if (r2.x + r2.width > this.bounds.x + this.bounds.width) {
                this.bounds.width = r2.x + r2.width - this.bounds.x;
            }
            if (r2.y + r2.height <= this.bounds.y + this.bounds.height) continue;
            this.bounds.height = r2.y + r2.height - this.bounds.y;
        }
        return this.bounds;
    }

    public Object clone() throws CloneNotSupportedException {
        return this.copy();
    }

    public RectListManager copy() {
        return new RectListManager(this.rects);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public void clear() {
        Arrays.fill(this.rects, null);
        this.size = 0;
        this.bounds = null;
    }

    @Override
    public Iterator iterator() {
        return new RLMIterator();
    }

    public ListIterator listIterator() {
        return new RLMIterator();
    }

    @Override
    public Object[] toArray() {
        Object[] ret = new Rectangle[this.size];
        System.arraycopy(this.rects, 0, ret, 0, this.size);
        return ret;
    }

    public Object[] toArray(Object[] a2) {
        Class<?> t2 = a2.getClass().getComponentType();
        if (t2 != Object.class && t2 != Rectangle.class) {
            Arrays.fill(a2, null);
            return a2;
        }
        if (a2.length < this.size) {
            a2 = new Rectangle[this.size];
        }
        System.arraycopy(this.rects, 0, a2, 0, this.size);
        Arrays.fill(a2, this.size, a2.length, null);
        return a2;
    }

    public boolean add(Object o2) {
        this.add((Rectangle)o2);
        return true;
    }

    public void add(Rectangle rect) {
        this.add(rect, 0, this.size - 1);
    }

    protected void add(Rectangle rect, int l2, int r2) {
        this.ensureCapacity(this.size + 1);
        int idx = l2;
        while (l2 <= r2) {
            for (idx = (l2 + r2) / 2; this.rects[idx] == null && idx < r2; ++idx) {
            }
            if (this.rects[idx] == null) {
                r2 = (l2 + r2) / 2;
                idx = (l2 + r2) / 2;
                if (l2 > r2) {
                    idx = l2;
                }
                while (this.rects[idx] == null && idx > l2) {
                    --idx;
                }
                if (this.rects[idx] == null) {
                    this.rects[idx] = rect;
                    return;
                }
            }
            if (rect.x == this.rects[idx].x) break;
            if (rect.x < this.rects[idx].x) {
                if (idx == 0 || this.rects[idx - 1] != null && rect.x >= this.rects[idx - 1].x) break;
                r2 = idx - 1;
                continue;
            }
            if (idx == this.size - 1) {
                ++idx;
                break;
            }
            if (this.rects[idx + 1] != null && rect.x <= this.rects[idx + 1].x) {
                ++idx;
                break;
            }
            l2 = idx + 1;
        }
        if (idx < this.size) {
            System.arraycopy(this.rects, idx, this.rects, idx + 1, this.size - idx);
        }
        this.rects[idx] = rect;
        ++this.size;
        this.bounds = null;
    }

    public boolean addAll(Collection c2) {
        if (c2 instanceof RectListManager) {
            this.add((RectListManager)c2);
        } else {
            this.add(new RectListManager(c2));
        }
        return c2.size() != 0;
    }

    @Override
    public boolean contains(Object o2) {
        int i2;
        Rectangle rect = (Rectangle)o2;
        int l2 = 0;
        int r2 = this.size - 1;
        int idx = 0;
        while (l2 <= r2) {
            idx = l2 + r2 >>> 1;
            if (rect.x == this.rects[idx].x) break;
            if (rect.x < this.rects[idx].x) {
                if (idx == 0 || rect.x >= this.rects[idx - 1].x) break;
                r2 = idx - 1;
                continue;
            }
            if (idx == this.size - 1) {
                ++idx;
                break;
            }
            if (rect.x <= this.rects[idx + 1].x) {
                ++idx;
                break;
            }
            l2 = idx + 1;
        }
        if (this.rects[idx].x != rect.x) {
            return false;
        }
        for (i2 = idx; i2 >= 0; --i2) {
            if (this.rects[idx].equals(rect)) {
                return true;
            }
            if (this.rects[idx].x != rect.x) break;
        }
        for (i2 = idx + 1; i2 < this.size; ++i2) {
            if (this.rects[idx].equals(rect)) {
                return true;
            }
            if (this.rects[idx].x != rect.x) break;
        }
        return false;
    }

    public boolean containsAll(Collection c2) {
        if (c2 instanceof RectListManager) {
            return this.containsAll((RectListManager)c2);
        }
        return this.containsAll(new RectListManager(c2));
    }

    public boolean containsAll(RectListManager rlm) {
        int xChange = 0;
        int i2 = 0;
        for (int j2 = 0; j2 < rlm.size; ++j2) {
            i2 = xChange;
            while (this.rects[i2].x < rlm.rects[j2].x) {
                if (++i2 != this.size) continue;
                return false;
            }
            xChange = i2;
            int x2 = this.rects[i2].x;
            while (!rlm.rects[j2].equals(this.rects[i2])) {
                if (++i2 == this.size) {
                    return false;
                }
                if (x2 == this.rects[i2].x) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean remove(Object o2) {
        return this.remove((Rectangle)o2);
    }

    public boolean remove(Rectangle rect) {
        int i2;
        int l2 = 0;
        int r2 = this.size - 1;
        int idx = 0;
        while (l2 <= r2) {
            idx = l2 + r2 >>> 1;
            if (rect.x == this.rects[idx].x) break;
            if (rect.x < this.rects[idx].x) {
                if (idx == 0 || rect.x >= this.rects[idx - 1].x) break;
                r2 = idx - 1;
                continue;
            }
            if (idx == this.size - 1) {
                ++idx;
                break;
            }
            if (rect.x <= this.rects[idx + 1].x) {
                ++idx;
                break;
            }
            l2 = idx + 1;
        }
        if (this.rects[idx].x != rect.x) {
            return false;
        }
        for (i2 = idx; i2 >= 0; --i2) {
            if (this.rects[idx].equals(rect)) {
                System.arraycopy(this.rects, idx + 1, this.rects, idx, this.size - idx);
                --this.size;
                this.bounds = null;
                return true;
            }
            if (this.rects[idx].x != rect.x) break;
        }
        for (i2 = idx + 1; i2 < this.size; ++i2) {
            if (this.rects[idx].equals(rect)) {
                System.arraycopy(this.rects, idx + 1, this.rects, idx, this.size - idx);
                --this.size;
                this.bounds = null;
                return true;
            }
            if (this.rects[idx].x != rect.x) break;
        }
        return false;
    }

    public boolean removeAll(Collection c2) {
        if (c2 instanceof RectListManager) {
            return this.removeAll((RectListManager)c2);
        }
        return this.removeAll(new RectListManager(c2));
    }

    public boolean removeAll(RectListManager rlm) {
        int j2;
        int xChange = 0;
        boolean ret = false;
        int i2 = 0;
        block0: for (j2 = 0; j2 < rlm.size; ++j2) {
            i2 = xChange;
            while ((this.rects[i2] == null || this.rects[i2].x < rlm.rects[j2].x) && ++i2 != this.size) {
            }
            if (i2 == this.size) break;
            xChange = i2;
            int x2 = this.rects[i2].x;
            while (true) {
                if (this.rects[i2] == null) {
                    if (++i2 != this.size) continue;
                    continue block0;
                }
                if (rlm.rects[j2].equals(this.rects[i2])) {
                    this.rects[i2] = null;
                    ret = true;
                }
                if (++i2 == this.size || x2 != this.rects[i2].x) continue block0;
            }
        }
        if (ret) {
            j2 = 0;
            for (i2 = 0; i2 < this.size; ++i2) {
                if (this.rects[i2] == null) continue;
                this.rects[j2++] = this.rects[i2];
            }
            this.size = j2;
            this.bounds = null;
        }
        return ret;
    }

    public boolean retainAll(Collection c2) {
        if (c2 instanceof RectListManager) {
            return this.retainAll((RectListManager)c2);
        }
        return this.retainAll(new RectListManager(c2));
    }

    public boolean retainAll(RectListManager rlm) {
        int j2;
        int xChange = 0;
        boolean ret = false;
        int i2 = 0;
        block0: for (j2 = 0; j2 < this.size; ++j2) {
            i2 = xChange;
            while (rlm.rects[i2].x < this.rects[j2].x && ++i2 != rlm.size) {
            }
            if (i2 == rlm.size) {
                ret = true;
                for (int k2 = j2; k2 < this.size; ++k2) {
                    this.rects[k2] = null;
                }
                this.size = j2;
                break;
            }
            xChange = i2;
            int x2 = rlm.rects[i2].x;
            while (!this.rects[j2].equals(rlm.rects[i2])) {
                if (++i2 != rlm.size && x2 == rlm.rects[i2].x) continue;
                this.rects[j2] = null;
                ret = true;
                continue block0;
            }
        }
        if (ret) {
            j2 = 0;
            for (i2 = 0; i2 < this.size; ++i2) {
                if (this.rects[i2] == null) continue;
                this.rects[j2++] = this.rects[i2];
            }
            this.size = j2;
            this.bounds = null;
        }
        return ret;
    }

    public void add(RectListManager rlm) {
        if (rlm.size == 0) {
            return;
        }
        Rectangle[] dst = this.rects;
        if (this.rects.length < this.size + rlm.size) {
            dst = new Rectangle[this.size + rlm.size];
        }
        if (this.size == 0) {
            System.arraycopy(rlm.rects, 0, dst, this.size, rlm.size);
            this.size = rlm.size;
            this.bounds = null;
            return;
        }
        Rectangle[] src1 = rlm.rects;
        int src1Sz = rlm.size;
        int src1I = src1Sz - 1;
        Rectangle[] src2 = this.rects;
        int src2Sz = this.size;
        int src2I = src2Sz - 1;
        int x1 = src1[src1I].x;
        int x2 = src2[src2I].x;
        for (int dstI = this.size + rlm.size - 1; dstI >= 0; --dstI) {
            if (x1 <= x2) {
                dst[dstI] = src2[src2I];
                if (src2I == 0) {
                    System.arraycopy(src1, 0, dst, 0, src1I + 1);
                    break;
                }
                x2 = src2[--src2I].x;
                continue;
            }
            dst[dstI] = src1[src1I];
            if (src1I == 0) {
                System.arraycopy(src2, 0, dst, 0, src2I + 1);
                break;
            }
            x1 = src1[--src1I].x;
        }
        this.rects = dst;
        this.size += rlm.size;
        this.bounds = null;
    }

    public void mergeRects(int overhead, int lineOverhead) {
        int j2;
        Rectangle r2;
        int i2;
        if (this.size == 0) {
            return;
        }
        Rectangle[] splits = new Rectangle[4];
        for (i2 = 0; i2 < this.size; ++i2) {
            r2 = this.rects[i2];
            if (r2 == null) continue;
            int cost1 = overhead + r2.height * lineOverhead + r2.height * r2.width;
            block1: do {
                int maxX = r2.x + r2.width + overhead / r2.height;
                for (j2 = i2 + 1; j2 < this.size; ++j2) {
                    Rectangle cr = this.rects[j2];
                    if (cr == null || cr == r2) continue;
                    if (cr.x >= maxX) {
                        j2 = this.size;
                        continue block1;
                    }
                    int cost2 = overhead + cr.height * lineOverhead + cr.height * cr.width;
                    Rectangle mr = r2.union(cr);
                    int cost3 = overhead + mr.height * lineOverhead + mr.height * mr.width;
                    if (cost3 <= cost1 + cost2) {
                        r2 = this.rects[i2] = mr;
                        this.rects[j2] = null;
                        cost1 = cost3;
                        j2 = -1;
                        continue block1;
                    }
                    if (!r2.intersects(cr)) continue;
                    this.splitRect(cr, r2, splits);
                    int splitCost = 0;
                    int l2 = 0;
                    for (int k2 = 0; k2 < 4; ++k2) {
                        if (splits[k2] == null) continue;
                        Rectangle sr = splits[k2];
                        if (k2 < 3) {
                            splits[l2++] = sr;
                        }
                        splitCost += overhead + sr.height * lineOverhead + sr.height * sr.width;
                    }
                    if (splitCost >= cost2) continue;
                    if (l2 == 0) {
                        this.rects[j2] = null;
                        if (splits[3] == null) continue;
                        this.add(splits[3], j2, this.size - 1);
                        continue;
                    }
                    this.rects[j2] = splits[0];
                    if (l2 > 1) {
                        this.insertRects(splits, 1, j2 + 1, l2 - 1);
                    }
                    if (splits[3] == null) continue;
                    this.add(splits[3], j2, this.size - 1);
                }
            } while (j2 != this.size);
        }
        j2 = 0;
        float area = 0.0f;
        for (i2 = 0; i2 < this.size; ++i2) {
            if (this.rects[i2] == null) continue;
            r2 = this.rects[i2];
            this.rects[j2++] = r2;
            area += (float)(overhead + r2.height * lineOverhead + r2.height * r2.width);
        }
        this.size = j2;
        this.bounds = null;
        r2 = this.getBounds();
        if (r2 == null) {
            return;
        }
        if ((float)(overhead + r2.height * lineOverhead + r2.height * r2.width) < area) {
            this.rects[0] = r2;
            this.size = 1;
        }
    }

    public void subtract(RectListManager rlm, int overhead, int lineOverhead) {
        int jMin = 0;
        Rectangle[] splits = new Rectangle[4];
        block0: for (int i2 = 0; i2 < this.size; ++i2) {
            Rectangle r2 = this.rects[i2];
            int cost = overhead + r2.height * lineOverhead + r2.height * r2.width;
            for (int j2 = jMin; j2 < rlm.size; ++j2) {
                Rectangle sr = rlm.rects[j2];
                if (sr.x + sr.width < r2.x) {
                    if (j2 != jMin) continue;
                    ++jMin;
                    continue;
                }
                if (sr.x > r2.x + r2.width) continue block0;
                if (!r2.intersects(sr)) continue;
                this.splitRect(r2, sr, splits);
                int splitCost = 0;
                for (int k2 = 0; k2 < 4; ++k2) {
                    Rectangle tmpR = splits[k2];
                    if (tmpR == null) continue;
                    splitCost += overhead + tmpR.height * lineOverhead + tmpR.height * tmpR.width;
                }
                if (splitCost >= cost) continue;
                int l2 = 0;
                for (int k3 = 0; k3 < 3; ++k3) {
                    if (splits[k3] == null) continue;
                    splits[l2++] = splits[k3];
                }
                if (l2 == 0) {
                    this.rects[i2].width = 0;
                    if (splits[3] == null) continue block0;
                    this.add(splits[3], i2, this.size - 1);
                    continue block0;
                }
                this.rects[i2] = r2 = splits[0];
                cost = overhead + r2.height * lineOverhead + r2.height * r2.width;
                if (l2 > 1) {
                    this.insertRects(splits, 1, i2 + 1, l2 - 1);
                }
                if (splits[3] == null) continue;
                this.add(splits[3], i2 + l2, this.size - 1);
            }
        }
        int j3 = 0;
        for (int i3 = 0; i3 < this.size; ++i3) {
            if (this.rects[i3].width == 0) {
                this.rects[i3] = null;
                continue;
            }
            this.rects[j3++] = this.rects[i3];
        }
        this.size = j3;
        this.bounds = null;
    }

    protected void splitRect(Rectangle r2, Rectangle sr, Rectangle[] splits) {
        int rx0 = r2.x;
        int rx1 = rx0 + r2.width - 1;
        int ry0 = r2.y;
        int ry1 = ry0 + r2.height - 1;
        int srx0 = sr.x;
        int srx1 = srx0 + sr.width - 1;
        int sry0 = sr.y;
        int sry1 = sry0 + sr.height - 1;
        if (ry0 < sry0 && ry1 >= sry0) {
            splits[0] = new Rectangle(rx0, ry0, r2.width, sry0 - ry0);
            ry0 = sry0;
        } else {
            splits[0] = null;
        }
        if (ry0 <= sry1 && ry1 > sry1) {
            splits[1] = new Rectangle(rx0, sry1 + 1, r2.width, ry1 - sry1);
            ry1 = sry1;
        } else {
            splits[1] = null;
        }
        splits[2] = rx0 < srx0 && rx1 >= srx0 ? new Rectangle(rx0, ry0, srx0 - rx0, ry1 - ry0 + 1) : null;
        splits[3] = rx0 <= srx1 && rx1 > srx1 ? new Rectangle(srx1 + 1, ry0, rx1 - srx1, ry1 - ry0 + 1) : null;
    }

    protected void insertRects(Rectangle[] rects, int srcPos, int dstPos, int len) {
        if (len == 0) {
            return;
        }
        this.ensureCapacity(this.size + len);
        for (int i2 = this.size - 1; i2 >= dstPos; --i2) {
            this.rects[i2 + len] = this.rects[i2];
        }
        System.arraycopy(rects, srcPos, this.rects, dstPos, len);
        this.size += len;
    }

    public void ensureCapacity(int sz) {
        int nSz;
        if (sz <= this.rects.length) {
            return;
        }
        for (nSz = this.rects.length + (this.rects.length >> 1) + 1; nSz < sz; nSz += (nSz >> 1) + 1) {
        }
        Rectangle[] nRects = new Rectangle[nSz];
        System.arraycopy(this.rects, 0, nRects, 0, this.size);
        this.rects = nRects;
    }

    private class RLMIterator
    implements ListIterator {
        int idx = 0;
        boolean removeOk = false;
        boolean forward = true;

        RLMIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.idx < RectListManager.this.size;
        }

        @Override
        public int nextIndex() {
            return this.idx;
        }

        @Override
        public Object next() {
            if (this.idx >= RectListManager.this.size) {
                throw new NoSuchElementException("No Next Element");
            }
            this.forward = true;
            this.removeOk = true;
            return RectListManager.this.rects[this.idx++];
        }

        @Override
        public boolean hasPrevious() {
            return this.idx > 0;
        }

        @Override
        public int previousIndex() {
            return this.idx - 1;
        }

        public Object previous() {
            if (this.idx <= 0) {
                throw new NoSuchElementException("No Previous Element");
            }
            this.forward = false;
            this.removeOk = true;
            return RectListManager.this.rects[--this.idx];
        }

        @Override
        public void remove() {
            if (!this.removeOk) {
                throw new IllegalStateException("remove can only be called directly after next/previous");
            }
            if (this.forward) {
                --this.idx;
            }
            if (this.idx != RectListManager.this.size - 1) {
                System.arraycopy(RectListManager.this.rects, this.idx + 1, RectListManager.this.rects, this.idx, RectListManager.this.size - (this.idx + 1));
            }
            --RectListManager.this.size;
            RectListManager.this.rects[RectListManager.this.size] = null;
            this.removeOk = false;
        }

        public void set(Object o2) {
            Rectangle r2 = (Rectangle)o2;
            if (!this.removeOk) {
                throw new IllegalStateException("set can only be called directly after next/previous");
            }
            if (this.forward) {
                --this.idx;
            }
            if (this.idx + 1 < RectListManager.this.size && RectListManager.this.rects[this.idx + 1].x < r2.x) {
                throw new UnsupportedOperationException("RectListManager entries must be sorted");
            }
            if (this.idx >= 0 && RectListManager.this.rects[this.idx - 1].x > r2.x) {
                throw new UnsupportedOperationException("RectListManager entries must be sorted");
            }
            RectListManager.this.rects[this.idx] = r2;
            this.removeOk = false;
        }

        public void add(Object o2) {
            Rectangle r2 = (Rectangle)o2;
            if (this.idx < RectListManager.this.size && RectListManager.this.rects[this.idx].x < r2.x) {
                throw new UnsupportedOperationException("RectListManager entries must be sorted");
            }
            if (this.idx != 0 && RectListManager.this.rects[this.idx - 1].x > r2.x) {
                throw new UnsupportedOperationException("RectListManager entries must be sorted");
            }
            RectListManager.this.ensureCapacity(RectListManager.this.size + 1);
            if (this.idx != RectListManager.this.size) {
                System.arraycopy(RectListManager.this.rects, this.idx, RectListManager.this.rects, this.idx + 1, RectListManager.this.size - this.idx);
            }
            RectListManager.this.rects[this.idx] = r2;
            ++this.idx;
            this.removeOk = false;
        }
    }

    private static class RectXComparator
    implements Comparator,
    Serializable {
        RectXComparator() {
        }

        public final int compare(Object o1, Object o2) {
            return ((Rectangle)o1).x - ((Rectangle)o2).x;
        }
    }
}

