/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom;

import org.apache.batik.dom.AbstractCharacterData;
import org.apache.batik.dom.AbstractNode;
import org.apache.batik.dom.util.XMLSupport;
import org.apache.batik.xml.XMLUtilities;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public abstract class AbstractText
extends AbstractCharacterData
implements Text {
    @Override
    public Text splitText(int offset) throws DOMException {
        if (this.isReadonly()) {
            throw this.createDOMException((short)7, "readonly.node", new Object[]{(int)this.getNodeType(), this.getNodeName()});
        }
        String v2 = this.getNodeValue();
        if (offset < 0 || offset >= v2.length()) {
            throw this.createDOMException((short)1, "offset", new Object[]{offset});
        }
        Node n2 = this.getParentNode();
        if (n2 == null) {
            throw this.createDOMException((short)1, "need.parent", new Object[0]);
        }
        String t1 = v2.substring(offset);
        Text t2 = this.createTextNode(t1);
        Node ns = this.getNextSibling();
        if (ns != null) {
            n2.insertBefore(t2, ns);
        } else {
            n2.appendChild(t2);
        }
        this.setNodeValue(v2.substring(0, offset));
        return t2;
    }

    protected Node getPreviousLogicallyAdjacentTextNode(Node n2) {
        Node p2;
        Node parent = n2.getParentNode();
        for (p2 = n2.getPreviousSibling(); p2 == null && parent != null && parent.getNodeType() == 5; p2 = p2.getPreviousSibling()) {
            p2 = parent;
            parent = p2.getParentNode();
        }
        while (p2 != null && p2.getNodeType() == 5) {
            p2 = p2.getLastChild();
        }
        if (p2 == null) {
            return null;
        }
        short nt = p2.getNodeType();
        if (nt == 3 || nt == 4) {
            return p2;
        }
        return null;
    }

    protected Node getNextLogicallyAdjacentTextNode(Node n2) {
        Node p2;
        Node parent = n2.getParentNode();
        for (p2 = n2.getNextSibling(); p2 == null && parent != null && parent.getNodeType() == 5; p2 = p2.getNextSibling()) {
            p2 = parent;
            parent = p2.getParentNode();
        }
        while (p2 != null && p2.getNodeType() == 5) {
            p2 = p2.getFirstChild();
        }
        if (p2 == null) {
            return null;
        }
        short nt = p2.getNodeType();
        if (nt == 3 || nt == 4) {
            return p2;
        }
        return null;
    }

    @Override
    public String getWholeText() {
        StringBuffer sb = new StringBuffer();
        Node n2 = this;
        while (n2 != null) {
            sb.insert(0, n2.getNodeValue());
            n2 = this.getPreviousLogicallyAdjacentTextNode(n2);
        }
        n2 = this.getNextLogicallyAdjacentTextNode(this);
        while (n2 != null) {
            sb.append(n2.getNodeValue());
            n2 = this.getNextLogicallyAdjacentTextNode(n2);
        }
        return sb.toString();
    }

    @Override
    public boolean isElementContentWhitespace() {
        int len = this.nodeValue.length();
        for (int i2 = 0; i2 < len; ++i2) {
            if (XMLUtilities.isXMLSpace(this.nodeValue.charAt(i2))) continue;
            return false;
        }
        Node p2 = this.getParentNode();
        if (p2.getNodeType() == 1) {
            String sp = XMLSupport.getXMLSpace((Element)p2);
            return !sp.equals("preserve");
        }
        return true;
    }

    @Override
    public Text replaceWholeText(String s2) throws DOMException {
        AbstractNode an;
        Node n2 = this.getPreviousLogicallyAdjacentTextNode(this);
        while (n2 != null) {
            an = (AbstractNode)n2;
            if (an.isReadonly()) {
                throw this.createDOMException((short)7, "readonly.node", new Object[]{(int)n2.getNodeType(), n2.getNodeName()});
            }
            n2 = this.getPreviousLogicallyAdjacentTextNode(n2);
        }
        n2 = this.getNextLogicallyAdjacentTextNode(this);
        while (n2 != null) {
            an = (AbstractNode)n2;
            if (an.isReadonly()) {
                throw this.createDOMException((short)7, "readonly.node", new Object[]{(int)n2.getNodeType(), n2.getNodeName()});
            }
            n2 = this.getNextLogicallyAdjacentTextNode(n2);
        }
        Node parent = this.getParentNode();
        Node n3 = this.getPreviousLogicallyAdjacentTextNode(this);
        while (n3 != null) {
            parent.removeChild(n3);
            n3 = this.getPreviousLogicallyAdjacentTextNode(n3);
        }
        n3 = this.getNextLogicallyAdjacentTextNode(this);
        while (n3 != null) {
            parent.removeChild(n3);
            n3 = this.getNextLogicallyAdjacentTextNode(n3);
        }
        if (this.isReadonly()) {
            Text t2 = this.createTextNode(s2);
            parent.replaceChild(t2, this);
            return t2;
        }
        this.setNodeValue(s2);
        return this;
    }

    @Override
    public String getTextContent() {
        if (this.isElementContentWhitespace()) {
            return "";
        }
        return this.getNodeValue();
    }

    protected abstract Text createTextNode(String var1);
}

