/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom;

import java.io.Serializable;
import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.AbstractNode;
import org.apache.batik.dom.AbstractText;
import org.apache.batik.dom.ExtendedNode;
import org.apache.batik.dom.events.DOMMutationEvent;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractParentNode
extends AbstractNode {
    protected ChildNodes childNodes;

    @Override
    public NodeList getChildNodes() {
        return this.childNodes == null ? (this.childNodes = new ChildNodes()) : this.childNodes;
    }

    @Override
    public Node getFirstChild() {
        return this.childNodes == null ? null : this.childNodes.firstChild;
    }

    @Override
    public Node getLastChild() {
        return this.childNodes == null ? null : this.childNodes.lastChild;
    }

    @Override
    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        if (refChild != null && (this.childNodes == null || refChild.getParentNode() != this)) {
            throw this.createDOMException((short)8, "child.missing", new Object[]{(int)refChild.getNodeType(), refChild.getNodeName()});
        }
        this.checkAndRemove(newChild, false);
        if (newChild.getNodeType() == 11) {
            Node n2 = newChild.getFirstChild();
            while (n2 != null) {
                Node ns = n2.getNextSibling();
                this.insertBefore(n2, refChild);
                n2 = ns;
            }
            return newChild;
        }
        if (this.childNodes == null) {
            this.childNodes = new ChildNodes();
        }
        ExtendedNode n3 = this.childNodes.insert((ExtendedNode)newChild, (ExtendedNode)refChild);
        n3.setParentNode(this);
        this.nodeAdded(n3);
        this.fireDOMNodeInsertedEvent(n3);
        this.fireDOMSubtreeModifiedEvent();
        return n3;
    }

    @Override
    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        if (this.childNodes == null || oldChild.getParentNode() != this) {
            throw this.createDOMException((short)8, "child.missing", new Object[]{(int)oldChild.getNodeType(), oldChild.getNodeName()});
        }
        this.checkAndRemove(newChild, true);
        if (newChild.getNodeType() == 11) {
            Node n2 = newChild.getLastChild();
            if (n2 == null) {
                return newChild;
            }
            Node ps = n2.getPreviousSibling();
            this.replaceChild(n2, oldChild);
            Node ns = n2;
            n2 = ps;
            while (n2 != null) {
                ps = n2.getPreviousSibling();
                this.insertBefore(n2, ns);
                ns = n2;
                n2 = ps;
            }
            return newChild;
        }
        this.fireDOMNodeRemovedEvent(oldChild);
        this.getCurrentDocument().nodeToBeRemoved(oldChild);
        this.nodeToBeRemoved(oldChild);
        ExtendedNode n3 = (ExtendedNode)newChild;
        ExtendedNode o2 = this.childNodes.replace(n3, (ExtendedNode)oldChild);
        n3.setParentNode(this);
        o2.setParentNode(null);
        this.nodeAdded(n3);
        this.fireDOMNodeInsertedEvent(n3);
        this.fireDOMSubtreeModifiedEvent();
        return n3;
    }

    @Override
    public Node removeChild(Node oldChild) throws DOMException {
        if (this.childNodes == null || oldChild.getParentNode() != this) {
            throw this.createDOMException((short)8, "child.missing", new Object[]{(int)oldChild.getNodeType(), oldChild.getNodeName()});
        }
        if (this.isReadonly()) {
            throw this.createDOMException((short)7, "readonly.node", new Object[]{(int)this.getNodeType(), this.getNodeName()});
        }
        this.fireDOMNodeRemovedEvent(oldChild);
        this.getCurrentDocument().nodeToBeRemoved(oldChild);
        this.nodeToBeRemoved(oldChild);
        ExtendedNode result = this.childNodes.remove((ExtendedNode)oldChild);
        result.setParentNode(null);
        this.fireDOMSubtreeModifiedEvent();
        return result;
    }

    @Override
    public Node appendChild(Node newChild) throws DOMException {
        this.checkAndRemove(newChild, false);
        if (newChild.getNodeType() == 11) {
            Node n2 = newChild.getFirstChild();
            while (n2 != null) {
                Node ns = n2.getNextSibling();
                this.appendChild(n2);
                n2 = ns;
            }
            return newChild;
        }
        if (this.childNodes == null) {
            this.childNodes = new ChildNodes();
        }
        ExtendedNode n3 = this.childNodes.append((ExtendedNode)newChild);
        n3.setParentNode(this);
        this.nodeAdded(n3);
        this.fireDOMNodeInsertedEvent(n3);
        this.fireDOMSubtreeModifiedEvent();
        return n3;
    }

    @Override
    public boolean hasChildNodes() {
        return this.childNodes != null && this.childNodes.getLength() != 0;
    }

    @Override
    public void normalize() {
        Node p2 = this.getFirstChild();
        if (p2 != null) {
            p2.normalize();
            Node n2 = p2.getNextSibling();
            while (n2 != null) {
                if (p2.getNodeType() == 3 && n2.getNodeType() == 3) {
                    String s2 = p2.getNodeValue() + n2.getNodeValue();
                    AbstractText at = (AbstractText)p2;
                    at.setNodeValue(s2);
                    this.removeChild(n2);
                    n2 = p2.getNextSibling();
                    continue;
                }
                n2.normalize();
                p2 = n2;
                n2 = n2.getNextSibling();
            }
        }
    }

    public NodeList getElementsByTagName(String name) {
        if (name == null) {
            return EMPTY_NODE_LIST;
        }
        AbstractDocument ad = this.getCurrentDocument();
        ElementsByTagName result = ad.getElementsByTagName(this, name);
        if (result == null) {
            result = new ElementsByTagName(name);
            ad.putElementsByTagName(this, name, result);
        }
        return result;
    }

    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        AbstractDocument ad;
        ElementsByTagNameNS result;
        if (localName == null) {
            return EMPTY_NODE_LIST;
        }
        if (namespaceURI != null && namespaceURI.length() == 0) {
            namespaceURI = null;
        }
        if ((result = (ad = this.getCurrentDocument()).getElementsByTagNameNS(this, namespaceURI, localName)) == null) {
            result = new ElementsByTagNameNS(namespaceURI, localName);
            ad.putElementsByTagNameNS(this, namespaceURI, localName, result);
        }
        return result;
    }

    @Override
    public String getTextContent() {
        StringBuffer sb = new StringBuffer();
        block3: for (Node n2 = this.getFirstChild(); n2 != null; n2 = n2.getNextSibling()) {
            switch (n2.getNodeType()) {
                case 7: 
                case 8: {
                    continue block3;
                }
                default: {
                    sb.append(((AbstractNode)n2).getTextContent());
                }
            }
        }
        return sb.toString();
    }

    @Override
    public void fireDOMNodeInsertedIntoDocumentEvent() {
        AbstractDocument doc = this.getCurrentDocument();
        if (doc.getEventsEnabled()) {
            super.fireDOMNodeInsertedIntoDocumentEvent();
            for (Node n2 = this.getFirstChild(); n2 != null; n2 = n2.getNextSibling()) {
                ((AbstractNode)n2).fireDOMNodeInsertedIntoDocumentEvent();
            }
        }
    }

    @Override
    public void fireDOMNodeRemovedFromDocumentEvent() {
        AbstractDocument doc = this.getCurrentDocument();
        if (doc.getEventsEnabled()) {
            super.fireDOMNodeRemovedFromDocumentEvent();
            for (Node n2 = this.getFirstChild(); n2 != null; n2 = n2.getNextSibling()) {
                ((AbstractNode)n2).fireDOMNodeRemovedFromDocumentEvent();
            }
        }
    }

    protected void nodeAdded(Node n2) {
    }

    protected void nodeToBeRemoved(Node n2) {
    }

    @Override
    protected Node deepExport(Node n2, AbstractDocument d2) {
        super.deepExport(n2, d2);
        for (Node p2 = this.getFirstChild(); p2 != null; p2 = p2.getNextSibling()) {
            Node t2 = ((AbstractNode)p2).deepExport(p2.cloneNode(false), d2);
            n2.appendChild(t2);
        }
        return n2;
    }

    @Override
    protected Node deepCopyInto(Node n2) {
        super.deepCopyInto(n2);
        for (Node p2 = this.getFirstChild(); p2 != null; p2 = p2.getNextSibling()) {
            Node t2 = p2.cloneNode(true);
            n2.appendChild(t2);
        }
        return n2;
    }

    protected void fireDOMSubtreeModifiedEvent() {
        AbstractDocument doc = this.getCurrentDocument();
        if (doc.getEventsEnabled()) {
            DOMMutationEvent ev = (DOMMutationEvent)doc.createEvent("MutationEvents");
            ev.initMutationEventNS("http://www.w3.org/2001/xml-events", "DOMSubtreeModified", true, false, null, null, null, null, (short)1);
            this.dispatchEvent(ev);
        }
    }

    protected void fireDOMNodeInsertedEvent(Node node) {
        AbstractDocument doc = this.getCurrentDocument();
        if (doc.getEventsEnabled()) {
            DOMMutationEvent ev = (DOMMutationEvent)doc.createEvent("MutationEvents");
            ev.initMutationEventNS("http://www.w3.org/2001/xml-events", "DOMNodeInserted", true, false, this, null, null, null, (short)2);
            AbstractNode n2 = (AbstractNode)node;
            n2.dispatchEvent(ev);
            n2.fireDOMNodeInsertedIntoDocumentEvent();
        }
    }

    protected void fireDOMNodeRemovedEvent(Node node) {
        AbstractDocument doc = this.getCurrentDocument();
        if (doc.getEventsEnabled()) {
            DOMMutationEvent ev = (DOMMutationEvent)doc.createEvent("MutationEvents");
            ev.initMutationEventNS("http://www.w3.org/2001/xml-events", "DOMNodeRemoved", true, false, this, null, null, null, (short)3);
            AbstractNode n2 = (AbstractNode)node;
            n2.dispatchEvent(ev);
            n2.fireDOMNodeRemovedFromDocumentEvent();
        }
    }

    protected void checkAndRemove(Node n2, boolean replace) {
        this.checkChildType(n2, replace);
        if (this.isReadonly()) {
            throw this.createDOMException((short)7, "readonly.node", new Object[]{(int)this.getNodeType(), this.getNodeName()});
        }
        if (n2.getOwnerDocument() != this.getCurrentDocument()) {
            throw this.createDOMException((short)4, "node.from.wrong.document", new Object[]{(int)this.getNodeType(), this.getNodeName()});
        }
        if (this == n2) {
            throw this.createDOMException((short)3, "add.self", new Object[]{this.getNodeName()});
        }
        Node np = n2.getParentNode();
        if (np == null) {
            return;
        }
        for (Node pn = this; pn != null; pn = pn.getParentNode()) {
            if (pn != n2) continue;
            throw this.createDOMException((short)3, "add.ancestor", new Object[]{(int)this.getNodeType(), this.getNodeName()});
        }
        np.removeChild(n2);
    }

    protected class ChildNodes
    implements NodeList,
    Serializable {
        protected ExtendedNode firstChild;
        protected ExtendedNode lastChild;
        protected int children;
        protected int elementChildren;

        @Override
        public Node item(int index) {
            if (index < 0 || index >= this.children) {
                return null;
            }
            if (index < this.children >> 1) {
                Node n2 = this.firstChild;
                for (int i2 = 0; i2 < index; ++i2) {
                    n2 = n2.getNextSibling();
                }
                return n2;
            }
            Node n3 = this.lastChild;
            for (int i3 = this.children - 1; i3 > index; --i3) {
                n3 = n3.getPreviousSibling();
            }
            return n3;
        }

        @Override
        public int getLength() {
            return this.children;
        }

        public ExtendedNode append(ExtendedNode n2) {
            if (this.lastChild == null) {
                this.firstChild = n2;
            } else {
                this.lastChild.setNextSibling(n2);
                n2.setPreviousSibling(this.lastChild);
            }
            this.lastChild = n2;
            ++this.children;
            if (n2.getNodeType() == 1) {
                ++this.elementChildren;
            }
            return n2;
        }

        public ExtendedNode insert(ExtendedNode n2, ExtendedNode r2) {
            if (r2 == null) {
                return this.append(n2);
            }
            if (r2 == this.firstChild) {
                this.firstChild.setPreviousSibling(n2);
                n2.setNextSibling(this.firstChild);
                this.firstChild = n2;
                ++this.children;
                if (n2.getNodeType() == 1) {
                    ++this.elementChildren;
                }
                return n2;
            }
            if (r2 == this.lastChild) {
                ExtendedNode ps = (ExtendedNode)r2.getPreviousSibling();
                ps.setNextSibling(n2);
                r2.setPreviousSibling(n2);
                n2.setNextSibling(r2);
                n2.setPreviousSibling(ps);
                ++this.children;
                if (n2.getNodeType() == 1) {
                    ++this.elementChildren;
                }
                return n2;
            }
            ExtendedNode ps = (ExtendedNode)r2.getPreviousSibling();
            if (ps.getNextSibling() == r2 && ps.getParentNode() == r2.getParentNode()) {
                ps.setNextSibling(n2);
                n2.setPreviousSibling(ps);
                n2.setNextSibling(r2);
                r2.setPreviousSibling(n2);
                ++this.children;
                if (n2.getNodeType() == 1) {
                    ++this.elementChildren;
                }
                return n2;
            }
            throw AbstractParentNode.this.createDOMException((short)8, "child.missing", new Object[]{(int)r2.getNodeType(), r2.getNodeName()});
        }

        public ExtendedNode replace(ExtendedNode n2, ExtendedNode o2) {
            if (o2 == this.firstChild) {
                ExtendedNode t2 = (ExtendedNode)this.firstChild.getNextSibling();
                n2.setNextSibling(t2);
                if (o2 == this.lastChild) {
                    this.lastChild = n2;
                } else {
                    t2.setPreviousSibling(n2);
                }
                this.firstChild.setNextSibling(null);
                this.firstChild = n2;
                if (o2.getNodeType() == 1) {
                    --this.elementChildren;
                }
                if (n2.getNodeType() == 1) {
                    ++this.elementChildren;
                }
                return o2;
            }
            if (o2 == this.lastChild) {
                ExtendedNode t3 = (ExtendedNode)this.lastChild.getPreviousSibling();
                n2.setPreviousSibling(t3);
                t3.setNextSibling(n2);
                this.lastChild.setPreviousSibling(null);
                this.lastChild = n2;
                if (o2.getNodeType() == 1) {
                    --this.elementChildren;
                }
                if (n2.getNodeType() == 1) {
                    ++this.elementChildren;
                }
                return o2;
            }
            ExtendedNode ps = (ExtendedNode)o2.getPreviousSibling();
            ExtendedNode ns = (ExtendedNode)o2.getNextSibling();
            if (ps.getNextSibling() == o2 && ns.getPreviousSibling() == o2 && ps.getParentNode() == o2.getParentNode() && ns.getParentNode() == o2.getParentNode()) {
                ps.setNextSibling(n2);
                n2.setPreviousSibling(ps);
                n2.setNextSibling(ns);
                ns.setPreviousSibling(n2);
                o2.setPreviousSibling(null);
                o2.setNextSibling(null);
                if (o2.getNodeType() == 1) {
                    --this.elementChildren;
                }
                if (n2.getNodeType() == 1) {
                    ++this.elementChildren;
                }
                return o2;
            }
            throw AbstractParentNode.this.createDOMException((short)8, "child.missing", new Object[]{(int)o2.getNodeType(), o2.getNodeName()});
        }

        public ExtendedNode remove(ExtendedNode n2) {
            if (n2 == this.firstChild) {
                if (n2 == this.lastChild) {
                    this.firstChild = null;
                    this.lastChild = null;
                    --this.children;
                    if (n2.getNodeType() == 1) {
                        --this.elementChildren;
                    }
                    return n2;
                }
                this.firstChild = (ExtendedNode)this.firstChild.getNextSibling();
                this.firstChild.setPreviousSibling(null);
                n2.setNextSibling(null);
                if (n2.getNodeType() == 1) {
                    --this.elementChildren;
                }
                --this.children;
                return n2;
            }
            if (n2 == this.lastChild) {
                this.lastChild = (ExtendedNode)this.lastChild.getPreviousSibling();
                this.lastChild.setNextSibling(null);
                n2.setPreviousSibling(null);
                --this.children;
                if (n2.getNodeType() == 1) {
                    --this.elementChildren;
                }
                return n2;
            }
            ExtendedNode ps = (ExtendedNode)n2.getPreviousSibling();
            ExtendedNode ns = (ExtendedNode)n2.getNextSibling();
            if (ps.getNextSibling() == n2 && ns.getPreviousSibling() == n2 && ps.getParentNode() == n2.getParentNode() && ns.getParentNode() == n2.getParentNode()) {
                ps.setNextSibling(ns);
                ns.setPreviousSibling(ps);
                n2.setPreviousSibling(null);
                n2.setNextSibling(null);
                --this.children;
                if (n2.getNodeType() == 1) {
                    --this.elementChildren;
                }
                return n2;
            }
            throw AbstractParentNode.this.createDOMException((short)8, "child.missing", new Object[]{(int)n2.getNodeType(), n2.getNodeName()});
        }
    }

    protected class ElementsByTagNameNS
    implements NodeList {
        protected Node[] table;
        protected int size = -1;
        protected String namespaceURI;
        protected String localName;

        public ElementsByTagNameNS(String ns, String ln) {
            this.namespaceURI = ns;
            this.localName = ln;
        }

        @Override
        public Node item(int index) {
            if (this.size == -1) {
                this.initialize();
            }
            if (this.table == null || index < 0 || index > this.size) {
                return null;
            }
            return this.table[index];
        }

        @Override
        public int getLength() {
            if (this.size == -1) {
                this.initialize();
            }
            return this.size;
        }

        public void invalidate() {
            this.size = -1;
        }

        protected void append(Node n2) {
            if (this.table == null) {
                this.table = new Node[11];
            } else if (this.size == this.table.length - 1) {
                Node[] t2 = new Node[this.table.length * 2 + 1];
                System.arraycopy(this.table, 0, t2, 0, this.size);
                this.table = t2;
            }
            this.table[this.size++] = n2;
        }

        protected void initialize() {
            this.size = 0;
            for (Node n2 = AbstractParentNode.this.getFirstChild(); n2 != null; n2 = n2.getNextSibling()) {
                this.initialize(n2);
            }
        }

        private void initialize(Node node) {
            if (node.getNodeType() == 1) {
                String nm;
                String ns = node.getNamespaceURI();
                String string = nm = ns == null ? node.getNodeName() : node.getLocalName();
                if (this.nsMatch(this.namespaceURI, node.getNamespaceURI()) && (this.localName.equals("*") || this.localName.equals(nm))) {
                    this.append(node);
                }
            }
            for (Node n2 = node.getFirstChild(); n2 != null; n2 = n2.getNextSibling()) {
                this.initialize(n2);
            }
        }

        private boolean nsMatch(String s1, String s2) {
            if (s1 == null && s2 == null) {
                return true;
            }
            if (s1 == null || s2 == null) {
                return false;
            }
            if (s1.equals("*")) {
                return true;
            }
            return s1.equals(s2);
        }
    }

    protected class ElementsByTagName
    implements NodeList {
        protected Node[] table;
        protected int size = -1;
        protected String name;

        public ElementsByTagName(String n2) {
            this.name = n2;
        }

        @Override
        public Node item(int index) {
            if (this.size == -1) {
                this.initialize();
            }
            if (this.table == null || index < 0 || index >= this.size) {
                return null;
            }
            return this.table[index];
        }

        @Override
        public int getLength() {
            if (this.size == -1) {
                this.initialize();
            }
            return this.size;
        }

        public void invalidate() {
            this.size = -1;
        }

        protected void append(Node n2) {
            if (this.table == null) {
                this.table = new Node[11];
            } else if (this.size == this.table.length - 1) {
                Node[] t2 = new Node[this.table.length * 2 + 1];
                System.arraycopy(this.table, 0, t2, 0, this.size);
                this.table = t2;
            }
            this.table[this.size++] = n2;
        }

        protected void initialize() {
            this.size = 0;
            for (Node n2 = AbstractParentNode.this.getFirstChild(); n2 != null; n2 = n2.getNextSibling()) {
                this.initialize(n2);
            }
        }

        private void initialize(Node node) {
            if (node.getNodeType() == 1) {
                String nm = node.getNodeName();
                if (this.name.equals("*") || this.name.equals(nm)) {
                    this.append(node);
                }
            }
            for (Node n2 = node.getFirstChild(); n2 != null; n2 = n2.getNextSibling()) {
                this.initialize(n2);
            }
        }
    }
}

