/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.engine.value.svg;

import org.apache.batik.css.engine.value.AbstractValue;
import org.w3c.dom.DOMException;

public class ICCColor
extends AbstractValue {
    public static final String ICC_COLOR_FUNCTION = "icc-color";
    protected String colorProfile;
    protected int count;
    protected float[] colors = new float[5];

    public ICCColor(String name) {
        this.colorProfile = name;
    }

    @Override
    public short getCssValueType() {
        return 3;
    }

    public String getColorProfile() throws DOMException {
        return this.colorProfile;
    }

    public int getNumberOfColors() throws DOMException {
        return this.count;
    }

    public float getColor(int i2) throws DOMException {
        return this.colors[i2];
    }

    @Override
    public String getCssText() {
        StringBuffer sb = new StringBuffer(this.count * 8);
        sb.append(ICC_COLOR_FUNCTION).append('(');
        sb.append(this.colorProfile);
        for (int i2 = 0; i2 < this.count; ++i2) {
            sb.append(", ");
            sb.append(this.colors[i2]);
        }
        sb.append(')');
        return sb.toString();
    }

    public void append(float c2) {
        if (this.count == this.colors.length) {
            float[] t2 = new float[this.count * 2];
            System.arraycopy(this.colors, 0, t2, 0, this.count);
            this.colors = t2;
        }
        this.colors[this.count++] = c2;
    }

    public String toString() {
        return this.getCssText();
    }
}

