/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.engine.value.css2;

import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.css.engine.CSSStylableElement;
import org.apache.batik.css.engine.StyleMap;
import org.apache.batik.css.engine.value.IdentifierManager;
import org.apache.batik.css.engine.value.StringMap;
import org.apache.batik.css.engine.value.Value;
import org.apache.batik.css.engine.value.ValueConstants;

public class FontStretchManager
extends IdentifierManager {
    protected static final StringMap values = new StringMap();

    @Override
    public boolean isInheritedProperty() {
        return true;
    }

    @Override
    public boolean isAnimatableProperty() {
        return true;
    }

    @Override
    public boolean isAdditiveProperty() {
        return false;
    }

    @Override
    public int getPropertyType() {
        return 15;
    }

    @Override
    public String getPropertyName() {
        return "font-stretch";
    }

    @Override
    public Value getDefaultValue() {
        return ValueConstants.NORMAL_VALUE;
    }

    @Override
    public Value computeValue(CSSStylableElement elt, String pseudo, CSSEngine engine, int idx, StyleMap sm, Value value) {
        if (value == ValueConstants.NARROWER_VALUE) {
            sm.putParentRelative(idx, true);
            CSSStylableElement p2 = CSSEngine.getParentCSSStylableElement(elt);
            if (p2 == null) {
                return ValueConstants.SEMI_CONDENSED_VALUE;
            }
            Value v2 = engine.getComputedStyle(p2, pseudo, idx);
            if (v2 == ValueConstants.NORMAL_VALUE) {
                return ValueConstants.SEMI_CONDENSED_VALUE;
            }
            if (v2 == ValueConstants.CONDENSED_VALUE) {
                return ValueConstants.EXTRA_CONDENSED_VALUE;
            }
            if (v2 == ValueConstants.EXPANDED_VALUE) {
                return ValueConstants.SEMI_EXPANDED_VALUE;
            }
            if (v2 == ValueConstants.SEMI_EXPANDED_VALUE) {
                return ValueConstants.NORMAL_VALUE;
            }
            if (v2 == ValueConstants.SEMI_CONDENSED_VALUE) {
                return ValueConstants.CONDENSED_VALUE;
            }
            if (v2 == ValueConstants.EXTRA_CONDENSED_VALUE) {
                return ValueConstants.ULTRA_CONDENSED_VALUE;
            }
            if (v2 == ValueConstants.EXTRA_EXPANDED_VALUE) {
                return ValueConstants.EXPANDED_VALUE;
            }
            if (v2 == ValueConstants.ULTRA_CONDENSED_VALUE) {
                return ValueConstants.ULTRA_CONDENSED_VALUE;
            }
            return ValueConstants.EXTRA_EXPANDED_VALUE;
        }
        if (value == ValueConstants.WIDER_VALUE) {
            sm.putParentRelative(idx, true);
            CSSStylableElement p3 = CSSEngine.getParentCSSStylableElement(elt);
            if (p3 == null) {
                return ValueConstants.SEMI_CONDENSED_VALUE;
            }
            Value v3 = engine.getComputedStyle(p3, pseudo, idx);
            if (v3 == ValueConstants.NORMAL_VALUE) {
                return ValueConstants.SEMI_EXPANDED_VALUE;
            }
            if (v3 == ValueConstants.CONDENSED_VALUE) {
                return ValueConstants.SEMI_CONDENSED_VALUE;
            }
            if (v3 == ValueConstants.EXPANDED_VALUE) {
                return ValueConstants.EXTRA_EXPANDED_VALUE;
            }
            if (v3 == ValueConstants.SEMI_EXPANDED_VALUE) {
                return ValueConstants.EXPANDED_VALUE;
            }
            if (v3 == ValueConstants.SEMI_CONDENSED_VALUE) {
                return ValueConstants.NORMAL_VALUE;
            }
            if (v3 == ValueConstants.EXTRA_CONDENSED_VALUE) {
                return ValueConstants.CONDENSED_VALUE;
            }
            if (v3 == ValueConstants.EXTRA_EXPANDED_VALUE) {
                return ValueConstants.ULTRA_EXPANDED_VALUE;
            }
            if (v3 == ValueConstants.ULTRA_CONDENSED_VALUE) {
                return ValueConstants.EXTRA_CONDENSED_VALUE;
            }
            return ValueConstants.ULTRA_EXPANDED_VALUE;
        }
        return value;
    }

    @Override
    public StringMap getIdentifiers() {
        return values;
    }

    static {
        values.put("all", ValueConstants.ALL_VALUE);
        values.put("condensed", ValueConstants.CONDENSED_VALUE);
        values.put("expanded", ValueConstants.EXPANDED_VALUE);
        values.put("extra-condensed", ValueConstants.EXTRA_CONDENSED_VALUE);
        values.put("extra-expanded", ValueConstants.EXTRA_EXPANDED_VALUE);
        values.put("narrower", ValueConstants.NARROWER_VALUE);
        values.put("normal", ValueConstants.NORMAL_VALUE);
        values.put("semi-condensed", ValueConstants.SEMI_CONDENSED_VALUE);
        values.put("semi-expanded", ValueConstants.SEMI_EXPANDED_VALUE);
        values.put("ultra-condensed", ValueConstants.ULTRA_CONDENSED_VALUE);
        values.put("ultra-expanded", ValueConstants.ULTRA_EXPANDED_VALUE);
        values.put("wider", ValueConstants.WIDER_VALUE);
    }
}

