/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.engine;

import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.css.engine.value.Value;

public class StyleMap {
    public static final short IMPORTANT_MASK = 1;
    public static final short COMPUTED_MASK = 2;
    public static final short NULL_CASCADED_MASK = 4;
    public static final short INHERITED_MASK = 8;
    public static final short LINE_HEIGHT_RELATIVE_MASK = 16;
    public static final short FONT_SIZE_RELATIVE_MASK = 32;
    public static final short COLOR_RELATIVE_MASK = 64;
    public static final short PARENT_RELATIVE_MASK = 128;
    public static final short BLOCK_WIDTH_RELATIVE_MASK = 256;
    public static final short BLOCK_HEIGHT_RELATIVE_MASK = 512;
    public static final short BOX_RELATIVE_MASK = 1024;
    public static final short ORIGIN_MASK = -8192;
    public static final short USER_AGENT_ORIGIN = 0;
    public static final short USER_ORIGIN = 8192;
    public static final short NON_CSS_ORIGIN = 16384;
    public static final short AUTHOR_ORIGIN = 24576;
    public static final short INLINE_AUTHOR_ORIGIN = Short.MIN_VALUE;
    public static final short OVERRIDE_ORIGIN = -24576;
    protected Value[] values;
    protected short[] masks;
    protected boolean fixedCascadedValues;

    public StyleMap(int size) {
        this.values = new Value[size];
        this.masks = new short[size];
    }

    public boolean hasFixedCascadedValues() {
        return this.fixedCascadedValues;
    }

    public void setFixedCascadedStyle(boolean b2) {
        this.fixedCascadedValues = b2;
    }

    public Value getValue(int i2) {
        return this.values[i2];
    }

    public short getMask(int i2) {
        return this.masks[i2];
    }

    public boolean isImportant(int i2) {
        return (this.masks[i2] & 1) != 0;
    }

    public boolean isComputed(int i2) {
        return (this.masks[i2] & 2) != 0;
    }

    public boolean isNullCascaded(int i2) {
        return (this.masks[i2] & 4) != 0;
    }

    public boolean isInherited(int i2) {
        return (this.masks[i2] & 8) != 0;
    }

    public short getOrigin(int i2) {
        return (short)(this.masks[i2] & 0xFFFFE000);
    }

    public boolean isColorRelative(int i2) {
        return (this.masks[i2] & 0x40) != 0;
    }

    public boolean isParentRelative(int i2) {
        return (this.masks[i2] & 0x80) != 0;
    }

    public boolean isLineHeightRelative(int i2) {
        return (this.masks[i2] & 0x10) != 0;
    }

    public boolean isFontSizeRelative(int i2) {
        return (this.masks[i2] & 0x20) != 0;
    }

    public boolean isBlockWidthRelative(int i2) {
        return (this.masks[i2] & 0x100) != 0;
    }

    public boolean isBlockHeightRelative(int i2) {
        return (this.masks[i2] & 0x200) != 0;
    }

    public void putValue(int i2, Value v2) {
        this.values[i2] = v2;
    }

    public void putMask(int i2, short m2) {
        this.masks[i2] = m2;
    }

    public void putImportant(int i2, boolean b2) {
        if (b2) {
            int n2 = i2;
            this.masks[n2] = (short)(this.masks[n2] | 1);
        } else {
            int n3 = i2;
            this.masks[n3] = (short)(this.masks[n3] & 0xFFFFFFFE);
        }
    }

    public void putOrigin(int i2, short val) {
        int n2 = i2;
        this.masks[n2] = (short)(this.masks[n2] & 0x1FFF);
        int n3 = i2;
        this.masks[n3] = (short)(this.masks[n3] | (short)(val & 0xFFFFE000));
    }

    public void putComputed(int i2, boolean b2) {
        if (b2) {
            int n2 = i2;
            this.masks[n2] = (short)(this.masks[n2] | 2);
        } else {
            int n3 = i2;
            this.masks[n3] = (short)(this.masks[n3] & 0xFFFFFFFD);
        }
    }

    public void putNullCascaded(int i2, boolean b2) {
        if (b2) {
            int n2 = i2;
            this.masks[n2] = (short)(this.masks[n2] | 4);
        } else {
            int n3 = i2;
            this.masks[n3] = (short)(this.masks[n3] & 0xFFFFFFFB);
        }
    }

    public void putInherited(int i2, boolean b2) {
        if (b2) {
            int n2 = i2;
            this.masks[n2] = (short)(this.masks[n2] | 8);
        } else {
            int n3 = i2;
            this.masks[n3] = (short)(this.masks[n3] & 0xFFFFFFF7);
        }
    }

    public void putColorRelative(int i2, boolean b2) {
        if (b2) {
            int n2 = i2;
            this.masks[n2] = (short)(this.masks[n2] | 0x40);
        } else {
            int n3 = i2;
            this.masks[n3] = (short)(this.masks[n3] & 0xFFFFFFBF);
        }
    }

    public void putParentRelative(int i2, boolean b2) {
        if (b2) {
            int n2 = i2;
            this.masks[n2] = (short)(this.masks[n2] | 0x80);
        } else {
            int n3 = i2;
            this.masks[n3] = (short)(this.masks[n3] & 0xFFFFFF7F);
        }
    }

    public void putLineHeightRelative(int i2, boolean b2) {
        if (b2) {
            int n2 = i2;
            this.masks[n2] = (short)(this.masks[n2] | 0x10);
        } else {
            int n3 = i2;
            this.masks[n3] = (short)(this.masks[n3] & 0xFFFFFFEF);
        }
    }

    public void putFontSizeRelative(int i2, boolean b2) {
        if (b2) {
            int n2 = i2;
            this.masks[n2] = (short)(this.masks[n2] | 0x20);
        } else {
            int n3 = i2;
            this.masks[n3] = (short)(this.masks[n3] & 0xFFFFFFDF);
        }
    }

    public void putBlockWidthRelative(int i2, boolean b2) {
        if (b2) {
            int n2 = i2;
            this.masks[n2] = (short)(this.masks[n2] | 0x100);
        } else {
            int n3 = i2;
            this.masks[n3] = (short)(this.masks[n3] & 0xFFFFFEFF);
        }
    }

    public void putBlockHeightRelative(int i2, boolean b2) {
        if (b2) {
            int n2 = i2;
            this.masks[n2] = (short)(this.masks[n2] | 0x200);
        } else {
            int n3 = i2;
            this.masks[n3] = (short)(this.masks[n3] & 0xFFFFFDFF);
        }
    }

    public String toString(CSSEngine eng) {
        int nSlots = this.values.length;
        StringBuffer sb = new StringBuffer(nSlots * 8);
        for (int i2 = 0; i2 < nSlots; ++i2) {
            Value v2 = this.values[i2];
            if (v2 == null) continue;
            sb.append(eng.getPropertyName(i2));
            sb.append(": ");
            sb.append(v2);
            if (this.isImportant(i2)) {
                sb.append(" !important");
            }
            sb.append(";\n");
        }
        return sb.toString();
    }
}

