/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.LinkedList;
import java.util.StringTokenizer;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.ErrorConstants;
import org.apache.batik.bridge.URIResolver;
import org.apache.batik.bridge.UnitProcessor;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.dom.util.XLinkSupport;
import org.apache.batik.dom.util.XMLSupport;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.parser.AWTTransformProducer;
import org.apache.batik.parser.ClockHandler;
import org.apache.batik.parser.ClockParser;
import org.apache.batik.parser.ParseException;
import org.apache.batik.parser.UnitProcessor;
import org.apache.batik.util.ParsedURL;
import org.apache.batik.util.SVGConstants;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGLangSpace;
import org.w3c.dom.svg.SVGNumberList;

public abstract class SVGUtilities
implements SVGConstants,
ErrorConstants {
    public static final short USER_SPACE_ON_USE = 1;
    public static final short OBJECT_BOUNDING_BOX = 2;
    public static final short STROKE_WIDTH = 3;

    protected SVGUtilities() {
    }

    public static Element getParentElement(Element elt) {
        Node n2 = CSSEngine.getCSSParentNode(elt);
        while (n2 != null && n2.getNodeType() != 1) {
            n2 = CSSEngine.getCSSParentNode(n2);
        }
        return (Element)n2;
    }

    public static float[] convertSVGNumberList(SVGNumberList l2) {
        int n2 = l2.getNumberOfItems();
        if (n2 == 0) {
            return null;
        }
        float[] fl = new float[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            fl[i2] = l2.getItem(i2).getValue();
        }
        return fl;
    }

    public static float convertSVGNumber(String s2) {
        return Float.parseFloat(s2);
    }

    public static int convertSVGInteger(String s2) {
        return Integer.parseInt(s2);
    }

    public static float convertRatio(String v2) {
        float r2;
        float d2 = 1.0f;
        if (v2.endsWith("%")) {
            v2 = v2.substring(0, v2.length() - 1);
            d2 = 100.0f;
        }
        if ((r2 = Float.parseFloat(v2) / d2) < 0.0f) {
            r2 = 0.0f;
        } else if (r2 > 1.0f) {
            r2 = 1.0f;
        }
        return r2;
    }

    public static String getDescription(SVGElement elt) {
        String result = "";
        boolean preserve = false;
        Node n2 = elt.getFirstChild();
        if (n2 != null && n2.getNodeType() == 1) {
            String name;
            String string = name = n2.getPrefix() == null ? n2.getNodeName() : n2.getLocalName();
            if (name.equals("desc")) {
                preserve = ((SVGLangSpace)((Object)n2)).getXMLspace().equals("preserve");
                for (n2 = n2.getFirstChild(); n2 != null; n2 = n2.getNextSibling()) {
                    if (n2.getNodeType() != 3) continue;
                    result = result + n2.getNodeValue();
                }
            }
        }
        return preserve ? XMLSupport.preserveXMLSpace(result) : XMLSupport.defaultXMLSpace(result);
    }

    public static boolean matchUserAgent(Element elt, UserAgent ua) {
        String s2;
        StringTokenizer st;
        block9: {
            if (elt.hasAttributeNS(null, "systemLanguage")) {
                String sl = elt.getAttributeNS(null, "systemLanguage");
                if (sl.length() == 0) {
                    return false;
                }
                st = new StringTokenizer(sl, ", ");
                while (st.hasMoreTokens()) {
                    s2 = st.nextToken();
                    if (!SVGUtilities.matchUserLanguage(s2, ua.getLanguages())) continue;
                    break block9;
                }
                return false;
            }
        }
        if (elt.hasAttributeNS(null, "requiredFeatures")) {
            String rf = elt.getAttributeNS(null, "requiredFeatures");
            if (rf.length() == 0) {
                return false;
            }
            st = new StringTokenizer(rf, " ");
            while (st.hasMoreTokens()) {
                s2 = st.nextToken();
                if (ua.hasFeature(s2)) continue;
                return false;
            }
        }
        if (elt.hasAttributeNS(null, "requiredExtensions")) {
            String re = elt.getAttributeNS(null, "requiredExtensions");
            if (re.length() == 0) {
                return false;
            }
            st = new StringTokenizer(re, " ");
            while (st.hasMoreTokens()) {
                s2 = st.nextToken();
                if (ua.supportExtension(s2)) continue;
                return false;
            }
        }
        return true;
    }

    protected static boolean matchUserLanguage(String s2, String userLanguages) {
        StringTokenizer st = new StringTokenizer(userLanguages, ", ");
        while (st.hasMoreTokens()) {
            String t2 = st.nextToken();
            if (!s2.startsWith(t2)) continue;
            if (s2.length() > t2.length()) {
                return s2.charAt(t2.length()) == '-';
            }
            return true;
        }
        return false;
    }

    public static String getChainableAttributeNS(Element element, String namespaceURI, String attrName, BridgeContext ctx) {
        DocumentLoader loader = ctx.getDocumentLoader();
        Element e2 = element;
        LinkedList<ParsedURL> refs = new LinkedList<ParsedURL>();
        String v2;
        while ((v2 = e2.getAttributeNS(namespaceURI, attrName)).length() <= 0) {
            String uriStr = XLinkSupport.getXLinkHref(e2);
            if (uriStr.length() == 0) {
                return "";
            }
            String baseURI = e2.getBaseURI();
            ParsedURL purl = new ParsedURL(baseURI, uriStr);
            for (Object e3 : refs) {
                if (!purl.equals(e3)) continue;
                throw new BridgeException(ctx, e2, "xlink.href.circularDependencies", new Object[]{uriStr});
            }
            try {
                SVGDocument svgDoc = (SVGDocument)e2.getOwnerDocument();
                URIResolver uRIResolver = ctx.createURIResolver(svgDoc, loader);
                e2 = uRIResolver.getElement(purl.toString(), e2);
                refs.add(purl);
            }
            catch (IOException ioEx) {
                throw new BridgeException(ctx, e2, ioEx, "uri.io", new Object[]{uriStr});
            }
            catch (SecurityException secEx) {
                throw new BridgeException(ctx, e2, secEx, "uri.unsecure", new Object[]{uriStr});
            }
        }
        return v2;
    }

    public static Point2D convertPoint(String xStr, String xAttr, String yStr, String yAttr, short unitsType, UnitProcessor.Context uctx) {
        float y2;
        float x2;
        switch (unitsType) {
            case 2: {
                x2 = UnitProcessor.svgHorizontalCoordinateToObjectBoundingBox(xStr, xAttr, uctx);
                y2 = UnitProcessor.svgVerticalCoordinateToObjectBoundingBox(yStr, yAttr, uctx);
                break;
            }
            case 1: {
                x2 = UnitProcessor.svgHorizontalCoordinateToUserSpace(xStr, xAttr, uctx);
                y2 = UnitProcessor.svgVerticalCoordinateToUserSpace(yStr, yAttr, uctx);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid unit type");
            }
        }
        return new Point2D.Float(x2, y2);
    }

    public static float convertLength(String length, String attr, short unitsType, UnitProcessor.Context uctx) {
        switch (unitsType) {
            case 2: {
                return UnitProcessor.svgOtherLengthToObjectBoundingBox(length, attr, uctx);
            }
            case 1: {
                return UnitProcessor.svgOtherLengthToUserSpace(length, attr, uctx);
            }
        }
        throw new IllegalArgumentException("Invalid unit type");
    }

    public static Rectangle2D convertMaskRegion(Element maskElement, Element maskedElement, GraphicsNode maskedNode, BridgeContext ctx) {
        String units;
        String hStr;
        String wStr;
        String yStr;
        String xStr = maskElement.getAttributeNS(null, "x");
        if (xStr.length() == 0) {
            xStr = "-10%";
        }
        if ((yStr = maskElement.getAttributeNS(null, "y")).length() == 0) {
            yStr = "-10%";
        }
        if ((wStr = maskElement.getAttributeNS(null, "width")).length() == 0) {
            wStr = "120%";
        }
        if ((hStr = maskElement.getAttributeNS(null, "height")).length() == 0) {
            hStr = "120%";
        }
        short unitsType = (units = maskElement.getAttributeNS(null, "maskUnits")).length() == 0 ? (short)2 : (short)SVGUtilities.parseCoordinateSystem(maskElement, "maskUnits", units, ctx);
        UnitProcessor.Context uctx = UnitProcessor.createContext(ctx, maskedElement);
        return SVGUtilities.convertRegion(xStr, yStr, wStr, hStr, unitsType, maskedNode, uctx);
    }

    public static Rectangle2D convertPatternRegion(Element patternElement, Element paintedElement, GraphicsNode paintedNode, BridgeContext ctx) {
        String wStr;
        String yStr;
        String xStr = SVGUtilities.getChainableAttributeNS(patternElement, null, "x", ctx);
        if (xStr.length() == 0) {
            xStr = "0";
        }
        if ((yStr = SVGUtilities.getChainableAttributeNS(patternElement, null, "y", ctx)).length() == 0) {
            yStr = "0";
        }
        if ((wStr = SVGUtilities.getChainableAttributeNS(patternElement, null, "width", ctx)).length() == 0) {
            throw new BridgeException(ctx, patternElement, "attribute.missing", new Object[]{"width"});
        }
        String hStr = SVGUtilities.getChainableAttributeNS(patternElement, null, "height", ctx);
        if (hStr.length() == 0) {
            throw new BridgeException(ctx, patternElement, "attribute.missing", new Object[]{"height"});
        }
        String units = SVGUtilities.getChainableAttributeNS(patternElement, null, "patternUnits", ctx);
        short unitsType = units.length() == 0 ? (short)2 : (short)SVGUtilities.parseCoordinateSystem(patternElement, "patternUnits", units, ctx);
        UnitProcessor.Context uctx = UnitProcessor.createContext(ctx, paintedElement);
        return SVGUtilities.convertRegion(xStr, yStr, wStr, hStr, unitsType, paintedNode, uctx);
    }

    public static float[] convertFilterRes(Element filterElement, BridgeContext ctx) {
        float[] filterRes = new float[2];
        String s2 = SVGUtilities.getChainableAttributeNS(filterElement, null, "filterRes", ctx);
        Float[] vals = SVGUtilities.convertSVGNumberOptionalNumber(filterElement, "filterRes", s2, ctx);
        if (filterRes[0] < 0.0f || filterRes[1] < 0.0f) {
            throw new BridgeException(ctx, filterElement, "attribute.malformed", new Object[]{"filterRes", s2});
        }
        if (vals[0] == null) {
            filterRes[0] = -1.0f;
        } else {
            filterRes[0] = vals[0].floatValue();
            if (filterRes[0] < 0.0f) {
                throw new BridgeException(ctx, filterElement, "attribute.malformed", new Object[]{"filterRes", s2});
            }
        }
        if (vals[1] == null) {
            filterRes[1] = filterRes[0];
        } else {
            filterRes[1] = vals[1].floatValue();
            if (filterRes[1] < 0.0f) {
                throw new BridgeException(ctx, filterElement, "attribute.malformed", new Object[]{"filterRes", s2});
            }
        }
        return filterRes;
    }

    public static Float[] convertSVGNumberOptionalNumber(Element elem, String attrName, String attrValue, BridgeContext ctx) {
        Float[] ret = new Float[2];
        if (attrValue.length() == 0) {
            return ret;
        }
        try {
            StringTokenizer tokens = new StringTokenizer(attrValue, " ");
            ret[0] = Float.valueOf(Float.parseFloat(tokens.nextToken()));
            if (tokens.hasMoreTokens()) {
                ret[1] = Float.valueOf(Float.parseFloat(tokens.nextToken()));
            }
            if (tokens.hasMoreTokens()) {
                throw new BridgeException(ctx, elem, "attribute.malformed", new Object[]{attrName, attrValue});
            }
        }
        catch (NumberFormatException nfEx) {
            throw new BridgeException(ctx, elem, nfEx, "attribute.malformed", new Object[]{attrName, attrValue, nfEx});
        }
        return ret;
    }

    public static Rectangle2D convertFilterChainRegion(Element filterElement, Element filteredElement, GraphicsNode filteredNode, BridgeContext ctx) {
        String dhStr;
        String dwStr;
        String dyStr;
        String units;
        String hStr;
        String wStr;
        String yStr;
        String xStr = SVGUtilities.getChainableAttributeNS(filterElement, null, "x", ctx);
        if (xStr.length() == 0) {
            xStr = "-10%";
        }
        if ((yStr = SVGUtilities.getChainableAttributeNS(filterElement, null, "y", ctx)).length() == 0) {
            yStr = "-10%";
        }
        if ((wStr = SVGUtilities.getChainableAttributeNS(filterElement, null, "width", ctx)).length() == 0) {
            wStr = "120%";
        }
        if ((hStr = SVGUtilities.getChainableAttributeNS(filterElement, null, "height", ctx)).length() == 0) {
            hStr = "120%";
        }
        short unitsType = (units = SVGUtilities.getChainableAttributeNS(filterElement, null, "filterUnits", ctx)).length() == 0 ? (short)2 : (short)SVGUtilities.parseCoordinateSystem(filterElement, "filterUnits", units, ctx);
        UnitProcessor.Context uctx = UnitProcessor.createContext(ctx, filteredElement);
        Rectangle2D region = SVGUtilities.convertRegion(xStr, yStr, wStr, hStr, unitsType, filteredNode, uctx);
        units = SVGUtilities.getChainableAttributeNS(filterElement, null, "filterMarginsUnits", ctx);
        unitsType = units.length() == 0 ? (short)1 : SVGUtilities.parseCoordinateSystem(filterElement, "filterMarginsUnits", units, ctx);
        String dxStr = filterElement.getAttributeNS(null, "mx");
        if (dxStr.length() == 0) {
            dxStr = "0";
        }
        if ((dyStr = filterElement.getAttributeNS(null, "my")).length() == 0) {
            dyStr = "0";
        }
        if ((dwStr = filterElement.getAttributeNS(null, "mw")).length() == 0) {
            dwStr = "0";
        }
        if ((dhStr = filterElement.getAttributeNS(null, "mh")).length() == 0) {
            dhStr = "0";
        }
        return SVGUtilities.extendRegion(dxStr, dyStr, dwStr, dhStr, unitsType, filteredNode, region, uctx);
    }

    protected static Rectangle2D extendRegion(String dxStr, String dyStr, String dwStr, String dhStr, short unitsType, GraphicsNode filteredNode, Rectangle2D region, UnitProcessor.Context uctx) {
        float dh;
        float dw;
        float dy;
        float dx;
        switch (unitsType) {
            case 1: {
                dx = UnitProcessor.svgHorizontalCoordinateToUserSpace(dxStr, "mx", uctx);
                dy = UnitProcessor.svgVerticalCoordinateToUserSpace(dyStr, "my", uctx);
                dw = UnitProcessor.svgHorizontalCoordinateToUserSpace(dwStr, "mw", uctx);
                dh = UnitProcessor.svgVerticalCoordinateToUserSpace(dhStr, "mh", uctx);
                break;
            }
            case 2: {
                Rectangle2D bounds = filteredNode.getGeometryBounds();
                if (bounds == null) {
                    dh = 0.0f;
                    dw = 0.0f;
                    dy = 0.0f;
                    dx = 0.0f;
                    break;
                }
                dx = UnitProcessor.svgHorizontalCoordinateToObjectBoundingBox(dxStr, "mx", uctx);
                dx = (float)((double)dx * bounds.getWidth());
                dy = UnitProcessor.svgVerticalCoordinateToObjectBoundingBox(dyStr, "my", uctx);
                dy = (float)((double)dy * bounds.getHeight());
                dw = UnitProcessor.svgHorizontalCoordinateToObjectBoundingBox(dwStr, "mw", uctx);
                dw = (float)((double)dw * bounds.getWidth());
                dh = UnitProcessor.svgVerticalCoordinateToObjectBoundingBox(dhStr, "mh", uctx);
                dh = (float)((double)dh * bounds.getHeight());
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid unit type");
            }
        }
        region.setRect(region.getX() + (double)dx, region.getY() + (double)dy, region.getWidth() + (double)dw, region.getHeight() + (double)dh);
        return region;
    }

    public static Rectangle2D getBaseFilterPrimitiveRegion(Element filterPrimitiveElement, Element filteredElement, GraphicsNode filteredNode, Rectangle2D defaultRegion, BridgeContext ctx) {
        UnitProcessor.Context uctx = UnitProcessor.createContext(ctx, filteredElement);
        double x2 = defaultRegion.getX();
        String s2 = filterPrimitiveElement.getAttributeNS(null, "x");
        if (s2.length() != 0) {
            x2 = UnitProcessor.svgHorizontalCoordinateToUserSpace(s2, "x", uctx);
        }
        double y2 = defaultRegion.getY();
        s2 = filterPrimitiveElement.getAttributeNS(null, "y");
        if (s2.length() != 0) {
            y2 = UnitProcessor.svgVerticalCoordinateToUserSpace(s2, "y", uctx);
        }
        double w2 = defaultRegion.getWidth();
        s2 = filterPrimitiveElement.getAttributeNS(null, "width");
        if (s2.length() != 0) {
            w2 = UnitProcessor.svgHorizontalLengthToUserSpace(s2, "width", uctx);
        }
        double h2 = defaultRegion.getHeight();
        s2 = filterPrimitiveElement.getAttributeNS(null, "height");
        if (s2.length() != 0) {
            h2 = UnitProcessor.svgVerticalLengthToUserSpace(s2, "height", uctx);
        }
        return new Rectangle2D.Double(x2, y2, w2, h2);
    }

    public static Rectangle2D convertFilterPrimitiveRegion(Element filterPrimitiveElement, Element filterElement, Element filteredElement, GraphicsNode filteredNode, Rectangle2D defaultRegion, Rectangle2D filterRegion, BridgeContext ctx) {
        String units = "";
        if (filterElement != null) {
            units = SVGUtilities.getChainableAttributeNS(filterElement, null, "primitiveUnits", ctx);
        }
        short unitsType = units.length() == 0 ? (short)1 : SVGUtilities.parseCoordinateSystem(filterElement, "filterUnits", units, ctx);
        String xStr = "";
        String yStr = "";
        String wStr = "";
        String hStr = "";
        if (filterPrimitiveElement != null) {
            xStr = filterPrimitiveElement.getAttributeNS(null, "x");
            yStr = filterPrimitiveElement.getAttributeNS(null, "y");
            wStr = filterPrimitiveElement.getAttributeNS(null, "width");
            hStr = filterPrimitiveElement.getAttributeNS(null, "height");
        }
        double x2 = defaultRegion.getX();
        double y2 = defaultRegion.getY();
        double w2 = defaultRegion.getWidth();
        double h2 = defaultRegion.getHeight();
        UnitProcessor.Context uctx = UnitProcessor.createContext(ctx, filteredElement);
        switch (unitsType) {
            case 2: {
                Rectangle2D bounds = filteredNode.getGeometryBounds();
                if (bounds == null) break;
                if (xStr.length() != 0) {
                    x2 = UnitProcessor.svgHorizontalCoordinateToObjectBoundingBox(xStr, "x", uctx);
                    x2 = bounds.getX() + x2 * bounds.getWidth();
                }
                if (yStr.length() != 0) {
                    y2 = UnitProcessor.svgVerticalCoordinateToObjectBoundingBox(yStr, "y", uctx);
                    y2 = bounds.getY() + y2 * bounds.getHeight();
                }
                if (wStr.length() != 0) {
                    w2 = UnitProcessor.svgHorizontalLengthToObjectBoundingBox(wStr, "width", uctx);
                    w2 *= bounds.getWidth();
                }
                if (hStr.length() == 0) break;
                h2 = UnitProcessor.svgVerticalLengthToObjectBoundingBox(hStr, "height", uctx);
                h2 *= bounds.getHeight();
                break;
            }
            case 1: {
                if (xStr.length() != 0) {
                    x2 = UnitProcessor.svgHorizontalCoordinateToUserSpace(xStr, "x", uctx);
                }
                if (yStr.length() != 0) {
                    y2 = UnitProcessor.svgVerticalCoordinateToUserSpace(yStr, "y", uctx);
                }
                if (wStr.length() != 0) {
                    w2 = UnitProcessor.svgHorizontalLengthToUserSpace(wStr, "width", uctx);
                }
                if (hStr.length() == 0) break;
                h2 = UnitProcessor.svgVerticalLengthToUserSpace(hStr, "height", uctx);
                break;
            }
            default: {
                throw new RuntimeException("invalid unitsType:" + unitsType);
            }
        }
        Rectangle2D region = new Rectangle2D.Double(x2, y2, w2, h2);
        units = "";
        if (filterElement != null) {
            units = SVGUtilities.getChainableAttributeNS(filterElement, null, "filterPrimitiveMarginsUnits", ctx);
        }
        unitsType = units.length() == 0 ? (short)1 : SVGUtilities.parseCoordinateSystem(filterElement, "filterPrimitiveMarginsUnits", units, ctx);
        String dxStr = "";
        String dyStr = "";
        String dwStr = "";
        String dhStr = "";
        if (filterPrimitiveElement != null) {
            dxStr = filterPrimitiveElement.getAttributeNS(null, "mx");
            dyStr = filterPrimitiveElement.getAttributeNS(null, "my");
            dwStr = filterPrimitiveElement.getAttributeNS(null, "mw");
            dhStr = filterPrimitiveElement.getAttributeNS(null, "mh");
        }
        if (dxStr.length() == 0) {
            dxStr = "0";
        }
        if (dyStr.length() == 0) {
            dyStr = "0";
        }
        if (dwStr.length() == 0) {
            dwStr = "0";
        }
        if (dhStr.length() == 0) {
            dhStr = "0";
        }
        region = SVGUtilities.extendRegion(dxStr, dyStr, dwStr, dhStr, unitsType, filteredNode, region, uctx);
        Rectangle2D.intersect(region, filterRegion, region);
        return region;
    }

    public static Rectangle2D convertFilterPrimitiveRegion(Element filterPrimitiveElement, Element filteredElement, GraphicsNode filteredNode, Rectangle2D defaultRegion, Rectangle2D filterRegion, BridgeContext ctx) {
        Node parentNode = filterPrimitiveElement.getParentNode();
        Element filterElement = null;
        if (parentNode != null && parentNode.getNodeType() == 1) {
            filterElement = (Element)parentNode;
        }
        return SVGUtilities.convertFilterPrimitiveRegion(filterPrimitiveElement, filterElement, filteredElement, filteredNode, defaultRegion, filterRegion, ctx);
    }

    public static short parseCoordinateSystem(Element e2, String attr, String coordinateSystem, BridgeContext ctx) {
        if ("userSpaceOnUse".equals(coordinateSystem)) {
            return 1;
        }
        if ("objectBoundingBox".equals(coordinateSystem)) {
            return 2;
        }
        throw new BridgeException(ctx, e2, "attribute.malformed", new Object[]{attr, coordinateSystem});
    }

    public static short parseMarkerCoordinateSystem(Element e2, String attr, String coordinateSystem, BridgeContext ctx) {
        if ("userSpaceOnUse".equals(coordinateSystem)) {
            return 1;
        }
        if ("strokeWidth".equals(coordinateSystem)) {
            return 3;
        }
        throw new BridgeException(ctx, e2, "attribute.malformed", new Object[]{attr, coordinateSystem});
    }

    protected static Rectangle2D convertRegion(String xStr, String yStr, String wStr, String hStr, short unitsType, GraphicsNode targetNode, UnitProcessor.Context uctx) {
        double h2;
        double w2;
        double y2;
        double x2;
        switch (unitsType) {
            case 2: {
                x2 = UnitProcessor.svgHorizontalCoordinateToObjectBoundingBox(xStr, "x", uctx);
                y2 = UnitProcessor.svgVerticalCoordinateToObjectBoundingBox(yStr, "y", uctx);
                w2 = UnitProcessor.svgHorizontalLengthToObjectBoundingBox(wStr, "width", uctx);
                h2 = UnitProcessor.svgVerticalLengthToObjectBoundingBox(hStr, "height", uctx);
                Rectangle2D bounds = targetNode.getGeometryBounds();
                if (bounds != null) {
                    x2 = bounds.getX() + x2 * bounds.getWidth();
                    y2 = bounds.getY() + y2 * bounds.getHeight();
                    w2 *= bounds.getWidth();
                    h2 *= bounds.getHeight();
                    break;
                }
                h2 = 0.0;
                w2 = 0.0;
                y2 = 0.0;
                x2 = 0.0;
                break;
            }
            case 1: {
                x2 = UnitProcessor.svgHorizontalCoordinateToUserSpace(xStr, "x", uctx);
                y2 = UnitProcessor.svgVerticalCoordinateToUserSpace(yStr, "y", uctx);
                w2 = UnitProcessor.svgHorizontalLengthToUserSpace(wStr, "width", uctx);
                h2 = UnitProcessor.svgVerticalLengthToUserSpace(hStr, "height", uctx);
                break;
            }
            default: {
                throw new RuntimeException("invalid unitsType:" + unitsType);
            }
        }
        return new Rectangle2D.Double(x2, y2, w2, h2);
    }

    public static AffineTransform convertTransform(Element e2, String attr, String transform, BridgeContext ctx) {
        try {
            return AWTTransformProducer.createAffineTransform(transform);
        }
        catch (ParseException pEx) {
            throw new BridgeException(ctx, e2, pEx, "attribute.malformed", new Object[]{attr, transform, pEx});
        }
    }

    public static AffineTransform toObjectBBox(AffineTransform Tx, GraphicsNode node) {
        AffineTransform Mx = new AffineTransform();
        Rectangle2D bounds = node.getGeometryBounds();
        if (bounds != null) {
            Mx.translate(bounds.getX(), bounds.getY());
            Mx.scale(bounds.getWidth(), bounds.getHeight());
        }
        Mx.concatenate(Tx);
        return Mx;
    }

    public static Rectangle2D toObjectBBox(Rectangle2D r2, GraphicsNode node) {
        Rectangle2D bounds = node.getGeometryBounds();
        if (bounds != null) {
            return new Rectangle2D.Double(bounds.getX() + r2.getX() * bounds.getWidth(), bounds.getY() + r2.getY() * bounds.getHeight(), r2.getWidth() * bounds.getWidth(), r2.getHeight() * bounds.getHeight());
        }
        return new Rectangle2D.Double();
    }

    public static float convertSnapshotTime(Element e2, BridgeContext ctx) {
        if (!e2.hasAttributeNS(null, "snapshotTime")) {
            return 0.0f;
        }
        String t2 = e2.getAttributeNS(null, "snapshotTime");
        if (t2.equals("none")) {
            return 0.0f;
        }
        ClockParser p2 = new ClockParser(false);
        class Handler
        implements ClockHandler {
            float time;

            Handler() {
            }

            @Override
            public void clockValue(float t2) {
                this.time = t2;
            }
        }
        Handler h2 = new Handler();
        p2.setClockHandler(h2);
        try {
            p2.parse(t2);
        }
        catch (ParseException pEx) {
            throw new BridgeException(null, e2, pEx, "attribute.malformed", new Object[]{"snapshotTime", t2, pEx});
        }
        return h2.time;
    }
}

