/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.batik.anim.dom.AbstractSVGAnimatedLength;
import org.apache.batik.anim.dom.AnimatedLiveAttributeValue;
import org.apache.batik.anim.dom.SVGOMAnimatedRect;
import org.apache.batik.anim.dom.SVGOMElement;
import org.apache.batik.anim.dom.SVGOMSVGElement;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.SVGGElementBridge;
import org.apache.batik.bridge.SVGTextElementBridge;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.bridge.TextNode;
import org.apache.batik.bridge.UpdateManager;
import org.apache.batik.bridge.ViewBox;
import org.apache.batik.bridge.Viewport;
import org.apache.batik.dom.svg.LiveAttributeException;
import org.apache.batik.dom.svg.SVGContext;
import org.apache.batik.dom.svg.SVGSVGContext;
import org.apache.batik.ext.awt.image.renderable.ClipRable8Bit;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.gvt.CanvasGraphicsNode;
import org.apache.batik.gvt.CompositeGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.ShapeNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGAnimatedPreserveAspectRatio;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGRect;

public class SVGSVGElementBridge
extends SVGGElementBridge
implements SVGSVGContext {
    @Override
    public String getLocalName() {
        return "svg";
    }

    @Override
    public Bridge getInstance() {
        return new SVGSVGElementBridge();
    }

    @Override
    protected GraphicsNode instantiateGraphicsNode() {
        return new CanvasGraphicsNode();
    }

    @Override
    public GraphicsNode createGraphicsNode(BridgeContext ctx, Element e2) {
        if (!SVGUtilities.matchUserAgent(e2, ctx.getUserAgent())) {
            return null;
        }
        CanvasGraphicsNode cgn = (CanvasGraphicsNode)this.instantiateGraphicsNode();
        this.associateSVGContext(ctx, e2, cgn);
        try {
            Rectangle2D r2;
            SVGDocument doc = (SVGDocument)e2.getOwnerDocument();
            SVGOMSVGElement se = (SVGOMSVGElement)e2;
            boolean isOutermost = doc.getRootElement() == e2;
            float x2 = 0.0f;
            float y2 = 0.0f;
            if (!isOutermost) {
                AbstractSVGAnimatedLength _x = (AbstractSVGAnimatedLength)se.getX();
                x2 = _x.getCheckedValue();
                AbstractSVGAnimatedLength _y = (AbstractSVGAnimatedLength)se.getY();
                y2 = _y.getCheckedValue();
            }
            AbstractSVGAnimatedLength _width = (AbstractSVGAnimatedLength)se.getWidth();
            float w2 = _width.getCheckedValue();
            AbstractSVGAnimatedLength _height = (AbstractSVGAnimatedLength)se.getHeight();
            float h2 = _height.getCheckedValue();
            cgn.setVisible(CSSUtilities.convertVisibility(e2));
            SVGOMAnimatedRect vb = (SVGOMAnimatedRect)se.getViewBox();
            SVGAnimatedPreserveAspectRatio par = se.getPreserveAspectRatio();
            AffineTransform viewingTransform = ViewBox.getPreserveAspectRatioTransform(e2, vb, par, w2, h2, ctx);
            float actualWidth = w2;
            float actualHeight = h2;
            try {
                AffineTransform vtInv = viewingTransform.createInverse();
                actualWidth = (float)((double)w2 * vtInv.getScaleX());
                actualHeight = (float)((double)h2 * vtInv.getScaleY());
            }
            catch (NoninvertibleTransformException vtInv) {
                // empty catch block
            }
            AffineTransform positionTransform = AffineTransform.getTranslateInstance(x2, y2);
            if (!isOutermost) {
                cgn.setPositionTransform(positionTransform);
            } else if (doc == ctx.getDocument()) {
                final double dw = w2;
                final double dh = h2;
                ctx.setDocumentSize(new Dimension2D(){
                    double w;
                    double h;
                    {
                        this.w = dw;
                        this.h = dh;
                    }

                    @Override
                    public double getWidth() {
                        return this.w;
                    }

                    @Override
                    public double getHeight() {
                        return this.h;
                    }

                    @Override
                    public void setSize(double w2, double h2) {
                        this.w = w2;
                        this.h = h2;
                    }
                });
            }
            cgn.setViewingTransform(viewingTransform);
            Shape clip = null;
            if (CSSUtilities.convertOverflow(e2)) {
                float[] offsets = CSSUtilities.convertClip(e2);
                clip = offsets == null ? new Rectangle2D.Float(x2, y2, w2, h2) : new Rectangle2D.Float(x2 + offsets[3], y2 + offsets[0], w2 - offsets[1] - offsets[3], h2 - offsets[2] - offsets[0]);
            }
            if (clip != null) {
                try {
                    AffineTransform at = new AffineTransform(positionTransform);
                    at.concatenate(viewingTransform);
                    at = at.createInverse();
                    clip = at.createTransformedShape(clip);
                    Filter filter = cgn.getGraphicsNodeRable(true);
                    cgn.setClip(new ClipRable8Bit(filter, clip));
                }
                catch (NoninvertibleTransformException at) {
                    // empty catch block
                }
            }
            RenderingHints hints = null;
            if ((hints = CSSUtilities.convertColorRendering(e2, hints)) != null) {
                cgn.setRenderingHints(hints);
            }
            if ((r2 = CSSUtilities.convertEnableBackground(e2)) != null) {
                cgn.setBackgroundEnable(r2);
            }
            if (vb.isSpecified()) {
                SVGRect vbr = vb.getAnimVal();
                actualWidth = vbr.getWidth();
                actualHeight = vbr.getHeight();
            }
            ctx.openViewport(e2, new SVGSVGElementViewport(actualWidth, actualHeight));
            return cgn;
        }
        catch (LiveAttributeException ex) {
            throw new BridgeException(ctx, ex);
        }
    }

    @Override
    public void buildGraphicsNode(BridgeContext ctx, Element e2, GraphicsNode node) {
        node.setComposite(CSSUtilities.convertOpacity(e2));
        node.setFilter(CSSUtilities.convertFilter(e2, node, ctx));
        node.setMask(CSSUtilities.convertMask(e2, node, ctx));
        node.setPointerEventType(CSSUtilities.convertPointerEvents(e2));
        this.initializeDynamicSupport(ctx, e2, node);
        ctx.closeViewport(e2);
    }

    @Override
    public void dispose() {
        this.ctx.removeViewport(this.e);
        super.dispose();
    }

    @Override
    public void handleAnimatedAttributeChanged(AnimatedLiveAttributeValue alav) {
        block16: {
            try {
                SVGDocument doc;
                boolean rebuild = false;
                if (alav.getNamespaceURI() != null) break block16;
                String ln = alav.getLocalName();
                if (ln.equals("width") || ln.equals("height")) {
                    rebuild = true;
                } else if (ln.equals("x") || ln.equals("y")) {
                    boolean isOutermost;
                    doc = (SVGDocument)this.e.getOwnerDocument();
                    SVGOMSVGElement se = (SVGOMSVGElement)this.e;
                    boolean bl = isOutermost = doc.getRootElement() == this.e;
                    if (!isOutermost) {
                        AbstractSVGAnimatedLength _x = (AbstractSVGAnimatedLength)se.getX();
                        float x2 = _x.getCheckedValue();
                        AbstractSVGAnimatedLength _y = (AbstractSVGAnimatedLength)se.getY();
                        float y2 = _y.getCheckedValue();
                        AffineTransform positionTransform = AffineTransform.getTranslateInstance(x2, y2);
                        CanvasGraphicsNode cgn = (CanvasGraphicsNode)this.node;
                        cgn.setPositionTransform(positionTransform);
                        return;
                    }
                } else if (ln.equals("viewBox") || ln.equals("preserveAspectRatio")) {
                    doc = (SVGDocument)this.e.getOwnerDocument();
                    SVGOMSVGElement se = (SVGOMSVGElement)this.e;
                    boolean isOutermost = doc.getRootElement() == this.e;
                    float x3 = 0.0f;
                    float y3 = 0.0f;
                    if (!isOutermost) {
                        AbstractSVGAnimatedLength _x = (AbstractSVGAnimatedLength)se.getX();
                        x3 = _x.getCheckedValue();
                        AbstractSVGAnimatedLength _y = (AbstractSVGAnimatedLength)se.getY();
                        y3 = _y.getCheckedValue();
                    }
                    AbstractSVGAnimatedLength _width = (AbstractSVGAnimatedLength)se.getWidth();
                    float w2 = _width.getCheckedValue();
                    AbstractSVGAnimatedLength _height = (AbstractSVGAnimatedLength)se.getHeight();
                    float h2 = _height.getCheckedValue();
                    CanvasGraphicsNode cgn = (CanvasGraphicsNode)this.node;
                    SVGOMAnimatedRect vb = (SVGOMAnimatedRect)se.getViewBox();
                    SVGAnimatedPreserveAspectRatio par = se.getPreserveAspectRatio();
                    AffineTransform newVT = ViewBox.getPreserveAspectRatioTransform(this.e, vb, par, w2, h2, this.ctx);
                    AffineTransform oldVT = cgn.getViewingTransform();
                    if (newVT.getScaleX() != oldVT.getScaleX() || newVT.getScaleY() != oldVT.getScaleY() || newVT.getShearX() != oldVT.getShearX() || newVT.getShearY() != oldVT.getShearY()) {
                        rebuild = true;
                    } else {
                        cgn.setViewingTransform(newVT);
                        Shape clip = null;
                        if (CSSUtilities.convertOverflow(this.e)) {
                            float[] offsets = CSSUtilities.convertClip(this.e);
                            clip = offsets == null ? new Rectangle2D.Float(x3, y3, w2, h2) : new Rectangle2D.Float(x3 + offsets[3], y3 + offsets[0], w2 - offsets[1] - offsets[3], h2 - offsets[2] - offsets[0]);
                        }
                        if (clip != null) {
                            try {
                                AffineTransform at = cgn.getPositionTransform();
                                at = at == null ? new AffineTransform() : new AffineTransform(at);
                                at.concatenate(newVT);
                                at = at.createInverse();
                                clip = at.createTransformedShape(clip);
                                Filter filter = cgn.getGraphicsNodeRable(true);
                                cgn.setClip(new ClipRable8Bit(filter, clip));
                            }
                            catch (NoninvertibleTransformException noninvertibleTransformException) {
                                // empty catch block
                            }
                        }
                    }
                }
                if (rebuild) {
                    CompositeGraphicsNode gn = this.node.getParent();
                    gn.remove(this.node);
                    SVGSVGElementBridge.disposeTree(this.e, false);
                    this.handleElementAdded(gn, this.e.getParentNode(), this.e);
                    return;
                }
            }
            catch (LiveAttributeException ex) {
                throw new BridgeException(this.ctx, ex);
            }
        }
        super.handleAnimatedAttributeChanged(alav);
    }

    @Override
    public List getIntersectionList(SVGRect svgRect, Element end) {
        Node next;
        ArrayList<Element> ret = new ArrayList<Element>();
        Rectangle2D.Float rect = new Rectangle2D.Float(svgRect.getX(), svgRect.getY(), svgRect.getWidth(), svgRect.getHeight());
        GraphicsNode svgGN = this.ctx.getGraphicsNode(this.e);
        if (svgGN == null) {
            return ret;
        }
        Rectangle2D svgBounds = svgGN.getSensitiveBounds();
        if (svgBounds == null) {
            return ret;
        }
        if (!rect.intersects(svgBounds)) {
            return ret;
        }
        Element base = this.e;
        AffineTransform ati = svgGN.getGlobalTransform();
        try {
            ati = ati.createInverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
        for (next = base.getFirstChild(); next != null && !(next instanceof Element); next = next.getNextSibling()) {
        }
        if (next == null) {
            return ret;
        }
        Element curr = (Element)next;
        Set ancestors = null;
        if (end != null && (ancestors = this.getAncestors(end, base)) == null) {
            end = null;
        }
        while (curr != null) {
            String nsURI = curr.getNamespaceURI();
            String tag = curr.getLocalName();
            boolean isGroup = "http://www.w3.org/2000/svg".equals(nsURI) && ("g".equals(tag) || "svg".equals(tag) || "a".equals(tag));
            GraphicsNode gn = this.ctx.getGraphicsNode(curr);
            if (gn == null) {
                if (ancestors != null && ancestors.contains(curr)) break;
                curr = this.getNext(curr, base, end);
                continue;
            }
            AffineTransform at = gn.getGlobalTransform();
            Rectangle2D gnBounds = gn.getSensitiveBounds();
            at.preConcatenate(ati);
            if (gnBounds != null) {
                gnBounds = at.createTransformedShape(gnBounds).getBounds2D();
            }
            if (gnBounds == null || !rect.intersects(gnBounds)) {
                if (ancestors != null && ancestors.contains(curr)) break;
                curr = this.getNext(curr, base, end);
                continue;
            }
            if (isGroup) {
                for (next = curr.getFirstChild(); next != null && !(next instanceof Element); next = next.getNextSibling()) {
                }
                if (next != null) {
                    curr = (Element)next;
                    continue;
                }
            } else {
                if (curr == end) break;
                if ("http://www.w3.org/2000/svg".equals(nsURI) && "use".equals(tag) && rect.contains(gnBounds)) {
                    ret.add(curr);
                }
                if (gn instanceof ShapeNode) {
                    ShapeNode sn = (ShapeNode)gn;
                    Shape sensitive = sn.getSensitiveArea();
                    if (sensitive != null && (sensitive = at.createTransformedShape(sensitive)).intersects(rect)) {
                        ret.add(curr);
                    }
                } else if (gn instanceof TextNode) {
                    SVGOMElement svgElem = (SVGOMElement)curr;
                    SVGTextElementBridge txtBridge = (SVGTextElementBridge)svgElem.getSVGContext();
                    Set elems = txtBridge.getTextIntersectionSet(at, rect);
                    if (ancestors != null && ancestors.contains(curr)) {
                        this.filterChildren(curr, end, elems, ret);
                    } else {
                        ret.addAll(elems);
                    }
                } else {
                    ret.add(curr);
                }
            }
            curr = this.getNext(curr, base, end);
        }
        return ret;
    }

    @Override
    public List getEnclosureList(SVGRect svgRect, Element end) {
        Node next;
        ArrayList<Element> ret = new ArrayList<Element>();
        Rectangle2D.Float rect = new Rectangle2D.Float(svgRect.getX(), svgRect.getY(), svgRect.getWidth(), svgRect.getHeight());
        GraphicsNode svgGN = this.ctx.getGraphicsNode(this.e);
        if (svgGN == null) {
            return ret;
        }
        Rectangle2D svgBounds = svgGN.getSensitiveBounds();
        if (svgBounds == null) {
            return ret;
        }
        if (!rect.intersects(svgBounds)) {
            return ret;
        }
        Element base = this.e;
        AffineTransform ati = svgGN.getGlobalTransform();
        try {
            ati = ati.createInverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
        for (next = base.getFirstChild(); next != null && !(next instanceof Element); next = next.getNextSibling()) {
        }
        if (next == null) {
            return ret;
        }
        Element curr = (Element)next;
        Set ancestors = null;
        if (end != null && (ancestors = this.getAncestors(end, base)) == null) {
            end = null;
        }
        while (curr != null) {
            String nsURI = curr.getNamespaceURI();
            String tag = curr.getLocalName();
            boolean isGroup = "http://www.w3.org/2000/svg".equals(nsURI) && ("g".equals(tag) || "svg".equals(tag) || "a".equals(tag));
            GraphicsNode gn = this.ctx.getGraphicsNode(curr);
            if (gn == null) {
                if (ancestors != null && ancestors.contains(curr)) break;
                curr = this.getNext(curr, base, end);
                continue;
            }
            AffineTransform at = gn.getGlobalTransform();
            Rectangle2D gnBounds = gn.getSensitiveBounds();
            at.preConcatenate(ati);
            if (gnBounds != null) {
                gnBounds = at.createTransformedShape(gnBounds).getBounds2D();
            }
            if (gnBounds == null || !rect.intersects(gnBounds)) {
                if (ancestors != null && ancestors.contains(curr)) break;
                curr = this.getNext(curr, base, end);
                continue;
            }
            if (isGroup) {
                for (next = curr.getFirstChild(); next != null && !(next instanceof Element); next = next.getNextSibling()) {
                }
                if (next != null) {
                    curr = (Element)next;
                    continue;
                }
            } else {
                if (curr == end) break;
                if ("http://www.w3.org/2000/svg".equals(nsURI) && "use".equals(tag)) {
                    if (rect.contains(gnBounds)) {
                        ret.add(curr);
                    }
                } else if (gn instanceof TextNode) {
                    SVGOMElement svgElem = (SVGOMElement)curr;
                    SVGTextElementBridge txtBridge = (SVGTextElementBridge)svgElem.getSVGContext();
                    Set elems = txtBridge.getTextEnclosureSet(at, rect);
                    if (ancestors != null && ancestors.contains(curr)) {
                        this.filterChildren(curr, end, elems, ret);
                    } else {
                        ret.addAll(elems);
                    }
                } else if (rect.contains(gnBounds)) {
                    ret.add(curr);
                }
            }
            curr = this.getNext(curr, base, end);
        }
        return ret;
    }

    @Override
    public boolean checkIntersection(Element element, SVGRect svgRect) {
        GraphicsNode svgGN = this.ctx.getGraphicsNode(this.e);
        if (svgGN == null) {
            return false;
        }
        Rectangle2D.Float rect = new Rectangle2D.Float(svgRect.getX(), svgRect.getY(), svgRect.getWidth(), svgRect.getHeight());
        AffineTransform ati = svgGN.getGlobalTransform();
        try {
            ati = ati.createInverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
        SVGContext svgctx = null;
        if (element instanceof SVGOMElement && ((svgctx = ((SVGOMElement)element).getSVGContext()) instanceof SVGTextElementBridge || svgctx instanceof SVGTextElementBridge.AbstractTextChildSVGContext)) {
            return SVGTextElementBridge.getTextIntersection(this.ctx, element, ati, rect, true);
        }
        Rectangle2D gnBounds = null;
        GraphicsNode gn = this.ctx.getGraphicsNode(element);
        if (gn != null) {
            gnBounds = gn.getSensitiveBounds();
        }
        if (gnBounds == null) {
            return false;
        }
        AffineTransform at = gn.getGlobalTransform();
        at.preConcatenate(ati);
        gnBounds = at.createTransformedShape(gnBounds).getBounds2D();
        if (!rect.intersects(gnBounds)) {
            return false;
        }
        if (!(gn instanceof ShapeNode)) {
            return true;
        }
        ShapeNode sn = (ShapeNode)gn;
        Shape sensitive = sn.getSensitiveArea();
        if (sensitive == null) {
            return false;
        }
        return (sensitive = at.createTransformedShape(sensitive)).intersects(rect);
    }

    @Override
    public boolean checkEnclosure(Element element, SVGRect svgRect) {
        GraphicsNode gn = this.ctx.getGraphicsNode(element);
        Rectangle2D gnBounds = null;
        SVGContext svgctx = null;
        if (element instanceof SVGOMElement) {
            svgctx = ((SVGOMElement)element).getSVGContext();
            if (svgctx instanceof SVGTextElementBridge || svgctx instanceof SVGTextElementBridge.AbstractTextChildSVGContext) {
                gnBounds = SVGTextElementBridge.getTextBounds(this.ctx, element, true);
                for (Element p2 = (Element)element.getParentNode(); p2 != null && gn == null; p2 = (Element)p2.getParentNode()) {
                    gn = this.ctx.getGraphicsNode(p2);
                }
            } else if (gn != null) {
                gnBounds = gn.getSensitiveBounds();
            }
        } else if (gn != null) {
            gnBounds = gn.getSensitiveBounds();
        }
        if (gnBounds == null) {
            return false;
        }
        GraphicsNode svgGN = this.ctx.getGraphicsNode(this.e);
        if (svgGN == null) {
            return false;
        }
        Rectangle2D.Float rect = new Rectangle2D.Float(svgRect.getX(), svgRect.getY(), svgRect.getWidth(), svgRect.getHeight());
        AffineTransform ati = svgGN.getGlobalTransform();
        try {
            ati = ati.createInverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
        AffineTransform at = gn.getGlobalTransform();
        at.preConcatenate(ati);
        gnBounds = at.createTransformedShape(gnBounds).getBounds2D();
        return rect.contains(gnBounds);
    }

    public boolean filterChildren(Element curr, Element end, Set elems, List ret) {
        for (Node child = curr.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof Element) || !this.filterChildren((Element)child, end, elems, ret)) continue;
            return true;
        }
        if (curr == end) {
            return true;
        }
        if (elems.contains(curr)) {
            ret.add(curr);
        }
        return false;
    }

    protected Set getAncestors(Element end, Element base) {
        HashSet<Element> ret = new HashSet<Element>();
        Element p2 = end;
        do {
            ret.add(p2);
        } while ((p2 = (Element)p2.getParentNode()) != null && p2 != base);
        if (p2 == null) {
            return null;
        }
        return ret;
    }

    protected Element getNext(Element curr, Element base, Element end) {
        Node next;
        for (next = curr.getNextSibling(); next != null && !(next instanceof Element); next = next.getNextSibling()) {
        }
        while (next == null) {
            if ((curr = (Element)curr.getParentNode()) == end || curr == base) {
                next = null;
                break;
            }
            for (next = curr.getNextSibling(); next != null && !(next instanceof Element); next = next.getNextSibling()) {
            }
        }
        return (Element)next;
    }

    @Override
    public void deselectAll() {
        this.ctx.getUserAgent().deselectAll();
    }

    @Override
    public int suspendRedraw(int max_wait_milliseconds) {
        UpdateManager um = this.ctx.getUpdateManager();
        if (um != null) {
            return um.addRedrawSuspension(max_wait_milliseconds);
        }
        return -1;
    }

    @Override
    public boolean unsuspendRedraw(int suspend_handle_id) {
        UpdateManager um = this.ctx.getUpdateManager();
        if (um != null) {
            return um.releaseRedrawSuspension(suspend_handle_id);
        }
        return false;
    }

    @Override
    public void unsuspendRedrawAll() {
        UpdateManager um = this.ctx.getUpdateManager();
        if (um != null) {
            um.releaseAllRedrawSuspension();
        }
    }

    @Override
    public void forceRedraw() {
        UpdateManager um = this.ctx.getUpdateManager();
        if (um != null) {
            um.forceRepaint();
        }
    }

    @Override
    public void pauseAnimations() {
        this.ctx.getAnimationEngine().pause();
    }

    @Override
    public void unpauseAnimations() {
        this.ctx.getAnimationEngine().unpause();
    }

    @Override
    public boolean animationsPaused() {
        return this.ctx.getAnimationEngine().isPaused();
    }

    @Override
    public float getCurrentTime() {
        return this.ctx.getAnimationEngine().getCurrentTime();
    }

    @Override
    public void setCurrentTime(float t2) {
        this.ctx.getAnimationEngine().setCurrentTime(t2);
    }

    public static class SVGSVGElementViewport
    implements Viewport {
        private float width;
        private float height;

        public SVGSVGElementViewport(float w2, float h2) {
            this.width = w2;
            this.height = h2;
        }

        @Override
        public float getWidth() {
            return this.width;
        }

        @Override
        public float getHeight() {
            return this.height;
        }
    }
}

