/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import org.apache.batik.bridge.AbstractSVGBridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.SVGGVTFont;
import org.apache.batik.gvt.font.GVTFontFace;
import org.apache.batik.gvt.text.ArabicTextHandler;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SVGFontElementBridge
extends AbstractSVGBridge {
    @Override
    public String getLocalName() {
        return "font";
    }

    public SVGGVTFont createFont(BridgeContext ctx, Element fontElement, Element textElement, float size, GVTFontFace fontFace) {
        NodeList glyphElements = fontElement.getElementsByTagNameNS("http://www.w3.org/2000/svg", "glyph");
        int numGlyphs = glyphElements.getLength();
        String[] glyphCodes = new String[numGlyphs];
        String[] glyphNames = new String[numGlyphs];
        String[] glyphLangs = new String[numGlyphs];
        String[] glyphOrientations = new String[numGlyphs];
        String[] glyphForms = new String[numGlyphs];
        Element[] glyphElementArray = new Element[numGlyphs];
        for (int i2 = 0; i2 < numGlyphs; ++i2) {
            Element glyphElement = (Element)glyphElements.item(i2);
            glyphCodes[i2] = glyphElement.getAttributeNS(null, "unicode");
            if (glyphCodes[i2].length() > 1 && ArabicTextHandler.arabicChar(glyphCodes[i2].charAt(0))) {
                glyphCodes[i2] = new StringBuffer(glyphCodes[i2]).reverse().toString();
            }
            glyphNames[i2] = glyphElement.getAttributeNS(null, "glyph-name");
            glyphLangs[i2] = glyphElement.getAttributeNS(null, "lang");
            glyphOrientations[i2] = glyphElement.getAttributeNS(null, "orientation");
            glyphForms[i2] = glyphElement.getAttributeNS(null, "arabic-form");
            glyphElementArray[i2] = glyphElement;
        }
        NodeList missingGlyphElements = fontElement.getElementsByTagNameNS("http://www.w3.org/2000/svg", "missing-glyph");
        Element missingGlyphElement = null;
        if (missingGlyphElements.getLength() > 0) {
            missingGlyphElement = (Element)missingGlyphElements.item(0);
        }
        NodeList hkernElements = fontElement.getElementsByTagNameNS("http://www.w3.org/2000/svg", "hkern");
        Element[] hkernElementArray = new Element[hkernElements.getLength()];
        for (int i3 = 0; i3 < hkernElementArray.length; ++i3) {
            Element hkernElement;
            hkernElementArray[i3] = hkernElement = (Element)hkernElements.item(i3);
        }
        NodeList vkernElements = fontElement.getElementsByTagNameNS("http://www.w3.org/2000/svg", "vkern");
        Element[] vkernElementArray = new Element[vkernElements.getLength()];
        for (int i4 = 0; i4 < vkernElementArray.length; ++i4) {
            Element vkernElement;
            vkernElementArray[i4] = vkernElement = (Element)vkernElements.item(i4);
        }
        return new SVGGVTFont(size, fontFace, glyphCodes, glyphNames, glyphLangs, glyphOrientations, glyphForms, ctx, glyphElementArray, missingGlyphElement, hkernElementArray, vkernElementArray, textElement);
    }
}

