/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.Point;
import java.awt.geom.Rectangle2D;
import java.awt.image.Kernel;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.batik.bridge.AbstractSVGFilterPrimitiveElementBridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.ext.awt.image.PadMode;
import org.apache.batik.ext.awt.image.renderable.ConvolveMatrixRable8Bit;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.renderable.PadRable8Bit;
import org.apache.batik.gvt.GraphicsNode;
import org.w3c.dom.Element;

public class SVGFeConvolveMatrixElementBridge
extends AbstractSVGFilterPrimitiveElementBridge {
    @Override
    public String getLocalName() {
        return "feConvolveMatrix";
    }

    @Override
    public Filter createFilter(BridgeContext ctx, Element filterElement, Element filteredElement, GraphicsNode filteredNode, Filter inputFilter, Rectangle2D filterRegion, Map filterMap) {
        int[] orderXY = SVGFeConvolveMatrixElementBridge.convertOrder(filterElement, ctx);
        float[] kernelMatrix = SVGFeConvolveMatrixElementBridge.convertKernelMatrix(filterElement, orderXY, ctx);
        float divisor = SVGFeConvolveMatrixElementBridge.convertDivisor(filterElement, kernelMatrix, ctx);
        float bias = SVGFeConvolveMatrixElementBridge.convertNumber(filterElement, "bias", 0.0f, ctx);
        int[] targetXY = SVGFeConvolveMatrixElementBridge.convertTarget(filterElement, orderXY, ctx);
        PadMode padMode = SVGFeConvolveMatrixElementBridge.convertEdgeMode(filterElement, ctx);
        double[] kernelUnitLength = SVGFeConvolveMatrixElementBridge.convertKernelUnitLength(filterElement, ctx);
        boolean preserveAlpha = SVGFeConvolveMatrixElementBridge.convertPreserveAlpha(filterElement, ctx);
        Filter in = SVGFeConvolveMatrixElementBridge.getIn(filterElement, filteredElement, filteredNode, inputFilter, filterMap, ctx);
        if (in == null) {
            return null;
        }
        Rectangle2D defaultRegion = in.getBounds2D();
        Rectangle2D primitiveRegion = SVGUtilities.convertFilterPrimitiveRegion(filterElement, filteredElement, filteredNode, defaultRegion, filterRegion, ctx);
        PadRable8Bit pad = new PadRable8Bit(in, primitiveRegion, PadMode.ZERO_PAD);
        ConvolveMatrixRable8Bit convolve = new ConvolveMatrixRable8Bit(pad);
        int i2 = 0;
        while (i2 < kernelMatrix.length) {
            int n2 = i2++;
            kernelMatrix[n2] = kernelMatrix[n2] / divisor;
        }
        convolve.setKernel(new Kernel(orderXY[0], orderXY[1], kernelMatrix));
        convolve.setTarget(new Point(targetXY[0], targetXY[1]));
        convolve.setBias(bias);
        convolve.setEdgeMode(padMode);
        convolve.setKernelUnitLength(kernelUnitLength);
        convolve.setPreserveAlpha(preserveAlpha);
        SVGFeConvolveMatrixElementBridge.handleColorInterpolationFilters(convolve, filterElement);
        PadRable8Bit filter = new PadRable8Bit(convolve, primitiveRegion, PadMode.ZERO_PAD);
        SVGFeConvolveMatrixElementBridge.updateFilterMap(filterElement, filter, filterMap);
        return filter;
    }

    protected static int[] convertOrder(Element filterElement, BridgeContext ctx) {
        String s2 = filterElement.getAttributeNS(null, "order");
        if (s2.length() == 0) {
            return new int[]{3, 3};
        }
        int[] orderXY = new int[2];
        StringTokenizer tokens = new StringTokenizer(s2, " ,");
        try {
            orderXY[0] = SVGUtilities.convertSVGInteger(tokens.nextToken());
            orderXY[1] = tokens.hasMoreTokens() ? SVGUtilities.convertSVGInteger(tokens.nextToken()) : orderXY[0];
        }
        catch (NumberFormatException nfEx) {
            throw new BridgeException(ctx, filterElement, nfEx, "attribute.malformed", new Object[]{"order", s2, nfEx});
        }
        if (tokens.hasMoreTokens() || orderXY[0] <= 0 || orderXY[1] <= 0) {
            throw new BridgeException(ctx, filterElement, "attribute.malformed", new Object[]{"order", s2});
        }
        return orderXY;
    }

    protected static float[] convertKernelMatrix(Element filterElement, int[] orderXY, BridgeContext ctx) {
        String s2 = filterElement.getAttributeNS(null, "kernelMatrix");
        if (s2.length() == 0) {
            throw new BridgeException(ctx, filterElement, "attribute.missing", new Object[]{"kernelMatrix"});
        }
        int size = orderXY[0] * orderXY[1];
        float[] kernelMatrix = new float[size];
        StringTokenizer tokens = new StringTokenizer(s2, " ,");
        int i2 = 0;
        try {
            while (tokens.hasMoreTokens() && i2 < size) {
                kernelMatrix[i2++] = SVGUtilities.convertSVGNumber(tokens.nextToken());
            }
        }
        catch (NumberFormatException nfEx) {
            throw new BridgeException(ctx, filterElement, nfEx, "attribute.malformed", new Object[]{"kernelMatrix", s2, nfEx});
        }
        if (i2 != size) {
            throw new BridgeException(ctx, filterElement, "attribute.malformed", new Object[]{"kernelMatrix", s2});
        }
        return kernelMatrix;
    }

    protected static float convertDivisor(Element filterElement, float[] kernelMatrix, BridgeContext ctx) {
        String s2 = filterElement.getAttributeNS(null, "divisor");
        if (s2.length() == 0) {
            float sum = 0.0f;
            for (float aKernelMatrix : kernelMatrix) {
                sum += aKernelMatrix;
            }
            return sum == 0.0f ? 1.0f : sum;
        }
        try {
            return SVGUtilities.convertSVGNumber(s2);
        }
        catch (NumberFormatException nfEx) {
            throw new BridgeException(ctx, filterElement, nfEx, "attribute.malformed", new Object[]{"divisor", s2, nfEx});
        }
    }

    protected static int[] convertTarget(Element filterElement, int[] orderXY, BridgeContext ctx) {
        int v2;
        int[] targetXY = new int[2];
        String s2 = filterElement.getAttributeNS(null, "targetX");
        if (s2.length() == 0) {
            targetXY[0] = orderXY[0] / 2;
        } else {
            try {
                v2 = SVGUtilities.convertSVGInteger(s2);
                if (v2 < 0 || v2 >= orderXY[0]) {
                    throw new BridgeException(ctx, filterElement, "attribute.malformed", new Object[]{"targetX", s2});
                }
                targetXY[0] = v2;
            }
            catch (NumberFormatException nfEx) {
                throw new BridgeException(ctx, filterElement, nfEx, "attribute.malformed", new Object[]{"targetX", s2, nfEx});
            }
        }
        s2 = filterElement.getAttributeNS(null, "targetY");
        if (s2.length() == 0) {
            targetXY[1] = orderXY[1] / 2;
        } else {
            try {
                v2 = SVGUtilities.convertSVGInteger(s2);
                if (v2 < 0 || v2 >= orderXY[1]) {
                    throw new BridgeException(ctx, filterElement, "attribute.malformed", new Object[]{"targetY", s2});
                }
                targetXY[1] = v2;
            }
            catch (NumberFormatException nfEx) {
                throw new BridgeException(ctx, filterElement, nfEx, "attribute.malformed", new Object[]{"targetY", s2, nfEx});
            }
        }
        return targetXY;
    }

    protected static double[] convertKernelUnitLength(Element filterElement, BridgeContext ctx) {
        String s2 = filterElement.getAttributeNS(null, "kernelUnitLength");
        if (s2.length() == 0) {
            return null;
        }
        double[] units = new double[2];
        StringTokenizer tokens = new StringTokenizer(s2, " ,");
        try {
            units[0] = SVGUtilities.convertSVGNumber(tokens.nextToken());
            units[1] = tokens.hasMoreTokens() ? (double)SVGUtilities.convertSVGNumber(tokens.nextToken()) : units[0];
        }
        catch (NumberFormatException nfEx) {
            throw new BridgeException(ctx, filterElement, nfEx, "attribute.malformed", new Object[]{"kernelUnitLength", s2});
        }
        if (tokens.hasMoreTokens() || units[0] <= 0.0 || units[1] <= 0.0) {
            throw new BridgeException(ctx, filterElement, "attribute.malformed", new Object[]{"kernelUnitLength", s2});
        }
        return units;
    }

    protected static PadMode convertEdgeMode(Element filterElement, BridgeContext ctx) {
        String s2 = filterElement.getAttributeNS(null, "edgeMode");
        if (s2.length() == 0) {
            return PadMode.REPLICATE;
        }
        if ("duplicate".equals(s2)) {
            return PadMode.REPLICATE;
        }
        if ("wrap".equals(s2)) {
            return PadMode.WRAP;
        }
        if ("none".equals(s2)) {
            return PadMode.ZERO_PAD;
        }
        throw new BridgeException(ctx, filterElement, "attribute.malformed", new Object[]{"edgeMode", s2});
    }

    protected static boolean convertPreserveAlpha(Element filterElement, BridgeContext ctx) {
        String s2 = filterElement.getAttributeNS(null, "preserveAlpha");
        if (s2.length() == 0) {
            return false;
        }
        if ("true".equals(s2)) {
            return true;
        }
        if ("false".equals(s2)) {
            return false;
        }
        throw new BridgeException(ctx, filterElement, "attribute.malformed", new Object[]{"preserveAlpha", s2});
    }
}

