/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.batik.bridge.GlyphLayout;
import org.apache.batik.bridge.StrokingTextPainter;
import org.apache.batik.bridge.TextNode;
import org.apache.batik.bridge.TextPainter;
import org.apache.batik.bridge.TextSpanLayout;
import org.apache.batik.gvt.flow.BlockInfo;
import org.apache.batik.gvt.flow.FlowRegions;
import org.apache.batik.gvt.flow.GlyphGroupInfo;
import org.apache.batik.gvt.flow.LineInfo;
import org.apache.batik.gvt.flow.RegionInfo;
import org.apache.batik.gvt.flow.TextLineBreaks;
import org.apache.batik.gvt.flow.WordInfo;
import org.apache.batik.gvt.font.GVTFont;
import org.apache.batik.gvt.font.GVTGlyphVector;
import org.apache.batik.gvt.font.GVTLineMetrics;
import org.apache.batik.gvt.font.MultiGlyphVector;
import org.apache.batik.gvt.text.GVTAttributedCharacterIterator;

public class FlowTextPainter
extends StrokingTextPainter {
    protected static TextPainter singleton = new FlowTextPainter();
    public static final char SOFT_HYPHEN = '\u00ad';
    public static final char ZERO_WIDTH_SPACE = '\u200b';
    public static final char ZERO_WIDTH_JOINER = '\u200d';
    public static final char SPACE = ' ';
    public static final AttributedCharacterIterator.Attribute WORD_LIMIT = TextLineBreaks.WORD_LIMIT;
    public static final AttributedCharacterIterator.Attribute FLOW_REGIONS = GVTAttributedCharacterIterator.TextAttribute.FLOW_REGIONS;
    public static final AttributedCharacterIterator.Attribute FLOW_LINE_BREAK = GVTAttributedCharacterIterator.TextAttribute.FLOW_LINE_BREAK;
    public static final AttributedCharacterIterator.Attribute LINE_HEIGHT = GVTAttributedCharacterIterator.TextAttribute.LINE_HEIGHT;
    public static final AttributedCharacterIterator.Attribute GVT_FONT = GVTAttributedCharacterIterator.TextAttribute.GVT_FONT;
    protected static Set szAtts = new HashSet();

    public static TextPainter getInstance() {
        return singleton;
    }

    @Override
    public List getTextRuns(TextNode node, AttributedCharacterIterator aci) {
        List textRuns = node.getTextRuns();
        if (textRuns != null) {
            return textRuns;
        }
        AttributedCharacterIterator[] chunkACIs = this.getTextChunkACIs(aci);
        textRuns = this.computeTextRuns(node, aci, chunkACIs);
        aci.first();
        List rgns = (List)aci.getAttribute(FLOW_REGIONS);
        if (rgns != null) {
            Iterator i2 = textRuns.iterator();
            ArrayList chunkLayouts = new ArrayList();
            StrokingTextPainter.TextRun tr = (StrokingTextPainter.TextRun)i2.next();
            ArrayList<TextSpanLayout> layouts = new ArrayList<TextSpanLayout>();
            chunkLayouts.add(layouts);
            layouts.add(tr.getLayout());
            while (i2.hasNext()) {
                tr = (StrokingTextPainter.TextRun)i2.next();
                if (tr.isFirstRunInChunk()) {
                    layouts = new ArrayList();
                    chunkLayouts.add(layouts);
                }
                layouts.add(tr.getLayout());
            }
            FlowTextPainter.textWrap(chunkACIs, chunkLayouts, rgns, this.fontRenderContext);
        }
        node.setTextRuns(textRuns);
        return node.getTextRuns();
    }

    public static boolean textWrap(AttributedCharacterIterator[] acis, List chunkLayouts, List flowRects, FontRenderContext frc) {
        boolean overflow;
        WordInfo[] chunkInfo;
        WordInfo[][] wordInfos = new WordInfo[acis.length][];
        Iterator clIter = chunkLayouts.iterator();
        float prevBotMargin = 0.0f;
        int numWords = 0;
        BlockInfo[] blockInfos = new BlockInfo[acis.length];
        float[] topSkip = new float[acis.length];
        int chunk = 0;
        while (clIter.hasNext()) {
            AttributedCharacterIterator aci = acis[chunk];
            LinkedList<GVTGlyphVector> gvl = new LinkedList<GVTGlyphVector>();
            List layouts = (List)clIter.next();
            for (Object layout : layouts) {
                GlyphLayout gl = (GlyphLayout)layout;
                gvl.add(gl.getGlyphVector());
            }
            MultiGlyphVector gv = new MultiGlyphVector(gvl);
            wordInfos[chunk] = FlowTextPainter.doWordAnalysis(gv, aci, numWords, frc);
            aci.first();
            BlockInfo bi = (BlockInfo)aci.getAttribute(FLOW_PARAGRAPH);
            bi.initLineInfo(frc);
            blockInfos[chunk] = bi;
            topSkip[chunk] = prevBotMargin > bi.getTopMargin() ? prevBotMargin : bi.getTopMargin();
            prevBotMargin = bi.getBottomMargin();
            numWords += wordInfos[chunk].length;
            ++chunk;
        }
        Iterator frIter = flowRects.iterator();
        RegionInfo currentRegion = null;
        int currWord = 0;
        int chunk2 = 0;
        LinkedList<LineInfo> lineInfos = new LinkedList<LineInfo>();
        while (frIter.hasNext()) {
            currentRegion = (RegionInfo)frIter.next();
            FlowRegions fr = new FlowRegions(currentRegion.getShape());
            while (chunk2 < wordInfos.length) {
                chunkInfo = wordInfos[chunk2];
                BlockInfo bi = blockInfos[chunk2];
                WordInfo wi = chunkInfo[currWord];
                Object flowLine = wi.getFlowLine();
                double lh = Math.max(wi.getLineHeight(), bi.getLineHeight());
                LineInfo li = new LineInfo(fr, bi, true);
                double newY = li.getCurrentY() + (double)topSkip[chunk2];
                topSkip[chunk2] = 0.0f;
                if (li.gotoY(newY)) break;
                while (!li.addWord(wi) && !li.gotoY(newY = li.getCurrentY() + lh * 0.1)) {
                }
                if (fr.done()) break;
                ++currWord;
                while (currWord < chunkInfo.length) {
                    wi = chunkInfo[currWord];
                    if (wi.getFlowLine() != flowLine || !li.addWord(wi)) {
                        li.layout();
                        lineInfos.add(li);
                        li = null;
                        flowLine = wi.getFlowLine();
                        lh = Math.max(wi.getLineHeight(), bi.getLineHeight());
                        if (!fr.newLine(lh)) break;
                        li = new LineInfo(fr, bi, false);
                        while (!li.addWord(wi) && !li.gotoY(newY = li.getCurrentY() + lh * 0.1)) {
                        }
                        if (fr.done()) break;
                    }
                    ++currWord;
                }
                if (li != null) {
                    li.setParaEnd(true);
                    li.layout();
                }
                if (fr.done()) break;
                ++chunk2;
                currWord = 0;
                if (!bi.isFlowRegionBreak() && fr.newLine(lh)) continue;
                break;
            }
            if (chunk2 != wordInfos.length) continue;
            break;
        }
        boolean bl = overflow = chunk2 < wordInfos.length;
        while (chunk2 < wordInfos.length) {
            chunkInfo = wordInfos[chunk2];
            while (currWord < chunkInfo.length) {
                WordInfo wi = chunkInfo[currWord];
                int numGG = wi.getNumGlyphGroups();
                for (int gg = 0; gg < numGG; ++gg) {
                    GlyphGroupInfo ggi = wi.getGlyphGroup(gg);
                    GVTGlyphVector gv = ggi.getGlyphVector();
                    int end = ggi.getEnd();
                    for (int g2 = ggi.getStart(); g2 <= end; ++g2) {
                        gv.setGlyphVisible(g2, false);
                    }
                }
                ++currWord;
            }
            ++chunk2;
            currWord = 0;
        }
        return overflow;
    }

    static int[] allocWordMap(int[] wordMap, int sz) {
        int ext;
        if (wordMap != null) {
            if (sz <= wordMap.length) {
                return wordMap;
            }
            if (sz < wordMap.length * 2) {
                sz = wordMap.length * 2;
            }
        }
        int[] ret = new int[sz];
        int n2 = ext = wordMap != null ? wordMap.length : 0;
        if (sz < ext) {
            ext = sz;
        }
        if (ext != 0) {
            System.arraycopy(wordMap, 0, ret, 0, ext);
        }
        Arrays.fill(ret, ext, sz, -1);
        return ret;
    }

    static WordInfo[] doWordAnalysis(GVTGlyphVector gv, AttributedCharacterIterator aci, int numWords, FontRenderContext frc) {
        int i2;
        int numGlyphs = gv.getNumGlyphs();
        int[] glyphWords = new int[numGlyphs];
        int[] wordMap = FlowTextPainter.allocWordMap(null, 10);
        int maxWord = 0;
        int aciIdx = aci.getBeginIndex();
        for (int i3 = 0; i3 < numGlyphs; ++i3) {
            int cnt = gv.getCharacterCount(i3, i3);
            aci.setIndex(aciIdx);
            Integer integer = (Integer)aci.getAttribute(WORD_LIMIT);
            int minWord = integer - numWords;
            if (minWord > maxWord) {
                maxWord = minWord;
                wordMap = FlowTextPainter.allocWordMap(wordMap, maxWord + 1);
            }
            ++aciIdx;
            for (int c2 = 1; c2 < cnt; ++c2) {
                aci.setIndex(aciIdx);
                integer = (Integer)aci.getAttribute(WORD_LIMIT);
                int cWord = integer - numWords;
                if (cWord > maxWord) {
                    maxWord = cWord;
                    wordMap = FlowTextPainter.allocWordMap(wordMap, maxWord + 1);
                }
                if (cWord < minWord) {
                    wordMap[minWord] = cWord;
                    minWord = cWord;
                } else if (cWord > minWord) {
                    wordMap[cWord] = minWord;
                }
                ++aciIdx;
            }
            glyphWords[i3] = minWord;
        }
        int words = 0;
        WordInfo[] cWordMap = new WordInfo[maxWord + 1];
        for (int i4 = 0; i4 <= maxWord; ++i4) {
            int nw = wordMap[i4];
            if (nw == -1) {
                cWordMap[i4] = new WordInfo(words++);
                continue;
            }
            int word = nw;
            nw = wordMap[i4];
            while (nw != -1) {
                word = nw;
                nw = wordMap[word];
            }
            wordMap[i4] = word;
            cWordMap[i4] = cWordMap[word];
        }
        wordMap = null;
        WordInfo[] wordInfos = new WordInfo[words];
        for (int i5 = 0; i5 <= maxWord; ++i5) {
            WordInfo wi = cWordMap[i5];
            wordInfos[wi.getIndex()] = cWordMap[i5];
        }
        aciIdx = aci.getBeginIndex();
        int aciEnd = aci.getEndIndex();
        char ch = aci.setIndex(aciIdx);
        int aciWordStart = aciIdx;
        GVTFont gvtFont = (GVTFont)aci.getAttribute(GVT_FONT);
        float lineHeight = 1.0f;
        Float lineHeightFloat = (Float)aci.getAttribute(LINE_HEIGHT);
        if (lineHeightFloat != null) {
            lineHeight = lineHeightFloat.floatValue();
        }
        int runLimit = aci.getRunLimit(szAtts);
        WordInfo prevWI = null;
        float[] lastAdvAdj = new float[numGlyphs];
        float[] advAdj = new float[numGlyphs];
        boolean[] hideLast = new boolean[numGlyphs];
        boolean[] hide = new boolean[numGlyphs];
        boolean[] space = new boolean[numGlyphs];
        float[] glyphPos = gv.getGlyphPositions(0, numGlyphs + 1, null);
        for (int i6 = 0; i6 < numGlyphs; ++i6) {
            char pch = ch;
            ch = aci.setIndex(aciIdx);
            Integer integer = (Integer)aci.getAttribute(WORD_LIMIT);
            WordInfo theWI = cWordMap[integer - numWords];
            if (theWI.getFlowLine() == null) {
                theWI.setFlowLine(aci.getAttribute(FLOW_LINE_BREAK));
            }
            if (prevWI == null) {
                prevWI = theWI;
            } else if (prevWI != theWI) {
                GVTLineMetrics lm = gvtFont.getLineMetrics(aci, aciWordStart, aciIdx, frc);
                prevWI.addLineMetrics(gvtFont, lm);
                prevWI.addLineHeight(lineHeight);
                aciWordStart = aciIdx;
                prevWI = theWI;
            }
            int chCnt = gv.getCharacterCount(i6, i6);
            if (chCnt == 1) {
                switch (ch) {
                    case '\u00ad': {
                        hideLast[i6] = true;
                        char nch = aci.next();
                        aci.previous();
                        float kern = gvtFont.getHKern(pch, nch);
                        advAdj[i6] = -(glyphPos[2 * i6 + 2] - glyphPos[2 * i6] + kern);
                        break;
                    }
                    case '\u200d': {
                        hide[i6] = true;
                        break;
                    }
                    case '\u200b': {
                        hide[i6] = true;
                        break;
                    }
                    case ' ': {
                        space[i6] = true;
                        char nch = aci.next();
                        aci.previous();
                        float kern = gvtFont.getHKern(pch, nch);
                        lastAdvAdj[i6] = -(glyphPos[2 * i6 + 2] - glyphPos[2 * i6] + kern);
                    }
                }
            }
            if ((aciIdx += chCnt) <= runLimit || aciIdx >= aciEnd) continue;
            GVTLineMetrics lm = gvtFont.getLineMetrics(aci, aciWordStart, runLimit, frc);
            prevWI.addLineMetrics(gvtFont, lm);
            prevWI.addLineHeight(lineHeight);
            prevWI = null;
            aciWordStart = aciIdx;
            aci.setIndex(aciIdx);
            gvtFont = (GVTFont)aci.getAttribute(GVT_FONT);
            Float f2 = (Float)aci.getAttribute(LINE_HEIGHT);
            lineHeight = f2.floatValue();
            runLimit = aci.getRunLimit(szAtts);
        }
        GVTLineMetrics lm = gvtFont.getLineMetrics(aci, aciWordStart, runLimit, frc);
        prevWI.addLineMetrics(gvtFont, lm);
        prevWI.addLineHeight(lineHeight);
        int[] wordGlyphCounts = new int[words];
        for (int i7 = 0; i7 < numGlyphs; ++i7) {
            int cWord;
            int word = glyphWords[i7];
            glyphWords[i7] = cWord = cWordMap[word].getIndex();
            int n2 = cWord;
            wordGlyphCounts[n2] = wordGlyphCounts[n2] + 1;
        }
        cWordMap = null;
        int[][] wordGlyphs = new int[words][];
        int[] wordGlyphGroupsCounts = new int[words];
        for (i2 = 0; i2 < numGlyphs; ++i2) {
            int cWord = glyphWords[i2];
            int[] wgs = wordGlyphs[cWord];
            if (wgs == null) {
                wgs = wordGlyphs[cWord] = new int[wordGlyphCounts[cWord]];
                wordGlyphCounts[cWord] = 0;
            }
            int cnt = wordGlyphCounts[cWord];
            wgs[cnt] = i2;
            if (cnt == 0) {
                int n3 = cWord;
                wordGlyphGroupsCounts[n3] = wordGlyphGroupsCounts[n3] + 1;
            } else if (wgs[cnt - 1] != i2 - 1) {
                int n4 = cWord;
                wordGlyphGroupsCounts[n4] = wordGlyphGroupsCounts[n4] + 1;
            }
            int n5 = cWord;
            wordGlyphCounts[n5] = wordGlyphCounts[n5] + 1;
        }
        for (i2 = 0; i2 < words; ++i2) {
            int cnt = wordGlyphGroupsCounts[i2];
            GlyphGroupInfo[] wordGlyphGroups = new GlyphGroupInfo[cnt];
            if (cnt == 1) {
                int[] glyphs = wordGlyphs[i2];
                int start = glyphs[0];
                int end = glyphs[glyphs.length - 1];
                wordGlyphGroups[0] = new GlyphGroupInfo(gv, start, end, hide, hideLast[end], glyphPos, advAdj, lastAdvAdj, space);
            } else {
                int prev;
                int glyphGroup = 0;
                int[] glyphs = wordGlyphs[i2];
                int start = prev = glyphs[0];
                for (int j2 = 1; j2 < glyphs.length; ++j2) {
                    if (prev + 1 != glyphs[j2]) {
                        int end = glyphs[j2 - 1];
                        wordGlyphGroups[glyphGroup] = new GlyphGroupInfo(gv, start, end, hide, hideLast[end], glyphPos, advAdj, lastAdvAdj, space);
                        start = glyphs[j2];
                        ++glyphGroup;
                    }
                    prev = glyphs[j2];
                }
                int end = glyphs[glyphs.length - 1];
                wordGlyphGroups[glyphGroup] = new GlyphGroupInfo(gv, start, end, hide, hideLast[end], glyphPos, advAdj, lastAdvAdj, space);
            }
            wordInfos[i2].setGlyphGroups(wordGlyphGroups);
        }
        return wordInfos;
    }

    static {
        szAtts.add(TextAttribute.SIZE);
        szAtts.add(GVT_FONT);
        szAtts.add(LINE_HEIGHT);
    }
}

