/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.apps.svgbrowser;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.dom.util.DOMUtilities;
import org.apache.batik.dom.util.SAXDocumentFactory;
import org.apache.batik.util.PreferenceManager;
import org.apache.batik.util.XMLResourceDescriptor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLPreferenceManager
extends PreferenceManager {
    protected String xmlParserClassName;
    public static final String PREFERENCE_ENCODING = "8859_1";

    public XMLPreferenceManager(String prefFileName) {
        this(prefFileName, null, XMLResourceDescriptor.getXMLParserClassName());
    }

    public XMLPreferenceManager(String prefFileName, Map defaults) {
        this(prefFileName, defaults, XMLResourceDescriptor.getXMLParserClassName());
    }

    public XMLPreferenceManager(String prefFileName, String parser) {
        this(prefFileName, null, parser);
    }

    public XMLPreferenceManager(String prefFileName, Map defaults, String parser) {
        super(prefFileName, defaults);
        this.internal = new XMLProperties();
        this.xmlParserClassName = parser;
    }

    protected class XMLProperties
    extends Properties {
        protected XMLProperties() {
        }

        @Override
        public synchronized void load(InputStream is) throws IOException {
            BufferedReader r2 = new BufferedReader(new InputStreamReader(is, XMLPreferenceManager.PREFERENCE_ENCODING));
            SAXDocumentFactory df = new SAXDocumentFactory(GenericDOMImplementation.getDOMImplementation(), XMLPreferenceManager.this.xmlParserClassName);
            Document doc = df.createDocument("http://xml.apache.org/batik/preferences", "preferences", null, r2);
            Element elt = doc.getDocumentElement();
            for (Node n2 = elt.getFirstChild(); n2 != null; n2 = n2.getNextSibling()) {
                if (n2.getNodeType() != 1 || !n2.getNodeName().equals("property")) continue;
                String name = ((Element)n2).getAttributeNS(null, "name");
                StringBuffer cont = new StringBuffer();
                for (Node c2 = n2.getFirstChild(); c2 != null && c2.getNodeType() == 3; c2 = c2.getNextSibling()) {
                    cont.append(c2.getNodeValue());
                }
                String val = cont.toString();
                this.put(name, val);
            }
        }

        @Override
        public synchronized void store(OutputStream os, String header) throws IOException {
            BufferedWriter w2 = new BufferedWriter(new OutputStreamWriter(os, XMLPreferenceManager.PREFERENCE_ENCODING));
            HashMap m2 = new HashMap();
            this.enumerate(m2);
            w2.write("<preferences xmlns=\"http://xml.apache.org/batik/preferences\">\n");
            for (Object o2 : m2.keySet()) {
                String n2 = (String)o2;
                String v2 = (String)m2.get(n2);
                w2.write("<property name=\"" + n2 + "\">");
                try {
                    w2.write(DOMUtilities.contentToString(v2, false));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                w2.write("</property>\n");
            }
            w2.write("</preferences>\n");
            w2.flush();
        }

        private synchronized void enumerate(Map m2) {
            if (this.defaults != null) {
                for (Object k2 : m2.keySet()) {
                    m2.put(k2, this.defaults.get(k2));
                }
            }
            for (Object k2 : this.keySet()) {
                m2.put(k2, this.get(k2));
            }
        }
    }
}

