/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.apps.svgbrowser;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.BevelBorder;
import org.apache.batik.util.resources.ResourceManager;

public class StatusBar
extends JPanel {
    protected static final String RESOURCES = "org.apache.batik.apps.svgbrowser.resources.StatusBarMessages";
    protected static ResourceBundle bundle = ResourceBundle.getBundle("org.apache.batik.apps.svgbrowser.resources.StatusBarMessages", Locale.getDefault());
    protected static ResourceManager rManager = new ResourceManager(bundle);
    protected JLabel xPosition;
    protected JLabel yPosition;
    protected JLabel zoom;
    protected JLabel message;
    protected String mainMessage;
    protected String temporaryMessage;
    protected DisplayThread displayThread;

    public StatusBar() {
        super(new BorderLayout(5, 5));
        JPanel p2 = new JPanel(new BorderLayout(0, 0));
        this.add("West", p2);
        this.xPosition = new JLabel();
        BevelBorder bb = new BevelBorder(1, this.getBackground().brighter().brighter(), this.getBackground(), this.getBackground().darker().darker(), this.getBackground());
        this.xPosition.setBorder(bb);
        this.xPosition.setPreferredSize(new Dimension(110, 16));
        p2.add("West", this.xPosition);
        this.yPosition = new JLabel();
        this.yPosition.setBorder(bb);
        this.yPosition.setPreferredSize(new Dimension(110, 16));
        p2.add("Center", this.yPosition);
        this.zoom = new JLabel();
        this.zoom.setBorder(bb);
        this.zoom.setPreferredSize(new Dimension(70, 16));
        p2.add("East", this.zoom);
        p2 = new JPanel(new BorderLayout(0, 0));
        this.message = new JLabel();
        this.message.setBorder(bb);
        p2.add(this.message);
        this.add(p2);
        this.setMainMessage(rManager.getString("Panel.default_message"));
    }

    public void setXPosition(float x2) {
        this.xPosition.setText("x: " + x2);
    }

    public void setWidth(float w2) {
        this.xPosition.setText(rManager.getString("Position.width_letters") + " " + w2);
    }

    public void setYPosition(float y2) {
        this.yPosition.setText("y: " + y2);
    }

    public void setHeight(float h2) {
        this.yPosition.setText(rManager.getString("Position.height_letters") + " " + h2);
    }

    public void setZoom(float f2) {
        float f3 = f2 = f2 > 0.0f ? f2 : -f2;
        if (f2 == 1.0f) {
            this.zoom.setText("1:1");
        } else if (f2 >= 1.0f) {
            String s2 = Float.toString(f2);
            if (s2.length() > 6) {
                s2 = s2.substring(0, 6);
            }
            this.zoom.setText("1:" + s2);
        } else {
            String s3 = Float.toString(1.0f / f2);
            if (s3.length() > 6) {
                s3 = s3.substring(0, 6);
            }
            this.zoom.setText(s3 + ":1");
        }
    }

    public void setMessage(String s2) {
        this.setPreferredSize(new Dimension(0, this.getPreferredSize().height));
        if (this.displayThread != null) {
            this.displayThread.finish();
        }
        this.temporaryMessage = s2;
        DisplayThread old = this.displayThread;
        this.displayThread = new DisplayThread(old);
        this.displayThread.start();
    }

    public void setMainMessage(String s2) {
        this.mainMessage = s2;
        this.mainMessage = s2;
        this.message.setText(this.mainMessage);
        if (this.displayThread != null) {
            this.displayThread.finish();
            this.displayThread = null;
        }
        this.setPreferredSize(new Dimension(0, this.getPreferredSize().height));
    }

    protected class DisplayThread
    extends Thread {
        static final long DEFAULT_DURATION = 5000L;
        long duration;
        Thread toJoin;

        public DisplayThread() {
            this(5000L, null);
        }

        public DisplayThread(long duration) {
            this(duration, null);
        }

        public DisplayThread(Thread toJoin) {
            this(5000L, toJoin);
        }

        public DisplayThread(long duration, Thread toJoin) {
            this.duration = duration;
            this.toJoin = toJoin;
            this.setPriority(1);
        }

        public synchronized void finish() {
            this.duration = 0L;
            this.notifyAll();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            DisplayThread displayThread = this;
            synchronized (displayThread) {
                if (this.toJoin != null) {
                    while (this.toJoin.isAlive()) {
                        try {
                            this.toJoin.join();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    this.toJoin = null;
                }
                StatusBar.this.message.setText(StatusBar.this.temporaryMessage);
                long lTime = System.currentTimeMillis();
                while (this.duration > 0L) {
                    try {
                        this.wait(this.duration);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    long cTime = System.currentTimeMillis();
                    this.duration -= cTime - lTime;
                    lTime = cTime;
                }
                StatusBar.this.message.setText(StatusBar.this.mainMessage);
            }
        }
    }
}

