/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.apps.svgbrowser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.Authenticator;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import org.apache.batik.apps.svgbrowser.AboutDialog;
import org.apache.batik.apps.svgbrowser.Application;
import org.apache.batik.apps.svgbrowser.JAuthenticator;
import org.apache.batik.apps.svgbrowser.JSVGViewerFrame;
import org.apache.batik.apps.svgbrowser.PreferenceDialog;
import org.apache.batik.apps.svgbrowser.XMLPreferenceManager;
import org.apache.batik.swing.JSVGCanvas;
import org.apache.batik.swing.gvt.GVTTreeRendererAdapter;
import org.apache.batik.swing.gvt.GVTTreeRendererEvent;
import org.apache.batik.swing.svg.GVTTreeBuilderAdapter;
import org.apache.batik.swing.svg.GVTTreeBuilderEvent;
import org.apache.batik.swing.svg.SVGDocumentLoaderAdapter;
import org.apache.batik.swing.svg.SVGDocumentLoaderEvent;
import org.apache.batik.util.ApplicationSecurityEnforcer;
import org.apache.batik.util.ParsedURL;
import org.apache.batik.util.Platform;
import org.apache.batik.util.XMLResourceDescriptor;
import org.apache.batik.util.resources.ResourceManager;

public class Main
implements Application {
    public static final String UNKNOWN_SCRIPT_TYPE_LOAD_KEY_EXTENSION = ".load";
    public static final String PROPERTY_USER_HOME = "user.home";
    public static final String PROPERTY_JAVA_SECURITY_POLICY = "java.security.policy";
    public static final String BATIK_CONFIGURATION_SUBDIRECTORY = ".batik";
    public static final String SQUIGGLE_CONFIGURATION_FILE = "preferences.xml";
    public static final String SQUIGGLE_POLICY_FILE = "__svgbrowser.policy";
    public static final String POLICY_GRANT_SCRIPT_NETWORK_ACCESS = "grant {\n  permission java.net.SocketPermission \"*\", \"listen, connect, resolve, accept\";\n};\n\n";
    public static final String POLICY_GRANT_SCRIPT_FILE_ACCESS = "grant {\n  permission java.io.FilePermission \"<<ALL FILES>>\", \"read\";\n};\n\n";
    public static final String PREFERENCE_KEY_VISITED_URI_LIST = "preference.key.visited.uri.list";
    public static final String PREFERENCE_KEY_VISITED_URI_LIST_LENGTH = "preference.key.visited.uri.list.length";
    public static final String URI_SEPARATOR = " ";
    public static final String DEFAULT_DEFAULT_FONT_FAMILY = "Arial, Helvetica, sans-serif";
    public static final String SVG_INITIALIZATION = "resources/init.svg";
    protected String svgInitializationURI;
    public static final String RESOURCES = "org.apache.batik.apps.svgbrowser.resources.Main";
    public static final String SQUIGGLE_SECURITY_POLICY = "org/apache/batik/apps/svgbrowser/resources/svgbrowser.policy";
    protected static ResourceBundle bundle = ResourceBundle.getBundle("org.apache.batik.apps.svgbrowser.resources.Main", Locale.getDefault());
    protected static ResourceManager resources = new ResourceManager(bundle);
    protected static ImageIcon frameIcon = new ImageIcon(Main.class.getResource(resources.getString("Frame.icon")));
    protected XMLPreferenceManager preferenceManager;
    public static final int MAX_VISITED_URIS = 10;
    protected Vector lastVisited = new Vector();
    protected int maxVisitedURIs = 10;
    protected String[] arguments;
    protected boolean overrideSecurityPolicy = false;
    protected ApplicationSecurityEnforcer securityEnforcer;
    protected Map handlers = new HashMap();
    protected List viewerFrames;
    protected PreferenceDialog preferenceDialog;
    protected String uiSpecialization;

    public static void main(String[] args) {
        new Main(args);
    }

    public Main(String[] args) {
        this.handlers.put("-font-size", new FontSizeHandler());
        this.viewerFrames = new LinkedList();
        this.arguments = args;
        if (Platform.isOSX) {
            this.uiSpecialization = "OSX";
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            try {
                Class<?> Application2 = Class.forName("com.apple.eawt.Application");
                Class<?> ApplicationListener = Class.forName("com.apple.eawt.ApplicationListener");
                Class<?> ApplicationEvent = Class.forName("com.apple.eawt.ApplicationEvent");
                Method getApplication = Application2.getMethod("getApplication", new Class[0]);
                Method addApplicationListener = Application2.getMethod("addApplicationListener", ApplicationListener);
                final Method setHandled = ApplicationEvent.getMethod("setHandled", Boolean.TYPE);
                Method setEnabledPreferencesMenu = Application2.getMethod("setEnabledPreferencesMenu", Boolean.TYPE);
                InvocationHandler listenerHandler = new InvocationHandler(){

                    @Override
                    public Object invoke(Object proxy, Method method, Object[] args) {
                        String name = method.getName();
                        if (name.equals("handleAbout")) {
                            JSVGViewerFrame relativeTo = (JSVGViewerFrame)Main.this.viewerFrames.get(0);
                            AboutDialog dlg = new AboutDialog(relativeTo);
                            dlg.setSize(dlg.getPreferredSize());
                            dlg.setLocationRelativeTo(relativeTo);
                            dlg.setVisible(true);
                            dlg.toFront();
                        } else if (name.equals("handlePreferences")) {
                            JSVGViewerFrame relativeTo = (JSVGViewerFrame)Main.this.viewerFrames.get(0);
                            Main.this.showPreferenceDialog(relativeTo);
                        } else if (!name.equals("handleQuit")) {
                            return null;
                        }
                        try {
                            setHandled.invoke(args[0], Boolean.TRUE);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return null;
                    }
                };
                Object application = getApplication.invoke(null, (Object[])null);
                setEnabledPreferencesMenu.invoke(application, Boolean.TRUE);
                Object listener = Proxy.newProxyInstance(Main.class.getClassLoader(), new Class[]{ApplicationListener}, listenerHandler);
                addApplicationListener.invoke(application, listener);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.uiSpecialization = null;
            }
        }
        HashMap<String, Object> defaults = new HashMap<String, Object>(11);
        defaults.put("preference.key.languages", Locale.getDefault().getLanguage());
        defaults.put("preference.key.show.rendering", Boolean.FALSE);
        defaults.put("preference.key.auto.adjust.window", Boolean.TRUE);
        defaults.put("preference.key.selection.xor.mode", Boolean.FALSE);
        defaults.put("preference.key.enable.double.buffering", Boolean.TRUE);
        defaults.put("preference.key.show.debug.trace", Boolean.FALSE);
        defaults.put("preference.key.proxy.host", "");
        defaults.put("preference.key.proxy.port", "");
        defaults.put("preference.key.cssmedia", "screen");
        defaults.put("preference.key.default.font.family", DEFAULT_DEFAULT_FONT_FAMILY);
        defaults.put("preference.key.is.xml.parser.validating", Boolean.FALSE);
        defaults.put("preference.key.enforce.secure.scripting", Boolean.TRUE);
        defaults.put("preference.key.grant.script.file.access", Boolean.FALSE);
        defaults.put("preference.key.grant.script.network.access", Boolean.FALSE);
        defaults.put("preference.key.load.java.script", Boolean.TRUE);
        defaults.put("preference.key.load.ecmascript", Boolean.TRUE);
        defaults.put("preference.key.allowed.script.origin", 2);
        defaults.put("preference.key.allowed.external.resource.origin", 1);
        defaults.put(PREFERENCE_KEY_VISITED_URI_LIST, "");
        defaults.put(PREFERENCE_KEY_VISITED_URI_LIST_LENGTH, 10);
        defaults.put("preference.key.animation.rate.limiting.mode", 1);
        defaults.put("preference.key.animation.rate.limiting.cpu", Float.valueOf(0.75f));
        defaults.put("preference.key.animation.rate.limiting.fps", Float.valueOf(10.0f));
        defaults.put("preference.key.user.stylesheet.enabled", Boolean.TRUE);
        this.securityEnforcer = new ApplicationSecurityEnforcer(this.getClass(), SQUIGGLE_SECURITY_POLICY);
        try {
            this.preferenceManager = new XMLPreferenceManager(SQUIGGLE_CONFIGURATION_FILE, defaults);
            String dir = System.getProperty(PROPERTY_USER_HOME);
            File f2 = new File(dir, BATIK_CONFIGURATION_SUBDIRECTORY);
            f2.mkdir();
            XMLPreferenceManager.setPreferenceDirectory(f2.getCanonicalPath());
            this.preferenceManager.load();
            this.setPreferences();
            this.initializeLastVisited();
            Authenticator.setDefault(new JAuthenticator());
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        final AboutDialog initDialog = new AboutDialog();
        ((BorderLayout)initDialog.getContentPane().getLayout()).setVgap(8);
        final JProgressBar pb = new JProgressBar(0, 3);
        initDialog.getContentPane().add((Component)pb, "South");
        Dimension ss = initDialog.getToolkit().getScreenSize();
        Dimension ds = initDialog.getPreferredSize();
        initDialog.setLocation((ss.width - ds.width) / 2, (ss.height - ds.height) / 2);
        initDialog.setSize(ds);
        initDialog.setVisible(true);
        final JSVGViewerFrame v2 = new JSVGViewerFrame(this);
        JSVGCanvas c2 = v2.getJSVGCanvas();
        c2.addSVGDocumentLoaderListener(new SVGDocumentLoaderAdapter(){

            @Override
            public void documentLoadingStarted(SVGDocumentLoaderEvent e2) {
                pb.setValue(1);
            }

            @Override
            public void documentLoadingCompleted(SVGDocumentLoaderEvent e2) {
                pb.setValue(2);
            }
        });
        c2.addGVTTreeBuilderListener(new GVTTreeBuilderAdapter(){

            @Override
            public void gvtBuildCompleted(GVTTreeBuilderEvent e2) {
                pb.setValue(3);
            }
        });
        c2.addGVTTreeRendererListener(new GVTTreeRendererAdapter(){

            @Override
            public void gvtRenderingCompleted(GVTTreeRendererEvent e2) {
                initDialog.dispose();
                v2.dispose();
                System.gc();
                Main.this.run();
            }
        });
        c2.setSize(100, 100);
        this.svgInitializationURI = Main.class.getResource(SVG_INITIALIZATION).toString();
        c2.loadSVGDocument(this.svgInitializationURI);
    }

    public void installCustomPolicyFile() throws IOException {
        String securityPolicyProperty = System.getProperty(PROPERTY_JAVA_SECURITY_POLICY);
        if (this.overrideSecurityPolicy || securityPolicyProperty == null || "".equals(securityPolicyProperty)) {
            ParsedURL policyURL = new ParsedURL(this.securityEnforcer.getPolicyURL());
            String dir = System.getProperty(PROPERTY_USER_HOME);
            File batikConfigDir = new File(dir, BATIK_CONFIGURATION_SUBDIRECTORY);
            File policyFile = new File(batikConfigDir, SQUIGGLE_POLICY_FILE);
            BufferedReader r2 = new BufferedReader(new InputStreamReader(policyURL.openStream()));
            FileWriter w2 = new FileWriter(policyFile);
            char[] buf = new char[1024];
            int n2 = 0;
            while ((n2 = ((Reader)r2).read(buf, 0, buf.length)) != -1) {
                ((Writer)w2).write(buf, 0, n2);
            }
            ((Reader)r2).close();
            boolean grantScriptNetworkAccess = this.preferenceManager.getBoolean("preference.key.grant.script.network.access");
            boolean grantScriptFileAccess = this.preferenceManager.getBoolean("preference.key.grant.script.file.access");
            if (grantScriptNetworkAccess) {
                w2.write(POLICY_GRANT_SCRIPT_NETWORK_ACCESS);
            }
            if (grantScriptFileAccess) {
                w2.write(POLICY_GRANT_SCRIPT_FILE_ACCESS);
            }
            ((Writer)w2).close();
            this.overrideSecurityPolicy = true;
            System.setProperty(PROPERTY_JAVA_SECURITY_POLICY, policyFile.toURI().toURL().toString());
        }
    }

    public void run() {
        try {
            OptionHandler oh;
            int i2;
            for (i2 = 0; i2 < this.arguments.length && (oh = (OptionHandler)this.handlers.get(this.arguments[i2])) != null; ++i2) {
                i2 = oh.handleOption(i2);
            }
            JSVGViewerFrame frame = this.createAndShowJSVGViewerFrame();
            while (i2 < this.arguments.length) {
                if (this.arguments[i2].length() == 0) {
                    ++i2;
                    continue;
                }
                File file = new File(this.arguments[i2]);
                String uri = null;
                try {
                    if (file.canRead()) {
                        uri = file.toURI().toURL().toString();
                    }
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                if (uri == null) {
                    uri = this.arguments[i2];
                    ParsedURL purl = null;
                    purl = new ParsedURL(this.arguments[i2]);
                    if (!purl.complete()) {
                        uri = null;
                    }
                }
                if (uri != null) {
                    if (frame == null) {
                        frame = this.createAndShowJSVGViewerFrame();
                    }
                    frame.showSVGDocument(uri);
                    frame = null;
                } else {
                    JOptionPane.showMessageDialog(frame, resources.getString("Error.skipping.file") + this.arguments[i2]);
                }
                ++i2;
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
            this.printUsage();
        }
    }

    protected void printUsage() {
        System.out.println();
        System.out.println(resources.getString("Command.header"));
        System.out.println(resources.getString("Command.syntax"));
        System.out.println();
        System.out.println(resources.getString("Command.options"));
        for (Object o2 : this.handlers.keySet()) {
            String s2 = (String)o2;
            System.out.println(((OptionHandler)this.handlers.get(s2)).getDescription());
        }
    }

    @Override
    public JSVGViewerFrame createAndShowJSVGViewerFrame() {
        JSVGViewerFrame mainFrame = new JSVGViewerFrame(this);
        mainFrame.setSize(resources.getInteger("Frame.width"), resources.getInteger("Frame.height"));
        mainFrame.setIconImage(frameIcon.getImage());
        mainFrame.setTitle(resources.getString("Frame.title"));
        mainFrame.setVisible(true);
        this.viewerFrames.add(mainFrame);
        this.setPreferences(mainFrame);
        return mainFrame;
    }

    @Override
    public void closeJSVGViewerFrame(JSVGViewerFrame f2) {
        f2.getJSVGCanvas().stopProcessing();
        this.viewerFrames.remove(f2);
        if (this.viewerFrames.size() == 0) {
            System.exit(0);
        }
        f2.dispose();
    }

    @Override
    public Action createExitAction(JSVGViewerFrame vf) {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                System.exit(0);
            }
        };
    }

    @Override
    public void openLink(String url) {
        JSVGViewerFrame f2 = this.createAndShowJSVGViewerFrame();
        f2.getJSVGCanvas().loadSVGDocument(url);
    }

    @Override
    public String getXMLParserClassName() {
        return XMLResourceDescriptor.getXMLParserClassName();
    }

    @Override
    public boolean isXMLParserValidating() {
        return this.preferenceManager.getBoolean("preference.key.is.xml.parser.validating");
    }

    @Override
    public void showPreferenceDialog(JSVGViewerFrame f2) {
        if (this.preferenceDialog == null) {
            this.preferenceDialog = new PreferenceDialog((Frame)f2, this.preferenceManager);
        }
        if (this.preferenceDialog.showDialog() == 0) {
            try {
                this.preferenceManager.save();
                this.setPreferences();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void setPreferences() throws IOException {
        for (Object viewerFrame : this.viewerFrames) {
            this.setPreferences((JSVGViewerFrame)viewerFrame);
        }
        System.setProperty("proxyHost", this.preferenceManager.getString("preference.key.proxy.host"));
        System.setProperty("proxyPort", this.preferenceManager.getString("preference.key.proxy.port"));
        this.installCustomPolicyFile();
        this.securityEnforcer.enforceSecurity(this.preferenceManager.getBoolean("preference.key.enforce.secure.scripting"));
    }

    private void setPreferences(JSVGViewerFrame vf) {
        boolean db = this.preferenceManager.getBoolean("preference.key.enable.double.buffering");
        vf.getJSVGCanvas().setDoubleBufferedRendering(db);
        boolean sr = this.preferenceManager.getBoolean("preference.key.show.rendering");
        vf.getJSVGCanvas().setProgressivePaint(sr);
        boolean d2 = this.preferenceManager.getBoolean("preference.key.show.debug.trace");
        vf.setDebug(d2);
        boolean aa = this.preferenceManager.getBoolean("preference.key.auto.adjust.window");
        vf.setAutoAdjust(aa);
        boolean dd = this.preferenceManager.getBoolean("preference.key.selection.xor.mode");
        vf.getJSVGCanvas().setSelectionOverlayXORMode(dd);
        int al = this.preferenceManager.getInteger("preference.key.animation.rate.limiting.mode");
        if (al < 0 || al > 2) {
            al = 1;
        }
        switch (al) {
            case 0: {
                vf.getJSVGCanvas().setAnimationLimitingNone();
                break;
            }
            case 1: {
                float pc = this.preferenceManager.getFloat("preference.key.animation.rate.limiting.cpu");
                if (pc <= 0.0f || pc > 1.0f) {
                    pc = 0.75f;
                }
                vf.getJSVGCanvas().setAnimationLimitingCPU(pc);
                break;
            }
            case 2: {
                float fps = this.preferenceManager.getFloat("preference.key.animation.rate.limiting.fps");
                if (fps <= 0.0f) {
                    fps = 10.0f;
                }
                vf.getJSVGCanvas().setAnimationLimitingFPS(fps);
                break;
            }
        }
    }

    @Override
    public String getLanguages() {
        String s2 = this.preferenceManager.getString("preference.key.languages");
        return s2 == null ? Locale.getDefault().getLanguage() : s2;
    }

    @Override
    public String getUserStyleSheetURI() {
        boolean enabled = this.preferenceManager.getBoolean("preference.key.user.stylesheet.enabled");
        String ssPath = this.preferenceManager.getString("preference.key.user.stylesheet");
        if (!enabled || ssPath.length() == 0) {
            return null;
        }
        try {
            File f2 = new File(ssPath);
            if (f2.exists()) {
                return f2.toURI().toURL().toString();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ssPath;
    }

    @Override
    public String getDefaultFontFamily() {
        return this.preferenceManager.getString("preference.key.default.font.family");
    }

    @Override
    public String getMedia() {
        String s2 = this.preferenceManager.getString("preference.key.cssmedia");
        return s2 == null ? "screen" : s2;
    }

    @Override
    public boolean isSelectionOverlayXORMode() {
        return this.preferenceManager.getBoolean("preference.key.selection.xor.mode");
    }

    @Override
    public boolean canLoadScriptType(String scriptType) {
        if ("text/ecmascript".equals(scriptType) || "application/ecmascript".equals(scriptType) || "text/javascript".equals(scriptType) || "application/javascript".equals(scriptType)) {
            return this.preferenceManager.getBoolean("preference.key.load.ecmascript");
        }
        if ("application/java-archive".equals(scriptType)) {
            return this.preferenceManager.getBoolean("preference.key.load.java.script");
        }
        return this.preferenceManager.getBoolean(scriptType + UNKNOWN_SCRIPT_TYPE_LOAD_KEY_EXTENSION);
    }

    @Override
    public int getAllowedScriptOrigin() {
        int ret = this.preferenceManager.getInteger("preference.key.allowed.script.origin");
        return ret;
    }

    @Override
    public int getAllowedExternalResourceOrigin() {
        int ret = this.preferenceManager.getInteger("preference.key.allowed.external.resource.origin");
        return ret;
    }

    @Override
    public void addVisitedURI(String uri) {
        if (this.svgInitializationURI.equals(uri)) {
            return;
        }
        int maxVisitedURIs = this.preferenceManager.getInteger(PREFERENCE_KEY_VISITED_URI_LIST_LENGTH);
        if (maxVisitedURIs < 0) {
            maxVisitedURIs = 0;
        }
        if (this.lastVisited.contains(uri)) {
            this.lastVisited.removeElement(uri);
        }
        while (this.lastVisited.size() > 0 && this.lastVisited.size() > maxVisitedURIs - 1) {
            this.lastVisited.removeElementAt(0);
        }
        if (maxVisitedURIs > 0) {
            this.lastVisited.addElement(uri);
        }
        StringBuffer lastVisitedBuffer = new StringBuffer(this.lastVisited.size() * 8);
        for (Object aLastVisited : this.lastVisited) {
            try {
                lastVisitedBuffer.append(URLEncoder.encode(aLastVisited.toString(), Charset.defaultCharset().name()));
            }
            catch (UnsupportedEncodingException e2) {
                throw new RuntimeException(e2);
            }
            lastVisitedBuffer.append(URI_SEPARATOR);
        }
        this.preferenceManager.setString(PREFERENCE_KEY_VISITED_URI_LIST, lastVisitedBuffer.toString());
        try {
            this.preferenceManager.save();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public String[] getVisitedURIs() {
        String[] visitedURIs = new String[this.lastVisited.size()];
        this.lastVisited.toArray(visitedURIs);
        return visitedURIs;
    }

    @Override
    public String getUISpecialization() {
        return this.uiSpecialization;
    }

    protected void initializeLastVisited() {
        int maxVisitedURIs;
        String lastVisitedStr = this.preferenceManager.getString(PREFERENCE_KEY_VISITED_URI_LIST);
        StringTokenizer st = new StringTokenizer(lastVisitedStr, URI_SEPARATOR);
        int n2 = st.countTokens();
        if (n2 > (maxVisitedURIs = this.preferenceManager.getInteger(PREFERENCE_KEY_VISITED_URI_LIST_LENGTH))) {
            n2 = maxVisitedURIs;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            try {
                this.lastVisited.addElement(URLDecoder.decode(st.nextToken(), Charset.defaultCharset().name()));
                continue;
            }
            catch (UnsupportedEncodingException e2) {
                throw new RuntimeException(e2);
            }
        }
    }

    protected class FontSizeHandler
    implements OptionHandler {
        protected FontSizeHandler() {
        }

        @Override
        public int handleOption(int i2) {
            int size = Integer.parseInt(Main.this.arguments[++i2]);
            Font font = new Font("Dialog", 0, size);
            FontUIResource fontRes = new FontUIResource(font);
            UIManager.put("CheckBox.font", fontRes);
            UIManager.put("PopupMenu.font", fontRes);
            UIManager.put("TextPane.font", fontRes);
            UIManager.put("MenuItem.font", fontRes);
            UIManager.put("ComboBox.font", fontRes);
            UIManager.put("Button.font", fontRes);
            UIManager.put("Tree.font", fontRes);
            UIManager.put("ScrollPane.font", fontRes);
            UIManager.put("TabbedPane.font", fontRes);
            UIManager.put("EditorPane.font", fontRes);
            UIManager.put("TitledBorder.font", fontRes);
            UIManager.put("Menu.font", fontRes);
            UIManager.put("TextArea.font", fontRes);
            UIManager.put("OptionPane.font", fontRes);
            UIManager.put("DesktopIcon.font", fontRes);
            UIManager.put("MenuBar.font", fontRes);
            UIManager.put("ToolBar.font", fontRes);
            UIManager.put("RadioButton.font", fontRes);
            UIManager.put("RadioButtonMenuItem.font", fontRes);
            UIManager.put("ToggleButton.font", fontRes);
            UIManager.put("ToolTip.font", fontRes);
            UIManager.put("ProgressBar.font", fontRes);
            UIManager.put("TableHeader.font", fontRes);
            UIManager.put("Panel.font", fontRes);
            UIManager.put("List.font", fontRes);
            UIManager.put("ColorChooser.font", fontRes);
            UIManager.put("PasswordField.font", fontRes);
            UIManager.put("TextField.font", fontRes);
            UIManager.put("Table.font", fontRes);
            UIManager.put("Label.font", fontRes);
            UIManager.put("InternalFrameTitlePane.font", fontRes);
            UIManager.put("CheckBoxMenuItem.font", fontRes);
            return i2;
        }

        @Override
        public String getDescription() {
            return resources.getString("Command.font-size");
        }
    }

    protected static interface OptionHandler {
        public int handleOption(int var1);

        public String getDescription();
    }
}

