/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.apps.svgbrowser;

import java.util.ArrayList;
import org.apache.batik.apps.svgbrowser.AbstractUndoableCommand;
import org.apache.batik.apps.svgbrowser.UndoableCommand;

public abstract class AbstractCompoundCommand
extends AbstractUndoableCommand {
    protected ArrayList atomCommands = new ArrayList();

    public void addCommand(UndoableCommand command) {
        if (command.shouldExecute()) {
            this.atomCommands.add(command);
        }
    }

    @Override
    public void execute() {
        int n2 = this.atomCommands.size();
        for (Object atomCommand : this.atomCommands) {
            UndoableCommand cmd = (UndoableCommand)atomCommand;
            cmd.execute();
        }
    }

    @Override
    public void undo() {
        int size = this.atomCommands.size();
        for (int i2 = size - 1; i2 >= 0; --i2) {
            UndoableCommand command = (UndoableCommand)this.atomCommands.get(i2);
            command.undo();
        }
    }

    @Override
    public void redo() {
        int n2 = this.atomCommands.size();
        for (Object atomCommand : this.atomCommands) {
            UndoableCommand cmd = (UndoableCommand)atomCommand;
            cmd.redo();
        }
    }

    @Override
    public boolean shouldExecute() {
        boolean shouldExecute = true;
        if (this.atomCommands.size() == 0) {
            shouldExecute = false;
        }
        int n2 = this.atomCommands.size();
        for (int i2 = 0; i2 < n2 && shouldExecute; ++i2) {
            UndoableCommand command = (UndoableCommand)this.atomCommands.get(i2);
            shouldExecute = command.shouldExecute() && shouldExecute;
        }
        return shouldExecute;
    }

    public int getCommandNumber() {
        return this.atomCommands.size();
    }
}

