/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.tool;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.antlr.analysis.NFAState;
import org.antlr.analysis.RuleClosureTransition;
import org.antlr.analysis.Transition;
import org.antlr.runtime.tree.Tree;
import org.antlr.tool.ErrorManager;
import org.antlr.tool.Grammar;
import org.antlr.tool.GrammarAST;
import org.antlr.tool.Rule;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrammarSanity {
    protected Set<Rule> visitedDuringRecursionCheck = null;
    protected Grammar grammar;

    public GrammarSanity(Grammar grammar) {
        this.grammar = grammar;
    }

    public List<Set<Rule>> checkAllRulesForLeftRecursion() {
        this.grammar.buildNFA();
        this.grammar.leftRecursiveRules = new HashSet<Rule>();
        ArrayList<Set<Rule>> listOfRecursiveCycles = new ArrayList<Set<Rule>>();
        for (int i2 = 0; i2 < this.grammar.composite.ruleIndexToRuleList.size(); ++i2) {
            Rule r2 = this.grammar.composite.ruleIndexToRuleList.elementAt(i2);
            if (r2 == null) continue;
            this.visitedDuringRecursionCheck = new HashSet<Rule>();
            this.visitedDuringRecursionCheck.add(r2);
            HashSet visitedStates = new HashSet();
            this.traceStatesLookingForLeftRecursion(r2.startState, visitedStates, listOfRecursiveCycles);
        }
        if (listOfRecursiveCycles.size() > 0) {
            ErrorManager.leftRecursionCycles(listOfRecursiveCycles);
        }
        return listOfRecursiveCycles;
    }

    protected boolean traceStatesLookingForLeftRecursion(NFAState s2, Set visitedStates, List<Set<Rule>> listOfRecursiveCycles) {
        if (s2.isAcceptState()) {
            return true;
        }
        if (visitedStates.contains(s2)) {
            return false;
        }
        visitedStates.add(s2);
        boolean stateReachesAcceptState = false;
        Transition t0 = s2.transition[0];
        if (t0 instanceof RuleClosureTransition) {
            RuleClosureTransition refTrans = (RuleClosureTransition)t0;
            Rule refRuleDef = refTrans.rule;
            if (this.visitedDuringRecursionCheck.contains(refRuleDef)) {
                this.grammar.leftRecursiveRules.add(refRuleDef);
                this.addRulesToCycle(refRuleDef, s2.enclosingRule, listOfRecursiveCycles);
            } else {
                this.visitedDuringRecursionCheck.add(refRuleDef);
                boolean callReachedAcceptState = this.traceStatesLookingForLeftRecursion((NFAState)t0.target, new HashSet(), listOfRecursiveCycles);
                this.visitedDuringRecursionCheck.remove(refRuleDef);
                if (callReachedAcceptState) {
                    NFAState followingState = ((RuleClosureTransition)t0).followState;
                    stateReachesAcceptState |= this.traceStatesLookingForLeftRecursion(followingState, visitedStates, listOfRecursiveCycles);
                }
            }
        } else if (t0.label.isEpsilon() || t0.label.isSemanticPredicate()) {
            stateReachesAcceptState |= this.traceStatesLookingForLeftRecursion((NFAState)t0.target, visitedStates, listOfRecursiveCycles);
        }
        Transition t1 = s2.transition[1];
        if (t1 != null) {
            stateReachesAcceptState |= this.traceStatesLookingForLeftRecursion((NFAState)t1.target, visitedStates, listOfRecursiveCycles);
        }
        return stateReachesAcceptState;
    }

    protected void addRulesToCycle(Rule targetRule, Rule enclosingRule, List<Set<Rule>> listOfRecursiveCycles) {
        boolean foundCycle = false;
        for (int i2 = 0; i2 < listOfRecursiveCycles.size(); ++i2) {
            Set<Rule> rulesInCycle = listOfRecursiveCycles.get(i2);
            if (rulesInCycle.contains(targetRule)) {
                rulesInCycle.add(enclosingRule);
                foundCycle = true;
            }
            if (!rulesInCycle.contains(enclosingRule)) continue;
            rulesInCycle.add(targetRule);
            foundCycle = true;
        }
        if (!foundCycle) {
            HashSet<Rule> cycle = new HashSet<Rule>();
            cycle.add(targetRule);
            cycle.add(enclosingRule);
            listOfRecursiveCycles.add(cycle);
        }
    }

    public void checkRuleReference(GrammarAST scopeAST, GrammarAST refAST, GrammarAST argsAST, String currentRuleName) {
        Rule r2 = this.grammar.getRule(refAST.getText());
        if (refAST.getType() == 75) {
            if (argsAST != null) {
                if (r2 != null && r2.argActionAST == null) {
                    ErrorManager.grammarError(130, this.grammar, argsAST.getToken(), r2.name);
                }
            } else if (r2 != null && r2.argActionAST != null) {
                ErrorManager.grammarError(129, this.grammar, refAST.getToken(), r2.name);
            }
        } else if (refAST.getType() == 64) {
            if (this.grammar.type != 1) {
                if (argsAST != null) {
                    ErrorManager.grammarError(131, this.grammar, refAST.getToken(), refAST.getText());
                }
                return;
            }
            if (argsAST != null) {
                if (r2 != null && r2.argActionAST == null) {
                    ErrorManager.grammarError(130, this.grammar, argsAST.getToken(), r2.name);
                }
            } else if (r2 != null && r2.argActionAST != null) {
                ErrorManager.grammarError(129, this.grammar, refAST.getToken(), r2.name);
            }
        }
    }

    public void ensureAltIsSimpleNodeOrTree(GrammarAST altAST, GrammarAST elementAST, int outerAltNum) {
        if (this.isValidSimpleElementNode(elementAST)) {
            GrammarAST next = elementAST.getNextSibling();
            if (!this.isNextNonActionElementEOA(next)) {
                ErrorManager.grammarWarning(153, this.grammar, next.token, new Integer(outerAltNum));
            }
            return;
        }
        switch (elementAST.getType()) {
            case 57: 
            case 70: {
                if (!this.isValidSimpleElementNode(elementAST.getChild(1))) break;
                return;
            }
            case 44: 
            case 45: 
            case 46: 
            case 50: 
            case 71: {
                this.ensureAltIsSimpleNodeOrTree(altAST, elementAST.getNextSibling(), outerAltNum);
                return;
            }
        }
        ErrorManager.grammarWarning(153, this.grammar, elementAST.token, new Integer(outerAltNum));
    }

    protected boolean isValidSimpleElementNode(Tree t2) {
        switch (t2.getType()) {
            case 58: 
            case 59: 
            case 64: 
            case 74: 
            case 77: {
                return true;
            }
        }
        return false;
    }

    protected boolean isNextNonActionElementEOA(GrammarAST t2) {
        while (t2.getType() == 50 || t2.getType() == 71) {
            t2 = t2.getNextSibling();
        }
        return t2.getType() == 29;
    }
}

