/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.tool;

import java.util.Iterator;
import org.antlr.tool.CompositeGrammar;
import org.antlr.tool.Grammar;
import org.antlr.tool.GrammarAST;
import org.antlr.tool.Rule;

public class GrammarReport2 {
    public static final String newline = System.getProperty("line.separator");
    public Grammar root;

    public GrammarReport2(Grammar rootGrammar) {
        this.root = rootGrammar;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        this.stats(this.root, buf);
        CompositeGrammar composite = this.root.composite;
        Iterator<Grammar> i$ = composite.getDelegates(this.root).iterator();
        while (i$.hasNext()) {
            Grammar g2 = i$.next();
            this.stats(g2, buf);
        }
        return buf.toString();
    }

    void stats(Grammar g2, StringBuilder buf) {
        int numDec = g2.getNumberOfDecisions();
        for (int decision = 1; decision <= numDec; ++decision) {
            Grammar.Decision d2 = g2.getDecision(decision);
            if (d2.dfa == null) continue;
            int k2 = d2.dfa.getMaxLookaheadDepth();
            Rule enclosingRule = d2.dfa.decisionNFAStartState.enclosingRule;
            if (enclosingRule.isSynPred) continue;
            buf.append(g2.name + "." + enclosingRule.name + ":" + "");
            GrammarAST decisionAST = d2.dfa.decisionNFAStartState.associatedASTNode;
            buf.append(decisionAST.getLine());
            buf.append(":");
            buf.append(decisionAST.getCharPositionInLine());
            buf.append(" decision " + decision + ":");
            if (d2.dfa.isCyclic()) {
                buf.append(" cyclic");
            }
            if (k2 != Integer.MAX_VALUE) {
                buf.append(" k=" + k2);
            }
            if (d2.dfa.hasSynPred()) {
                buf.append(" backtracks");
            }
            if (d2.dfa.hasSemPred()) {
                buf.append(" sempred");
            }
            this.nl(buf);
        }
    }

    void nl(StringBuilder buf) {
        buf.append(newline);
    }
}

