/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.tool;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.antlr.codegen.CodeGenerator;
import org.antlr.runtime.Token;
import org.antlr.tool.Attribute;
import org.antlr.tool.ErrorManager;
import org.antlr.tool.Grammar;
import org.antlr.tool.GrammarAST;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeScope {
    public static AttributeScope tokenScope = new AttributeScope("Token", null);
    public Token derivedFromToken;
    public Grammar grammar;
    private String name;
    public boolean isDynamicGlobalScope;
    public boolean isDynamicRuleScope;
    public boolean isParameterScope;
    public boolean isReturnScope;
    public boolean isPredefinedRuleScope;
    public boolean isPredefinedLexerRuleScope;
    protected LinkedHashMap<String, Attribute> attributes = new LinkedHashMap();
    public LinkedHashMap<String, GrammarAST> actions = new LinkedHashMap();

    public AttributeScope(String name, Token derivedFromToken) {
        this(null, name, derivedFromToken);
    }

    public AttributeScope(Grammar grammar, String name, Token derivedFromToken) {
        this.grammar = grammar;
        this.name = name;
        this.derivedFromToken = derivedFromToken;
    }

    public String getName() {
        if (this.isParameterScope) {
            return new StringBuffer().append(this.name).append("_parameter").toString();
        }
        if (this.isReturnScope) {
            return new StringBuffer().append(this.name).append("_return").toString();
        }
        return this.name;
    }

    public void addAttributes(String definitions, int separator) {
        ArrayList<String> attrs = new ArrayList<String>();
        CodeGenerator.getListOfArgumentsFromAction(definitions, 0, -1, separator, attrs);
        for (String a2 : attrs) {
            Attribute attr = new Attribute(a2);
            if (!this.isReturnScope && attr.initValue != null) {
                ErrorManager.grammarError(148, this.grammar, this.derivedFromToken, attr.name);
                attr.initValue = null;
            }
            this.attributes.put(attr.name, attr);
        }
    }

    public void addAttribute(String name, String decl) {
        this.attributes.put(name, new Attribute(name, decl));
    }

    public final void defineNamedAction(GrammarAST nameAST, GrammarAST actionAST) {
        String actionName = nameAST.getText();
        GrammarAST a2 = this.actions.get(actionName);
        if (a2 != null) {
            ErrorManager.grammarError(144, this.grammar, nameAST.getToken(), nameAST.getText());
        } else {
            this.actions.put(actionName, actionAST);
        }
    }

    public Attribute getAttribute(String name) {
        return this.attributes.get(name);
    }

    public List<Attribute> getAttributes() {
        ArrayList<Attribute> a2 = new ArrayList<Attribute>();
        a2.addAll(this.attributes.values());
        return a2;
    }

    public Set intersection(AttributeScope other) {
        if (other == null || other.size() == 0 || this.size() == 0) {
            return null;
        }
        HashSet<String> inter = new HashSet<String>();
        Set<String> thisKeys = this.attributes.keySet();
        for (String key : thisKeys) {
            if (other.attributes.get(key) == null) continue;
            inter.add(key);
        }
        if (inter.size() == 0) {
            return null;
        }
        return inter;
    }

    public int size() {
        return this.attributes == null ? 0 : this.attributes.size();
    }

    public String toString() {
        return new StringBuffer().append(this.isDynamicGlobalScope ? "global " : "").append(this.getName()).append(":").append(this.attributes).toString();
    }

    static {
        tokenScope.addAttribute("text", null);
        tokenScope.addAttribute("type", null);
        tokenScope.addAttribute("line", null);
        tokenScope.addAttribute("index", null);
        tokenScope.addAttribute("pos", null);
        tokenScope.addAttribute("channel", null);
        tokenScope.addAttribute("tree", null);
        tokenScope.addAttribute("int", null);
    }
}

