/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.misc;

import java.util.AbstractList;
import org.antlr.misc.Utils;

public class IntArrayList
extends AbstractList
implements Cloneable {
    private static final int DEFAULT_CAPACITY = 10;
    protected int n = 0;
    protected int[] elements = null;

    public IntArrayList() {
        this(10);
    }

    public IntArrayList(int initialCapacity) {
        this.elements = new int[initialCapacity];
    }

    public int set(int i2, int newValue) {
        if (i2 >= this.n) {
            this.setSize(i2);
        }
        int v2 = this.elements[i2];
        this.elements[i2] = newValue;
        return v2;
    }

    public boolean add(int o2) {
        if (this.n >= this.elements.length) {
            this.grow();
        }
        this.elements[this.n] = o2;
        ++this.n;
        return true;
    }

    public void setSize(int newSize) {
        if (newSize >= this.elements.length) {
            this.ensureCapacity(newSize);
        }
        this.n = newSize;
    }

    protected void grow() {
        this.ensureCapacity(this.elements.length * 3 / 2 + 1);
    }

    public boolean contains(int v2) {
        for (int i2 = 0; i2 < this.n; ++i2) {
            int element = this.elements[i2];
            if (element != v2) continue;
            return true;
        }
        return false;
    }

    public void ensureCapacity(int newCapacity) {
        int oldCapacity = this.elements.length;
        if (this.n >= oldCapacity) {
            int[] oldData = this.elements;
            this.elements = new int[newCapacity];
            System.arraycopy(oldData, 0, this.elements, 0, this.n);
        }
    }

    public Object get(int i2) {
        return Utils.integer(this.element(i2));
    }

    public int element(int i2) {
        return this.elements[i2];
    }

    public int[] elements() {
        int[] a2 = new int[this.n];
        System.arraycopy(this.elements, 0, a2, 0, this.n);
        return a2;
    }

    public int size() {
        return this.n;
    }

    public int capacity() {
        return this.elements.length;
    }

    public boolean equals(Object o2) {
        if (o2 == null) {
            return false;
        }
        IntArrayList other = (IntArrayList)o2;
        if (this.size() != other.size()) {
            return false;
        }
        for (int i2 = 0; i2 < this.n; ++i2) {
            if (this.elements[i2] == other.elements[i2]) continue;
            return false;
        }
        return true;
    }

    public Object clone() throws CloneNotSupportedException {
        IntArrayList a2 = (IntArrayList)super.clone();
        a2.n = this.n;
        System.arraycopy(this.elements, 0, a2.elements, 0, this.elements.length);
        return a2;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (int i2 = 0; i2 < this.n; ++i2) {
            if (i2 > 0) {
                buf.append(", ");
            }
            buf.append(this.elements[i2]);
        }
        return buf.toString();
    }
}

