/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.gunit;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.antlr.gunit.GrammarInfo;
import org.antlr.gunit.gUnitTestInput;
import org.antlr.gunit.gUnitTestSuite;
import org.antlr.stringtemplate.CommonGroupLoader;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.StringTemplateGroupLoader;
import org.antlr.stringtemplate.language.AngleBracketTemplateLexer;

public class JUnitCodeGen {
    public GrammarInfo grammarInfo;
    public Map<String, String> ruleWithReturn;
    private final String testsuiteDir;
    private String outputDirectoryPath = ".";
    private static final Handler console = new ConsoleHandler();
    private static final Logger logger = Logger.getLogger(JUnitCodeGen.class.getName());

    public JUnitCodeGen(GrammarInfo grammarInfo, String testsuiteDir) throws ClassNotFoundException {
        this(grammarInfo, JUnitCodeGen.determineClassLoader(), testsuiteDir);
    }

    private static ClassLoader determineClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = JUnitCodeGen.class.getClassLoader();
        }
        return classLoader;
    }

    public JUnitCodeGen(GrammarInfo grammarInfo, ClassLoader classLoader, String testsuiteDir) throws ClassNotFoundException {
        Method[] methods;
        this.grammarInfo = grammarInfo;
        this.testsuiteDir = testsuiteDir;
        this.ruleWithReturn = new HashMap<String, String>();
        Class parserClass = this.locateParserClass(grammarInfo, classLoader);
        Method[] arr$ = methods = parserClass.getDeclaredMethods();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Method method = arr$[i$];
            if (method.getReturnType().getName().equals("void")) continue;
            this.ruleWithReturn.put(method.getName(), method.getReturnType().getName().replace('$', '.'));
        }
    }

    private Class locateParserClass(GrammarInfo grammarInfo, ClassLoader classLoader) throws ClassNotFoundException {
        String parserClassName = grammarInfo.getGrammarName() + "Parser";
        if (grammarInfo.getGrammarPackage() != null) {
            parserClassName = grammarInfo.getGrammarPackage() + "." + parserClassName;
        }
        return classLoader.loadClass(parserClassName);
    }

    public String getOutputDirectoryPath() {
        return this.outputDirectoryPath;
    }

    public void setOutputDirectoryPath(String outputDirectoryPath) {
        this.outputDirectoryPath = outputDirectoryPath;
    }

    public void compile() throws IOException {
        String junitFileName = this.grammarInfo.getTreeGrammarName() != null ? "Test" + this.grammarInfo.getTreeGrammarName() : "Test" + this.grammarInfo.getGrammarName();
        String lexerName = this.grammarInfo.getGrammarName() + "Lexer";
        String parserName = this.grammarInfo.getGrammarName() + "Parser";
        CommonGroupLoader loader = new CommonGroupLoader("org/antlr/gunit", null);
        StringTemplateGroup.registerGroupLoader((StringTemplateGroupLoader)loader);
        StringTemplateGroup.registerDefaultLexer((Class)AngleBracketTemplateLexer.class);
        StringBuffer buf = this.compileToBuffer(junitFileName, lexerName, parserName);
        this.writeTestFile(".", junitFileName + ".java", buf.toString());
    }

    public StringBuffer compileToBuffer(String className, String lexerName, String parserName) {
        StringTemplateGroup group = StringTemplateGroup.loadGroup((String)"junit");
        StringBuffer buf = new StringBuffer();
        buf.append(this.genClassHeader(group, className, lexerName, parserName));
        buf.append(this.genTestRuleMethods(group));
        buf.append("\n\n}");
        return buf;
    }

    protected String genClassHeader(StringTemplateGroup group, String junitFileName, String lexerName, String parserName) {
        StringTemplate classHeaderST = group.getInstanceOf("classHeader");
        if (this.grammarInfo.getTestPackage() != null) {
            classHeaderST.setAttribute("header", (Object)("package " + this.grammarInfo.getTestPackage() + ";"));
        }
        classHeaderST.setAttribute("junitFileName", (Object)junitFileName);
        String lexerPath = null;
        String parserPath = null;
        String treeParserPath = null;
        String packagePath = null;
        boolean isTreeGrammar = false;
        boolean hasPackage = false;
        if (this.grammarInfo.getGrammarPackage() != null) {
            hasPackage = true;
            packagePath = "./" + this.grammarInfo.getGrammarPackage().replace('.', '/');
            lexerPath = this.grammarInfo.getGrammarPackage() + "." + lexerName;
            parserPath = this.grammarInfo.getGrammarPackage() + "." + parserName;
            if (this.grammarInfo.getTreeGrammarName() != null) {
                treeParserPath = this.grammarInfo.getGrammarPackage() + "." + this.grammarInfo.getTreeGrammarName();
                isTreeGrammar = true;
            }
        } else {
            lexerPath = lexerName;
            parserPath = parserName;
            if (this.grammarInfo.getTreeGrammarName() != null) {
                treeParserPath = this.grammarInfo.getTreeGrammarName();
                isTreeGrammar = true;
            }
        }
        String treeAdaptorPath = null;
        boolean hasTreeAdaptor = false;
        if (this.grammarInfo.getAdaptor() != null) {
            hasTreeAdaptor = true;
            treeAdaptorPath = this.grammarInfo.getAdaptor();
        }
        classHeaderST.setAttribute("hasTreeAdaptor", (Object)new Boolean(hasTreeAdaptor));
        classHeaderST.setAttribute("treeAdaptorPath", (Object)treeAdaptorPath);
        classHeaderST.setAttribute("hasPackage", (Object)new Boolean(hasPackage));
        classHeaderST.setAttribute("packagePath", (Object)packagePath);
        classHeaderST.setAttribute("lexerPath", (Object)lexerPath);
        classHeaderST.setAttribute("parserPath", (Object)parserPath);
        classHeaderST.setAttribute("treeParserPath", (Object)treeParserPath);
        classHeaderST.setAttribute("isTreeGrammar", (Object)new Boolean(isTreeGrammar));
        return classHeaderST.toString();
    }

    protected String genTestRuleMethods(StringTemplateGroup group) {
        StringBuffer buf = new StringBuffer();
        if (this.grammarInfo.getTreeGrammarName() != null) {
            this.genTreeMethods(group, buf);
        } else {
            this.genParserMethods(group, buf);
        }
        return buf.toString();
    }

    private void genParserMethods(StringTemplateGroup group, StringBuffer buf) {
        Iterator<gUnitTestSuite> i$ = this.grammarInfo.getRuleTestSuites().iterator();
        while (i$.hasNext()) {
            gUnitTestSuite ts = i$.next();
            int i2 = 0;
            Iterator<gUnitTestInput> i$2 = ts.testSuites.keySet().iterator();
            while (i$2.hasNext()) {
                StringTemplate testRuleMethodST;
                gUnitTestInput input = i$2.next();
                ++i2;
                if (ts.testSuites.get(input).getType() == 4 && this.ruleWithReturn.containsKey(ts.getRuleName())) {
                    testRuleMethodST = group.getInstanceOf("testRuleMethod2");
                    String outputString = ts.testSuites.get(input).getText();
                    testRuleMethodST.setAttribute("methodName", (Object)("test" + this.changeFirstCapital(ts.getRuleName()) + i2));
                    testRuleMethodST.setAttribute("testRuleName", (Object)('\"' + ts.getRuleName() + '\"'));
                    testRuleMethodST.setAttribute("test", (Object)input);
                    testRuleMethodST.setAttribute("returnType", (Object)this.ruleWithReturn.get(ts.getRuleName()));
                    testRuleMethodST.setAttribute("expecting", (Object)outputString);
                } else {
                    String testRuleName = ts.isLexicalRule() ? ts.getLexicalRuleName() : ts.getRuleName();
                    testRuleMethodST = group.getInstanceOf("testRuleMethod");
                    String outputString = ts.testSuites.get(input).getText();
                    testRuleMethodST.setAttribute("isLexicalRule", (Object)new Boolean(ts.isLexicalRule()));
                    testRuleMethodST.setAttribute("methodName", (Object)("test" + this.changeFirstCapital(testRuleName) + i2));
                    testRuleMethodST.setAttribute("testRuleName", (Object)('\"' + testRuleName + '\"'));
                    testRuleMethodST.setAttribute("test", (Object)input);
                    testRuleMethodST.setAttribute("tokenType", (Object)this.getTypeString(ts.testSuites.get(input).getType()));
                    outputString = JUnitCodeGen.normalizeTreeSpec(outputString);
                    if (ts.testSuites.get(input).getType() == 4) {
                        testRuleMethodST.setAttribute("expecting", (Object)outputString);
                    } else if (ts.testSuites.get(input).getType() == 18) {
                        testRuleMethodST.setAttribute("expecting", (Object)outputString);
                    } else {
                        outputString = outputString.replaceAll("\n", "");
                        testRuleMethodST.setAttribute("expecting", (Object)('\"' + JUnitCodeGen.escapeForJava(outputString) + '\"'));
                    }
                }
                buf.append(testRuleMethodST.toString());
            }
        }
    }

    private void genTreeMethods(StringTemplateGroup group, StringBuffer buf) {
        Iterator<gUnitTestSuite> i$ = this.grammarInfo.getRuleTestSuites().iterator();
        while (i$.hasNext()) {
            gUnitTestSuite ts = i$.next();
            int i2 = 0;
            Iterator<gUnitTestInput> i$2 = ts.testSuites.keySet().iterator();
            while (i$2.hasNext()) {
                String outputString;
                StringTemplate testRuleMethodST;
                gUnitTestInput input = i$2.next();
                ++i2;
                if (ts.testSuites.get(input).getType() == 4 && this.ruleWithReturn.containsKey(ts.getTreeRuleName())) {
                    testRuleMethodST = group.getInstanceOf("testTreeRuleMethod2");
                    outputString = ts.testSuites.get(input).getText();
                    testRuleMethodST.setAttribute("methodName", (Object)("test" + this.changeFirstCapital(ts.getTreeRuleName()) + "_walks_" + this.changeFirstCapital(ts.getRuleName()) + i2));
                    testRuleMethodST.setAttribute("testTreeRuleName", (Object)('\"' + ts.getTreeRuleName() + '\"'));
                    testRuleMethodST.setAttribute("testRuleName", (Object)('\"' + ts.getRuleName() + '\"'));
                    testRuleMethodST.setAttribute("test", (Object)input);
                    testRuleMethodST.setAttribute("returnType", (Object)this.ruleWithReturn.get(ts.getTreeRuleName()));
                    testRuleMethodST.setAttribute("expecting", (Object)outputString);
                } else {
                    testRuleMethodST = group.getInstanceOf("testTreeRuleMethod");
                    outputString = ts.testSuites.get(input).getText();
                    testRuleMethodST.setAttribute("methodName", (Object)("test" + this.changeFirstCapital(ts.getTreeRuleName()) + "_walks_" + this.changeFirstCapital(ts.getRuleName()) + i2));
                    testRuleMethodST.setAttribute("testTreeRuleName", (Object)('\"' + ts.getTreeRuleName() + '\"'));
                    testRuleMethodST.setAttribute("testRuleName", (Object)('\"' + ts.getRuleName() + '\"'));
                    testRuleMethodST.setAttribute("test", (Object)input);
                    testRuleMethodST.setAttribute("tokenType", (Object)this.getTypeString(ts.testSuites.get(input).getType()));
                    if (ts.testSuites.get(input).getType() == 4) {
                        testRuleMethodST.setAttribute("expecting", (Object)outputString);
                    } else if (ts.testSuites.get(input).getType() == 18) {
                        testRuleMethodST.setAttribute("expecting", (Object)outputString);
                    } else {
                        testRuleMethodST.setAttribute("expecting", (Object)('\"' + JUnitCodeGen.escapeForJava(outputString) + '\"'));
                    }
                }
                buf.append(testRuleMethodST.toString());
            }
        }
    }

    public String getTypeString(int type) {
        String typeText;
        switch (type) {
            case 16: {
                typeText = "org.antlr.gunit.gUnitParser.OK";
                break;
            }
            case 10: {
                typeText = "org.antlr.gunit.gUnitParser.FAIL";
                break;
            }
            case 21: {
                typeText = "org.antlr.gunit.gUnitParser.STRING";
                break;
            }
            case 12: {
                typeText = "org.antlr.gunit.gUnitParser.ML_STRING";
                break;
            }
            case 18: {
                typeText = "org.antlr.gunit.gUnitParser.RETVAL";
                break;
            }
            case 5: {
                typeText = "org.antlr.gunit.gUnitParser.AST";
                break;
            }
            default: {
                typeText = "org.antlr.gunit.gUnitParser.EOF";
            }
        }
        return typeText;
    }

    protected void writeTestFile(String dir, String fileName, String content) {
        try {
            File f2 = new File(dir, fileName);
            FileWriter w2 = new FileWriter(f2);
            BufferedWriter bw = new BufferedWriter(w2);
            bw.write(content);
            bw.close();
            w2.close();
        }
        catch (IOException ioe) {
            logger.log(Level.SEVERE, "can't write file", ioe);
        }
    }

    public static String escapeForJava(String inputString) {
        inputString = inputString.replace("\\", "\\\\");
        inputString = inputString.replace("\"", "\\\"");
        inputString = inputString.replace("\n", "\\n").replace("\t", "\\t").replace("\r", "\\r").replace("\b", "\\b").replace("\f", "\\f");
        return inputString;
    }

    protected String changeFirstCapital(String ruleName) {
        String firstChar = String.valueOf(ruleName.charAt(0));
        return firstChar.toUpperCase() + ruleName.substring(1);
    }

    public static String normalizeTreeSpec(String t2) {
        ArrayList<String> words = new ArrayList<String>();
        int i2 = 0;
        StringBuilder word = new StringBuilder();
        while (i2 < t2.length()) {
            if (t2.charAt(i2) == '(' || t2.charAt(i2) == ')') {
                if (word.length() > 0) {
                    words.add(word.toString());
                    word.setLength(0);
                }
                words.add(String.valueOf(t2.charAt(i2)));
                ++i2;
                continue;
            }
            if (Character.isWhitespace(t2.charAt(i2))) {
                if (word.length() > 0) {
                    words.add(word.toString());
                    word.setLength(0);
                }
                ++i2;
                continue;
            }
            if (t2.charAt(i2) == '\"' && i2 - 1 >= 0 && (t2.charAt(i2 - 1) == '(' || Character.isWhitespace(t2.charAt(i2 - 1)))) {
                ++i2;
                while (i2 < t2.length() && t2.charAt(i2) != '\"') {
                    if (t2.charAt(i2) == '\\' && i2 + 1 < t2.length() && t2.charAt(i2 + 1) == '\"') {
                        word.append('\"');
                        i2 += 2;
                        continue;
                    }
                    word.append(t2.charAt(i2));
                    ++i2;
                }
                ++i2;
                words.add(word.toString());
                word.setLength(0);
                continue;
            }
            word.append(t2.charAt(i2));
            ++i2;
        }
        if (word.length() > 0) {
            words.add(word.toString());
        }
        StringBuilder buf = new StringBuilder();
        for (int j2 = 0; j2 < words.size(); ++j2) {
            if (j2 > 0 && !((String)words.get(j2)).equals(")") && !((String)words.get(j2 - 1)).equals("(")) {
                buf.append(' ');
            }
            buf.append((String)words.get(j2));
        }
        return buf.toString();
    }

    static {
        logger.addHandler(console);
    }
}

