/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.codegen;

import java.util.ArrayList;
import java.util.List;
import org.antlr.codegen.CodeGenerator;
import org.antlr.codegen.Target;
import org.antlr.runtime.Token;
import org.antlr.tool.Grammar;

public class PythonTarget
extends Target {
    public String getTokenTypeAsTargetLabel(CodeGenerator generator, int ttype) {
        if (ttype >= 0 && ttype <= 3) {
            return String.valueOf(ttype);
        }
        String name = generator.grammar.getTokenDisplayName(ttype);
        if (name.charAt(0) == '\'') {
            return String.valueOf(ttype);
        }
        return name;
    }

    public String getTargetCharLiteralFromANTLRCharLiteral(CodeGenerator generator, String literal) {
        int c2 = Grammar.getCharValueFromGrammarCharLiteral(literal);
        return String.valueOf(c2);
    }

    private List splitLines(String text) {
        ArrayList<String> l2 = new ArrayList<String>();
        int idx = 0;
        while (true) {
            int eol;
            if ((eol = text.indexOf("\n", idx)) == -1) break;
            l2.add(text.substring(idx, eol + 1));
            idx = eol + 1;
        }
        l2.add(text.substring(idx));
        return l2;
    }

    public List postProcessAction(List chunks, Token actionToken) {
        int lastChunk;
        ArrayList nChunks = new ArrayList();
        for (int i2 = 0; i2 < chunks.size(); ++i2) {
            Object chunk = chunks.get(i2);
            if (chunk instanceof String) {
                int j2;
                String text = (String)chunks.get(i2);
                if (nChunks.size() == 0 && actionToken.getCharPositionInLine() >= 0) {
                    String ws = "";
                    for (j2 = 0; j2 < actionToken.getCharPositionInLine(); ++j2) {
                        ws = ws + " ";
                    }
                    text = ws + text;
                }
                List parts = this.splitLines(text);
                for (j2 = 0; j2 < parts.size(); ++j2) {
                    chunk = parts.get(j2);
                    nChunks.add(chunk);
                }
                continue;
            }
            if (nChunks.size() == 0 && actionToken.getCharPositionInLine() >= 0) {
                String ws = "";
                for (int j3 = 0; j3 <= actionToken.getCharPositionInLine(); ++j3) {
                    ws = ws + " ";
                }
                nChunks.add(ws);
            }
            nChunks.add(chunk);
        }
        int lineNo = actionToken.getLine();
        int col = 0;
        for (lastChunk = nChunks.size() - 1; lastChunk > 0 && nChunks.get(lastChunk) instanceof String && ((String)nChunks.get(lastChunk)).trim().length() == 0; --lastChunk) {
        }
        for (int firstChunk = 0; firstChunk <= lastChunk && nChunks.get(firstChunk) instanceof String && ((String)nChunks.get(firstChunk)).trim().length() == 0 && ((String)nChunks.get(firstChunk)).endsWith("\n"); ++firstChunk) {
            ++lineNo;
        }
        int indent = -1;
        for (int i3 = firstChunk; i3 <= lastChunk; ++i3) {
            Object chunk = nChunks.get(i3);
            if (chunk instanceof String) {
                String text = (String)chunk;
                if (col == 0) {
                    int j4;
                    if (indent == -1) {
                        indent = 0;
                        for (j4 = 0; j4 < text.length() && Character.isWhitespace(text.charAt(j4)); ++j4) {
                            ++indent;
                        }
                    }
                    if (text.length() >= indent) {
                        for (j4 = 0; j4 < indent; ++j4) {
                            if (Character.isWhitespace(text.charAt(j4))) continue;
                            System.err.println("Warning: badly indented line " + lineNo + " in action:");
                            System.err.println(text);
                            break;
                        }
                        nChunks.set(i3, text.substring(j4));
                    } else if (text.trim().length() > 0) {
                        System.err.println("Warning: badly indented line " + lineNo + " in action:");
                        System.err.println(text);
                    }
                }
                if (text.endsWith("\n")) {
                    ++lineNo;
                    col = 0;
                    continue;
                }
                col += text.length();
                continue;
            }
            ++col;
        }
        return nChunks;
    }
}

