/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.analysis;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.antlr.analysis.DFAState;
import org.antlr.analysis.DecisionProbe;
import org.antlr.analysis.Label;
import org.antlr.analysis.NFA;
import org.antlr.analysis.NFAState;
import org.antlr.analysis.NFAToDFAConverter;
import org.antlr.analysis.NonLLStarDecisionException;
import org.antlr.analysis.SemanticContext;
import org.antlr.analysis.Transition;
import org.antlr.codegen.CodeGenerator;
import org.antlr.misc.IntSet;
import org.antlr.misc.IntervalSet;
import org.antlr.misc.Utils;
import org.antlr.runtime.IntStream;
import org.antlr.tool.ErrorManager;
import org.antlr.tool.FASerializer;
import org.antlr.tool.GrammarAST;
import org.antlr.tool.Interpreter;
import org.antlr.tool.Rule;
import org.stringtemplate.v4.ST;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DFA {
    public static final int REACHABLE_UNKNOWN = -2;
    public static final int REACHABLE_BUSY = -1;
    public static final int REACHABLE_NO = 0;
    public static final int REACHABLE_YES = 1;
    public static final int CYCLIC_UNKNOWN = -2;
    public static final int CYCLIC_BUSY = -1;
    public static final int CYCLIC_DONE = 0;
    public static int MAX_TIME_PER_DFA_CREATION = 1000;
    public static int MAX_STATE_TRANSITIONS_FOR_TABLE = 65534;
    public DFAState startState;
    public int decisionNumber;
    public NFAState decisionNFAStartState;
    public String description;
    protected Map<DFAState, DFAState> uniqueStates;
    protected Vector<DFAState> states;
    protected int stateCounter;
    protected int numberOfStates;
    protected int user_k;
    protected int max_k;
    protected boolean reduced;
    protected boolean cyclic;
    public boolean predicateVisible;
    public boolean hasPredicateBlockedByAction;
    protected List<Integer> unreachableAlts;
    protected int nAlts;
    protected DFAState[] altToAcceptState;
    public IntSet recursiveAltSet;
    public NFA nfa;
    protected NFAToDFAConverter nfaConverter;
    public DecisionProbe probe;
    public Map edgeTransitionClassMap;
    protected int edgeTransitionClass;
    public List specialStates;
    public List specialStateSTs;
    public Vector accept;
    public Vector eot;
    public Vector eof;
    public Vector min;
    public Vector max;
    public Vector special;
    public Vector transition;
    public Vector transitionEdgeTables;
    protected int uniqueCompressedSpecialStateNum;
    protected CodeGenerator generator;

    protected DFA() {
        this.decisionNumber = 0;
        this.uniqueStates = new HashMap<DFAState, DFAState>();
        this.states = new Vector();
        this.stateCounter = 0;
        this.numberOfStates = 0;
        this.user_k = -1;
        this.max_k = -1;
        this.reduced = true;
        this.cyclic = false;
        this.predicateVisible = false;
        this.hasPredicateBlockedByAction = false;
        this.nAlts = 0;
        this.recursiveAltSet = new IntervalSet();
        this.probe = new DecisionProbe(this);
        this.edgeTransitionClassMap = new LinkedHashMap();
        this.edgeTransitionClass = 0;
        this.uniqueCompressedSpecialStateNum = 0;
        this.generator = null;
    }

    public DFA(int decisionNumber, NFAState decisionStartState) {
        block3: {
            this.decisionNumber = 0;
            this.uniqueStates = new HashMap<DFAState, DFAState>();
            this.states = new Vector();
            this.stateCounter = 0;
            this.numberOfStates = 0;
            this.user_k = -1;
            this.max_k = -1;
            this.reduced = true;
            this.cyclic = false;
            this.predicateVisible = false;
            this.hasPredicateBlockedByAction = false;
            this.nAlts = 0;
            this.recursiveAltSet = new IntervalSet();
            this.probe = new DecisionProbe(this);
            this.edgeTransitionClassMap = new LinkedHashMap();
            this.edgeTransitionClass = 0;
            this.uniqueCompressedSpecialStateNum = 0;
            this.generator = null;
            this.decisionNumber = decisionNumber;
            this.decisionNFAStartState = decisionStartState;
            this.nfa = decisionStartState.nfa;
            this.nAlts = this.nfa.grammar.getNumberOfAltsForDecisionNFA(decisionStartState);
            this.initAltRelatedInfo();
            this.nfaConverter = new NFAToDFAConverter(this);
            try {
                this.nfaConverter.convert();
                this.verify();
                if (!this.probe.isDeterministic() || this.probe.analysisOverflowed()) {
                    this.probe.issueWarnings();
                }
                this.resetStateNumbersToBeContiguous();
            }
            catch (NonLLStarDecisionException nonLL) {
                this.probe.reportNonLLStarDecision(this);
                if (this.okToRetryDFAWithK1()) break block3;
                this.probe.issueWarnings();
            }
        }
    }

    public void resetStateNumbersToBeContiguous() {
        if (this.getUserMaxLookahead() > 0) {
            return;
        }
        int snum = 0;
        for (int i2 = 0; i2 <= this.getMaxStateNumber(); ++i2) {
            boolean alreadyRenumbered;
            DFAState s2 = this.getState(i2);
            if (s2 == null) continue;
            boolean bl = alreadyRenumbered = s2.stateNumber < i2;
            if (alreadyRenumbered) continue;
            s2.stateNumber = snum++;
        }
        if (snum != this.getNumberOfStates()) {
            ErrorManager.internalError(new StringBuffer().append("DFA ").append(this.decisionNumber).append(": ").append(this.decisionNFAStartState.getDescription()).append(" num unique states ").append(this.getNumberOfStates()).append("!= num renumbered states ").append(snum).toString());
        }
    }

    public List getJavaCompressedAccept() {
        return this.getRunLengthEncoding(this.accept);
    }

    public List getJavaCompressedEOT() {
        return this.getRunLengthEncoding(this.eot);
    }

    public List getJavaCompressedEOF() {
        return this.getRunLengthEncoding(this.eof);
    }

    public List getJavaCompressedMin() {
        return this.getRunLengthEncoding(this.min);
    }

    public List getJavaCompressedMax() {
        return this.getRunLengthEncoding(this.max);
    }

    public List getJavaCompressedSpecial() {
        return this.getRunLengthEncoding(this.special);
    }

    public List getJavaCompressedTransition() {
        if (this.transition == null || this.transition.size() == 0) {
            return null;
        }
        ArrayList<List> encoded = new ArrayList<List>(this.transition.size());
        for (int i2 = 0; i2 < this.transition.size(); ++i2) {
            Vector transitionsForState = (Vector)this.transition.elementAt(i2);
            encoded.add(this.getRunLengthEncoding(transitionsForState));
        }
        return encoded;
    }

    public List getRunLengthEncoding(List data) {
        int n2;
        if (data == null || data.size() == 0) {
            ArrayList<String> empty = new ArrayList<String>();
            empty.add("");
            return empty;
        }
        int size = Math.max(2, data.size() / 2);
        ArrayList<String> encoded = new ArrayList<String>(size);
        Integer emptyValue = Utils.integer(-1);
        for (int i2 = 0; i2 < data.size(); i2 += n2) {
            Integer I2 = (Integer)data.get(i2);
            if (I2 == null) {
                I2 = emptyValue;
            }
            n2 = 0;
            for (int j2 = i2; j2 < data.size(); ++j2) {
                Integer v2 = (Integer)data.get(j2);
                if (v2 == null) {
                    v2 = emptyValue;
                }
                if (!I2.equals(v2)) break;
                ++n2;
            }
            encoded.add(this.generator.target.encodeIntAsCharEscape((char)n2));
            encoded.add(this.generator.target.encodeIntAsCharEscape((char)I2.intValue()));
        }
        return encoded;
    }

    public void createStateTables(CodeGenerator generator) {
        this.generator = generator;
        this.description = this.getNFADecisionStartState().getDescription();
        this.description = generator.target.getTargetStringLiteralFromString(this.description);
        this.special = new Vector(this.getNumberOfStates());
        this.special.setSize(this.getNumberOfStates());
        this.specialStates = new ArrayList();
        this.specialStateSTs = new ArrayList();
        this.accept = new Vector(this.getNumberOfStates());
        this.accept.setSize(this.getNumberOfStates());
        this.eot = new Vector(this.getNumberOfStates());
        this.eot.setSize(this.getNumberOfStates());
        this.eof = new Vector(this.getNumberOfStates());
        this.eof.setSize(this.getNumberOfStates());
        this.min = new Vector(this.getNumberOfStates());
        this.min.setSize(this.getNumberOfStates());
        this.max = new Vector(this.getNumberOfStates());
        this.max.setSize(this.getNumberOfStates());
        this.transition = new Vector(this.getNumberOfStates());
        this.transition.setSize(this.getNumberOfStates());
        this.transitionEdgeTables = new Vector(this.getNumberOfStates());
        this.transitionEdgeTables.setSize(this.getNumberOfStates());
        Iterator<DFAState> it = null;
        it = this.getUserMaxLookahead() > 0 ? this.states.iterator() : this.getUniqueStates().values().iterator();
        while (it.hasNext()) {
            DFAState s2 = it.next();
            if (s2 == null) continue;
            if (s2.isAcceptState()) {
                this.accept.set(s2.stateNumber, Utils.integer(s2.getUniquelyPredictedAlt()));
                continue;
            }
            this.createMinMaxTables(s2);
            this.createTransitionTableEntryForState(s2);
            this.createSpecialTable(s2);
            this.createEOTAndEOFTables(s2);
        }
        for (int i2 = 0; i2 < this.specialStates.size(); ++i2) {
            DFAState ss = (DFAState)this.specialStates.get(i2);
            ST stateST = generator.generateSpecialState(ss);
            this.specialStateSTs.add(stateST);
        }
    }

    protected void createMinMaxTables(DFAState s2) {
        int smin = 65536;
        int smax = -3;
        for (int j2 = 0; j2 < s2.getNumberOfTransitions(); ++j2) {
            Transition edge = s2.transition(j2);
            Label label = edge.label;
            if (label.isAtom()) {
                if (label.getAtom() < 0) continue;
                if (label.getAtom() < smin) {
                    smin = label.getAtom();
                }
                if (label.getAtom() <= smax) continue;
                smax = label.getAtom();
                continue;
            }
            if (!label.isSet()) continue;
            IntervalSet labels = (IntervalSet)label.getSet();
            int lmin = labels.getMinElement();
            if (lmin < smin && lmin >= 0) {
                smin = labels.getMinElement();
            }
            if (labels.getMaxElement() <= smax) continue;
            smax = labels.getMaxElement();
        }
        if (smax < 0) {
            smin = 0;
            smax = 0;
        }
        this.min.set(s2.stateNumber, Utils.integer((char)smin));
        this.max.set(s2.stateNumber, Utils.integer((char)smax));
        if (smax < 0 || smin > 65535 || smin < 0) {
            ErrorManager.internalError(new StringBuffer().append("messed up: min=").append(this.min).append(", max=").append(this.max).toString());
        }
    }

    protected void createTransitionTableEntryForState(DFAState s2) {
        int smax = (Integer)this.max.get(s2.stateNumber);
        int smin = (Integer)this.min.get(s2.stateNumber);
        Vector<Integer> stateTransitions = new Vector<Integer>(smax - smin + 1);
        stateTransitions.setSize(smax - smin + 1);
        this.transition.set(s2.stateNumber, stateTransitions);
        for (int j2 = 0; j2 < s2.getNumberOfTransitions(); ++j2) {
            Transition edge = s2.transition(j2);
            Label label = edge.label;
            if (label.isAtom() && label.getAtom() >= 0) {
                int labelIndex = label.getAtom() - smin;
                stateTransitions.set(labelIndex, Utils.integer(edge.target.stateNumber));
                continue;
            }
            if (!label.isSet()) continue;
            IntervalSet labels = (IntervalSet)label.getSet();
            int[] atoms = labels.toArray();
            for (int a2 = 0; a2 < atoms.length; ++a2) {
                if (atoms[a2] < 0) continue;
                int labelIndex = atoms[a2] - smin;
                stateTransitions.set(labelIndex, Utils.integer(edge.target.stateNumber));
            }
        }
        Integer edgeClass = (Integer)this.edgeTransitionClassMap.get(stateTransitions);
        if (edgeClass != null) {
            this.transitionEdgeTables.set(s2.stateNumber, edgeClass);
        } else {
            edgeClass = Utils.integer(this.edgeTransitionClass);
            this.transitionEdgeTables.set(s2.stateNumber, edgeClass);
            this.edgeTransitionClassMap.put(stateTransitions, edgeClass);
            ++this.edgeTransitionClass;
        }
    }

    protected void createEOTAndEOFTables(DFAState s2) {
        for (int j2 = 0; j2 < s2.getNumberOfTransitions(); ++j2) {
            Transition edge = s2.transition(j2);
            Label label = edge.label;
            if (label.isAtom()) {
                if (label.getAtom() == -2) {
                    this.eot.set(s2.stateNumber, Utils.integer(edge.target.stateNumber));
                    continue;
                }
                if (label.getAtom() != -1) continue;
                this.eof.set(s2.stateNumber, Utils.integer(edge.target.stateNumber));
                continue;
            }
            if (!label.isSet()) continue;
            IntervalSet labels = (IntervalSet)label.getSet();
            int[] atoms = labels.toArray();
            for (int a2 = 0; a2 < atoms.length; ++a2) {
                if (atoms[a2] == -2) {
                    this.eot.set(s2.stateNumber, Utils.integer(edge.target.stateNumber));
                    continue;
                }
                if (atoms[a2] != -1) continue;
                this.eof.set(s2.stateNumber, Utils.integer(edge.target.stateNumber));
            }
        }
    }

    protected void createSpecialTable(DFAState s2) {
        boolean hasSemPred = false;
        for (int j2 = 0; j2 < s2.getNumberOfTransitions(); ++j2) {
            Transition edge = s2.transition(j2);
            Label label = edge.label;
            if (!label.isSemanticPredicate() && ((DFAState)edge.target).getGatedPredicatesInNFAConfigurations() == null) continue;
            hasSemPred = true;
            break;
        }
        int smax = (Integer)this.max.get(s2.stateNumber);
        int smin = (Integer)this.min.get(s2.stateNumber);
        if (hasSemPred || smax - smin > MAX_STATE_TRANSITIONS_FOR_TABLE) {
            this.special.set(s2.stateNumber, Utils.integer(this.uniqueCompressedSpecialStateNum));
            ++this.uniqueCompressedSpecialStateNum;
            this.specialStates.add(s2);
        } else {
            this.special.set(s2.stateNumber, Utils.integer(-1));
        }
    }

    public int predict(IntStream input) {
        Interpreter interp = new Interpreter(this.nfa.grammar, input);
        return interp.predict(this);
    }

    protected DFAState addState(DFAState d2) {
        if (this.getUserMaxLookahead() > 0) {
            return d2;
        }
        DFAState existing = this.uniqueStates.get(d2);
        if (existing != null) {
            return existing;
        }
        this.uniqueStates.put(d2, d2);
        ++this.numberOfStates;
        return d2;
    }

    public void removeState(DFAState d2) {
        DFAState it = this.uniqueStates.remove(d2);
        if (it != null) {
            --this.numberOfStates;
        }
    }

    public Map<DFAState, DFAState> getUniqueStates() {
        return this.uniqueStates;
    }

    public int getMaxStateNumber() {
        return this.states.size() - 1;
    }

    public DFAState getState(int stateNumber) {
        return this.states.get(stateNumber);
    }

    public void setState(int stateNumber, DFAState d2) {
        this.states.set(stateNumber, d2);
    }

    public boolean isReduced() {
        return this.reduced;
    }

    public boolean isCyclic() {
        return this.cyclic && this.getUserMaxLookahead() == 0;
    }

    public boolean isClassicDFA() {
        return !this.isCyclic() && !this.nfa.grammar.decisionsWhoseDFAsUsesSemPreds.contains(this) && !this.nfa.grammar.decisionsWhoseDFAsUsesSynPreds.contains(this);
    }

    public boolean canInlineDecision() {
        return !this.isCyclic() && !this.probe.isNonLLStarDecision() && this.getNumberOfStates() < CodeGenerator.MAX_ACYCLIC_DFA_STATES_INLINE;
    }

    public boolean isTokensRuleDecision() {
        if (this.nfa.grammar.type != 1) {
            return false;
        }
        NFAState nfaStart = this.getNFADecisionStartState();
        Rule r2 = this.nfa.grammar.getLocallyDefinedRule("Tokens");
        NFAState TokensRuleStart = r2.startState;
        NFAState TokensDecisionStart = (NFAState)TokensRuleStart.transition[0].target;
        return nfaStart == TokensDecisionStart;
    }

    public int getUserMaxLookahead() {
        if (this.user_k >= 0) {
            return this.user_k;
        }
        this.user_k = this.nfa.grammar.getUserMaxLookahead(this.decisionNumber);
        return this.user_k;
    }

    public boolean getAutoBacktrackMode() {
        return this.nfa.grammar.getAutoBacktrackMode(this.decisionNumber);
    }

    public void setUserMaxLookahead(int k2) {
        this.user_k = k2;
    }

    public int getMaxLookaheadDepth() {
        if (this.hasCycle()) {
            return Integer.MAX_VALUE;
        }
        return this._getMaxLookaheadDepth(this.startState, 0);
    }

    int _getMaxLookaheadDepth(DFAState d2, int depth) {
        int max = depth;
        for (int i2 = 0; i2 < d2.getNumberOfTransitions(); ++i2) {
            Transition t2 = d2.transition(i2);
            if (t2.isSemanticPredicate()) continue;
            DFAState edgeTarget = (DFAState)t2.target;
            int m2 = this._getMaxLookaheadDepth(edgeTarget, depth + 1);
            max = Math.max(max, m2);
        }
        return max;
    }

    public boolean hasSynPred() {
        boolean has = this._hasSynPred(this.startState, new HashSet<DFAState>());
        return has;
    }

    public boolean getHasSynPred() {
        return this.hasSynPred();
    }

    boolean _hasSynPred(DFAState d2, Set<DFAState> busy) {
        busy.add(d2);
        for (int i2 = 0; i2 < d2.getNumberOfTransitions(); ++i2) {
            SemanticContext ctx;
            Transition t2 = d2.transition(i2);
            if (t2.isSemanticPredicate() && (ctx = t2.label.getSemanticContext()).isSyntacticPredicate()) {
                return true;
            }
            DFAState edgeTarget = (DFAState)t2.target;
            if (busy.contains(edgeTarget) || !this._hasSynPred(edgeTarget, busy)) continue;
            return true;
        }
        return false;
    }

    public boolean hasSemPred() {
        boolean has = this._hasSemPred(this.startState, new HashSet<DFAState>());
        return has;
    }

    boolean _hasSemPred(DFAState d2, Set<DFAState> busy) {
        busy.add(d2);
        for (int i2 = 0; i2 < d2.getNumberOfTransitions(); ++i2) {
            SemanticContext ctx;
            Transition t2 = d2.transition(i2);
            if (t2.isSemanticPredicate() && (ctx = t2.label.getSemanticContext()).hasUserSemanticPredicate()) {
                return true;
            }
            DFAState edgeTarget = (DFAState)t2.target;
            if (busy.contains(edgeTarget) || !this._hasSemPred(edgeTarget, busy)) continue;
            return true;
        }
        return false;
    }

    public boolean hasCycle() {
        boolean cyclic = this._hasCycle(this.startState, new HashMap<DFAState, Integer>());
        return cyclic;
    }

    boolean _hasCycle(DFAState d2, Map<DFAState, Integer> busy) {
        busy.put(d2, new Integer(-1));
        for (int i2 = 0; i2 < d2.getNumberOfTransitions(); ++i2) {
            Transition t2 = d2.transition(i2);
            DFAState target = (DFAState)t2.target;
            int cond = -2;
            if (busy.get(target) != null) {
                cond = busy.get(target);
            }
            if (cond == -1) {
                return true;
            }
            if (cond == 0 || !this._hasCycle(target, busy)) continue;
            return true;
        }
        busy.put(d2, new Integer(0));
        return false;
    }

    public List<Integer> getUnreachableAlts() {
        return this.unreachableAlts;
    }

    public void verify() {
        this.doesStateReachAcceptState(this.startState);
    }

    protected boolean doesStateReachAcceptState(DFAState d2) {
        if (d2.isAcceptState()) {
            d2.setAcceptStateReachable(1);
            int predicts = d2.getUniquelyPredictedAlt();
            this.unreachableAlts.remove(Utils.integer(predicts));
            return true;
        }
        d2.setAcceptStateReachable(-1);
        boolean anEdgeReachesAcceptState = false;
        for (int i2 = 0; i2 < d2.getNumberOfTransitions(); ++i2) {
            Transition t2 = d2.transition(i2);
            DFAState edgeTarget = (DFAState)t2.target;
            int targetStatus = edgeTarget.getAcceptStateReachable();
            if (targetStatus == -1) {
                this.cyclic = true;
                continue;
            }
            if (targetStatus == 1) {
                anEdgeReachesAcceptState = true;
                continue;
            }
            if (targetStatus == 0 || !this.doesStateReachAcceptState(edgeTarget)) continue;
            anEdgeReachesAcceptState = true;
        }
        if (anEdgeReachesAcceptState) {
            d2.setAcceptStateReachable(1);
        } else {
            d2.setAcceptStateReachable(0);
            this.reduced = false;
        }
        return anEdgeReachesAcceptState;
    }

    public void findAllGatedSynPredsUsedInDFAAcceptStates() {
        int nAlts = this.getNumberOfAlts();
        for (int i2 = 1; i2 <= nAlts; ++i2) {
            Set synpreds;
            DFAState a2 = this.getAcceptState(i2);
            if (a2 == null || (synpreds = a2.getGatedSyntacticPredicatesInNFAConfigurations()) == null) continue;
            for (SemanticContext semctx : synpreds) {
                this.nfa.grammar.synPredUsedInDFA(this, semctx);
            }
        }
    }

    public NFAState getNFADecisionStartState() {
        return this.decisionNFAStartState;
    }

    public DFAState getAcceptState(int alt) {
        return this.altToAcceptState[alt];
    }

    public void setAcceptState(int alt, DFAState acceptState) {
        this.altToAcceptState[alt] = acceptState;
    }

    public String getDescription() {
        return this.description;
    }

    public int getDecisionNumber() {
        return this.decisionNFAStartState.getDecisionNumber();
    }

    public boolean okToRetryDFAWithK1() {
        boolean nonLLStarOrOverflowAndPredicateVisible = (this.probe.isNonLLStarDecision() || this.probe.analysisOverflowed()) && this.predicateVisible;
        return this.getUserMaxLookahead() != 1 && nonLLStarOrOverflowAndPredicateVisible;
    }

    public String getReasonForFailure() {
        StringBuffer buf = new StringBuffer();
        if (this.probe.isNonLLStarDecision()) {
            buf.append("non-LL(*)");
            if (this.predicateVisible) {
                buf.append(" && predicate visible");
            }
        }
        if (this.probe.analysisOverflowed()) {
            buf.append("recursion overflow");
            if (this.predicateVisible) {
                buf.append(" && predicate visible");
            }
        }
        buf.append("\n");
        return buf.toString();
    }

    public GrammarAST getDecisionASTNode() {
        return this.decisionNFAStartState.associatedASTNode;
    }

    public boolean isGreedy() {
        GrammarAST blockAST = this.nfa.grammar.getDecisionBlockAST(this.decisionNumber);
        Object v2 = this.nfa.grammar.getBlockOption(blockAST, "greedy");
        return v2 == null || !v2.equals("false");
    }

    public DFAState newState() {
        DFAState n2 = new DFAState(this);
        n2.stateNumber = this.stateCounter++;
        this.states.setSize(n2.stateNumber + 1);
        this.states.set(n2.stateNumber, n2);
        return n2;
    }

    public int getNumberOfStates() {
        if (this.getUserMaxLookahead() > 0) {
            return this.states.size();
        }
        return this.numberOfStates;
    }

    public int getNumberOfAlts() {
        return this.nAlts;
    }

    protected void initAltRelatedInfo() {
        this.unreachableAlts = new LinkedList<Integer>();
        for (int i2 = 1; i2 <= this.nAlts; ++i2) {
            this.unreachableAlts.add(Utils.integer(i2));
        }
        this.altToAcceptState = new DFAState[this.nAlts + 1];
    }

    public String toString() {
        FASerializer serializer = new FASerializer(this.nfa.grammar);
        if (this.startState == null) {
            return "";
        }
        return serializer.serialize(this.startState, false);
    }
}

