/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.help.search;

import com.sun.java.help.search.ByteArrayDecompressor;
import com.sun.java.help.search.Compressor;
import com.sun.java.help.search.IntegerArray;
import com.sun.java.help.search.StreamDecompressor;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

class DocumentLists {
    private static final int RANGE = 1024;
    private static final int NConcepts = 16;
    private static final int K = 3;
    private final IntegerArray[] _arrays = new IntegerArray[1024];
    private int _minConcept = 0;
    private int _limit = 1024;
    private final IntegerArray _concepts = new IntegerArray();
    private final IntegerArray _offsets = new IntegerArray();
    private final Compressor _compr = new Compressor();
    private final IntegerArray _diffs = new IntegerArray();
    private final ByteArrayDecompressor _decmp = new ByteArrayDecompressor(null, 0);
    private DataOutputStream _mainFile;
    private int _heapSize = 0;
    private MicroIndex[] _heap;
    private boolean debug = false;

    private DocumentLists(String string) throws Exception {
        int n2 = 0;
        while (n2 < 1024) {
            this._arrays[n2] = new IntegerArray();
            ++n2;
        }
        this._mainFile = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(string + "DOCS")));
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string + "OFFSETS"));
        int n3 = ((InputStream)bufferedInputStream).read();
        IntegerArray integerArray = new IntegerArray(4096);
        StreamDecompressor streamDecompressor = new StreamDecompressor(bufferedInputStream);
        streamDecompressor.ascDecode(n3, integerArray);
        int n4 = ((InputStream)bufferedInputStream).read();
        IntegerArray integerArray2 = new IntegerArray(integerArray.cardinality() + 1);
        StreamDecompressor streamDecompressor2 = new StreamDecompressor(bufferedInputStream);
        streamDecompressor2.ascDecode(n4, integerArray2);
        ((InputStream)bufferedInputStream).close();
        File file = new File(string + "POSITIONS");
        byte[] byArray = new byte[(int)file.length()];
        FileInputStream fileInputStream = new FileInputStream(file);
        fileInputStream.read(byArray);
        fileInputStream.close();
        this._heapSize = integerArray.cardinality();
        this._heap = new MicroIndex[this._heapSize];
        int n5 = 0;
        while (n5 < integerArray.cardinality()) {
            this._heap[n5] = new MicroIndex(n5, byArray, integerArray2.at(n5));
            ++n5;
        }
        this.debug(integerArray.cardinality() + " documents");
        int n6 = this._heapSize / 2;
        while (n6 >= 0) {
            this.heapify(n6);
            --n6;
        }
        while (true) {
            if (this._heap[0].process(this)) {
                this.heapify(0);
                continue;
            }
            if (this._heapSize <= 1) break;
            this._heap[0] = this._heap[--this._heapSize];
            this.heapify(0);
        }
        this.flush();
        this._mainFile.close();
        DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(string + "DOCS.TAB")));
        dataOutputStream.write(this._compr.compressAscending(this._concepts));
        this._compr.write(dataOutputStream);
        this._compr.clear();
        dataOutputStream.write(this._compr.minimize(this._offsets, 3));
        this._compr.write(dataOutputStream);
        dataOutputStream.close();
    }

    public short process(int n2, int[] nArray, int n3, short s2, boolean bl) throws IOException {
        if (bl && nArray[s2] >= this._limit) {
            this.flush();
        }
        nArray[n3] = this._limit;
        while (nArray[s2] < this._limit) {
            short s3 = s2;
            s2 = (short)(s2 + 1);
            this._arrays[nArray[s3] - this._minConcept].add(n2);
        }
        return s2;
    }

    private void heapify(int n2) {
        int n3;
        int n4 = n2 + 1 << 1;
        int n5 = n4 - 1;
        int n6 = n3 = n5 < this._heapSize && this._heap[n5].smallerThan(this._heap[n2]) ? n5 : n2;
        if (n4 < this._heapSize && this._heap[n4].smallerThan(this._heap[n3])) {
            n3 = n4;
        }
        if (n3 != n2) {
            MicroIndex microIndex = this._heap[n3];
            this._heap[n3] = this._heap[n2];
            this._heap[n2] = microIndex;
            this.heapify(n3);
        }
    }

    private void flush() throws IOException {
        int n2 = 0;
        while (n2 < 1024) {
            if (this._arrays[n2].cardinality() > 0) {
                this._arrays[n2].toDifferences(this._diffs);
                this._mainFile.write(this._compr.minimize(this._diffs, 3));
                this._offsets.add(this._compr.byteCount() + 1);
                this._compr.write(this._mainFile);
                this._concepts.add(this._minConcept + n2);
                this._arrays[n2].clear();
                this._diffs.clear();
                this._compr.clear();
            }
            ++n2;
        }
        this._limit += 1024;
        this._minConcept += 1024;
    }

    public static void invert(String string) throws Exception {
        new DocumentLists(string);
    }

    public static void main(String[] stringArray) {
        String string = stringArray[0];
        try {
            new DocumentLists(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void debug(String string) {
        if (this.debug) {
            System.err.println("DocumentLists: " + string);
        }
    }

    private class MicroIndex {
        private int _currentRange;
        private final int _documentNumber;
        private int[] _concepts = new int[17];
        private short _group;
        private short _ix;
        private IntegerArray _kTable = new IntegerArray();
        private IntegerArray _offsets = new IntegerArray();
        private IntegerArray _maxConcepts = new IntegerArray();
        private byte[] _data;
        private int _base;
        private int _limit;
        private int _nc;

        public MicroIndex(int n2, byte[] byArray, int n3) throws Exception {
            this._documentNumber = n2;
            this._data = byArray;
            this._base = n3;
            this.openDocumentIndex();
        }

        public boolean smallerThan(MicroIndex microIndex) {
            return this._currentRange < microIndex._currentRange || this._currentRange == microIndex._currentRange && this._documentNumber < microIndex._documentNumber;
        }

        private boolean next() throws Exception {
            if (this._group <= this._limit) {
                int n2;
                int n3;
                if (this._group > 0) {
                    n3 = this._base + this._offsets.at(this._group - 1);
                    n2 = this._maxConcepts.at(this._group - 1);
                } else {
                    n3 = this._base;
                    n2 = 0;
                }
                DocumentLists.this._decmp.initReading(this._data, n3);
                this._nc = DocumentLists.this._decmp.ascendingDecode(this._kTable.at(this._group * 2), n2, this._concepts);
                if (this._group < this._limit) {
                    this._concepts[this._nc++] = this._maxConcepts.at(this._group);
                }
                this._ix = 0;
                this._currentRange = this._concepts[0] / 1024;
                this._group = (short)(this._group + 1);
                return true;
            }
            return false;
        }

        private void openDocumentIndex() throws Exception {
            int n2 = this._data[this._base] & 0xFF;
            switch (n2 >> 6) {
                case 0: {
                    DocumentLists.this._decmp.initReading(this._data, this._base += 2);
                    this._nc = DocumentLists.this._decmp.ascendingDecode(n2 & 0x3F, 0, this._concepts);
                    this._ix = 0;
                    this._currentRange = this._concepts[0] / 1024;
                    this._limit = 0;
                    this._group = 1;
                    break;
                }
                case 2: {
                    DocumentLists.this._decmp.initReading(this._data, this._base + 1);
                    DocumentLists.this._decmp.decode(n2 & 0x3F, this._kTable);
                    DocumentLists.this._decmp.ascDecode(this._kTable.popLast(), this._offsets);
                    DocumentLists.this._decmp.ascDecode(this._kTable.popLast(), this._maxConcepts);
                    this._base += 1 + DocumentLists.this._decmp.bytesRead();
                    this._limit = this._maxConcepts.cardinality();
                    this._group = 0;
                    this.next();
                    break;
                }
                case 1: 
                case 3: {
                    System.err.println("extents not yet implemented\n");
                }
            }
        }

        public boolean process(DocumentLists documentLists) throws Exception {
            boolean bl = true;
            while (true) {
                short s2;
                if ((s2 = documentLists.process(this._documentNumber, this._concepts, this._nc, this._ix, bl)) < this._nc) {
                    this._ix = s2;
                    this._currentRange = this._concepts[this._ix] / 1024;
                    return true;
                }
                if (!this.next()) break;
                bl = false;
            }
            return false;
        }
    }
}

