/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.utils;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;

public class ActionSupportForJDK5 {
    public static final String SELECTED_KEY = "SwingSelectedKey";
    public static final String DISPLAYED_MNEMONIC_INDEX_KEY = "SwingDisplayedMnemonicIndexKey";
    public static final String LARGE_ICON_KEY = "SwingLargeIconKey";
    protected static final String CLIENT_PROPERTY_PROPERTY_CHANGE_LISTENER = "ActionSupportForJDK5.propertyChangeListener";
    protected static final String CLIENT_PROPERTY_ITEM_LISTENER = "ActionSupportForJDK5.itemListener";

    public static void setActionSelected(Action action, boolean bl) {
        action.putValue(SELECTED_KEY, bl);
    }

    public static boolean isActionSelected(Action action) {
        return Boolean.TRUE.equals(action.getValue(SELECTED_KEY));
    }

    public static void setDisplayedMnemonicIndex(Action action, int n2) {
        action.putValue(DISPLAYED_MNEMONIC_INDEX_KEY, n2);
    }

    public static boolean hasDisplayedMnemonicIndex(Action action) {
        return action.getValue(DISPLAYED_MNEMONIC_INDEX_KEY) != null;
    }

    public static int getDisplayedMnemonicIndex(Action action) {
        if (ActionSupportForJDK5.hasDisplayedMnemonicIndex(action)) {
            return (Integer)action.getValue(DISPLAYED_MNEMONIC_INDEX_KEY);
        }
        return -1;
    }

    public static void setLargeIcon(Action action, Icon icon) {
        action.putValue(LARGE_ICON_KEY, icon);
    }

    public static Icon getLargeIcon(Action action) {
        Object object = action.getValue(LARGE_ICON_KEY);
        return object instanceof Icon ? (Icon)object : null;
    }

    public static void install(final AbstractButton abstractButton, final Action action) {
        if (ActionSupportForJDK5.isActionSelected(action)) {
            ActionSupportForJDK5.setSelectedFromAction(abstractButton, action);
        }
        if (ActionSupportForJDK5.getDisplayedMnemonicIndex(action) != -1) {
            ActionSupportForJDK5.setDisplayedMnemonicIndexFromAction(abstractButton, action, true);
        }
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ActionSupportForJDK5.actionPropertyChanged(abstractButton, action, propertyChangeEvent.getPropertyName());
            }
        };
        action.addPropertyChangeListener(propertyChangeListener);
        ItemListener itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                ActionSupportForJDK5.setActionSelected(action, itemEvent.getStateChange() == 1);
            }
        };
        abstractButton.addItemListener(itemListener);
        abstractButton.putClientProperty(CLIENT_PROPERTY_PROPERTY_CHANGE_LISTENER, propertyChangeListener);
        abstractButton.putClientProperty(CLIENT_PROPERTY_ITEM_LISTENER, itemListener);
    }

    public static void install(AbstractButton abstractButton) {
        Action action = abstractButton.getAction();
        ActionSupportForJDK5.install(abstractButton, action);
    }

    public static void uninstall(AbstractButton abstractButton, Action action) {
        Object object = abstractButton.getClientProperty(CLIENT_PROPERTY_PROPERTY_CHANGE_LISTENER);
        if (object instanceof PropertyChangeListener) {
            action.removePropertyChangeListener((PropertyChangeListener)object);
        }
        if ((object = abstractButton.getClientProperty(CLIENT_PROPERTY_ITEM_LISTENER)) instanceof ItemListener) {
            abstractButton.removeItemListener((ItemListener)object);
        }
    }

    public static void uninstall(AbstractButton abstractButton) {
        Action action = abstractButton.getAction();
        ActionSupportForJDK5.uninstall(abstractButton, action);
    }

    public static void actionPropertyChanged(AbstractButton abstractButton, Action action, String string) {
        if (SELECTED_KEY.equals(string) && ActionSupportForJDK5.hasSelectedKey(action)) {
            ActionSupportForJDK5.setSelectedFromAction(abstractButton, action);
        } else if (DISPLAYED_MNEMONIC_INDEX_KEY.equals(string)) {
            ActionSupportForJDK5.setDisplayedMnemonicIndexFromAction(abstractButton, action, true);
        } else if (LARGE_ICON_KEY.equals(string)) {
            ActionSupportForJDK5.largeIconChanged(abstractButton, action);
        }
    }

    static boolean hasSelectedKey(Action action) {
        return action != null && action.getValue(SELECTED_KEY) != null;
    }

    private static void setSelectedFromAction(AbstractButton abstractButton, Action action) {
        boolean bl = false;
        if (action != null) {
            bl = ActionSupportForJDK5.isActionSelected(action);
        }
        if (bl != abstractButton.isSelected()) {
            ButtonGroup buttonGroup;
            abstractButton.setSelected(bl);
            if (!bl && abstractButton.isSelected() && abstractButton.getModel() instanceof DefaultButtonModel && (buttonGroup = ((DefaultButtonModel)abstractButton.getModel()).getGroup()) != null) {
                buttonGroup.remove(abstractButton);
                abstractButton.setSelected(false);
                buttonGroup.add(abstractButton);
            }
        }
    }

    private static void setDisplayedMnemonicIndexFromAction(AbstractButton abstractButton, Action action, boolean bl) {
        Integer n2;
        Integer n3 = n2 = action != null ? (Integer)action.getValue(DISPLAYED_MNEMONIC_INDEX_KEY) : null;
        if (bl || n2 != null) {
            int n4;
            if (n2 == null) {
                n4 = -1;
            } else {
                n4 = n2;
                String string = abstractButton.getText();
                if (string == null || n4 >= string.length()) {
                    n4 = -1;
                }
            }
            abstractButton.setDisplayedMnemonicIndex(n4);
        }
    }

    static void largeIconChanged(AbstractButton abstractButton, Action action) {
        ActionSupportForJDK5.setIconFromAction(abstractButton, action);
    }

    static void setIconFromAction(AbstractButton abstractButton, Action action) {
        Icon icon = null;
        if (action != null && (icon = (Icon)action.getValue(LARGE_ICON_KEY)) == null) {
            icon = (Icon)action.getValue("SmallIcon");
        }
        abstractButton.setIcon(icon);
    }
}

