/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import javax.swing.JToggleButton;

public class TristateButtonModel
extends JToggleButton.ToggleButtonModel {
    private static final long serialVersionUID = 9179129427948325126L;
    public static final int MIXED = 128;

    public void setState(int n2) {
        switch (n2) {
            case 0: {
                this.setSelected(false);
                break;
            }
            case 1: {
                this.setSelected(true);
                break;
            }
            case 2: {
                this.setMixed(true);
            }
        }
    }

    public int getState() {
        if (this.isMixed()) {
            return 2;
        }
        if (this.isSelected()) {
            return 1;
        }
        return 0;
    }

    protected int getNextState(int n2) {
        if (n2 == 0) {
            return 1;
        }
        if (n2 == 1) {
            return 2;
        }
        return 0;
    }

    @Override
    public void setPressed(boolean bl) {
        if (this.isPressed() == bl || !this.isEnabled()) {
            return;
        }
        if (!bl && this.isArmed()) {
            this.updateState();
        }
        this.stateMask = bl ? (this.stateMask |= 4) : (this.stateMask &= 0xFFFFFFFB);
        this.fireStateChanged();
        if (!this.isPressed() && this.isArmed()) {
            int n2 = 0;
            AWTEvent aWTEvent = EventQueue.getCurrentEvent();
            if (aWTEvent instanceof InputEvent) {
                n2 = ((InputEvent)aWTEvent).getModifiers();
            } else if (aWTEvent instanceof ActionEvent) {
                n2 = ((ActionEvent)aWTEvent).getModifiers();
            }
            this.fireActionPerformed(new ActionEvent(this, 1001, this.getActionCommand(), EventQueue.getMostRecentEventTime(), n2));
        }
    }

    protected void updateState() {
        this.setState(this.getNextState(this.getState()));
    }

    @Override
    public void setSelected(boolean bl) {
        boolean bl2 = this.isMixed();
        if (bl2) {
            this.stateMask &= 0xFFFFFF7F;
            this.internalSetSelected(!this.isSelected());
        }
        super.setSelected(bl);
    }

    void internalSetSelected(boolean bl) {
        this.stateMask = bl ? (this.stateMask |= 2) : (this.stateMask &= 0xFFFFFFFD);
    }

    public boolean isMixed() {
        return (this.stateMask & 0x80) != 0;
    }

    public void setMixed(boolean bl) {
        if (this.isMixed() == bl) {
            return;
        }
        if (bl) {
            this.stateMask |= 0x80;
            this.stateMask |= 2;
        } else {
            this.stateMask &= 0xFFFFFF7F;
        }
        this.fireStateChanged();
    }
}

