/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.utils.PortingUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.KeyEventDispatcher;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultFocusManager;
import javax.swing.JLayeredPane;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class PopupWindow {
    protected EventListenerList listenerList = new EventListenerList();
    private JWindow _delegate;
    private Container _container;
    private List _grabbed = new Vector();
    private List _excluded = new Vector();
    private WindowListener _windowListener;
    private ComponentListener _componentListener;
    private ContainerListener _containerListener;
    private MouseListener _mouseListener;
    private Component _component;
    private KeyEventDispatcher _keyEventDispatcher;
    private Component _parent;

    public PopupWindow(Container container) {
        this._container = container;
        this.createDelegate();
        this.createListeners();
    }

    private void createDelegate() {
        Window window = this.getWindow();
        if (window != null) {
            this._delegate = new JWindow(window);
        }
    }

    public void add(Component component) {
        this._component = component;
        this._component.addPropertyChangeListener("preferredSize", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (PopupWindow.this._delegate != null) {
                    PopupWindow.this._delegate.pack();
                }
            }
        });
        if (this._delegate != null) {
            this._delegate.getContentPane().add(component);
            this._delegate.pack();
            this._delegate.pack();
        }
    }

    public void show(Component component, int n2, int n3) {
        this._parent = component;
        if (this._delegate == null) {
            this.createDelegate();
            if (this._delegate == null) {
                return;
            }
            this.add(this._component);
        }
        Point point = new Point(n2, n3);
        SwingUtilities.convertPointToScreen(point, component);
        Rectangle rectangle = PortingUtils.getScreenBounds(component);
        Dimension dimension = this._component.getPreferredSize();
        int n4 = point.x + dimension.width;
        int n5 = point.y + dimension.height;
        if (point.x < rectangle.x) {
            point.x = rectangle.x;
        }
        if (n4 > rectangle.width) {
            point.x = rectangle.width - dimension.width;
        }
        if (point.y < rectangle.y) {
            point.y = rectangle.y;
        }
        if (n5 > rectangle.height) {
            point.y = rectangle.height - dimension.height;
        }
        this._delegate.setLocation(point.x, point.y);
        this._delegate.setSize(this._component.getPreferredSize());
        this.firePopupMenuWillBecomeVisible();
        this._delegate.setVisible(true);
        this.grabContainers();
        this._keyEventDispatcher = new KeyEventDispatcher(){

            @Override
            public boolean dispatchKeyEvent(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    PopupWindow.this.hide();
                    return true;
                }
                return false;
            }
        };
        DefaultFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this._keyEventDispatcher);
    }

    public void hide() {
        if (this._parent != null) {
            this._parent.requestFocus();
        }
        this.firePopupMenuWillBecomeInvisible();
        if (this._delegate != null) {
            this._delegate.setVisible(false);
        }
        if (this._keyEventDispatcher != null) {
            DefaultFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this._keyEventDispatcher);
            this._keyEventDispatcher = null;
        }
        this.releaseContainers();
        this.disposeDelegate();
    }

    private void createListeners() {
        this._windowListener = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                PopupWindow.this.hide();
            }

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                PopupWindow.this.hide();
            }

            @Override
            public void windowIconified(WindowEvent windowEvent) {
                PopupWindow.this.hide();
            }
        };
        this._componentListener = new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                PopupWindow.this.hide();
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
                PopupWindow.this.hide();
            }

            @Override
            public void componentShown(ComponentEvent componentEvent) {
                PopupWindow.this.hide();
            }

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
                PopupWindow.this.hide();
            }
        };
        this._containerListener = new ContainerListener(){

            @Override
            public void componentAdded(ContainerEvent containerEvent) {
                PopupWindow.this.hide();
            }

            @Override
            public void componentRemoved(ContainerEvent containerEvent) {
                PopupWindow.this.hide();
            }
        };
        this._mouseListener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                PopupWindow.this.hide();
            }
        };
    }

    private void disposeDelegate() {
        if (this._delegate != null) {
            this._delegate.dispose();
            this._delegate = null;
        }
    }

    private Window getWindow() {
        Container container = this._container;
        if (container == null) {
            return null;
        }
        while (!(container instanceof Window) && container.getParent() != null) {
            container = container.getParent();
        }
        if (container instanceof Window) {
            return (Window)container;
        }
        return null;
    }

    private void grabContainers() {
        Container container = this._container;
        while (!(container instanceof Window) && container.getParent() != null) {
            container = container.getParent();
        }
        this.grabContainer(container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void grabContainer(Container container) {
        if (container instanceof Window) {
            ((Window)container).addWindowListener(this._windowListener);
            container.addComponentListener(this._componentListener);
            this._grabbed.add(container);
        }
        Object object = container.getTreeLock();
        synchronized (object) {
            int n2 = container.getComponentCount();
            Component[] componentArray = container.getComponents();
            for (int i2 = 0; i2 < n2; ++i2) {
                Component component = componentArray[i2];
                if (!component.isVisible() || this.isExcludedComponent(component)) continue;
                component.addMouseListener(this._mouseListener);
                this._grabbed.add(component);
                if (!(component instanceof Container)) continue;
                Container container2 = (Container)component;
                if (container2 instanceof JLayeredPane) {
                    container2.addContainerListener(this._containerListener);
                }
                this.grabContainer(container2);
            }
        }
    }

    void releaseContainers() {
        for (Object e2 : this._grabbed) {
            Component component = (Component)e2;
            if (component instanceof Window) {
                ((Window)component).removeWindowListener(this._windowListener);
                component.removeComponentListener(this._componentListener);
            } else {
                component.removeMouseListener(this._mouseListener);
            }
            if (!(component instanceof Container) || !(component instanceof JLayeredPane)) continue;
            ((Container)component).removeContainerListener(this._containerListener);
        }
        this._grabbed.clear();
    }

    public boolean isVisible() {
        return this._delegate != null ? this._delegate.isVisible() : false;
    }

    public void addPopupMenuListener(PopupMenuListener popupMenuListener) {
        this.listenerList.add(PopupMenuListener.class, popupMenuListener);
    }

    public void removePopupMenuListener(PopupMenuListener popupMenuListener) {
        this.listenerList.remove(PopupMenuListener.class, popupMenuListener);
    }

    public PopupMenuListener[] getPopupMenuListeners() {
        return (PopupMenuListener[])this.listenerList.getListeners(PopupMenuListener.class);
    }

    public void firePopupMenuWillBecomeVisible() {
        Object[] objectArray = this.listenerList.getListenerList();
        PopupMenuEvent popupMenuEvent = null;
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != PopupMenuListener.class) continue;
            if (popupMenuEvent == null) {
                popupMenuEvent = new PopupMenuEvent(this);
            }
            ((PopupMenuListener)objectArray[i2 + 1]).popupMenuWillBecomeVisible(popupMenuEvent);
        }
    }

    public void firePopupMenuWillBecomeInvisible() {
        Object[] objectArray = this.listenerList.getListenerList();
        PopupMenuEvent popupMenuEvent = null;
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != PopupMenuListener.class) continue;
            if (popupMenuEvent == null) {
                popupMenuEvent = new PopupMenuEvent(this);
            }
            ((PopupMenuListener)objectArray[i2 + 1]).popupMenuWillBecomeInvisible(popupMenuEvent);
        }
    }

    public void firePopupMenuCanceled() {
        Object[] objectArray = this.listenerList.getListenerList();
        PopupMenuEvent popupMenuEvent = null;
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != PopupMenuListener.class) continue;
            if (popupMenuEvent == null) {
                popupMenuEvent = new PopupMenuEvent(this);
            }
            ((PopupMenuListener)objectArray[i2 + 1]).popupMenuCanceled(popupMenuEvent);
        }
    }

    public void addAsExcludedComponents(Component component) {
        if (this._excluded.contains(component)) {
            return;
        }
        this._excluded.add(component);
    }

    public void removeFromExcludedComponents(Component component) {
        if (!this._excluded.contains(component)) {
            return;
        }
        this._excluded.remove(component);
    }

    public boolean isExcludedComponent(Component component) {
        return this._excluded.contains(component);
    }
}

