/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.vsnet;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.vsnet.VsnetUtils;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalProgressBarUI;

public class VsnetMetalProgressBarUI
extends MetalProgressBarUI
implements ActionListener {
    private int repaintInterval;
    private int x = 0;
    private int y = 0;
    private int delta = 1;
    private Timer timer = null;
    private Rectangle boxRect;

    public static ComponentUI createUI(JComponent jComponent) {
        return new VsnetMetalProgressBarUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.initRepaintInterval();
    }

    @Override
    protected void startAnimationTimer() {
        if (this.timer == null) {
            this.timer = new Timer(this.getRepaintInterval() / 20, this);
        }
        this.y = 0;
        this.x = 0;
        this.delta = 1;
        this.timer.start();
    }

    @Override
    protected void stopAnimationTimer() {
        if (this.timer != null) {
            this.timer.stop();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.x == 0) {
            this.delta = 1;
        } else if (this.x == this.progressBar.getWidth()) {
            this.delta = -1;
        }
        this.x += this.delta;
        this.progressBar.repaint();
    }

    protected int getRepaintInterval() {
        return this.repaintInterval;
    }

    private int initRepaintInterval() {
        this.repaintInterval = UIDefaultsLookup.getInt("ProgressBar.repaintInterval");
        return this.repaintInterval;
    }

    @Override
    public void paintIndeterminate(Graphics graphics, JComponent jComponent) {
        boolean bl;
        super.paintDeterminate(graphics, jComponent);
        if (!(graphics instanceof Graphics2D)) {
            return;
        }
        Color color = this.progressBar.getForeground();
        Color color2 = VsnetUtils.getLighterColor(color, 0.9f);
        Insets insets = this.progressBar.getInsets();
        int n2 = this.progressBar.getWidth() - (insets.right + insets.left);
        int n3 = this.progressBar.getHeight() - (insets.top + insets.bottom);
        Graphics2D graphics2D = (Graphics2D)graphics;
        boolean bl2 = bl = jComponent.getHeight() > jComponent.getWidth();
        if (this.delta > 0) {
            this.boxRect = new Rectangle(0, 0, this.x, this.progressBar.getHeight() - 1);
            JideSwingUtilities.fillNormalGradient(graphics2D, this.boxRect, color2, color, bl);
        } else {
            this.boxRect = new Rectangle(this.x, 0, this.progressBar.getWidth() - this.x, this.progressBar.getHeight() - 1);
            JideSwingUtilities.fillNormalGradient(graphics2D, this.boxRect, color, color2, bl);
        }
        if (this.progressBar.isStringPainted()) {
            if (this.progressBar.getOrientation() == 0) {
                this.paintString(graphics2D, insets.left, insets.top, n2, n3, this.boxRect.x, this.boxRect.width, insets);
            } else {
                this.paintString(graphics2D, insets.left, insets.top, n2, n3, this.boxRect.y, this.boxRect.height, insets);
            }
        }
    }

    private void paintString(Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7, Insets insets) {
        if (!(graphics instanceof Graphics2D)) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        String string = this.progressBar.getString();
        graphics2D.setFont(this.progressBar.getFont());
        Point point = this.getStringPlacement(graphics2D, string, n2, n3, n4, n5);
        Rectangle rectangle = graphics2D.getClipBounds();
        if (this.progressBar.getOrientation() == 0) {
            graphics2D.setColor(this.getSelectionBackground());
            JideSwingUtilities.drawString(this.progressBar, graphics2D, string, point.x, point.y);
            graphics2D.setColor(this.getSelectionForeground());
            graphics2D.clipRect(n6, n3, n7, n5);
            JideSwingUtilities.drawString(this.progressBar, graphics2D, string, point.x, point.y);
        } else {
            graphics2D.setColor(this.getSelectionBackground());
            AffineTransform affineTransform = AffineTransform.getRotateInstance(1.5707963267948966);
            graphics2D.setFont(this.progressBar.getFont().deriveFont(affineTransform));
            point = this.getStringPlacement(graphics2D, string, n2, n3, n4, n5);
            JideSwingUtilities.drawString(this.progressBar, graphics2D, string, point.x, point.y);
            graphics2D.setColor(this.getSelectionForeground());
            graphics2D.clipRect(n2, n6, n4, n7);
            JideSwingUtilities.drawString(this.progressBar, graphics2D, string, point.x, point.y);
        }
        graphics2D.setClip(rectangle);
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        JProgressBar jProgressBar = new JProgressBar();
        JProgressBar jProgressBar2 = new JProgressBar();
        jProgressBar2.setUI(new VsnetMetalProgressBarUI());
        jProgressBar.setIndeterminate(true);
        jProgressBar.setString("Percent");
        jProgressBar.setStringPainted(true);
        jProgressBar2.setIndeterminate(true);
        jProgressBar2.setString("Percent");
        jProgressBar2.setStringPainted(true);
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        jPanel.add((Component)jProgressBar, "North");
        jPanel.add((Component)jProgressBar2, "South");
        JOptionPane.showMessageDialog(null, jPanel, "ProgressBars made intutive - santhosh@in.fiorano.com", 1);
        System.exit(0);
    }
}

