/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.XPUtils;
import com.jidesoft.plaf.basic.ThemePainter;
import com.jidesoft.swing.ComponentStateSupport;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.JideTabbedPane;
import com.jidesoft.utils.ColorUtils;
import com.jidesoft.utils.SecurityUtils;
import com.jidesoft.utils.SystemInfo;
import com.sun.java.swing.plaf.windows.WindowsClassicLookAndFeel;
import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import sun.swing.plaf.synth.SynthIcon;

public class BasicPainter
implements SwingConstants,
ThemePainter {
    private static BasicPainter _instance;
    protected Color _bk0;
    protected Color _bk1;
    protected Color _bk2;
    protected Color _bk3;
    protected Color _borderColor;
    public static int V_GAP;
    public static int H_GAP;
    public static int ARROW_TEXT_GAP;

    public static ThemePainter getInstance() {
        if (_instance == null) {
            _instance = new BasicPainter();
        }
        return _instance;
    }

    public void installDefaults() {
        if (this._bk0 == null) {
            this._bk0 = UIDefaultsLookup.getColor("JideButton.background");
        }
        if (this._bk1 == null) {
            this._bk1 = UIDefaultsLookup.getColor("JideButton.focusedBackground");
        }
        if (this._bk2 == null) {
            this._bk2 = UIDefaultsLookup.getColor("JideButton.selectedBackground");
        }
        if (this._bk3 == null) {
            this._bk3 = UIDefaultsLookup.getColor("JideButton.selectedAndFocusedBackground");
        }
        if (this._borderColor == null) {
            this._borderColor = UIDefaultsLookup.getColor("JideButton.borderColor");
        }
    }

    public void uninstallDefaults() {
        this._borderColor = null;
        this._bk0 = null;
        this._bk1 = null;
        this._bk2 = null;
        this._bk3 = null;
    }

    @Override
    public Color getGripperForeground() {
        return UIDefaultsLookup.getColor("Gripper.foreground");
    }

    @Override
    public Color getGripperForegroundLt() {
        return UIDefaultsLookup.getColor("JideButton.highlight");
    }

    @Override
    public Color getSeparatorForeground() {
        return UIDefaultsLookup.getColor("JideButton.shadow");
    }

    @Override
    public Color getSeparatorForegroundLt() {
        return UIDefaultsLookup.getColor("JideButton.highlight");
    }

    @Override
    public Color getCollapsiblePaneContentBackground() {
        return UIDefaultsLookup.getColor("CollapsiblePane.contentBackground");
    }

    @Override
    public Color getCollapsiblePaneTitleForeground() {
        return UIDefaultsLookup.getColor("CollapsiblePane.foreground");
    }

    @Override
    public Color getCollapsiblePaneTitleForegroundEmphasized() {
        return UIDefaultsLookup.getColor("CollapsiblePane.emphasizedForeground");
    }

    @Override
    public Color getCollapsiblePaneFocusTitleForegroundEmphasized() {
        return UIDefaultsLookup.getColor("CollapsiblePane.emphasizedForeground");
    }

    @Override
    public Color getCollapsiblePaneFocusTitleForeground() {
        return UIDefaultsLookup.getColor("CollapsiblePane.foreground");
    }

    @Override
    public ImageIcon getCollapsiblePaneUpIcon() {
        return (ImageIcon)UIDefaultsLookup.getIcon("CollapsiblePane.upIcon");
    }

    @Override
    public ImageIcon getCollapsiblePaneDownIcon() {
        return (ImageIcon)UIDefaultsLookup.getIcon("CollapsiblePane.downIcon");
    }

    @Override
    public ImageIcon getCollapsiblePaneUpIconEmphasized() {
        return this.getCollapsiblePaneUpIcon();
    }

    @Override
    public ImageIcon getCollapsiblePaneDownIconEmphasized() {
        return this.getCollapsiblePaneDownIcon();
    }

    @Override
    public ImageIcon getCollapsiblePaneTitleButtonBackground() {
        return (ImageIcon)UIDefaultsLookup.getIcon("CollapsiblePane.titleButtonBackground");
    }

    @Override
    public ImageIcon getCollapsiblePaneTitleButtonBackgroundEmphasized() {
        return (ImageIcon)UIDefaultsLookup.getIcon("CollapsiblePane.titleButtonBackground.emphasized");
    }

    @Override
    public ImageIcon getCollapsiblePaneUpMask() {
        return this.getCollapsiblePaneUpIcon();
    }

    @Override
    public ImageIcon getCollapsiblePaneDownMask() {
        return this.getCollapsiblePaneDownIcon();
    }

    @Override
    public Color getBackgroundDk() {
        return UIDefaultsLookup.getColor("JideButton.background");
    }

    @Override
    public Color getBackgroundLt() {
        return UIDefaultsLookup.getColor("JideButton.background");
    }

    @Override
    public Color getSelectionSelectedDk() {
        return this._bk2;
    }

    @Override
    public Color getSelectionSelectedLt() {
        return this._bk2;
    }

    @Override
    public Color getMenuItemBorderColor() {
        return UIDefaultsLookup.getColor("MenuItem.selectionBorderColor");
    }

    @Override
    public Color getMenuItemBackground() {
        return UIDefaultsLookup.getColor("MenuItem.background");
    }

    @Override
    public Color getCommandBarTitleBarBackground() {
        return UIDefaultsLookup.getColor("CommandBar.titleBarBackground");
    }

    @Override
    public Color getControl() {
        return UIDefaultsLookup.getColor("JideButton.background");
    }

    @Override
    public Color getControlLt() {
        return this.getControlShadow();
    }

    @Override
    public Color getControlDk() {
        return this.getControlShadow();
    }

    @Override
    public Color getControlShadow() {
        return UIDefaultsLookup.getColor("JideButton.shadow");
    }

    @Override
    public Color getTitleBarBackground() {
        return UIDefaultsLookup.getColor("DockableFrame.activeTitleBackground");
    }

    @Override
    public Color getDockableFrameTitleBarActiveForeground() {
        return UIDefaultsLookup.getColor("DockableFrame.activeTitleForeground");
    }

    @Override
    public Color getDockableFrameTitleBarInactiveForeground() {
        return UIDefaultsLookup.getColor("DockableFrame.inactiveTitleForeground");
    }

    @Override
    public Color getTabbedPaneSelectDk() {
        return UIDefaultsLookup.getColor("JideTabbedPane.selectedTabBackgroundDk");
    }

    @Override
    public Color getTabbedPaneSelectLt() {
        return UIDefaultsLookup.getColor("JideTabbedPane.selectedTabBackgroundlt");
    }

    @Override
    public Color getTabAreaBackgroundDk() {
        return UIDefaultsLookup.getColor("JideTabbedPane.tabAreaBackgroundDk");
    }

    @Override
    public Color getTabAreaBackgroundLt() {
        return UIDefaultsLookup.getColor("JideTabbedPane.tabAreaBackgroundLt");
    }

    @Override
    public Color getOptionPaneBannerForeground() {
        return new ColorUIResource(255, 255, 255);
    }

    @Override
    public Color getOptionPaneBannerDk() {
        return new ColorUIResource(45, 96, 249);
    }

    @Override
    public Color getOptionPaneBannerLt() {
        return new ColorUIResource(0, 52, 206);
    }

    @Override
    public void paintSelectedMenu(JComponent jComponent, Graphics graphics, Rectangle rectangle, int n2, int n3) {
        Color color = graphics.getColor();
        graphics.setColor(UIDefaultsLookup.getColor("JideButton.darkShadow"));
        graphics.drawLine(rectangle.x, rectangle.y + rectangle.height, rectangle.x, rectangle.y + 1);
        graphics.drawLine(rectangle.x + rectangle.width - 2, rectangle.y, rectangle.x + rectangle.width - 2, rectangle.y + rectangle.height);
        if (n2 == 0) {
            graphics.drawLine(rectangle.x, rectangle.y, rectangle.x + rectangle.width - 3, rectangle.y);
        } else {
            graphics.drawLine(rectangle.x, rectangle.y + rectangle.height - 1, rectangle.x + rectangle.width - 3, rectangle.y + rectangle.height - 1);
        }
        graphics.setColor(color);
    }

    @Override
    public void paintMenuItemBackground(JComponent jComponent, Graphics graphics, Rectangle rectangle, int n2, int n3) {
        this.paintMenuItemBackground(jComponent, graphics, rectangle, n2, n3, true);
    }

    @Override
    public void paintMenuItemBackground(JComponent jComponent, Graphics graphics, Rectangle rectangle, int n2, int n3, boolean bl) {
        this.paintButtonBackground(jComponent, graphics, rectangle, n2, n3, bl);
    }

    @Override
    public void paintButtonBackground(JComponent jComponent, Graphics graphics, Rectangle rectangle, int n2, int n3) {
        this.paintButtonBackground(jComponent, graphics, rectangle, n2, n3, true);
    }

    @Override
    public void paintButtonBackground(JComponent jComponent, Graphics graphics, Rectangle rectangle, int n2, int n3, boolean bl) {
        this.installDefaults();
        Color color = null;
        Boolean bl2 = UIManager.getBoolean("Theme.highContrast");
        if (bl2.booleanValue()) {
            color = jComponent.getBackground();
            this.paintBackground(jComponent, graphics, rectangle, n3 == 0 || n3 == 4 ? null : this._borderColor, n3 == 1 || n3 == 3 || n3 == 2 ? UIDefaultsLookup.getColor("JideButton.selectedBackground") : color, n2);
            return;
        }
        switch (n3) {
            case 0: {
                color = jComponent.getBackground();
                if (color == null || color instanceof UIResource) {
                    color = this._bk0;
                }
                this.paintBackground(jComponent, graphics, rectangle, bl ? this._borderColor : null, color, n2);
                break;
            }
            case 2: {
                if (jComponent instanceof ComponentStateSupport) {
                    color = ((ComponentStateSupport)((Object)jComponent)).getBackgroundOfState(2);
                }
                if (color == null || color instanceof UIResource) {
                    color = this._bk1;
                }
                this.paintBackground(jComponent, graphics, rectangle, bl ? this._borderColor : null, color, n2);
                break;
            }
            case 3: {
                if (jComponent instanceof ComponentStateSupport) {
                    color = ((ComponentStateSupport)((Object)jComponent)).getBackgroundOfState(3);
                }
                if (color == null || color instanceof UIResource) {
                    color = this._bk2;
                }
                this.paintBackground(jComponent, graphics, rectangle, bl ? this._borderColor : null, color, n2);
                break;
            }
            case 5: {
                if (jComponent instanceof ComponentStateSupport) {
                    color = ((ComponentStateSupport)((Object)jComponent)).getBackgroundOfState(3);
                }
                if (color == null || color instanceof UIResource) {
                    color = this._bk2;
                }
                this.paintBackground(jComponent, graphics, rectangle, bl ? ColorUtils.toGrayscale(this._borderColor) : null, ColorUtils.toGrayscale(color), n2);
                break;
            }
            case 1: {
                if (jComponent instanceof ComponentStateSupport) {
                    color = ((ComponentStateSupport)((Object)jComponent)).getBackgroundOfState(1);
                }
                if (color == null || color instanceof UIResource) {
                    color = this._bk3;
                }
                this.paintBackground(jComponent, graphics, rectangle, bl ? this._borderColor : null, color, n2);
            }
        }
    }

    protected void paintBackground(JComponent jComponent, Graphics graphics, Rectangle rectangle, Color color, Color color2, int n2) {
        Color color3 = graphics.getColor();
        if (color != null) {
            boolean bl = true;
            Object object = jComponent.getClientProperty("JideButton.paintDefaultBorder");
            if (object instanceof Boolean) {
                bl = (Boolean)object;
            }
            if (bl) {
                graphics.setColor(color);
                Object object2 = jComponent.getClientProperty("JButton.segmentPosition");
                if (object2 == null || "only".equals(object2)) {
                    graphics.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
                } else if ("first".equals(object2)) {
                    if (n2 == 0) {
                        graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height - 1);
                    } else {
                        graphics.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height);
                    }
                } else if ("middle".equals(object2)) {
                    if (n2 == 0) {
                        graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height - 1);
                    } else {
                        graphics.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height);
                    }
                } else if ("last".equals(object2)) {
                    if (n2 == 0) {
                        graphics.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
                    } else {
                        graphics.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
                    }
                }
            }
            graphics.setColor(color2);
            graphics.fillRect(rectangle.x + 1, rectangle.y + 1, rectangle.width - 2, rectangle.height - 2);
        } else {
            graphics.setColor(color2);
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        graphics.setColor(color3);
    }

    @Override
    public void paintChevronBackground(JComponent jComponent, Graphics graphics, Rectangle rectangle, int n2, int n3) {
        if (n3 != 0) {
            this.paintButtonBackground(jComponent, graphics, rectangle, n2, n3);
        }
    }

    @Override
    public void paintDividerBackground(JComponent jComponent, Graphics graphics, Rectangle rectangle, int n2, int n3) {
        Color color = graphics.getColor();
        graphics.setColor(UIDefaultsLookup.getColor("SplitPane.background"));
        graphics.fillRect(0, 0, rectangle.width, rectangle.height);
        graphics.setColor(color);
    }

    @Override
    public void paintCommandBarBackground(JComponent jComponent, Graphics graphics, Rectangle rectangle, int n2, int n3) {
        graphics.setColor(UIDefaultsLookup.getColor("CommandBar.background"));
        graphics.fillRoundRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height, 2, 2);
    }

    @Override
    public void paintFloatingCommandBarBackground(JComponent jComponent, Graphics graphics, Rectangle rectangle, int n2, int n3) {
        graphics.setColor(UIDefaultsLookup.getColor("CommandBar.background"));
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    @Override
    public void paintMenuShadow(JComponent jComponent, Graphics graphics, Rectangle rectangle, int n2, int n3) {
        Color color = graphics.getColor();
        graphics.setColor(UIDefaultsLookup.getColor("MenuItem.shadowColor"));
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.setColor(color);
    }

    @Override
    public void paintContentBackground(JComponent jComponent, Graphics graphics, Rectangle rectangle, int n2, int n3) {
        graphics.setColor(UIDefaultsLookup.getColor("control"));
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    @Override
    public void paintStatusBarBackground(JComponent jComponent, Graphics graphics, Rectangle rectangle, int n2, int n3) {
        if (jComponent.isOpaque()) {
            this.paintContentBackground(jComponent, graphics, rectangle, n2, n3);
        }
    }

    @Override
    public void paintCommandBarTitlePane(JComponent jComponent, Graphics graphics, Rectangle rectangle, int n2, int n3) {
        graphics.setColor(this.getCommandBarTitleBarBackground());
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    @Override
    public void paintGripper(JComponent jComponent, Graphics graphics, Rectangle rectangle, int n2, int n3) {
        graphics.setColor(this.getGripperForeground());
        if (rectangle.width > rectangle.height) {
            rectangle.x = rectangle.x + rectangle.width / 2 - 10;
            rectangle.width = 22;
        } else {
            rectangle.y = rectangle.y + rectangle.height / 2 - 10;
            rectangle.height = 22;
        }
        if (n2 == 0) {
            if (rectangle.width <= 30) {
                for (int i2 = 0; i2 < (rectangle.height - 6) / 2; ++i2) {
                    graphics.drawLine(rectangle.x + 3, rectangle.y + 3 + i2 * 2, rectangle.x + rectangle.width - 3, rectangle.y + 3 + i2 * 2);
                }
            } else {
                for (int i3 = 0; i3 < (rectangle.height - 4) / 2; ++i3) {
                    graphics.drawLine((rectangle.width - rectangle.width) / 2, rectangle.y + 2 + i3 * 2, (rectangle.width + rectangle.width) / 2, rectangle.y + 2 + i3 * 2);
                }
            }
        } else {
            int n4 = (rectangle.width - 6) / 2;
            for (int i4 = 0; i4 < n4; ++i4) {
                int n5 = rectangle.x + rectangle.width / 2 - n4 + i4 * 2;
                graphics.drawLine(n5, rectangle.y + 3, n5, rectangle.y + rectangle.height - 3);
            }
        }
    }

    @Override
    public void paintChevronMore(JComponent jComponent, Graphics graphics, Rectangle rectangle, int n2, int n3) {
        block6: {
            block5: {
                graphics.setColor(UIDefaultsLookup.getColor("CommandBar.darkShadow"));
                if (n2 != 0) break block5;
                if (!jComponent.getComponentOrientation().isLeftToRight()) {
                    int n4 = rectangle.y + 4;
                    for (int i2 = -2; i2 <= 2; ++i2) {
                        int n5 = Math.abs(i2);
                        graphics.drawLine(rectangle.x + 2 + n5, n4, rectangle.x + 3 + n5, n4);
                        graphics.drawLine(rectangle.x + 6 + n5, n4, rectangle.x + 7 + n5, n4);
                        ++n4;
                    }
                } else {
                    int n6 = rectangle.y + 4;
                    for (int i3 = -2; i3 <= 2; ++i3) {
                        int n7 = -Math.abs(i3);
                        graphics.drawLine(rectangle.x + 4 + n7, n6, rectangle.x + 5 + n7, n6);
                        graphics.drawLine(rectangle.x + 8 + n7, n6, rectangle.x + 9 + n7, n6);
                        ++n6;
                    }
                }
                break block6;
            }
            if (n2 != 1) break block6;
            int n8 = rectangle.x + 4;
            for (int i4 = -2; i4 <= 2; ++i4) {
                int n9 = -Math.abs(i4);
                graphics.drawLine(n8, rectangle.y + 4 + n9, n8, rectangle.y + 5 + n9);
                graphics.drawLine(n8, rectangle.y + 8 + n9, n8, rectangle.y + 9 + n9);
                ++n8;
            }
        }
    }

    @Override
    public void paintChevronOption(JComponent jComponent, Graphics graphics, Rectangle rectangle, int n2, int n3) {
        int n4;
        int n5;
        if (n2 == 0 || !jComponent.getComponentOrientation().isLeftToRight()) {
            n5 = rectangle.x + 3;
            n4 = rectangle.y + rectangle.height - 7;
        } else {
            n5 = rectangle.x + rectangle.width - 7;
            n4 = rectangle.y + 3;
        }
        if (n2 == 0 || !jComponent.getComponentOrientation().isLeftToRight()) {
            JideSwingUtilities.paintArrow(graphics, UIDefaultsLookup.getColor("CommandBar.darkShadow"), n5, n4, 5, 0);
        } else {
            JideSwingUtilities.paintArrow(graphics, UIDefaultsLookup.getColor("CommandBar.darkShadow"), n5, n4, 5, n2);
        }
    }

    @Override
    public void paintFloatingChevronOption(JComponent jComponent, Graphics graphics, Rectangle rectangle, int n2, int n3) {
        int n4 = rectangle.width / 2 - 4;
        int n5 = rectangle.height / 2 - 2;
        if (n3 == 2) {
            JideSwingUtilities.paintArrow(graphics, Color.BLACK, n4, n5, 9, n2);
        } else {
            JideSwingUtilities.paintArrow(graphics, Color.WHITE, n4, n5, 9, n2);
        }
    }

    @Override
    public void paintDockableFrameBackground(JComponent jComponent, Graphics graphics, Rectangle rectangle, int n2, int n3) {
        if (!jComponent.isOpaque()) {
            return;
        }
        graphics.setColor(UIDefaultsLookup.getColor("DockableFrame.background"));
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    @Override
    public void paintDockableFrameTitlePane(JComponent jComponent, Graphics graphics, Rectangle rectangle, int n2, int n3) {
        Serializable serializable;
        int n4 = rectangle.x;
        int n5 = rectangle.y;
        int n6 = rectangle.width - 1;
        int n7 = rectangle.height;
        if (jComponent.getBorder() != null) {
            serializable = jComponent.getBorder().getBorderInsets(jComponent);
            n4 += ((Insets)serializable).left;
            n5 += ((Insets)serializable).top;
            n6 -= ((Insets)serializable).right + ((Insets)serializable).left;
            n7 -= ((Insets)serializable).top + ((Insets)serializable).bottom;
        }
        rectangle = new Rectangle(n4 + 1, n5 + 1, n6 - 1, n7 - 1);
        serializable = Boolean.valueOf(UIManager.getBoolean("Theme.highContrast"));
        if (n3 == 3) {
            graphics.setColor(UIDefaultsLookup.getColor("DockableFrame.activeTitleBorderColor"));
            if ("true".equals(SecurityUtils.getProperty("shadingtheme", "false"))) {
                graphics.drawRoundRect(n4, n5, n6, n7, 2, 2);
            } else {
                graphics.drawRect(n4, n5, n6, n7);
            }
            graphics.setColor(((Boolean)serializable).booleanValue() ? UIDefaultsLookup.getColor("JideButton.selectedBackground") : UIDefaultsLookup.getColor("DockableFrame.activeTitleBackground"));
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        } else {
            graphics.setColor(UIDefaultsLookup.getColor("DockableFrame.inactiveTitleBorderColor"));
            graphics.drawRoundRect(n4, n5, n6, n7, 2, 2);
            graphics.setColor(UIDefaultsLookup.getColor("DockableFrame.inactiveTitleBackground"));
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        if ("true".equals(SecurityUtils.getProperty("shadingtheme", "false"))) {
            JideSwingUtilities.fillGradient(graphics, rectangle, 0);
        }
    }

    @Override
    public void paintCollapsiblePaneTitlePaneBackground(JComponent jComponent, Graphics graphics, Rectangle rectangle, int n2, int n3) {
        Boolean bl = UIManager.getBoolean("Theme.highContrast");
        if (!(jComponent.getBackground() instanceof UIResource)) {
            graphics.setColor(jComponent.getBackground());
        } else {
            graphics.setColor(UIDefaultsLookup.getColor(bl != false ? "JideButton.background" : "CollapsiblePane.background"));
        }
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        if (bl.booleanValue()) {
            graphics.setColor(UIDefaultsLookup.getColor("CollapsiblePane.background"));
            graphics.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height);
        }
    }

    @Override
    public void paintCollapsiblePaneTitlePaneBackgroundEmphasized(JComponent jComponent, Graphics graphics, Rectangle rectangle, int n2, int n3) {
        if (!(jComponent.getBackground() instanceof UIResource)) {
            graphics.setColor(jComponent.getBackground());
        } else {
            graphics.setColor(UIDefaultsLookup.getColor("CollapsiblePane.emphasizedBackground"));
        }
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    @Override
    public void paintCollapsiblePanesBackground(JComponent jComponent, Graphics graphics, Rectangle rectangle, int n2, int n3) {
        if (!jComponent.isOpaque()) {
            return;
        }
        if (!(jComponent.getBackground() instanceof UIResource)) {
            graphics.setColor(jComponent.getBackground());
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        } else {
            graphics.setColor(UIDefaultsLookup.getColor("TextField.background"));
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    @Override
    public void paintCollapsiblePaneTitlePaneBackgroundPlainEmphasized(JComponent jComponent, Graphics graphics, Rectangle rectangle, int n2, int n3) {
        graphics.setColor(UIDefaultsLookup.getColor("CollapsiblePane.emphasizedBackground"));
        graphics.drawLine(rectangle.x, rectangle.y + rectangle.height - 1, rectangle.x + rectangle.width, rectangle.y + rectangle.height - 1);
    }

    @Override
    public void paintCollapsiblePaneTitlePaneBackgroundPlain(JComponent jComponent, Graphics graphics, Rectangle rectangle, int n2, int n3) {
        if (!(jComponent.getBackground() instanceof UIResource)) {
            graphics.setColor(jComponent.getBackground());
        } else {
            graphics.setColor(UIDefaultsLookup.getColor("CollapsiblePane.background"));
        }
        switch (n2) {
            case 3: {
                graphics.drawLine(rectangle.x + rectangle.width - 1, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
                break;
            }
            case 7: {
                graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height - 1);
                break;
            }
            case 1: {
                graphics.drawLine(rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y);
            }
            default: {
                graphics.drawLine(rectangle.x, rectangle.y + rectangle.height - 1, rectangle.x + rectangle.width, rectangle.y + rectangle.height - 1);
            }
        }
    }

    @Override
    public void paintCollapsiblePaneTitlePaneBackgroundSeparatorEmphasized(JComponent jComponent, Graphics graphics, Rectangle rectangle, int n2, int n3) {
        graphics.setColor(UIManager.getColor("CollapsiblePane.emphasizedBackground"));
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.height);
    }

    @Override
    public void paintCollapsiblePaneTitlePaneBackgroundSeparator(JComponent jComponent, Graphics graphics, Rectangle rectangle, int n2, int n3) {
        graphics.setColor(UIManager.getColor("CollapsiblePane.background"));
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.height);
    }

    @Override
    public Color getColor(Object object) {
        return UIDefaultsLookup.getColor(object);
    }

    @Override
    public void paintTabAreaBackground(JComponent jComponent, Graphics graphics, Rectangle rectangle, int n2, int n3) {
        if (jComponent.isOpaque() && jComponent instanceof JideTabbedPane) {
            JideTabbedPane jideTabbedPane = (JideTabbedPane)jComponent;
            int n4 = jideTabbedPane.getTabShape();
            int n5 = jideTabbedPane.getColorTheme();
            if (n4 == 3) {
                graphics.setColor(UIDefaultsLookup.getColor("control"));
            } else if (n5 == 1) {
                graphics.setColor(UIDefaultsLookup.getColor("control"));
            } else if (n5 == 3) {
                graphics.setColor(UIDefaultsLookup.getColor("JideTabbedPane.tabAreaBackground"));
            } else {
                graphics.setColor(UIDefaultsLookup.getColor("control"));
            }
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    @Override
    public void paintTabBackground(JComponent jComponent, Graphics graphics, Shape shape, Color[] colorArray, int n2, int n3) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        Color color = colorArray[0];
        Color color2 = colorArray[1];
        if (color2 != null && color != null) {
            int n4 = 1;
            if (jComponent instanceof JideTabbedPane) {
                n4 = ((JideTabbedPane)jComponent).getTabPlacement();
            }
            switch (n4) {
                case 2: {
                    JideSwingUtilities.fillGradient(graphics2D, shape, color, color2, false);
                    break;
                }
                case 4: {
                    JideSwingUtilities.fillGradient(graphics2D, shape, color2, color, false);
                    break;
                }
                case 3: {
                    JideSwingUtilities.fillGradient(graphics2D, shape, color2, color, true);
                    break;
                }
                default: {
                    JideSwingUtilities.fillGradient(graphics2D, shape, color, color2, true);
                }
            }
        }
        graphics2D.dispose();
    }

    @Override
    public void paintTabContentBorder(JComponent jComponent, Graphics graphics, Rectangle rectangle, int n2, int n3) {
    }

    @Override
    public void paintSidePaneItemBackground(JComponent jComponent, Graphics graphics, Rectangle rectangle, Color[] colorArray, int n2, int n3) {
        Color color = colorArray != null && colorArray.length > 0 ? colorArray[0] : jComponent.getBackground();
        Color color2 = colorArray != null && colorArray.length > 1 ? colorArray[1] : color;
        switch (n2) {
            case 7: {
                JideSwingUtilities.fillGradient((Graphics2D)graphics, rectangle, color, color2, false);
                break;
            }
            case 3: {
                JideSwingUtilities.fillGradient((Graphics2D)graphics, rectangle, color2, color, false);
                break;
            }
            case 1: {
                JideSwingUtilities.fillGradient((Graphics2D)graphics, rectangle, color, color2, true);
                break;
            }
            case 5: {
                JideSwingUtilities.fillGradient((Graphics2D)graphics, rectangle, color2, color, true);
            }
        }
    }

    @Override
    public void paintHeaderBoxBackground(JComponent jComponent, Graphics graphics, Rectangle rectangle, int n2, int n3) {
        boolean bl = Boolean.TRUE.equals(jComponent.getClientProperty("HeaderBox.isTableCellEditor"));
        Color color = jComponent.getBackground();
        if (color instanceof UIResource && (color = UIDefaultsLookup.getColor("HeaderBox.background")) == null) {
            color = UIDefaultsLookup.getColor("control");
        }
        if (n3 == 1 || n3 == 3 || n3 == 2) {
            Color color2 = ColorUtils.getDerivedColor(color, 0.48f);
            if (bl) {
                graphics.setColor(color2);
                graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            } else {
                graphics.setColor(color2);
                graphics.fillRoundRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1, 4, 4);
                graphics.setColor(ColorUtils.getDerivedColor(color, 0.4f));
                graphics.drawRoundRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1, 6, 6);
            }
            graphics.setColor(ColorUtils.getDerivedColor(color, 0.45f));
            graphics.drawLine(rectangle.x + 1, rectangle.y + rectangle.height - 3, rectangle.x + rectangle.width - 2, rectangle.y + rectangle.height - 3);
            graphics.setColor(ColorUtils.getDerivedColor(color, 0.43f));
            graphics.drawLine(rectangle.x + 2, rectangle.y + rectangle.height - 2, rectangle.x + rectangle.width - 3, rectangle.y + rectangle.height - 2);
            graphics.setColor(ColorUtils.getDerivedColor(color, 0.4f));
            graphics.drawLine(rectangle.x + 3, rectangle.y + rectangle.height - 1, rectangle.x + rectangle.width - 4, rectangle.y + rectangle.height - 1);
        } else {
            if (bl) {
                graphics.setColor(color);
                graphics.fillRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
            } else {
                graphics.setColor(color);
                graphics.fillRoundRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1, 2, 2);
                graphics.setColor(ColorUtils.getDerivedColor(color, 0.42f));
                graphics.drawRoundRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1, 2, 4);
            }
            graphics.setColor(ColorUtils.getDerivedColor(color, 0.48f));
            graphics.drawLine(rectangle.x + 1, rectangle.y + rectangle.height - 3, rectangle.x + rectangle.width - 2, rectangle.y + rectangle.height - 3);
            graphics.setColor(ColorUtils.getDerivedColor(color, 0.47f));
            graphics.drawLine(rectangle.x + 1, rectangle.y + rectangle.height - 2, rectangle.x + rectangle.width - 2, rectangle.y + rectangle.height - 2);
            if (bl) {
                graphics.setColor(new Color(198, 197, 178));
                graphics.drawLine(rectangle.x + rectangle.width - 3, rectangle.y + 4, rectangle.x + rectangle.width - 3, rectangle.y + rectangle.height - 7);
                graphics.setColor(Color.WHITE);
                graphics.drawLine(rectangle.x + rectangle.width - 2, rectangle.y + 4, rectangle.x + rectangle.width - 2, rectangle.y + rectangle.height - 7);
            }
        }
    }

    @Override
    public void paintToolBarSeparator(JComponent jComponent, Graphics graphics, Rectangle rectangle, int n2, int n3) {
        if (jComponent.isOpaque()) {
            graphics.setColor(jComponent.getBackground());
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        if (n2 == 0) {
            graphics.setColor(jComponent.getForeground());
            graphics.drawLine(rectangle.x + rectangle.width / 2, rectangle.y + 1, rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height - 2);
        } else {
            graphics.setColor(jComponent.getForeground());
            graphics.drawLine(rectangle.x + 1, rectangle.y + rectangle.height / 2, rectangle.x + rectangle.width - 2, rectangle.y + rectangle.height / 2);
        }
    }

    @Override
    public void paintPopupMenuSeparator(JComponent jComponent, Graphics graphics, Rectangle rectangle, int n2, int n3) {
        int n4 = UIDefaultsLookup.getInt("MenuItem.shadowWidth");
        int n5 = UIDefaultsLookup.getInt("MenuItem.textIconGap");
        Color color = UIDefaultsLookup.getColor("MenuItem.shadowColor");
        Color color2 = UIDefaultsLookup.getColor("PopupMenuSeparator.foreground");
        Color color3 = UIDefaultsLookup.getColor("PopupMenuSeparator.background");
        graphics.setColor(color);
        if (jComponent.getComponentOrientation().isLeftToRight()) {
            graphics.fillRect(0, 0, n4, rectangle.height);
            if ("true".equals(SecurityUtils.getProperty("shadingtheme", "false"))) {
                JideSwingUtilities.fillSingleGradient(graphics, new Rectangle(rectangle.x, rectangle.y, n4, rectangle.height), 3, 255);
            }
            graphics.setColor(color3);
            graphics.fillRect(rectangle.x + n4, rectangle.y, rectangle.width - n4, rectangle.height);
            graphics.setColor(color2);
            graphics.drawLine(rectangle.x + n4 + n5, rectangle.y + 1, rectangle.x + rectangle.width, rectangle.y + 1);
        } else {
            graphics.fillRect(rectangle.x + rectangle.width, rectangle.y, n4, rectangle.height);
            if ("true".equals(SecurityUtils.getProperty("shadingtheme", "false"))) {
                JideSwingUtilities.fillSingleGradient(graphics, new Rectangle(rectangle.x + rectangle.width - n5, rectangle.y, n4, 2), 7, 255);
            }
            graphics.setColor(color3);
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width - n4, rectangle.height);
            graphics.setColor(color2);
            graphics.drawLine(rectangle.x, rectangle.y + 1, rectangle.x + rectangle.width - n4 - n5, rectangle.y + 1);
        }
    }

    @Override
    public void paintStatusBarSeparator(JComponent jComponent, Graphics graphics, Rectangle rectangle, int n2, int n3) {
    }

    protected boolean shouldDisplayOnTop() {
        return SystemInfo.isWindowsVistaAbove() && UIManager.getLookAndFeel() instanceof WindowsLookAndFeel && !(UIManager.getLookAndFeel() instanceof WindowsClassicLookAndFeel) && XPUtils.isXPStyleOn();
    }

    @Override
    public void fillBackground(JComponent jComponent, Graphics graphics, Rectangle rectangle, int n2, int n3, Color color) {
        Color color2 = graphics.getColor();
        graphics.setColor(color);
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.setColor(color2);
    }

    @Override
    public Insets getSortableTableHeaderColumnCellDecoratorInsets(JComponent jComponent, Graphics graphics, Rectangle rectangle, int n2, int n3, int n4, Icon icon, int n5, Color color, boolean bl) {
        if (this.shouldDisplayOnTop()) {
            return null;
        }
        int n6 = icon == null ? 0 : icon.getIconWidth();
        int n7 = 0;
        if (bl && n5 != -1) {
            Font font;
            Object object;
            if (graphics != null) {
                object = graphics.getFont();
                font = graphics.getFont().deriveFont(0, ((Font)object).getSize() - 3);
            } else {
                font = jComponent.getFont() != null ? jComponent.getFont().deriveFont(0, jComponent.getFont().getSize() - 3) : Font.getFont("Arial");
            }
            object = "" + (n5 + 1);
            int n8 = SwingUtilities.computeStringWidth(jComponent.getFontMetrics(font), (String)object);
            n7 = ARROW_TEXT_GAP + n8 + H_GAP;
        } else {
            n7 = H_GAP;
        }
        if (n7 + n6 == 0) {
            return null;
        }
        return new Insets(0, 0, 0, n7 + n6);
    }

    @Override
    public void paintSortableTableHeaderColumn(JComponent jComponent, Graphics graphics, Rectangle rectangle, int n2, int n3, int n4, Icon icon, int n5, Color color, boolean bl) {
        int n6 = icon == null ? 0 : icon.getIconHeight();
        int n7 = icon == null ? 0 : icon.getIconWidth();
        int n8 = icon == null ? 0 : (rectangle.height - n6) / 2 - V_GAP;
        boolean bl2 = jComponent.getComponentOrientation().isLeftToRight();
        if (bl && n5 != -1) {
            Font font = graphics.getFont();
            Font font2 = graphics.getFont().deriveFont(0, font.getSize() - 3);
            String string = "" + (n5 + 1);
            int n9 = SwingUtilities.computeStringWidth(jComponent.getFontMetrics(font2), string);
            graphics.setFont(font2);
            Color color2 = graphics.getColor();
            graphics.setColor(color);
            int n10 = rectangle.x + rectangle.width / 2 - (n7 + ARROW_TEXT_GAP + n9) / 2;
            if (this.shouldDisplayOnTop()) {
                JideSwingUtilities.drawString(jComponent, graphics, string, n10 + ARROW_TEXT_GAP + n7, rectangle.y + V_GAP + jComponent.getFontMetrics(font2).getAscent() - 2);
            } else if (bl2) {
                JideSwingUtilities.drawString(jComponent, graphics, string, rectangle.x + rectangle.width - n9 - H_GAP, rectangle.y + n8 + n6 / 2 + 1);
            } else {
                JideSwingUtilities.drawString(jComponent, graphics, string, rectangle.x + H_GAP, rectangle.y + n8 + n6 / 2 + 1);
            }
            graphics.setColor(color2);
            graphics.setFont(font);
            if (icon != null) {
                if (this.shouldDisplayOnTop()) {
                    if (icon instanceof SynthIcon) {
                        SynthContext synthContext = new SynthContext(jComponent, Region.TABLE_HEADER, SynthLookAndFeel.getStyle(jComponent, Region.TABLE_HEADER), 0);
                        ((SynthIcon)icon).paintIcon(synthContext, graphics, n10, rectangle.y + V_GAP, ((SynthIcon)icon).getIconWidth(synthContext), ((SynthIcon)icon).getIconHeight(synthContext));
                    } else {
                        icon.paintIcon(jComponent, graphics, n10, rectangle.y + V_GAP);
                    }
                } else if (bl2) {
                    if (icon instanceof SynthIcon) {
                        SynthContext synthContext = new SynthContext(jComponent, Region.TABLE_HEADER, SynthLookAndFeel.getStyle(jComponent, Region.TABLE_HEADER), 0);
                        ((SynthIcon)icon).paintIcon(synthContext, graphics, rectangle.x + rectangle.width - n7 - n9 - H_GAP - ARROW_TEXT_GAP, rectangle.y + n8, ((SynthIcon)icon).getIconWidth(synthContext), ((SynthIcon)icon).getIconHeight(synthContext));
                    } else {
                        icon.paintIcon(jComponent, graphics, rectangle.x + rectangle.width - n7 - n9 - H_GAP - ARROW_TEXT_GAP, rectangle.y + n8);
                    }
                } else if (icon instanceof SynthIcon) {
                    SynthContext synthContext = new SynthContext(jComponent, Region.TABLE_HEADER, SynthLookAndFeel.getStyle(jComponent, Region.TABLE_HEADER), 0);
                    ((SynthIcon)icon).paintIcon(synthContext, graphics, rectangle.x + n9 + H_GAP + ARROW_TEXT_GAP, rectangle.y + n8, ((SynthIcon)icon).getIconWidth(synthContext), ((SynthIcon)icon).getIconHeight(synthContext));
                } else {
                    icon.paintIcon(jComponent, graphics, rectangle.x + n9 + H_GAP + ARROW_TEXT_GAP, rectangle.y + n8);
                }
            }
        } else if (icon != null) {
            if (this.shouldDisplayOnTop()) {
                if (icon instanceof SynthIcon) {
                    SynthContext synthContext = new SynthContext(jComponent, Region.TABLE_HEADER, SynthLookAndFeel.getStyle(jComponent, Region.TABLE_HEADER), 0);
                    ((SynthIcon)icon).paintIcon(synthContext, graphics, rectangle.x + rectangle.width / 2 - n7 / 2, rectangle.y + V_GAP, ((SynthIcon)icon).getIconWidth(synthContext), ((SynthIcon)icon).getIconHeight(synthContext));
                } else {
                    icon.paintIcon(jComponent, graphics, rectangle.x + rectangle.width / 2 - n7 / 2, rectangle.y + V_GAP);
                }
            } else if (bl2) {
                if (icon instanceof SynthIcon) {
                    SynthContext synthContext = new SynthContext(jComponent, Region.TABLE_HEADER, SynthLookAndFeel.getStyle(jComponent, Region.TABLE_HEADER), 0);
                    ((SynthIcon)icon).paintIcon(synthContext, graphics, rectangle.x + rectangle.width - n7 - H_GAP, rectangle.y + n8, ((SynthIcon)icon).getIconWidth(synthContext), ((SynthIcon)icon).getIconHeight(synthContext));
                } else {
                    icon.paintIcon(jComponent, graphics, rectangle.x + rectangle.width - n7 - H_GAP, rectangle.y + n8);
                }
            } else if (icon instanceof SynthIcon) {
                SynthContext synthContext = new SynthContext(jComponent, Region.TABLE_HEADER, SynthLookAndFeel.getStyle(jComponent, Region.TABLE_HEADER), 0);
                ((SynthIcon)icon).paintIcon(synthContext, graphics, rectangle.x + H_GAP, rectangle.y + n8, ((SynthIcon)icon).getIconWidth(synthContext), ((SynthIcon)icon).getIconHeight(synthContext));
            } else {
                icon.paintIcon(jComponent, graphics, rectangle.x + H_GAP, rectangle.y + n8);
            }
        }
    }

    static {
        V_GAP = 0;
        H_GAP = 5;
        ARROW_TEXT_GAP = 0;
    }
}

