/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.plaf.PopupUI;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.popup.JidePopup;
import com.jidesoft.swing.Gripper;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;

public class BasicJidePopupUI
extends PopupUI {
    protected JidePopup _popup;
    protected PropertyChangeListener _propertyChangeListener;
    protected LayoutManager _dockableFrameLayout;
    protected JComponent _northPane;
    protected JComponent _southPane;
    protected JComponent _westPane;
    protected JComponent _eastPane;
    protected Gripper _titlePane;
    private boolean keyBindingRegistered = false;
    private boolean keyBindingActive = false;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicJidePopupUI((JidePopup)jComponent);
    }

    public BasicJidePopupUI() {
    }

    public BasicJidePopupUI(JidePopup jidePopup) {
        this._popup = jidePopup;
    }

    @Override
    public void installUI(JComponent jComponent) {
        this._popup = (JidePopup)jComponent;
        this.installDefaults();
        this.installListeners();
        this.installComponents();
        this.installKeyboardActions();
        this._popup.setOpaque(true);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        if (jComponent != this._popup) {
            throw new IllegalComponentStateException(this + " was asked to deinstall() " + jComponent + " when it only knows about " + this._popup + ".");
        }
        this.uninstallKeyboardActions();
        this.uninstallComponents();
        this.uninstallListeners();
        this.uninstallDefaults();
        this._popup = null;
    }

    protected void installDefaults() {
        Color color;
        JComponent jComponent = (JComponent)this._popup.getContentPane();
        if (jComponent != null && (color = jComponent.getBackground()) instanceof UIResource) {
            jComponent.setBackground(null);
        }
        this._dockableFrameLayout = this.createLayoutManager();
        this._popup.setLayout(this._dockableFrameLayout);
        this._popup.setBackground(UIDefaultsLookup.getColor("JideButton.background"));
        LookAndFeel.installBorder(this._popup, "Popup.border");
    }

    protected void installKeyboardActions() {
        ActionMap actionMap = this.getActionMap();
        SwingUtilities.replaceUIActionMap(this._popup, actionMap);
    }

    ActionMap getActionMap() {
        ActionMap actionMap = (ActionMap)UIDefaultsLookup.get("Popup.actionMap");
        if (actionMap == null && (actionMap = this.createActionMap()) != null) {
            UIManager.getLookAndFeelDefaults().put("Popup.actionMap", actionMap);
        }
        return actionMap;
    }

    ActionMap createActionMap() {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        return actionMapUIResource;
    }

    protected void installComponents() {
        this.setNorthPane(this.createNorthPane(this._popup));
        this.setSouthPane(this.createSouthPane(this._popup));
        this.setEastPane(this.createEastPane(this._popup));
        this.setWestPane(this.createWestPane(this._popup));
    }

    protected void installListeners() {
        this._propertyChangeListener = this.createPropertyChangeListener();
        this._popup.addPropertyChangeListener(this._propertyChangeListener);
    }

    InputMap getInputMap(int n2) {
        if (n2 == 2) {
            return this.createInputMap(n2);
        }
        return null;
    }

    InputMap createInputMap(int n2) {
        Object[] objectArray;
        if (n2 == 2 && (objectArray = (Object[])UIDefaultsLookup.get("Popup.windowBindings")) != null) {
            return LookAndFeel.makeComponentInputMap(this._popup, objectArray);
        }
        return null;
    }

    protected void uninstallDefaults() {
        this._dockableFrameLayout = null;
        this._popup.setLayout(null);
        LookAndFeel.uninstallBorder(this._popup);
    }

    protected void uninstallComponents() {
        this.setNorthPane(null);
        this.setSouthPane(null);
        this.setEastPane(null);
        this.setWestPane(null);
        this._titlePane = null;
    }

    protected void uninstallListeners() {
        this._popup.removePropertyChangeListener(this._propertyChangeListener);
        this._propertyChangeListener = null;
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIInputMap(this._popup, 2, null);
        SwingUtilities.replaceUIActionMap(this._popup, null);
    }

    @Override
    public Component getGripper() {
        return this._titlePane;
    }

    protected LayoutManager createLayoutManager() {
        return new PopupLayout();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PopupPropertyChangeListener();
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        if (this._popup == jComponent && this._popup.getLayout() != null) {
            return this._popup.getLayout().preferredLayoutSize(jComponent);
        }
        return new Dimension(100, 100);
    }

    @Override
    public Dimension getMinimumSize(JComponent jComponent) {
        if (this._popup == jComponent) {
            return this._popup.getLayout().minimumLayoutSize(jComponent);
        }
        return new Dimension(0, 0);
    }

    @Override
    public Dimension getMaximumSize(JComponent jComponent) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    protected void replacePane(JComponent jComponent, JComponent jComponent2) {
        if (jComponent != null) {
            this.deinstallMouseHandlers(jComponent);
            this._popup.remove(jComponent);
        }
        if (jComponent2 != null) {
            this._popup.add(jComponent2);
            this.installMouseHandlers(jComponent2);
        }
    }

    protected void deinstallMouseHandlers(JComponent jComponent) {
    }

    protected void installMouseHandlers(JComponent jComponent) {
    }

    protected JComponent createNorthPane(JidePopup jidePopup) {
        if (jidePopup.getGripperLocation() == 1 && jidePopup.isMovable()) {
            this._titlePane = new Gripper();
            this._titlePane.setOrientation(1);
            this._titlePane.setRolloverEnabled(true);
            this._titlePane.setOpaque(true);
            return this._titlePane;
        }
        return null;
    }

    protected JComponent createSouthPane(JidePopup jidePopup) {
        if (jidePopup.getGripperLocation() == 5 && jidePopup.isMovable()) {
            this._titlePane = new Gripper();
            this._titlePane.setOrientation(1);
            this._titlePane.setRolloverEnabled(true);
            this._titlePane.setOpaque(true);
            return this._titlePane;
        }
        return null;
    }

    protected JComponent createWestPane(JidePopup jidePopup) {
        if (jidePopup.getGripperLocation() == 7 && jidePopup.isMovable()) {
            this._titlePane = new Gripper();
            this._titlePane.setOrientation(0);
            this._titlePane.setRolloverEnabled(true);
            this._titlePane.setOpaque(true);
            return this._titlePane;
        }
        return null;
    }

    protected JComponent createEastPane(JidePopup jidePopup) {
        if (jidePopup.getGripperLocation() == 3 && jidePopup.isMovable()) {
            this._titlePane = new Gripper();
            this._titlePane.setOrientation(0);
            this._titlePane.setRolloverEnabled(true);
            this._titlePane.setOpaque(true);
            return this._titlePane;
        }
        return null;
    }

    protected final boolean isKeyBindingRegistered() {
        return this.keyBindingRegistered;
    }

    protected final void setKeyBindingRegistered(boolean bl) {
        this.keyBindingRegistered = bl;
    }

    public final boolean isKeyBindingActive() {
        return this.keyBindingActive;
    }

    protected final void setKeyBindingActive(boolean bl) {
        this.keyBindingActive = bl;
    }

    protected void setupMenuOpenKey() {
        InputMap inputMap = this.getInputMap(2);
        SwingUtilities.replaceUIInputMap(this._popup, 2, inputMap);
    }

    protected void setupMenuCloseKey() {
    }

    public JComponent getNorthPane() {
        return this._northPane;
    }

    protected void setNorthPane(JComponent jComponent) {
        this.replacePane(this._northPane, jComponent);
        this._northPane = jComponent;
    }

    public JComponent getSouthPane() {
        return this._southPane;
    }

    protected void setSouthPane(JComponent jComponent) {
        this.replacePane(this._southPane, jComponent);
        this._southPane = jComponent;
    }

    public JComponent getWestPane() {
        return this._westPane;
    }

    protected void setWestPane(JComponent jComponent) {
        this.replacePane(this._westPane, jComponent);
        this._westPane = jComponent;
    }

    public JComponent getEastPane() {
        return this._eastPane;
    }

    protected void setEastPane(JComponent jComponent) {
        this.replacePane(this._eastPane, jComponent);
        this._eastPane = jComponent;
    }

    public class PopupLayout
    implements LayoutManager {
        @Override
        public void addLayoutComponent(String string, Component component) {
        }

        @Override
        public void removeLayoutComponent(Component component) {
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            Dimension dimension;
            Insets insets = BasicJidePopupUI.this._popup.getInsets();
            Dimension dimension2 = new Dimension(BasicJidePopupUI.this._popup.getRootPane().getPreferredSize());
            dimension2.width += insets.left + insets.right;
            dimension2.height += insets.top + insets.bottom;
            if (BasicJidePopupUI.this.getNorthPane() != null) {
                dimension = BasicJidePopupUI.this.getNorthPane().getPreferredSize();
                dimension2.width = Math.max(dimension.width, dimension2.width);
                dimension2.height += dimension.height;
            }
            if (BasicJidePopupUI.this.getSouthPane() != null) {
                dimension = BasicJidePopupUI.this.getSouthPane().getPreferredSize();
                dimension2.width = Math.max(dimension.width, dimension2.width);
                dimension2.height += dimension.height;
            }
            if (BasicJidePopupUI.this.getEastPane() != null) {
                dimension = BasicJidePopupUI.this.getEastPane().getPreferredSize();
                dimension2.width += dimension.width;
                dimension2.height = Math.max(dimension.height, dimension2.height);
            }
            if (BasicJidePopupUI.this.getWestPane() != null) {
                dimension = BasicJidePopupUI.this.getWestPane().getPreferredSize();
                dimension2.width += dimension.width;
                dimension2.height = Math.max(dimension.height, dimension2.height);
            }
            return dimension2;
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            Dimension dimension;
            Dimension dimension2 = new Dimension();
            if (BasicJidePopupUI.this.getNorthPane() != null) {
                dimension2 = new Dimension(BasicJidePopupUI.this.getNorthPane().getMinimumSize());
            }
            if (BasicJidePopupUI.this.getSouthPane() != null) {
                dimension = BasicJidePopupUI.this.getSouthPane().getMinimumSize();
                dimension2.width = Math.max(dimension2.width, dimension.width);
                dimension2.height += dimension.height;
            }
            if (BasicJidePopupUI.this.getEastPane() != null) {
                dimension = BasicJidePopupUI.this.getEastPane().getMinimumSize();
                dimension2.width += dimension.width;
                dimension2.height = Math.max(dimension2.height, dimension.height);
            }
            if (BasicJidePopupUI.this.getWestPane() != null) {
                dimension = BasicJidePopupUI.this.getWestPane().getMinimumSize();
                dimension2.width = Math.max(dimension2.width, dimension.width);
                dimension2.height += dimension.height;
            }
            dimension = BasicJidePopupUI.this._popup.getContentPane().getMinimumSize();
            if (dimension.width > dimension2.width) {
                dimension2.width = dimension.width;
            }
            dimension2.height += dimension.height;
            Insets insets = BasicJidePopupUI.this._popup.getInsets();
            dimension2.width += insets.left + insets.right;
            dimension2.height += insets.top + insets.bottom;
            return dimension2;
        }

        @Override
        public void layoutContainer(Container container) {
            Dimension dimension;
            Insets insets = BasicJidePopupUI.this._popup.getInsets();
            int n2 = insets.left;
            int n3 = insets.top;
            int n4 = BasicJidePopupUI.this._popup.getWidth() - insets.left - insets.right;
            int n5 = BasicJidePopupUI.this._popup.getHeight() - insets.top - insets.bottom;
            if (BasicJidePopupUI.this.getNorthPane() != null) {
                BasicJidePopupUI.this.getNorthPane().setVisible(true);
                dimension = BasicJidePopupUI.this.getNorthPane().getPreferredSize();
                BasicJidePopupUI.this.getNorthPane().setBounds(n2, n3, n4, dimension.height);
                n3 += dimension.height;
                n5 -= dimension.height;
            }
            if (BasicJidePopupUI.this.getSouthPane() != null) {
                dimension = BasicJidePopupUI.this.getSouthPane().getPreferredSize();
                BasicJidePopupUI.this.getSouthPane().setBounds(n2, BasicJidePopupUI.this._popup.getHeight() - insets.bottom - dimension.height, n4, dimension.height);
                n5 -= dimension.height;
            }
            if (BasicJidePopupUI.this.getWestPane() != null) {
                dimension = BasicJidePopupUI.this.getWestPane().getPreferredSize();
                BasicJidePopupUI.this.getWestPane().setBounds(n2, n3, dimension.width, n5);
                n4 -= dimension.width;
                n2 += dimension.width;
            }
            if (BasicJidePopupUI.this.getEastPane() != null) {
                dimension = BasicJidePopupUI.this.getEastPane().getPreferredSize();
                BasicJidePopupUI.this.getEastPane().setBounds(n4 - dimension.width, n3, dimension.width, n5);
                n4 -= dimension.width;
            }
            if (BasicJidePopupUI.this._popup.getRootPane() != null) {
                BasicJidePopupUI.this._popup.getRootPane().setBounds(n2, n3, n4, n5);
            }
        }
    }

    public class PopupPropertyChangeListener
    implements PropertyChangeListener {
        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            JidePopup jidePopup = (JidePopup)propertyChangeEvent.getSource();
            Object object = propertyChangeEvent.getNewValue();
            Object object2 = propertyChangeEvent.getOldValue();
            if ("movable".equals(string)) {
                jidePopup.updateUI();
            }
            if ("gripperLocation".equals(string)) {
                jidePopup.updateUI();
            }
        }
    }
}

