/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.hints;

import com.jidesoft.hints.AbstractListIntelliHints;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import javax.swing.text.JTextComponent;

public class ListDataIntelliHints<T>
extends AbstractListIntelliHints {
    private boolean _caseSensitive = false;
    private List<T> _completionList;

    public ListDataIntelliHints(JTextComponent jTextComponent, List<T> list) {
        super(jTextComponent);
        this.setCompletionList(list);
    }

    public ListDataIntelliHints(JTextComponent jTextComponent, T[] TArray) {
        super(jTextComponent);
        this.setCompletionList(TArray);
    }

    public List<T> getCompletionList() {
        return this._completionList;
    }

    public void setCompletionList(List<T> list) {
        this._completionList = list;
    }

    public void setCompletionList(T[] TArray) {
        final Object[] objectArray = TArray;
        this._completionList = new AbstractList<T>(){

            @Override
            public T get(int n2) {
                return objectArray[n2];
            }

            @Override
            public int size() {
                return objectArray.length;
            }
        };
    }

    @Override
    public boolean updateHints(Object object) {
        if (object == null) {
            return false;
        }
        ArrayList<T> arrayList = new ArrayList<T>();
        for (T t2 : this.getCompletionList()) {
            if (!this.compare(object, t2)) continue;
            arrayList.add(t2);
        }
        Object[] objectArray = arrayList.toArray();
        this.setListData(objectArray);
        return objectArray.length > 0;
    }

    protected boolean compare(Object object, T t2) {
        boolean bl = false;
        String string = t2 == null ? "" : t2.toString();
        String string2 = object.toString();
        int n2 = string2.length();
        if (n2 <= string.length()) {
            if (!this.isCaseSensitive()) {
                if (string2.equalsIgnoreCase(string.substring(0, n2))) {
                    bl = true;
                }
            } else if (string.startsWith(string2)) {
                bl = true;
            }
        }
        return bl;
    }

    public boolean isCaseSensitive() {
        return this._caseSensitive;
    }

    public void setCaseSensitive(boolean bl) {
        this._caseSensitive = bl;
    }
}

