/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.plastic;

import com.jgoodies.looks.Options;
import java.awt.EventQueue;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import javax.swing.JFormattedTextField;
import javax.swing.SwingUtilities;
import javax.swing.plaf.UIResource;
import javax.swing.text.DefaultCaret;
import javax.swing.text.JTextComponent;

final class PlasticFieldCaret
extends DefaultCaret
implements UIResource {
    private boolean isKeyboardFocusEvent = true;

    PlasticFieldCaret() {
    }

    @Override
    public void focusGained(FocusEvent e2) {
        JTextComponent c2 = this.getComponent();
        if (c2 == null) {
            return;
        }
        if (c2.isEnabled()) {
            this.setVisible(true);
            this.setSelectionVisible(true);
        }
        if (!(c2.isEnabled() && this.isKeyboardFocusEvent && Options.isSelectOnFocusGainActive(c2))) {
            return;
        }
        if (c2 instanceof JFormattedTextField) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PlasticFieldCaret.this.selectAll();
                }
            });
        } else {
            this.selectAll();
        }
    }

    private void selectAll() {
        JTextComponent c2 = this.getComponent();
        if (c2 == null) {
            return;
        }
        boolean backward = Boolean.TRUE.equals(c2.getClientProperty("JGoodies.invertSelection"));
        if (backward) {
            this.setDot(c2.getDocument().getLength());
            this.moveDot(0);
        } else {
            this.setDot(0);
            this.moveDot(c2.getDocument().getLength());
        }
    }

    @Override
    public void focusLost(FocusEvent e2) {
        super.focusLost(e2);
        if (!e2.isTemporary()) {
            this.isKeyboardFocusEvent = true;
            if (this.getComponent() != null && Boolean.TRUE.equals(this.getComponent().getClientProperty("JGoodies.setCaretToStartOnFocusLost"))) {
                this.setDot(0);
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e2) {
        if (SwingUtilities.isLeftMouseButton(e2) || e2.isPopupTrigger()) {
            this.isKeyboardFocusEvent = false;
        }
        super.mousePressed(e2);
    }

    @Override
    public void mouseReleased(MouseEvent e2) {
        super.mouseReleased(e2);
        if (e2.isPopupTrigger()) {
            this.isKeyboardFocusEvent = false;
            if (this.getComponent() != null && this.getComponent().isEnabled() && this.getComponent().isRequestFocusEnabled()) {
                this.getComponent().requestFocus();
            }
        }
    }
}

