/***************************************************************************
 *   Copyright (C) 2005 by Thierry CHARLES   *
 *   thierry@les-charles.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "povparserres.h"
#include "fileinfo.h"
#include "povfileinfo.h"

#include "xpe_components/editor/pov_panelelement.h"

FileInfo * PovFileParserRes::createInfoFor(const wxString & _sFileName)
{
    return new PovFileInfo(FileInfo::SourcedFile,_sFileName);
}

/** cre une instance d'info pour un editeur donn */
FileInfo * PovFileParserRes::createInfoFor(int iEditor)
{
    return new PovFileInfo(FileInfo::NewFile,iEditor);
}

/** indique si on doit grer ce type d'diteur */
bool PovFileParserRes::mightHandleEditor(EditorPanelElement * editor)
{
    PovPanelElement * elt = dynamic_cast<PovPanelElement *>(editor);
    return elt != NULL;
}


